local function split(s, delimiter)
    result = {};
    for match in (s..delimiter):gmatch("(.-)"..delimiter) do
        table.insert(result, match);
    end
    return result;
end

local function on_wait()
    local inputs = fft_config_get("inputs")
    for k, v in ipairs(inputs) do
        local keys = split(v, "-")
        fft_key_press(keys[1], keys[2], keys[3], keys[4])
    end
    fft_wait(fft_config_get("interval"), on_wait)
end

function init()
    fft_wait(2000, on_wait)
end

function info()
    return {
        name = "Anti AFK",
        desc = "Regularly press buttons to cancel AFK timer.",
    }
end