#ifdef GL_ES
#define LOWP lowp
#define MED mediump
#define HIGH highp
precision highp float;
#else
#define MED
#define LOWP
#define HIGH
#endif


const vec3 col0 = vec3(0.07058824,0.05882353,0.09019608);
const vec3 col1 = vec3(0.94509804,0.8980392,0.70980394);
const vec3 col2 = vec3(0.70980394,0.61960787,0.03529412);
const vec3 col3 = vec3(0.76862746,0.36862746,0.08627451);
const vec3 col4 = vec3(0.6784314,0.12156863,0.12156863);
const vec3 col5 = vec3(0.12941177,0.48235294,0.5686275);
const vec3 col6 = vec3(0.3529412,0.4,0.4392157);
const vec3 col7 = vec3(0.41568628,0.26666668,0.5176471);
const vec3 col8 = vec3(0.21960784,0.5019608,0.26666668);
const vec3 col9 = vec3(0.61960787,0.65882355,0.6509804);
const vec3 col10 = vec3(0.827451,0.16862746,0.890196);

vec3 paletteCol(int index) {
  if(index == 0) return col0;
  else if(index == 1) return col1;
  else if(index == 2) return col2;
  else if(index == 3) return col3;
  else if(index == 4) return col4;
  else if(index == 5) return col5;
  else if(index == 6) return col6;
  else if(index == 7) return col7;
  else if(index == 8) return col8;
  else if(index == 9) return col9;
  else if(index == 10) return col10;
  return col10;
  // switch(index) {
  //   case 0 : return col0;
  //   case 1 : return col1;
  //   case 2 : return col2;
  //   case 3 : return col3;
  //   case 4 : return col4;
  //   case 5 : return col5;
  //   case 6 : return col6;
  //   case 7 : return col7;
  //   case 8 : return col8;
  //   case 9 : return col9;
  //   case 10 : return col10;
  // }
  // return vec3(
  //     palette[index*3+0], 
  //     palette[index*3+1],
  //     palette[index*3+2]
  //   );
}

// const float palette[33] = float[33](
//     0.07058824,0.05882353,0.09019608,
//     0.94509804,0.8980392,0.70980394,
//     0.70980394,0.61960787,0.03529412,
//     0.76862746,0.36862746,0.08627451,
//     0.6784314,0.12156863,0.12156863,
//     0.12941177,0.48235294,0.5686275,
//     0.3529412,0.4,0.4392157,
//     0.41568628,0.26666668,0.5176471,
//     0.21960784,0.5019608,0.26666668,
//     0.61960787,0.65882355,0.6509804,
//     0.827451,0.16862746,0.8901961
//   );

const vec4 dark = vec4(.070,.059,.090,1);

uniform vec4 v_villagerColour;

varying vec2 v_diffuseUV; // default diffuse
uniform sampler2D u_texture; // main big texture
varying vec4 v_color; // r
varying vec3 v_normal;
uniform int side;
uniform int state;

uniform vec2 u_face[6];
uniform float u_pip[6];
uniform float u_pipBonus[12];
uniform vec4 u_keyword[6*4];
uniform vec2 u_lapel;
uniform float u_glow;
uniform float u_pulsate;
uniform int u_landedSide;

uniform vec4 v_cornerCol[24];

uniform int size;

void drawRect(int x, int y, int width, int height, vec3 col) {
    vec2 dst = vec2(float(x), float(y));
    vec2 sz = vec2(float(width), float(height));
    dst /= 512.0;
    sz /= 512.0;
    vec2 UV = v_diffuseUV/(512.0/float(size));
    UV -= dst;
    if(UV.x<0. || UV.y<0. || UV.x>sz.x || UV.y>sz.y) {
        return;
    }
    gl_FragColor.rgb =  col;
}

// dst and sz are in pixels
void drawTexture(vec2 src, vec2 dst, vec2 sz, bool xFlip, bool yFlip) {
  dst /= 512.0;
  sz /= 512.0;
  vec2 UV = v_diffuseUV/(512.0/float(size));
  UV -= dst;
  if(UV.x<0. || UV.y<0. || UV.x>sz.x || UV.y>sz.y) {
    return;
  }
  if(xFlip) {
    UV.x = sz.x-UV.x;
  }
  if(yFlip) {
    UV.y = sz.y-UV.y;
  }
  vec2 texPos = src + UV;
  vec4 pipColour = texture2D(u_texture, texPos);

  gl_FragColor.rgb =  gl_FragColor.rgb *(1.0-pipColour.a) + pipColour.rgb*(pipColour.a);
  //gl_FragColor.rg = UV*100.;
}

// void drawPipsOld(int mySide, vec2 UV) {
//   vec2 pip = u_pip[mySide];
//   vec4 pipColour = texture2D(u_texture, pip+UV);
//   gl_FragColor.rgb =  gl_FragColor.rgb *(1.0-pipColour.a) +pipColour.rgb*(pipColour.a);
// }

int intMod(int a, int b) {  
  return int(mod(float(a), float(b)));
}

int getMaxPips(int availableSpace) {
  return 
  ((availableSpace-3)/4)*5 
  +
  intMod(availableSpace-3,4)/2 + 2
  ;
}


const vec3 pipCol = vec3(.945,.898,.710);

void drawAllPips(int mySide) {
    vec3 unglow = dark.rgb;
    int paletteIndex = int(u_pipBonus[6+mySide]);
    vec3 bpcr = vec3(paletteCol(paletteIndex));
    vec3 bpc = mix(unglow, bpcr, 
      (paletteIndex == 1)?(0.5+0.5*u_pulsate):1.
      );
    int pipWidth = 2 + int(size/25);
    int smallPipHeight = 1;
    int bigPipHeight = 3;
    int pipY = size-2;
    int pipX = size-2-pipWidth;
    int totalPips = int(u_pip[mySide]);
    int bonusPips = int(u_pipBonus[mySide]);
    int pipIndex = 0;

    if(getMaxPips(size-4) < totalPips) {
      int barHeight = size-4;
      drawRect(pipX, pipY-barHeight, 2, barHeight, 
          bonusPips > 0 ? bpc : pipCol
        );
      return;
    } else if (totalPips == 0) {
      vec3 zeroCol = vec3(.678,.122,.122);
      drawRect(pipX, pipY-1, 1, 1, zeroCol);
      drawRect(pipX+1, pipY-2, 1, 1, zeroCol);
      return;
    }
    
    while(totalPips-pipIndex >= 5) {
      bool startBonus = pipIndex >= totalPips-bonusPips;
      bool endBonus = pipIndex+4 >= totalPips-bonusPips;
      vec3 bigCol = startBonus ? bpc : pipCol;
      drawRect(pipX, pipY-bigPipHeight, pipWidth, bigPipHeight, bigCol);
      if (endBonus) {
        drawRect(pipX+1, pipY-bigPipHeight, pipWidth-1, bigPipHeight, bpc);
      }
      pipIndex += 5;
      pipY -= (bigPipHeight+1);
    }

    while(pipIndex < totalPips) {
      drawRect(pipX, pipY-smallPipHeight, pipWidth, smallPipHeight, pipIndex < totalPips-bonusPips ? pipCol : bpc);
      pipIndex ++;
      pipY -= (smallPipHeight+1);
    }
}

void main() {
	vec2 UV = v_diffuseUV/(512.0/float(size));

	// base colour
	gl_FragColor.rgba = dark;

	int mySide = int(v_normal.x+0.1);

	// add face image
	vec2 face = u_face[mySide];
	vec4 faceColour = texture2D(u_texture, face+UV);
	// add glow to face
	if(u_landedSide == mySide) {
		faceColour.rgb += (faceColour.rgb-dark.rgb)*u_glow;
	}

	gl_FragColor.rgb =  gl_FragColor.rgb *(1.0-faceColour.a) +faceColour.rgb*(faceColour.a);

	// add lapels
	vec4 lapelColour = texture2D(u_texture, u_lapel+UV);
  if(lapelColour.a<0.2){
    drawRect(0, 0, size, 1, v_villagerColour.rgb);
    drawRect(0, 0, 1, size, v_villagerColour.rgb);
    drawRect(0, size-1, size, 1, v_villagerColour.rgb);
    drawRect(size-1, 0, 1, size, v_villagerColour.rgb);
	}
	else{
		gl_FragColor.rgb =  gl_FragColor.rgb*(1.0-lapelColour.a) + lapelColour.rgb*lapelColour.a;
	}

  // draw keyword corners
  {
    float wholeDiceSize = float(size);
    for(int keywordIndex=0;keywordIndex<4;keywordIndex++) {
      vec4 loc = u_keyword[mySide*4+keywordIndex];
      float keywordSize = loc.a;
      float keywordWidth = float(mod(loc.a,20.));
      float keywordHeight = float(int(loc.a/20.));
      if(loc.x == 0. || loc.y == 0.) {
        continue;
      }
      bool bot = mod(float(keywordIndex),3.)==0.;
      bool left = keywordIndex<2;

      drawTexture(
        u_keyword[mySide*4+keywordIndex].xy,
        vec2(
          1.+ (left?0.:1.) * (wholeDiceSize - keywordWidth -2.),
          1.+ (bot?1.:0.) * (wholeDiceSize - keywordHeight -2.)
        ),
        vec2(keywordWidth,keywordHeight),
        !left&&loc.b==1.,
        !bot&&loc.b==1.
      );
    }
  }

  // drawPipsOld(mySide, UV);
  drawAllPips(mySide);

}
