/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.physics.bullet.collision;

import com.badlogic.gdx.physics.bullet.BulletBase;
import com.badlogic.gdx.physics.bullet.collision.CollisionJNI;
import com.badlogic.gdx.physics.bullet.collision.LocalRayResult;
import com.badlogic.gdx.physics.bullet.collision.btBroadphaseProxy;
import com.badlogic.gdx.physics.bullet.collision.btCollisionObject;

public class RayResultCallback
extends BulletBase {
    private long swigCPtr;

    protected RayResultCallback(String className, long cPtr, boolean cMemoryOwn) {
        super(className, cPtr, cMemoryOwn);
        this.swigCPtr = cPtr;
    }

    public RayResultCallback(long cPtr, boolean cMemoryOwn) {
        this("RayResultCallback", cPtr, cMemoryOwn);
        this.construct();
    }

    @Override
    protected void reset(long cPtr, boolean cMemoryOwn) {
        if (!this.destroyed) {
            this.destroy();
        }
        this.swigCPtr = cPtr;
        super.reset(this.swigCPtr, cMemoryOwn);
    }

    public static long getCPtr(RayResultCallback obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    @Override
    protected void finalize() throws Throwable {
        if (!this.destroyed) {
            this.destroy();
        }
        super.finalize();
    }

    @Override
    protected synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                CollisionJNI.delete_RayResultCallback(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
        super.delete();
    }

    protected void swigDirectorDisconnect() {
        this.swigCMemOwn = false;
        this.delete();
    }

    public void swigReleaseOwnership() {
        this.swigCMemOwn = false;
        CollisionJNI.RayResultCallback_change_ownership(this, this.swigCPtr, false);
    }

    public void swigTakeOwnership() {
        this.swigCMemOwn = true;
        CollisionJNI.RayResultCallback_change_ownership(this, this.swigCPtr, true);
    }

    public void setClosestHitFraction(float value) {
        CollisionJNI.RayResultCallback_closestHitFraction_set(this.swigCPtr, this, value);
    }

    public float getClosestHitFraction() {
        return CollisionJNI.RayResultCallback_closestHitFraction_get(this.swigCPtr, this);
    }

    public void setCollisionObject(btCollisionObject value) {
        CollisionJNI.RayResultCallback_collisionObject_set(this.swigCPtr, this, btCollisionObject.getCPtr(value), value);
    }

    public btCollisionObject getCollisionObject() {
        return btCollisionObject.getInstance(CollisionJNI.RayResultCallback_collisionObject_get(this.swigCPtr, this), false);
    }

    public void setCollisionFilterGroup(int value) {
        CollisionJNI.RayResultCallback_collisionFilterGroup_set(this.swigCPtr, this, value);
    }

    public int getCollisionFilterGroup() {
        return CollisionJNI.RayResultCallback_collisionFilterGroup_get(this.swigCPtr, this);
    }

    public void setCollisionFilterMask(int value) {
        CollisionJNI.RayResultCallback_collisionFilterMask_set(this.swigCPtr, this, value);
    }

    public int getCollisionFilterMask() {
        return CollisionJNI.RayResultCallback_collisionFilterMask_get(this.swigCPtr, this);
    }

    public void setFlags(long value) {
        CollisionJNI.RayResultCallback_flags_set(this.swigCPtr, this, value);
    }

    public long getFlags() {
        return CollisionJNI.RayResultCallback_flags_get(this.swigCPtr, this);
    }

    public boolean hasHit() {
        return CollisionJNI.RayResultCallback_hasHit(this.swigCPtr, this);
    }

    public RayResultCallback() {
        this(CollisionJNI.new_RayResultCallback(), true);
        CollisionJNI.RayResultCallback_director_connect(this, this.swigCPtr, this.swigCMemOwn, true);
    }

    public boolean needsCollision(btBroadphaseProxy proxy0) {
        return this.getClass() == RayResultCallback.class ? CollisionJNI.RayResultCallback_needsCollision(this.swigCPtr, this, btBroadphaseProxy.getCPtr(proxy0), proxy0) : CollisionJNI.RayResultCallback_needsCollisionSwigExplicitRayResultCallback(this.swigCPtr, this, btBroadphaseProxy.getCPtr(proxy0), proxy0);
    }

    public float addSingleResult(LocalRayResult rayResult, boolean normalInWorldSpace) {
        return CollisionJNI.RayResultCallback_addSingleResult(this.swigCPtr, this, LocalRayResult.getCPtr(rayResult), rayResult, normalInWorldSpace);
    }
}

