/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice;

import com.badlogic.gdx.Application;
import com.badlogic.gdx.ApplicationAdapter;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputMultiplexer;
import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.glutils.FrameBuffer;
import com.badlogic.gdx.graphics.glutils.HdpiUtils;
import com.badlogic.gdx.graphics.profiling.GLProfiler;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonWriter;
import com.badlogic.gdx.utils.viewport.FitViewport;
import com.tann.dice.gameplay.battleTest.BattleTestUtils;
import com.tann.dice.gameplay.content.ent.die.Die;
import com.tann.dice.gameplay.content.ent.die.side.EntSidesLib;
import com.tann.dice.gameplay.content.ent.type.lib.HeroTypeLib;
import com.tann.dice.gameplay.content.ent.type.lib.MonsterTypeLib;
import com.tann.dice.gameplay.content.gen.pipe.PipeUtils;
import com.tann.dice.gameplay.content.item.ItemLib;
import com.tann.dice.gameplay.context.DungeonContext;
import com.tann.dice.gameplay.context.config.ContextConfig;
import com.tann.dice.gameplay.effect.eff.keyword.KUtils;
import com.tann.dice.gameplay.effect.targetable.ability.AbilityUtils;
import com.tann.dice.gameplay.fightLog.EntSideState;
import com.tann.dice.gameplay.fightLog.EntState;
import com.tann.dice.gameplay.leaderboard.LeaderboardBlob;
import com.tann.dice.gameplay.mode.Mode;
import com.tann.dice.gameplay.modifier.ModifierLib;
import com.tann.dice.gameplay.phase.PhaseManager;
import com.tann.dice.gameplay.progress.MasterStats;
import com.tann.dice.gameplay.progress.UnlockManager;
import com.tann.dice.gameplay.save.SaveState;
import com.tann.dice.gameplay.save.settings.Settings;
import com.tann.dice.gameplay.save.settings.option.OptionLib;
import com.tann.dice.platform.audio.SoundHandler;
import com.tann.dice.platform.control.Control;
import com.tann.dice.screens.Screen;
import com.tann.dice.screens.dungeon.DungeonScreen;
import com.tann.dice.screens.dungeon.DungeonUtils;
import com.tann.dice.screens.dungeon.panels.book.Book;
import com.tann.dice.screens.generalPanels.InventoryPanel;
import com.tann.dice.screens.pauseScreen.PauseScreen;
import com.tann.dice.screens.shaderFx.FXContainer;
import com.tann.dice.screens.splashScreen.SplashDraw;
import com.tann.dice.screens.titleScreen.TitleScreen;
import com.tann.dice.statics.ImageUtils;
import com.tann.dice.statics.bullet.BulletStuff;
import com.tann.dice.statics.sound.Sounds;
import com.tann.dice.statics.sound.music.MusicManager;
import com.tann.dice.util.Colours;
import com.tann.dice.util.Draw;
import com.tann.dice.util.Noise;
import com.tann.dice.util.Pair;
import com.tann.dice.util.Pixl;
import com.tann.dice.util.Tann;
import com.tann.dice.util.TannFont;
import com.tann.dice.util.TannLog;
import com.tann.dice.util.TannStage;
import com.tann.dice.util.TimerUtil;
import com.tann.dice.util.VersionUtils;
import com.tann.dice.util.image.ImageFilter;
import com.tann.dice.util.saves.Prefs;
import com.tann.dice.util.ui.TextWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class Main
extends ApplicationAdapter {
    public static final boolean preppingForRelease = true;
    public static boolean demo = false;
    public static final String url = "https://tann.fun";
    public static final boolean trackBadFrames = false;
    public static int scale;
    public static int width;
    public static int height;
    private boolean isPaused;
    private int rotation;
    SpriteBatch bufferDrawer;
    public static TannStage stage;
    public OrthographicCamera orthoCam;
    public static TextureAtlas atlas;
    public static TextureAtlas atlas_big;
    public static TextureAtlas atlas_3d;
    private static boolean printCalls;
    Screen currentScreen;
    public static float secs;
    public static int frames;
    private static long lastResize;
    private final SoundHandler soundHandler;
    public final Control control;
    FrameBuffer fb;
    boolean settedUp;
    boolean invalidScale;
    public MasterStats masterStats;
    public Settings settings;
    static float noiseFromTicks;
    static Vector2 cursor;
    SplashDraw splashScreen;
    GLProfiler glp;
    private int SCREEN_WIDTH;
    private int SCREEN_HEIGHT;
    private int prevScaleAdjust = -500;
    private int prevDiceAdjust = -500;
    private static final long SCALE_COOLDOWN = 300L;
    private long lastSetupScale = 0L;
    int badFrames;
    public static int bonusRenderCalls;
    boolean fullscreening;
    String pausedKey;
    private boolean timerAlreadyCleared = false;
    int oldWidth;
    int oldHeight;
    SpriteBatch backgroundBatch;
    public static boolean chadwick;
    public static boolean renderSwapChadwick;
    private static long previousTime;
    private static List<Pair<String, Long[]>> times;
    private static int chadSamples;
    private static Json json;
    private static Json jsonMini;

    public Main(SoundHandler soundHandler, Control control, boolean demo, boolean debug) {
        this.soundHandler = soundHandler;
        this.control = control;
        Main.demo = demo;
    }

    public static String resolutionString() {
        return width + ":" + height + ":" + scale + ":" + Gdx.graphics.getWidth() + ":" + Gdx.graphics.getHeight();
    }

    public static boolean justResized() {
        return System.currentTimeMillis() - lastResize < 100L;
    }

    public int notch(int direction) {
        return (int)((float)this.control.getNotches()[direction] / (float)scale);
    }

    public Main(SoundHandler soundHandler, Control control, boolean demo) {
        this(soundHandler, control, demo, false);
    }

    public static Screen getCurrentScreen() {
        return Main.self().currentScreen;
    }

    public static Main self() {
        return (Main)Gdx.app.getApplicationListener();
    }

    public static UnlockManager unlockManager() {
        return Main.self().masterStats.getUnlockManager();
    }

    public static float getNoiseFromTicks() {
        return noiseFromTicks;
    }

    public static float pulsateFactor() {
        return Main.pulsateFactor(1.0f);
    }

    public static float pulsateFactor(float factor) {
        return (float)(Math.sin(secs * 5.0f * factor) + 1.0) / 2.0f;
    }

    public static float getDeltaMultiple() {
        return 1.0f;
    }

    public static Vector2 getCursor() {
        cursor.set(Gdx.input.getX() / scale, height - Gdx.input.getY() / scale);
        return cursor;
    }

    public static boolean isPortrait() {
        return (float)height > (float)width * 0.9f;
    }

    @Override
    public void create() {
        frames = 0;
        if (printCalls) {
            System.out.println("create");
        }
        this.splashScreen = new SplashDraw();
    }

    private void load() {
        Locale.setDefault(Locale.ENGLISH);
        TannLog.log("load1");
        Colours.init();
        OptionLib.init();
        TannLog.log("load2");
        VersionUtils.VERSION_COL = Colours.secretCol(VersionUtils.versionName.hashCode());
        this.loadAtli();
        Mode.init();
        TannLog.log("load3");
        this.setupJson();
        String settingsJson = Prefs.getString("settings", null);
        TannLog.log("load4");
        if (settingsJson == null) {
            TannLog.log("load4.1");
            this.resetSettings();
            TannLog.log("load4.2");
        } else {
            try {
                TannLog.log("load4.3");
                this.settings = Main.getJson().fromJson(Settings.class, settingsJson);
            }
            catch (Exception e) {
                e.printStackTrace();
                TannLog.error("Failed to load settings: " + e.getMessage());
                this.resetSettings();
            }
        }
        TannLog.log("load5");
        Main.getSettings().loadUp();
        this.control.onStart();
        this.bufferDrawer = new SpriteBatch();
        TannLog.log("load6");
        Sounds.setup(this.soundHandler);
        TannLog.log("load7");
        Draw.setup();
        TextWriter.setup();
        KUtils.init();
        HeroTypeLib.init();
        MonsterTypeLib.init();
        ItemLib.init();
        ModifierLib.init();
        AbilityUtils.init();
        PipeUtils.init();
        TannLog.log("load8");
        MusicManager.initMusic();
        TannLog.log("load9");
        BattleTestUtils.init();
        ContextConfig.resetCache();
        LeaderboardBlob.setupLeaderboards();
        FXContainer.loadAllShaders();
        this.masterStats = new MasterStats();
        this.masterStats.init();
        this.setupScale();
        if (Main.getCurrentScreen() == null) {
            this.setScreen(new TitleScreen());
        }
        if (OptionLib.SHOW_RENDERCALLS.c()) {
            this.glp = new GLProfiler(Gdx.graphics);
            this.glp.enable();
        }
        this.settedUp = true;
        if (Gdx.app.getType() != Application.ApplicationType.iOS) {
            this.control.checkPurchase();
        }
    }

    private void loadAtli() {
        atlas = new TextureAtlas(Gdx.files.internal("2d/atlas_image.atlas"));
        atlas_big = new TextureAtlas(Gdx.files.internal("2dBig/atlas_image.atlas"));
        atlas_3d = new TextureAtlas(Gdx.files.internal("3d/atlas_image.atlas"));
        for (Texture t : atlas_3d.getTextures()) {
            t.setFilter(Texture.TextureFilter.Nearest, Texture.TextureFilter.Nearest);
        }
    }

    public void setupScale() {
        this.lastSetupScale = System.currentTimeMillis();
        boolean wasInMenu = Tann.findByClass(stage, DungeonUtils.CogTag.class) != null;
        boolean wasInBook = Book.inBook();
        this.initBGBatch();
        int scaleAdjust = 0;
        int diceScale = 0;
        if (Main.getSettings() != null) {
            scaleAdjust = Main.getSettings().getScaleAdjust();
            diceScale = Main.getSettings().getDiceAdjust();
        }
        if (Gdx.app.getType() != Application.ApplicationType.iOS && this.SCREEN_WIDTH == Gdx.graphics.getWidth() && this.SCREEN_HEIGHT == Gdx.graphics.getHeight() && this.prevScaleAdjust == scaleAdjust && this.prevDiceAdjust == diceScale) {
            return;
        }
        this.prevScaleAdjust = scaleAdjust;
        this.prevDiceAdjust = diceScale;
        this.SCREEN_WIDTH = Gdx.graphics.getWidth();
        this.SCREEN_HEIGHT = Gdx.graphics.getHeight();
        boolean vert = this.SCREEN_HEIGHT > this.SCREEN_WIDTH;
        int maxD = Math.max(this.SCREEN_HEIGHT, this.SCREEN_WIDTH);
        int minD = Math.min(this.SCREEN_HEIGHT, this.SCREEN_WIDTH);
        int maxDiv = 290;
        int minDiv = vert ? 175 : 155;
        scale = Math.min(maxD / maxDiv, minD / minDiv);
        TannLog.log("Detected screen dimensions: " + this.SCREEN_WIDTH + "/" + this.SCREEN_HEIGHT + ", base scale: " + scale + "(" + scaleAdjust + ")");
        boolean bl = this.invalidScale = scale == 0;
        if (this.invalidScale) {
            return;
        }
        scale = Math.max(1, scale + scaleAdjust);
        width = this.SCREEN_WIDTH / scale;
        height = this.SCREEN_HEIGHT / scale;
        if (this.fb != null) {
            this.fb.dispose();
        }
        this.fb = new FrameBuffer(Pixmap.Format.RGBA8888, width, height, true);
        TannLog.log("FB init");
        ((Texture)this.fb.getColorBufferTexture()).setFilter(Texture.TextureFilter.Nearest, Texture.TextureFilter.Nearest);
        if (stage != null) {
            stage.clear();
        }
        stage = new TannStage(new FitViewport(width, height));
        stage.getBatch().setBlendFunctionSeparate(770, 771, 1, 1);
        this.orthoCam = (OrthographicCamera)stage.getCamera();
        BulletStuff.init();
        InventoryPanel.resetSingleton();
        stage.addListener(new InputListener(){

            @Override
            public boolean keyDown(InputEvent event, int keycode) {
                Main.this.currentScreen.mainKeyPress(keycode);
                return true;
            }
        });
        this.bufferDrawer = new SpriteBatch();
        TannLog.log("pre set screen");
        if (this.currentScreen != null) {
            this.setScreen(this.currentScreen.copy());
        } else {
            this.setScreen(new TitleScreen());
        }
        TannLog.log("post set screen");
        Gdx.input.setInputProcessor(new InputMultiplexer(this.makeSuperInput(), stage, this.makeDiceInput()));
        if (wasInBook) {
            Book.openBook(false);
        }
        if (wasInMenu) {
            DungeonUtils.showCogMenu();
        }
    }

    @Override
    public void render() {
        if (this.glp != null) {
            this.glp.reset();
        }
        Gdx.gl.glClear(256);
        Gdx.gl.glClear(16384);
        if (this.invalidScale) {
            this.splashScreen.draw(SplashDraw.SplashType.InvalidResolution);
            return;
        }
        switch (++frames) {
            case 1: {
                this.splashScreen.draw(SplashDraw.SplashType.Loading);
                return;
            }
            case 2: {
                long t = System.currentTimeMillis();
                this.load();
                TannLog.log("Load: " + (System.currentTimeMillis() - t) + "ms");
                return;
            }
            case 3: {
                Main.self().control.afterLoad();
            }
        }
        if (Main.self().control.belayRescale() && Gdx.graphics.getWidth() > 0 && Gdx.graphics.getHeight() > 0 && (this.SCREEN_WIDTH != Gdx.graphics.getWidth() || this.SCREEN_HEIGHT != Gdx.graphics.getHeight()) && System.currentTimeMillis() - this.lastSetupScale > 300L) {
            this.setupScale();
        }
        if (!this.settedUp) {
            throw new RuntimeException("Trying to render before finished setting up, frame: " + frames);
        }
        Main.resetTime();
        if (frames >= 2) {
            this.update(Gdx.graphics.getDeltaTime());
        }
        Main.logTime("upd");
        if (!this.fullscreening) {
            this.actuallyRender();
        }
        this.fullscreening = false;
    }

    private void actuallyRender() {
        bonusRenderCalls = 0;
        this.start2d(false);
        Gdx.gl.glClear(16384);
        stage.draw();
        if (OptionLib.SHOW_GRB.c()) {
            Batch b = stage.getBatch();
            b.begin();
            this.drawGRB(stage.getBatch());
            b.end();
        }
        this.stop2d(false);
        if (renderSwapChadwick) {
            System.out.println("foreground: " + ((SpriteBatch)Main.stage.getBatch()).renderCalls);
        }
        Main.logTime("frg");
        if (this.glp != null && OptionLib.SHOW_RENDERCALLS.c()) {
            String s = "draw calls: " + this.glp.getDrawCalls() + "[n]tex bind: " + this.glp.getTextureBindings() + "[n]shad swit: " + this.glp.getShaderSwitches() + "[n]calls: " + this.glp.getCalls();
            Group tw = new Pixl(0, 3).border(Colours.orange).text(s).pix();
            Batch b = stage.getBatch();
            b.begin();
            ((Actor)tw).draw(b, 1.0f);
            b.end();
        }
    }

    private void drawGRB(Batch batch) {
        Group a = new Pixl(3).border(Colours.grey).text("[green]" + EntState.cnt).row().text("[red]" + EntSideState.cnt).pix();
        ((Actor)a).draw(batch, 0.0f);
    }

    public void start2d(boolean startBatch) {
        stage.getBatch().flush();
        this.fb.begin();
        Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
        Gdx.gl.glClear(16384);
        if (startBatch) {
            stage.getBatch().begin();
        }
    }

    public void stop2d(boolean stopBatch) {
        if (stopBatch) {
            stage.getBatch().end();
        }
        this.fb.end();
        this.drawBufferToScreen();
        Gdx.gl.glClear(256);
    }

    private void drawBufferToScreen() {
        stage.getBatch().flush();
        this.bufferDrawer.begin();
        Draw.drawRotatedScaledFlipped(this.bufferDrawer, (Texture)this.fb.getColorBufferTexture(), 0.0f, 0.0f, scale, scale, 0.0f, false, true);
        this.bufferDrawer.end();
    }

    public void update(float delta) {
        if (this.isPaused) {
            return;
        }
        TimerUtil.tick(delta);
        int rotation = Gdx.input.getRotation();
        if (rotation != this.rotation) {
            this.rotation = rotation;
            this.setupScale();
        }
        delta = Math.min(0.033333335f, delta);
        noiseFromTicks = (float)Noise.noise(secs, 0.0);
        BulletStuff.update(delta *= Main.getDeltaMultiple());
        stage.act(delta);
        secs += delta;
        TannFont.bonusSin = 0.0f;
        if (!Main.justResized()) {
            MusicManager.tick(delta);
        }
    }

    @Override
    public void pause() {
        super.pause();
        this.isPaused = true;
        if (printCalls) {
            System.out.println("pause");
        }
        if (!this.control.unloadWhilePaused()) {
            return;
        }
        TannFont.GLOBAL_GLITCH = false;
        if (Main.getCurrentScreen() instanceof DungeonScreen) {
            DungeonContext dc = ((DungeonScreen)Main.getCurrentScreen()).getDungeonContext();
            this.pausedKey = dc.getContextConfig().getGeneralSaveKey();
            dc.getContextConfig().quitAction();
            this.setScreen(new PauseScreen());
            this.clearCaches();
        }
        BulletStuff.dispose();
    }

    @Override
    public void resume() {
        this.isPaused = false;
        if (!Main.self().control.unloadWhilePaused()) {
            return;
        }
        BulletStuff.init();
        BattleTestUtils.init();
        if (this.pausedKey != null) {
            final String fPause = this.pausedKey;
            this.pausedKey = null;
            TimerUtil.clearStatics();
            this.timerAlreadyCleared = true;
            Tann.delayOneFrame(new Runnable(){

                @Override
                public void run() {
                    DungeonScreen.clearStaticReference();
                    SaveState toLoad = SaveState.load(fPause);
                    if (toLoad != null) {
                        toLoad.start();
                    } else {
                        TannLog.log("Failed to load save on resume for some reason: " + Main.this.pausedKey, TannLog.Severity.error);
                        TannLog.log(Prefs.getString(fPause, "null pref"), TannLog.Severity.error);
                    }
                    Main.getCurrentScreen().act(0.5f);
                }
            });
        }
        if (printCalls) {
            System.out.println("resume");
        }
    }

    @Override
    public void resize(int width, int height) {
        if (!this.timerAlreadyCleared) {
            TimerUtil.clearStatics();
        }
        lastResize = System.currentTimeMillis();
        this.timerAlreadyCleared = false;
        HdpiUtils.glViewport(0, 0, width, height);
        if (!this.settedUp || this.isPaused) {
            return;
        }
        if (width == 0 && height == 0) {
            return;
        }
        if (!Main.self().control.unloadWhilePaused()) {
            if (width == this.oldWidth && height == this.oldHeight) {
                return;
            }
            this.oldWidth = width;
            this.oldHeight = height;
        }
        if (!Main.self().control.belayRescale()) {
            this.setupScale();
        }
        if (printCalls) {
            System.out.println("resize");
        }
        if (this.invalidScale) {
            this.setupScale();
        }
    }

    @Override
    public void dispose() {
        System.out.println("starting dispose");
        super.dispose();
        this.disposeAll();
        this.clearAllStatics();
        if (printCalls) {
            System.out.println("dispose");
        }
        System.out.println("finished dispose");
    }

    private void initBGBatch() {
        if (this.backgroundBatch != null) {
            this.backgroundBatch.dispose();
        }
        this.backgroundBatch = new SpriteBatch();
    }

    public SpriteBatch startBackground() {
        this.backgroundBatch.begin();
        return this.backgroundBatch;
    }

    public void stopBackground() {
        this.backgroundBatch.end();
    }

    public void setFullScreen(boolean enabled) {
        this.fullscreening = true;
        this.backgroundBatch.begin();
        Draw.fillRectangle(this.backgroundBatch, 0.0f, 0.0f, 5000.0f, 5000.0f);
        this.backgroundBatch.end();
        if (enabled) {
            Gdx.graphics.setFullscreenMode(Gdx.graphics.getDisplayMode());
        } else {
            Gdx.graphics.setWindowedMode(1280, 720);
        }
    }

    public void setScreen(Screen screen) {
        if (this.currentScreen != null) {
            this.currentScreen.remove();
        }
        this.currentScreen = screen;
        stage.addActor(screen);
        screen.afterSet();
    }

    public static void logTime(String id) {
        if (!chadwick) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        long time = currentTime - previousTime;
        previousTime = currentTime;
        boolean found = false;
        for (Pair<String, Long[]> p : times) {
            if (!((String)p.a).equals(id)) continue;
            ((Long[])p.b)[Main.frames % Main.chadSamples] = time;
            found = true;
        }
        if (!found) {
            times.add(new Pair<String, Long[]>(id, new Long[chadSamples]));
        }
    }

    private static void resetTime() {
        previousTime = System.currentTimeMillis();
    }

    private void disposeAll() {
        Sounds.disposeAll();
        BulletStuff.dispose();
    }

    private void clearCaches() {
        FXContainer.clearCaches();
        Sounds.clearCaches();
        ImageFilter.clearCaches();
        ImageUtils.clearCaches();
        PhaseManager.resetSingleton();
        InventoryPanel.resetSingleton();
    }

    private void clearAllStatics() {
        if (printCalls) {
            TannLog.log("Clearing statics");
        }
        this.clearCaches();
        TimerUtil.clearStatics();
        Die.clearAllStatics();
        MusicManager.clearStatics();
        EntSidesLib.clearStatics();
    }

    private InputProcessor makeDiceInput() {
        return new InputProcessor(){

            @Override
            public boolean touchDown(int screenX, int screenY, int pointer, int button) {
                if (DungeonScreen.get() == null || !DungeonScreen.get().hasParent()) {
                    return false;
                }
                return BulletStuff.touchDown(screenX, screenY, pointer, button);
            }

            @Override
            public boolean touchUp(int screenX, int screenY, int pointer, int button) {
                BulletStuff.touchUp(screenX, screenY, pointer, button);
                return false;
            }

            @Override
            public boolean touchCancelled(int screenX, int screenY, int pointer, int button) {
                return false;
            }

            @Override
            public boolean keyDown(int keycode) {
                return false;
            }

            @Override
            public boolean keyUp(int keycode) {
                return false;
            }

            @Override
            public boolean keyTyped(char character) {
                return false;
            }

            @Override
            public boolean touchDragged(int screenX, int screenY, int pointer) {
                return false;
            }

            @Override
            public boolean mouseMoved(int screenX, int screenY) {
                return false;
            }

            @Override
            public boolean scrolled(float amountX, float amountY) {
                return false;
            }

            public boolean scrolled(int amount) {
                return false;
            }
        };
    }

    private InputProcessor makeSuperInput() {
        return new InputProcessor(){

            @Override
            public boolean keyDown(int keycode) {
                switch (keycode) {
                    case 31: {
                        Colours.SHIFTER.set(Colours.random().cpy());
                        break;
                    }
                    case 41: {
                        break;
                    }
                    case 30: {
                        break;
                    }
                }
                return false;
            }

            @Override
            public boolean keyUp(int keycode) {
                return false;
            }

            @Override
            public boolean keyTyped(char character) {
                return false;
            }

            @Override
            public boolean touchDown(int screenX, int screenY, int pointer, int button) {
                return false;
            }

            @Override
            public boolean touchUp(int screenX, int screenY, int pointer, int button) {
                return false;
            }

            @Override
            public boolean touchCancelled(int screenX, int screenY, int pointer, int button) {
                return false;
            }

            @Override
            public boolean touchDragged(int screenX, int screenY, int pointer) {
                return false;
            }

            @Override
            public boolean mouseMoved(int screenX, int screenY) {
                return false;
            }

            @Override
            public boolean scrolled(float amountX, float amountY) {
                return false;
            }
        };
    }

    public static Json getJson() {
        return Main.getJson(false);
    }

    public static Json getJson(boolean mini) {
        return mini ? jsonMini : json;
    }

    private void setupJson() {
        json = new Json();
        json.setTypeName(null);
        json.setUsePrototypes(false);
        json.setIgnoreUnknownFields(true);
        json.setOutputType(JsonWriter.OutputType.json);
        jsonMini = new Json();
        jsonMini.setTypeName(null);
        jsonMini.setUsePrototypes(true);
        jsonMini.setIgnoreUnknownFields(true);
        jsonMini.setOutputType(JsonWriter.OutputType.minimal);
    }

    public static Settings getSettings() {
        return Main.self().settings;
    }

    public void resetSettings() {
        this.settings = new Settings();
        this.settings.reset();
    }

    public static boolean versionALower(String a, String b) {
        return a != null && b != null && a.compareTo(b) < 0;
    }

    static {
        printCalls = false;
        noiseFromTicks = 0.0f;
        cursor = new Vector2();
        bonusRenderCalls = 0;
        chadwick = false;
        renderSwapChadwick = false;
        times = new ArrayList<Pair<String, Long[]>>();
        chadSamples = 20;
    }
}

