/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.battleTest.testProvider;

import com.badlogic.gdx.math.Interpolation;
import com.tann.dice.gameplay.battleTest.BattleTest;
import com.tann.dice.gameplay.battleTest.testProvider.BattleTestProvider;
import com.tann.dice.gameplay.battleTest.testProvider.TierStats;
import com.tann.dice.gameplay.content.ent.type.MonsterType;
import java.util.Arrays;

public class MonsterPowerEstimate
implements BattleTestProvider {
    final float hp;
    final float dmg;
    final float mit;
    static final int ITER = 15;

    public MonsterPowerEstimate(float testStrength) {
        this(testStrength, EstimateType.Factors);
    }

    public MonsterPowerEstimate(float testStrength, EstimateType et) {
        float scaledStrength;
        float globalScale = 1.0f;
        this.dmg = scaledStrength = testStrength * 1.0f;
        this.mit = scaledStrength * TierStats.getDefenceRatio();
        switch (et) {
            case Factors: {
                this.hp = scaledStrength * 2.5f;
                break;
            }
            case FactorsFiveHP: {
                this.hp = Interpolation.linear.apply(5.0f, 50.0f, Math.min(1.0f, testStrength / 50.0f));
                break;
            }
            case FactorsNPlusHp: {
                this.hp = scaledStrength * 1.8f + 2.0f;
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
    }

    public MonsterPowerEstimate(float hp, float dmg, float mit) {
        this.hp = hp;
        this.dmg = dmg;
        this.mit = mit;
    }

    @Override
    public float getTotalHealth() {
        return this.hp;
    }

    @Override
    public float getAvgDamage() {
        return this.dmg;
    }

    @Override
    public float getAvgMitigation() {
        return this.mit;
    }

    public static float getValue(MonsterType mt) {
        return MonsterPowerEstimate.getValue(mt, EstimateType.Factors);
    }

    public static float getValue(MonsterType mt, EstimateType et) {
        if (Float.isNaN(mt.getEffectiveHp()) || Float.isNaN(mt.getAvgEffectTier(true))) {
            return Float.NaN;
        }
        Float overrideEstimate = mt.getOverridePowerEstimate();
        if (overrideEstimate != null) {
            return overrideEstimate.floatValue();
        }
        boolean numToFight = true;
        Object[] types = new MonsterType[1];
        Arrays.fill(types, mt);
        float lowerBound = -1.0f;
        float upperBound = 200.0f;
        for (int i = 0; i < 15; ++i) {
            float toCheck = lowerBound + (upperBound - lowerBound) / 2.0f;
            MonsterPowerEstimate mpe = new MonsterPowerEstimate(toCheck, et);
            BattleTest bt = new BattleTest((BattleTestProvider)mpe, (MonsterType[])types);
            if (bt.runBattle().isPlayerVictory()) {
                upperBound = toCheck;
                continue;
            }
            lowerBound = toCheck;
        }
        if (mt.calcBackRow(1)) {
            return lowerBound * 1.05f;
        }
        return lowerBound;
    }

    public static enum EstimateType {
        Factors,
        FactorsFiveHP,
        FactorsNPlusHp;

    }
}

