/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.content.gen.pipe.mod;

import com.tann.dice.gameplay.content.gen.pipe.regex.PipeRegexNamed;
import com.tann.dice.gameplay.content.gen.pipe.regex.prnPart.PRNPart;
import com.tann.dice.gameplay.content.gen.pipe.regex.prnPart.pos.PRNPref;
import com.tann.dice.gameplay.content.item.Item;
import com.tann.dice.gameplay.content.item.ItemLib;
import com.tann.dice.gameplay.effect.eff.keyword.Keyword;
import com.tann.dice.gameplay.modifier.Modifier;
import com.tann.dice.gameplay.trigger.global.linked.all.GlobalAllEntities;
import com.tann.dice.gameplay.trigger.personal.item.AsIfHasItem;

public class PipeModAllItem
extends PipeRegexNamed<Modifier> {
    final boolean hero;

    public PipeModAllItem(boolean hero) {
        super(PipeModAllItem.getPref(hero), ITEM);
        this.hero = hero;
    }

    private static PRNPart getPref(boolean hero) {
        return new PRNPref(hero ? "allitem" : "alliteme");
    }

    @Override
    protected Modifier internalMake(String[] groups) {
        String ms = groups[0];
        if (PipeModAllItem.bad(ms)) {
            return null;
        }
        return PipeModAllItem.makeItemAll(ItemLib.byName(ms), this.hero);
    }

    public static Modifier makeItemAll(Item item, boolean hero) {
        if (item.isMissingno()) {
            return null;
        }
        float calcTier = item.getTier() * 4;
        if (item.getTier() > 0) {
            calcTier = item.getTier() * 2;
        }
        if (!hero) {
            calcTier *= -1.0f;
        }
        if (item.getReferencedKeywords().contains((Object)Keyword.potion)) {
            calcTier *= 3.0f;
        }
        Modifier result = new Modifier(calcTier, PipeModAllItem.getPref(hero) + item.getName(), new GlobalAllEntities(hero, new AsIfHasItem(item)));
        return result;
    }

    @Override
    public Modifier example() {
        Item i = ItemLib.random();
        return PipeModAllItem.makeItemAll(i, this.hero);
    }

    @Override
    public boolean canGenerate(boolean wild) {
        return wild && this.hero;
    }

    @Override
    protected Modifier generateInternal(boolean wild) {
        return this.example();
    }

    @Override
    public boolean showHigher() {
        return true;
    }

    @Override
    public boolean skipAPI() {
        return true;
    }
}

