/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.mode.creative.custom;

import com.badlogic.gdx.Input;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane;
import com.tann.dice.Main;
import com.tann.dice.gameplay.battleTest.Difficulty;
import com.tann.dice.gameplay.content.ent.type.HeroType;
import com.tann.dice.gameplay.content.ent.type.MonsterType;
import com.tann.dice.gameplay.content.ent.type.lib.HeroTypeLib;
import com.tann.dice.gameplay.content.ent.type.lib.MonsterTypeLib;
import com.tann.dice.gameplay.content.gen.pipe.Pipe;
import com.tann.dice.gameplay.content.item.Item;
import com.tann.dice.gameplay.content.item.ItemLib;
import com.tann.dice.gameplay.context.DungeonContext;
import com.tann.dice.gameplay.context.config.ContextConfig;
import com.tann.dice.gameplay.mode.Mode;
import com.tann.dice.gameplay.mode.creative.custom.AlternateModifier;
import com.tann.dice.gameplay.mode.creative.custom.CustomPreset;
import com.tann.dice.gameplay.mode.creative.pastey.PasteMode;
import com.tann.dice.gameplay.mode.meta.folder.FolderType;
import com.tann.dice.gameplay.modifier.Modifier;
import com.tann.dice.gameplay.modifier.ModifierLib;
import com.tann.dice.gameplay.modifier.ModifierUtils;
import com.tann.dice.gameplay.modifier.SmallModifierPanel;
import com.tann.dice.gameplay.save.antiCheese.AntiCheeseRerollInfo;
import com.tann.dice.gameplay.save.settings.option.Option;
import com.tann.dice.gameplay.save.settings.option.OptionLib;
import com.tann.dice.gameplay.trigger.global.Global;
import com.tann.dice.screens.dungeon.panels.book.page.cogPage.menuPanel.OptionsMenu;
import com.tann.dice.screens.dungeon.panels.entPanel.choosablePanel.ModifierPanel;
import com.tann.dice.screens.titleScreen.TitleScreen;
import com.tann.dice.statics.Images;
import com.tann.dice.statics.sound.Sounds;
import com.tann.dice.util.Colours;
import com.tann.dice.util.Pixl;
import com.tann.dice.util.Tann;
import com.tann.dice.util.listener.TannListener;
import com.tann.dice.util.ui.ClipboardUtils;
import com.tann.dice.util.ui.choice.ChoiceDialog;
import com.tann.dice.util.ui.resolver.ModifierResolver;
import com.tann.dice.util.ui.standardButton.StandardButton;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class CustomMode
extends Mode {
    static float storedY = 500000.0f;
    final String cpct = "[yellow]";
    final String slct = "[blue]";

    public CustomMode() {
        super("Custom");
    }

    @Override
    public String[] getDescriptionLines() {
        return new String[]{"Like " + Mode.CLASSIC.getTextButtonName() + " " + Difficulty.Normal.getColourTaggedName() + " but you can choose modifiers", "See [blue]ledger[cu]-[red]textmod[cu] for modding"};
    }

    @Override
    protected List<Actor> getLeftOfTitleActors() {
        return Arrays.asList(this.makeModifierPickGroup());
    }

    public static List<Modifier> getCustomModifiers() {
        List<Modifier> i = ModifierUtils.deserialiseList(Main.getSettings().getCustomModifiers());
        return i;
    }

    private void clearStored() {
        storedY = 500000.0f;
    }

    private Actor makeModifierPickGroup() {
        boolean needsScroll;
        final List<Modifier> existing = CustomMode.getCustomModifiers();
        Pixl modifiersPix = new Pixl(2, 2);
        for (int i = 0; i < existing.size(); ++i) {
            final Modifier m = existing.get(i);
            StandardButton minus = new StandardButton("[minus]").makeTiny();
            minus.setRunnable(new Runnable(){

                @Override
                public void run() {
                    Sounds.playSound(Sounds.pipSmall);
                    CustomMode.this.removeModifier(existing.indexOf(m));
                }
            });
            modifiersPix.actor(minus);
            if (existing.size() > 1 && OptionLib.CUSTOM_REARRANGE.c()) {
                boolean active = i > 0;
                StandardButton up = new StandardButton(active ? "[hp-arrow_up]" : "[grey][hp-arrow_up]").makeTiny();
                if (active) {
                    final int finalI = i;
                    up.setRunnable(new Runnable(){

                        @Override
                        public void run() {
                            Sounds.playSound(Sounds.pipSmall);
                            existing.add(finalI - 1, (Modifier)existing.remove(finalI));
                            CustomMode.this.saveAndRefresh(existing);
                        }
                    });
                }
                modifiersPix.actor(up);
            }
            SmallModifierPanel sm = new SmallModifierPanel(m);
            sm.addBasicListener();
            modifiersPix.actor(sm);
            modifiersPix.row();
        }
        Group inner = modifiersPix.pix(8);
        int MAX_SCROLLPANE_HEIGHT = Main.height / 3;
        Pixl p = new Pixl(3, 2).border(Colours.purple);
        boolean bl = needsScroll = inner.getHeight() > (float)MAX_SCROLLPANE_HEIGHT;
        if (needsScroll) {
            final ScrollPane scroll = Tann.makeScrollpane(inner);
            scroll.setHeight(Math.min((float)MAX_SCROLLPANE_HEIGHT, inner.getHeight()));
            scroll.setWidth(Math.max(inner.getWidth() + (float)(needsScroll ? 6 : 0), scroll.getWidth()));
            scroll.layout();
            scroll.setScrollY(storedY);
            scroll.updateVisualScroll();
            p.actor(scroll);
            p.gap(0).actor(new Actor(){

                @Override
                public void act(float delta) {
                    storedY = scroll.getScrollY();
                }
            });
        } else {
            p.actor(inner);
        }
        p.row().actor(this.makeButtStuff(existing));
        return p.pix();
    }

    private Pixl makeButtStuff(List<Modifier> existing) {
        int buttGap = 2;
        Pixl buttStuff = new Pixl(buttGap, buttGap);
        buttStuff.actor(this.makePlus()).actor(this.makePlusRand());
        if (existing.size() > 2) {
            buttStuff.actor(this.makeMag());
        }
        buttStuff.actor(this.makeReset());
        buttStuff.row();
        if (!existing.isEmpty()) {
            buttStuff.actor(this.makeCopy());
        }
        buttStuff.actor(this.makePaste());
        if (!existing.isEmpty()) {
            buttStuff.actor(this.makeSave());
        }
        if (!Main.getSettings().getCustomPresets().isEmpty()) {
            buttStuff.actor(this.makeLoad());
        }
        return buttStuff;
    }

    private Actor makeReset() {
        StandardButton plus = new StandardButton("clear");
        CustomMode.styleButton(plus);
        plus.setRunnable(new Runnable(){

            @Override
            public void run() {
                CustomMode.this.buttonSound();
                CustomMode.this.clearModifiers(true);
            }
        });
        return plus;
    }

    private Actor makePlus() {
        StandardButton plus = new StandardButton(" [plus] ");
        CustomMode.styleButton(plus);
        plus.setRunnable(new Runnable(){

            @Override
            public void run() {
                CustomMode.this.buttonSound();
                CustomMode.this.makeMr().activate();
            }
        });
        return plus;
    }

    private ModifierResolver makeMr() {
        ModifierResolver mr = new ModifierResolver(){

            @Override
            protected List<Modifier> failSearch(String text) {
                Item i = ItemLib.checkedByName(text);
                if (!i.isMissingno()) {
                    return AlternateModifier.showItemMods(i);
                }
                HeroType ht = HeroTypeLib.safeByName(text);
                if (!ht.isMissingno()) {
                    return AlternateModifier.showHeroMods(ht);
                }
                MonsterType mt = MonsterTypeLib.safeByName(text);
                if (!mt.isMissingno()) {
                    return AlternateModifier.showMonsterMods(mt);
                }
                return 6.makeBlank();
            }

            @Override
            public void resolve(Modifier modifier) {
                CustomMode.this.addModifier(modifier);
            }
        };
        return mr;
    }

    private Actor makePlusRand() {
        StandardButton plus = new StandardButton("[plus][p]rng");
        CustomMode.styleButton(plus);
        plus.setRunnable(new Runnable(){

            @Override
            public void run() {
                CustomMode.this.addModifier(ModifierLib.random());
            }
        });
        return plus;
    }

    private Actor makeMag() {
        StandardButton plus = new StandardButton(Images.magnifyingGlass, Colours.light);
        CustomMode.styleButton(plus);
        plus.setRunnable(new Runnable(){

            @Override
            public void run() {
                CustomMode.this.buttonSound();
                Pixl p = new Pixl(3, 3).border(Colours.purple);
                for (Modifier customModifier : CustomMode.getCustomModifiers()) {
                    ModifierPanel mp = new ModifierPanel(customModifier, false);
                    p.actor(mp, (float)Main.width * 0.6f);
                }
                Group a = p.pix();
                if (a.getHeight() > (float)Main.height) {
                    ScrollPane scrollPane = Tann.makeScrollpane(a);
                    a = scrollPane;
                }
                Main.getCurrentScreen().push(a, 0.8f);
                Tann.center(a);
            }
        });
        return plus;
    }

    private Actor makeCopy() {
        StandardButton cpy = new StandardButton("[yellow]copy");
        CustomMode.styleButton(cpy);
        cpy.setRunnable(new Runnable(){

            @Override
            public void run() {
                CustomMode.this.buttonSound();
                String result = "=" + Tann.commaList(Main.getSettings().getCustomModifiers(), ",", ",");
                CustomMode.this.offerToCopy(PasteMode.encloseBackticks(result));
            }
        });
        return cpy;
    }

    private void buttonSound() {
        Sounds.playSound(Sounds.pipSmall);
    }

    private Actor makePaste() {
        StandardButton paste = new StandardButton("[yellow]paste");
        CustomMode.styleButton(paste);
        paste.setRunnable(new Runnable(){

            @Override
            public void run() {
                Pipe.setupChecks();
                this.pasteStuff();
                Pipe.disableChecks();
            }

            private void pasteStuff() {
                String contents = ClipboardUtils.pasteSafer();
                String genericError = PasteMode.getPasteErrorGeneric(contents);
                if (genericError != null) {
                    Main.getCurrentScreen().showDialog(genericError, Colours.red);
                    return;
                }
                if ((contents = PasteMode.genericPasteTagHandleCleanup(contents)).startsWith("{")) {
                    Main.getCurrentScreen().showDialog(PasteMode.looksLikeFor(Mode.PASTE));
                    return;
                }
                boolean replace = false;
                if (contents.startsWith("=")) {
                    contents = contents.substring(1);
                    replace = true;
                }
                String[] modNames = contents.split(",");
                List<Modifier> mods = ModifierUtils.deserialiseList(Arrays.asList(modNames));
                if (!replace && mods.size() > 1) {
                    Main.getCurrentScreen().showDialog("modifier lists must start with =");
                    return;
                }
                int fails = 0;
                for (int i = mods.size() - 1; i >= 0; --i) {
                    if (!mods.get(i).isMissingno()) continue;
                    mods.remove(i);
                    ++fails;
                }
                if (mods.size() == 0) {
                    Pipe.setupChecks();
                    if (!CustomMode.this.checkOtherThings(contents)) {
                        String err = "No modifiers found";
                        Main.getCurrentScreen().showDialog(err, Colours.red);
                        CustomMode.this.buttonSound();
                    }
                    Pipe.disableChecks();
                    return;
                }
                if (fails > 0) {
                    Main.getCurrentScreen().showDialog("[red]" + fails + "/" + (fails + mods.size()) + " failed to paste, cancelling");
                    return;
                }
                if (replace) {
                    CustomMode.this.clearModifiers(false);
                }
                CustomMode.this.addModifiers(mods);
            }
        });
        return paste;
    }

    private Actor makeSave() {
        StandardButton plus = new StandardButton("[blue]save");
        CustomMode.styleButton(plus);
        plus.setRunnable(new Runnable(){

            @Override
            public void run() {
                CustomMode.this.buttonSound();
                Main.self().control.textInput(new Input.TextInputListener(){

                    @Override
                    public void input(String modeName) {
                        CustomMode.this.buttonSound();
                        CustomMode.this.savePreset(modeName, CustomMode.getCustomModifiers());
                        CustomMode.this.refreshScreen();
                        Main.getCurrentScreen().showDialog("[blue]" + modeName + " saved");
                    }

                    @Override
                    public void canceled() {
                    }
                }, "Name this stored custom mode", null, null);
            }
        });
        return plus;
    }

    private Actor makeLoad() {
        StandardButton plus = new StandardButton("[blue]load");
        CustomMode.styleButton(plus);
        plus.setRunnable(new Runnable(){

            @Override
            public void run() {
                CustomMode.this.buttonSound();
                Pixl p = new Pixl(3, 3).border(Colours.blue);
                p.text("[text]Load a stored custom mode").row();
                for (final CustomPreset customPreset : Main.getSettings().getCustomPresets()) {
                    StandardButton sb = new StandardButton("[text]" + customPreset.getTitle());
                    sb.addListener(new TannListener(){

                        @Override
                        public boolean action(int button, int pointer, float x, float y) {
                            CustomMode.this.clearModifiers(false);
                            CustomMode.this.addModifiers(customPreset.getContentAsModifiers());
                            Main.getCurrentScreen().popAllLight();
                            return true;
                        }

                        @Override
                        public boolean info(int button, float x, float y) {
                            CustomMode.this.buttonSound();
                            ChoiceDialog cd = new ChoiceDialog("Delete " + customPreset.getTitle() + "?", ChoiceDialog.ChoiceNames.YesCancel, new Runnable(){

                                @Override
                                public void run() {
                                    CustomMode.this.buttonSound();
                                    Main.getSettings().removePreset(customPreset);
                                    CustomMode.this.refreshScreen();
                                }
                            }, new Runnable(){

                                @Override
                                public void run() {
                                    Main.getCurrentScreen().popSingleMedium();
                                }
                            });
                            Main.getCurrentScreen().push(cd);
                            Tann.center(cd);
                            return true;
                        }
                    });
                    p.actor(sb, 150.0f);
                }
                Group a = p.pix();
                if (a.getHeight() > (float)Main.height) {
                    a = Tann.makeScrollpane(a);
                }
                Main.getCurrentScreen().push(a, 0.8f);
                Tann.center(a);
            }
        });
        return plus;
    }

    private void savePreset(String name, List<Modifier> customModifiers) {
        CustomPreset cp = new CustomPreset(name, customModifiers);
        Main.getSettings().addPreset(cp);
    }

    private boolean checkOtherThings(String contents) {
        return this.makeMr().debugSearch(contents);
    }

    private static void styleButton(StandardButton sb) {
        sb.makeTiny();
    }

    private void offerToCopy(String result) {
        ClipboardUtils.offerToCopy(result, "Copy modifiers to clipboard?");
    }

    private void clearModifiers(boolean setScreen) {
        Main.getSettings().setCustomModifiers(new ArrayList<String>());
        if (setScreen) {
            this.refreshScreen();
        }
    }

    private void addModifiers(List<Modifier> list) {
        Sounds.playSound(Sounds.blocks);
        this.clearStored();
        List<Modifier> mods = ModifierUtils.deserialiseList(Main.getSettings().getCustomModifiers());
        mods.addAll(list);
        this.saveAndRefresh(mods);
    }

    private void removeModifier(int index) {
        List<Modifier> mods = ModifierUtils.deserialiseList(Main.getSettings().getCustomModifiers());
        mods.remove(index);
        this.saveAndRefresh(mods);
    }

    private void saveAndRefresh(List<Modifier> mods) {
        this.saveModifiers(mods);
        this.refreshScreen();
    }

    private void addModifier(Modifier m) {
        this.addModifiers(Arrays.asList(m));
    }

    private void refreshScreen() {
        Main.self().setScreen(new TitleScreen());
    }

    private void saveModifiers(List<Modifier> mods) {
        Main.getSettings().setCustomModifiers(ModifierLib.serialiseToStringList(mods));
    }

    @Override
    public boolean skipStats() {
        return true;
    }

    @Override
    public Color getColour() {
        return Colours.blue;
    }

    @Override
    protected List<ContextConfig> makeAllConfigs() {
        return Arrays.asList(new CustomConfig());
    }

    @Override
    public String getSaveKey() {
        return "custom";
    }

    @Override
    public boolean disablePartyLayout() {
        return true;
    }

    @Override
    public FolderType getFolderType() {
        return FolderType.creative;
    }

    @Override
    protected List<Actor> extraDescActors() {
        return Arrays.asList(new StandardButton("[red]options").makeTiny().setRunnable(new Runnable(){

            @Override
            public void run() {
                Sounds.playSound(Sounds.pip);
                Pixl p = new Pixl(3, 3).border(Colours.red);
                int w = (int)Math.min(200.0f, (float)Main.width * 0.5f);
                p.text(OptionsMenu.getCheckboxExp(), w).row();
                for (Option option : OptionLib.EscBopType.Modding.getOptions()) {
                    p.actor(option.makeCogActor(), w);
                }
                Group a = p.pix(8);
                Main.getCurrentScreen().push(a, true, true, false, 0.3f);
                Tann.center(a);
            }
        }));
    }

    public static class CustomConfig
    extends ContextConfig {
        public CustomConfig() {
            super(Mode.CUSTOM);
        }

        @Override
        public Collection<Global> getSpecificModeAddPhases() {
            Collection<Global> result = super.getSpecificModeAddPhases();
            return result;
        }

        @Override
        public DungeonContext makeContext(AntiCheeseRerollInfo info) {
            DungeonContext dc = super.makeContext(info);
            dc.addModifiers(CustomMode.getCustomModifiers());
            return dc;
        }
    }
}

