/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.modifier;

import com.tann.dice.gameplay.content.gen.pipe.Pipe;
import com.tann.dice.gameplay.content.gen.pipe.mod.PipeMod;
import com.tann.dice.gameplay.modifier.ModCache;
import com.tann.dice.gameplay.modifier.Modifier;
import com.tann.dice.gameplay.modifier.ModifierType;
import com.tann.dice.gameplay.modifier.bless.BlessingLib;
import com.tann.dice.gameplay.modifier.generation.CurseLib;
import com.tann.dice.gameplay.modifier.tweak.TweakLib;
import com.tann.dice.util.bsRandom.Supplier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ModifierLib {
    private static List<Modifier> all;
    private static List<Modifier> curses;
    private static List<Modifier> blessings;
    private static List<Modifier> tweaks;
    private static ModCache modCache;
    private static Map<String, List<Modifier>> hyphenCache;

    public static Modifier getMissingno() {
        return PipeMod.getMissingno();
    }

    public static boolean isWithin(Modifier m, Integer min, Integer max) {
        return !(min != null && m.getTier() < min || max != null && m.getTier() > max);
    }

    public static Modifier byName(String modifierName) {
        return PipeMod.fetch(modifierName);
    }

    public static List<Modifier> getAll() {
        return all;
    }

    public static List<Modifier> getAll(Boolean blessing) {
        if (blessing == null) {
            return ModifierLib.getAll();
        }
        return ModifierLib.getAll(blessing != false ? ModifierType.Blessing : ModifierType.Curse);
    }

    public static List<Modifier> getAll(ModifierType type) {
        if (type == null) {
            return ModifierLib.getAll();
        }
        switch (type) {
            case Blessing: {
                return blessings;
            }
            case Curse: {
                return curses;
            }
            case Tweak: {
                return tweaks;
            }
        }
        throw new RuntimeException("eip " + (Object)((Object)type));
    }

    public static void init() {
        all = new ArrayList<Modifier>();
        tweaks = ModifierLib.ul(TweakLib.makeAll());
        all.addAll(tweaks);
        curses = ModifierLib.ul(CurseLib.makeAll());
        all.addAll(curses);
        blessings = ModifierLib.ul(BlessingLib.makeAll());
        all.addAll(blessings);
        all = ModifierLib.ul(all);
        ModifierLib.validate(tweaks, 0);
        ModifierLib.validate(curses, -1);
        ModifierLib.validate(blessings, 1);
        PipeMod.init(all);
        modCache = new ModCache();
        hyphenCache = new HashMap<String, List<Modifier>>();
        for (int i = 0; i < all.size(); ++i) {
            Modifier m = all.get(i);
            String essence = m.getEssence();
            if (essence == null) continue;
            if (hyphenCache.get(essence) == null) {
                hyphenCache.put(essence, new ArrayList());
            }
            hyphenCache.get(essence).add(m);
        }
    }

    private static void validate(List<Modifier> mods, int tierSign) {
        for (int i = 0; i < mods.size(); ++i) {
            Modifier m = mods.get(i);
            if (Math.signum(m.tier) == (float)tierSign) continue;
            throw new RuntimeException("Tweak with bad tier: " + m.getTier() + "/" + m.getName());
        }
    }

    private static <T> List<T> ul(List<T> in) {
        return Collections.unmodifiableList(in);
    }

    public static List<Modifier> getAllStartingWith(String start) {
        start = start.toLowerCase();
        ArrayList<Modifier> result = new ArrayList<Modifier>();
        for (Modifier m : ModifierLib.getAll()) {
            if (m.getName().contains("11-20") || !m.getName().toLowerCase().startsWith(start)) continue;
            result.add(m);
        }
        return result;
    }

    public static List<Modifier> search(String search) {
        search = search.toLowerCase();
        ArrayList<Modifier> result = new ArrayList<Modifier>();
        List<Modifier> modifiers = ModifierLib.getAll();
        for (int i = 0; i < modifiers.size(); ++i) {
            Modifier m = modifiers.get(i);
            if (!m.getName().toLowerCase().contains(search)) continue;
            result.add(m);
        }
        return result;
    }

    public static List<String> serialiseToStringList(List<Modifier> originals) {
        ArrayList<String> strings = new ArrayList<String>();
        for (Modifier m : originals) {
            strings.add(m.getName());
        }
        return strings;
    }

    public static List<Modifier> getByNames(String ... names) {
        ArrayList<Modifier> result = new ArrayList<Modifier>();
        for (String n : names) {
            result.add(ModifierLib.byName(n));
        }
        return result;
    }

    public static Modifier random() {
        return PipeMod.randomDesigned();
    }

    public static ModCache getCache() {
        return modCache;
    }

    public static List<Modifier> findWithEssence(Modifier existingModifier) {
        return ModifierLib.findWithEssence(existingModifier.getEssence());
    }

    public static List<Modifier> findWithEssence(String part) {
        return hyphenCache.get(part);
    }

    public static Supplier<Modifier> makeSupplier() {
        return new Supplier<Modifier>(){

            @Override
            public Modifier supply() {
                return ModifierLib.random();
            }
        };
    }

    public static Modifier safeByName(String s) {
        Pipe.setupChecks();
        Modifier m = ModifierLib.byName(s);
        Pipe.disableChecks();
        return m;
    }
}

