/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.modifier;

import com.tann.dice.gameplay.content.gen.pipe.mod.PipeMod;
import com.tann.dice.gameplay.modifier.Modifier;
import com.tann.dice.gameplay.modifier.ModifierLib;
import com.tann.dice.gameplay.modifier.ModifierType;
import com.tann.dice.gameplay.modifier.ModifierUtils;
import com.tann.dice.gameplay.phase.levelEndPhase.rewardPhase.decisionPhase.choice.choosable.Choosable;
import com.tann.dice.gameplay.phase.levelEndPhase.rewardPhase.decisionPhase.choice.choosable.ChoosableUtils;
import com.tann.dice.gameplay.progress.chievo.unlock.UnUtil;
import com.tann.dice.gameplay.save.settings.option.OptionLib;
import com.tann.dice.gameplay.trigger.Collision;
import com.tann.dice.util.Tann;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public enum ModifierPickContext {
    Cursed,
    Difficulty,
    Difficulty_But_Midgame,
    Trade,
    Dificulty_Allow_T1;

    final Map<String, List<Modifier>> cache = new HashMap<String, List<Modifier>>();

    private List<Modifier> getStartCopy(Integer min, Integer max) {
        String key = min + ":" + max;
        if (this.cache.get(key) == null) {
            this.cache.put(key, this.makeStart(min, max));
        }
        return new ArrayList<Modifier>((Collection)this.cache.get(key));
    }

    private List<Modifier> makeStart(Integer min, Integer max) {
        int i;
        ArrayList<Modifier> result = new ArrayList<Modifier>(ModifierLib.getAll(ModifierType.fromTier(min, max)));
        for (i = result.size() - 1; i >= 0; --i) {
            Modifier m = (Modifier)result.get(i);
            if (!UnUtil.isLocked(m) && m != PipeMod.getMissingno() && ModifierLib.isWithin(m, min, max)) continue;
            result.remove(m);
        }
        switch (this) {
            case Difficulty: {
                Modifier potential;
                for (i = result.size() - 1; i >= 0; --i) {
                    potential = (Modifier)result.get(i);
                    if (potential.getTier() != -1 || !(Math.random() > 0.2)) continue;
                    result.remove(potential);
                }
                break;
            }
            case Difficulty_But_Midgame: 
            case Trade: {
                Modifier potential;
                for (i = result.size() - 1; i >= 0; --i) {
                    potential = (Modifier)result.get(i);
                    if (!potential.isOnPick() && !potential.allLevelsOnly() && !Collision.collides(potential.getCollisionBits(), Collision.SPECIFIC_LEVEL | Collision.ITEM_REWARD | Collision.LEVELUP_REWARD | Collision.PHASE)) continue;
                    result.remove(i);
                }
                break;
            }
        }
        return result;
    }

    public List<Modifier> getBase(List<Modifier> currentModifiers, Integer min, Integer max, Integer amt, long collisionBit) {
        boolean addGeneratedWild;
        int i;
        List<Modifier> result = this.getStartCopy(min, max);
        Collections.shuffle(result);
        float rarityRoll = Tann.random();
        HashSet<String> currentModifierEssences = new HashSet<String>();
        for (i = 0; i < currentModifiers.size(); ++i) {
            String ess = currentModifiers.get(i).getEssence();
            if (ess == null) continue;
            currentModifierEssences.add(ess);
        }
        for (i = result.size() - 1; i >= 0; --i) {
            Modifier m = result.get(i);
            if (!(m.chance() < rarityRoll) && !currentModifiers.contains(m) && !ChoosableUtils.collides((Choosable)m, collisionBit) && !currentModifierEssences.contains(m.getEssence())) continue;
            result.remove(m);
        }
        switch (this) {
            case Cursed: {
                for (i = 0; i < currentModifiers.size(); ++i) {
                    Modifier upgradedModifier;
                    Modifier existingModifier = currentModifiers.get(i);
                    if (max > 0 != existingModifier.getTier() > 0 || (upgradedModifier = ModifierUtils.someNextInChain(min, max, existingModifier)) == null) continue;
                    result.add(upgradedModifier);
                }
                break;
            }
        }
        Collections.shuffle(result);
        if (amt != null) {
            result = Tann.minList(result, amt);
        }
        boolean tweak = min != null && max != null && min == 0 && max == 0;
        boolean bl = addGeneratedWild = !tweak;
        if (min != null && max != null && Math.abs(max - min) < 2 && Math.abs(max) > 7) {
            addGeneratedWild = false;
        }
        int actualAmt = result.size();
        if (addGeneratedWild) {
            HashSet<String> currentNames = new HashSet<String>();
            for (int i2 = 0; i2 < currentModifiers.size(); ++i2) {
                currentNames.add(currentModifiers.get((int)i2).name);
            }
            for (boolean wild : Tann.BOTH) {
                if (wild && !OptionLib.WILD_MODIFIERS.c()) continue;
                int amtToGen = wild ? Tann.randomRound((float)actualAmt * OptionLib.genChance()) : Tann.randomRound((float)actualAmt * 0.21f);
                List<Modifier> gennd = ModifierLib.getCache().get(amtToGen, wild, min, max, collisionBit);
                for (int i3 = gennd.size() - 1; i3 >= 0; --i3) {
                    if (!currentNames.contains(gennd.get(i3).getName())) continue;
                    gennd.remove(i3);
                }
                result.addAll(gennd);
            }
            if (amt != null) {
                Collections.reverse(result);
                result = Tann.minList(result, amt);
            }
        }
        return result;
    }
}

