/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.phase.levelEndPhase.rewardPhase.decisionPhase.choice.choosable;

import com.tann.dice.gameplay.content.ent.type.EntType;
import com.tann.dice.gameplay.content.ent.type.lib.HeroTypeUtils;
import com.tann.dice.gameplay.content.item.Item;
import com.tann.dice.gameplay.content.item.ItemLib;
import com.tann.dice.gameplay.context.DungeonContext;
import com.tann.dice.gameplay.context.DungeonValueChoosable;
import com.tann.dice.gameplay.modifier.Modifier;
import com.tann.dice.gameplay.modifier.ModifierLib;
import com.tann.dice.gameplay.modifier.ModifierType;
import com.tann.dice.gameplay.phase.PhaseManager;
import com.tann.dice.gameplay.phase.levelEndPhase.rewardPhase.MessagePhase;
import com.tann.dice.gameplay.phase.levelEndPhase.rewardPhase.decisionPhase.choice.choosable.Choosable;
import com.tann.dice.gameplay.phase.levelEndPhase.rewardPhase.decisionPhase.choice.choosable.ChoosableType;
import com.tann.dice.gameplay.phase.levelEndPhase.rewardPhase.decisionPhase.choice.choosable.special.AndChoosable;
import com.tann.dice.gameplay.phase.levelEndPhase.rewardPhase.decisionPhase.choice.choosable.special.EnumChoosable;
import com.tann.dice.gameplay.phase.levelEndPhase.rewardPhase.decisionPhase.choice.choosable.special.LevelupHeroChoosable;
import com.tann.dice.gameplay.phase.levelEndPhase.rewardPhase.decisionPhase.choice.choosable.special.MissingnoChoosable;
import com.tann.dice.gameplay.phase.levelEndPhase.rewardPhase.decisionPhase.choice.choosable.special.OrChoosable;
import com.tann.dice.gameplay.phase.levelEndPhase.rewardPhase.decisionPhase.choice.choosable.special.RandomTieredChoosable;
import com.tann.dice.gameplay.phase.levelEndPhase.rewardPhase.decisionPhase.choice.choosable.special.RandomTieredChoosableRange;
import com.tann.dice.gameplay.phase.levelEndPhase.rewardPhase.decisionPhase.choice.choosable.special.ReplaceChoosable;
import com.tann.dice.gameplay.phase.levelEndPhase.rewardPhase.decisionPhase.choice.choosable.special.SkipChoosable;
import com.tann.dice.screens.dungeon.DungeonScreen;
import com.tann.dice.test.util.TestRunner;
import com.tann.dice.util.Tann;
import com.tann.dice.util.TannLog;
import com.tann.dice.util.tp.TP;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ChoosableUtils {
    private static final MissingnoChoosable DEF = new MissingnoChoosable();

    public static String describeList(List<Choosable> options) {
        if (options == null || options.isEmpty()) {
            return "invalid list";
        }
        ArrayList<TP<ModifierType, String>> presets = new ArrayList<TP<ModifierType, String>>();
        presets.add(new TP<ModifierType, String>(ModifierType.Blessing, "[green]blessings[cu]"));
        presets.add(new TP<ModifierType, String>(ModifierType.Curse, "[purple]curses[cu]"));
        presets.add(new TP<ModifierType, String>(ModifierType.Tweak, "[text]modifiers[cu]"));
        boolean[] valids = new boolean[presets.size()];
        Arrays.fill(valids, true);
        for (Choosable choo : options) {
            for (int i = 0; i < presets.size(); ++i) {
                int n = i;
                valids[n] = valids[n] & (choo instanceof Modifier && ((Modifier)choo).getMType() == ((TP)presets.get((int)i)).a);
            }
        }
        for (int i = 0; i < valids.length; ++i) {
            if (!valids[i]) continue;
            return (String)((TP)presets.get((int)i)).b;
        }
        if (ChoosableUtils.allMods(options)) {
            return "modifiers";
        }
        return "things";
    }

    private static boolean allMods(List<Choosable> in) {
        if (in.size() == 0) {
            return false;
        }
        for (int i = 0; i < in.size(); ++i) {
            for (Choosable oo : in) {
                if (oo instanceof Modifier) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isDefinitelySingle(Choosable c1) {
        return c1 instanceof LevelupHeroChoosable || c1 instanceof Item || c1 instanceof Modifier;
    }

    public static List<Item> fetchItems(List<Choosable> input) {
        ArrayList<Item> result = new ArrayList<Item>();
        for (Choosable choosable : input) {
            if (!(choosable instanceof Item)) continue;
            result.add((Item)choosable);
        }
        return result;
    }

    public static boolean shouldBracket(Choosable ch) {
        return ch instanceof AndChoosable || ch instanceof OrChoosable;
    }

    public static boolean isMeta(Choosable ch) {
        return ch instanceof AndChoosable || ch instanceof OrChoosable || ch instanceof RandomTieredChoosable;
    }

    public static boolean collides(Choosable a, long b) {
        return ChoosableUtils.collides(a.getCollisionBits(), b);
    }

    public static boolean collides(Choosable a, Choosable b) {
        String ae;
        if (a instanceof Modifier && b instanceof Modifier && (ae = ((Modifier)a).getEssence()) != null && ae.equalsIgnoreCase(((Modifier)b).getEssence())) {
            return true;
        }
        return ChoosableUtils.collides(a.getCollisionBits(), b.getCollisionBits());
    }

    public static boolean collides(long a, long b) {
        return (a & b) != 0L;
    }

    public static Choosable deserialise(String n) {
        return ChoosableUtils.deserialise(n, DEF);
    }

    public static Choosable deserialise(String n, Choosable def) {
        String data = "";
        if (n.length() > 1) {
            data = n.substring(1);
        }
        ChoosableType ct = ChoosableType.fromTag(n.charAt(0));
        try {
            switch (ct) {
                case Levelup: {
                    return new LevelupHeroChoosable(HeroTypeUtils.byName(data));
                }
                case Item: {
                    return ItemLib.byName(data);
                }
                case Hero: {
                    return HeroTypeUtils.byName(data);
                }
                case Modifier: {
                    return ModifierLib.byName(data);
                }
                case Random: {
                    return RandomTieredChoosable.byName(data);
                }
                case RandomRange: {
                    return RandomTieredChoosableRange.byName(data);
                }
                case Or: {
                    return OrChoosable.byName(data);
                }
                case And: {
                    return AndChoosable.byName(data);
                }
                case Skip: {
                    return new SkipChoosable();
                }
                case Enu: {
                    return EnumChoosable.valueOf(data);
                }
                case Value: {
                    return new DungeonValueChoosable(data);
                }
                case MISSINGNO: {
                    return new MissingnoChoosable();
                }
                case Replace: {
                    return ReplaceChoosable.make(data);
                }
            }
            TannLog.error("invalid choosable: " + n + ", returning " + def);
            return def;
        }
        catch (Exception e) {
            e.printStackTrace();
            TannLog.error("error to choose: " + e);
            if (TestRunner.isTesting()) {
                throw e;
            }
            return def;
        }
    }

    public static String serialiseList(List<Choosable> options) {
        return ChoosableUtils.serialiseList(options, "@3");
    }

    public static String serialiseList(List<Choosable> options, String sep) {
        ArrayList<String> result = new ArrayList<String>();
        for (Choosable option : options) {
            result.add(ChoosableUtils.fullSerialise(option));
        }
        return Tann.commaList(result, sep, sep);
    }

    public static String fullSerialise(Choosable choosable) {
        return choosable.getType().getTag() + choosable.getSaveString();
    }

    public static List<Choosable> deserialiseList(String data) {
        return ChoosableUtils.deserialiseList(data, "@3");
    }

    public static List<Choosable> deserialiseList(String data, String sep) {
        String[] parts = data.split(sep);
        ArrayList<Choosable> result = new ArrayList<Choosable>();
        for (String part : parts) {
            result.add(ChoosableUtils.deserialise(part));
        }
        return result;
    }

    public static boolean isMissingno(Choosable ch) {
        if (ch instanceof EntType) {
            return ((EntType)((Object)ch)).isMissingno();
        }
        if (ch instanceof Modifier) {
            return ((Modifier)ch).isMissingno();
        }
        if (ch instanceof Item) {
            return ((Item)ch).isMissingno();
        }
        if (ch instanceof LevelupHeroChoosable) {
            return ((LevelupHeroChoosable)ch).getHeroType().isMissingno();
        }
        if (ch instanceof MissingnoChoosable) {
            return true;
        }
        if (ch instanceof OrChoosable) {
            OrChoosable och = (OrChoosable)ch;
            return ChoosableUtils.isMissingno(och.getAll());
        }
        return false;
    }

    public static boolean isMissingno(List<Choosable> all) {
        for (int i = 0; i < all.size(); ++i) {
            if (!ChoosableUtils.isMissingno(all.get(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean anyCollides(List<Choosable> result) {
        for (int i = result.size() - 1; i >= 0; --i) {
            for (int i1 = i - 1; i1 >= 0; --i1) {
                if (!ChoosableUtils.collides(result.get(i), result.get(i1))) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean checkedOnChoose(Choosable ch, DungeonContext dc, String ctx) {
        return ChoosableUtils.checkedOnChoose(Arrays.asList(ch), dc, ctx);
    }

    public static boolean checkedOnChoose(Choosable[] ch, DungeonContext dc, String ctx) {
        return ChoosableUtils.checkedOnChoose(Arrays.asList(ch), dc, ctx);
    }

    public static boolean checkedOnChoose(List<Choosable> ch, DungeonContext dc, String ctx) {
        return ChoosableUtils.checkedOnChoose(ch, dc, ctx, 0);
    }

    public static boolean checkedOnChoose(List<Choosable> ch, DungeonContext dc, String ctx, int index) {
        try {
            for (int i = 0; i < ch.size(); ++i) {
                Choosable choosable = ch.get(i);
                choosable.onChoose(dc, index);
            }
        }
        catch (Exception e) {
            if (DungeonScreen.get() != null && PhaseManager.get() != null) {
                PhaseManager.get().pushPhaseNext(new MessagePhase(e, ctx));
            }
            e.printStackTrace();
            return false;
        }
        return true;
    }
}

