/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.trigger.global.linked;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.tann.dice.gameplay.context.DungeonContext;
import com.tann.dice.gameplay.trigger.global.Global;
import com.tann.dice.gameplay.trigger.global.linked.DipPanel;
import com.tann.dice.gameplay.trigger.global.linked.GlobalLinked;
import com.tann.dice.util.Colours;
import com.tann.dice.util.ui.TextWriter;

public class GlobalLinkedGeneric
extends GlobalLinked {
    final GenCon condition;
    final Global g;

    public GlobalLinkedGeneric(Global link, GenCon condition) {
        super(link);
        this.g = link;
        this.condition = condition;
    }

    @Override
    public Global getLinkedGlobal(DungeonContext context, int turn) {
        if (this.condition.holdsFor(context, turn)) {
            return this.g;
        }
        return super.getLinkedGlobal(context, turn);
    }

    @Override
    public String describeForSelfBuff() {
        return "If " + this.condition.describe() + ": " + this.g.describeForSelfBuff();
    }

    @Override
    public Actor makePanelActorI(boolean big) {
        return DipPanel.makeSidePanelGroup(big, (Actor)new TextWriter("[text]" + this.condition.describe(), 50), this.g, Colours.pink);
    }

    public static interface GenCon {
        public String describe();

        public boolean holdsFor(DungeonContext var1, int var2);
    }
}

