/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.trigger.global.phase.addPhase;

import com.tann.dice.gameplay.context.DungeonContext;
import com.tann.dice.gameplay.context.config.event.EventGenerator;
import com.tann.dice.gameplay.phase.Phase;
import com.tann.dice.gameplay.trigger.global.Global;
import com.tann.dice.gameplay.trigger.global.scaffolding.levelRequirement.LevelRequirement;
import com.tann.dice.gameplay.trigger.global.scaffolding.levelRequirement.LevelRequirementHash;
import com.tann.dice.util.Tann;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class GlobalAddPhaseBag
extends Global {
    private static final int MAX_PHASES = 4;
    private static final boolean log = false;
    final List<EventGenerator> adds;
    final float targetTotalStrength;

    public GlobalAddPhaseBag(List<EventGenerator> adds, float targetTotalStrength) {
        this.adds = adds;
        this.targetTotalStrength = targetTotalStrength;
        for (int i = 0; i < adds.size(); ++i) {
            LevelRequirement lr = adds.get((int)i).lr;
            if (!(lr instanceof LevelRequirementHash)) continue;
            ((LevelRequirementHash)lr).setSeedOffset(i);
        }
    }

    @Override
    public List<Phase> getPhases(DungeonContext dungeonContext) {
        List<EventGenerator> actives = this.getActives(dungeonContext);
        ArrayList<Phase> result = new ArrayList<Phase>();
        for (EventGenerator active : actives) {
            if (!active.lr.validFor(dungeonContext)) continue;
            result.addAll(active.pg.get(dungeonContext));
        }
        return result;
    }

    public List<EventGenerator> getActives(DungeonContext dc) {
        Random r = Tann.makeStdRandom(dc.getSeed());
        int attempts = 50;
        for (int i = 0; i < 50; ++i) {
            List<EventGenerator> rs = this.attemptToGetActives(r, dc);
            if (rs == null) continue;
            return rs;
        }
        return new ArrayList<EventGenerator>();
    }

    private List<EventGenerator> attemptToGetActives(Random r, DungeonContext dc) {
        ArrayList<EventGenerator> results = new ArrayList<EventGenerator>();
        ArrayList<EventGenerator> cpy = new ArrayList<EventGenerator>();
        float currentStrength = 0.0f;
        float maxOvershoot = 0.3f;
        ArrayList<Integer> takenLevels = new ArrayList<Integer>();
        for (int i = 0; i < 100; ++i) {
            float str;
            if (cpy.isEmpty()) {
                cpy = new ArrayList<EventGenerator>(this.adds);
            }
            EventGenerator rs = this.get(cpy, r);
            cpy.remove(rs);
            LevelRequirement lr = rs.lr;
            if (lr instanceof LevelRequirementHash) {
                int lv = ((LevelRequirementHash)lr).getChallengeLevel(dc);
                if (takenLevels.contains(lv)) {
                    return null;
                }
                takenLevels.add(lv);
            }
            if (currentStrength + (str = rs.getStrength(dc)) > this.targetTotalStrength + 0.3f) {
                return null;
            }
            results.add(rs);
            currentStrength += str;
            if (currentStrength >= this.targetTotalStrength) {
                return results;
            }
            if (results.size() < 4) continue;
            return null;
        }
        return results;
    }

    public EventGenerator get(List<EventGenerator> lst, Random r) {
        float total = 0.0f;
        for (EventGenerator add : lst) {
            total += add.chance;
        }
        float rnd = r.nextFloat() * total;
        for (EventGenerator t : lst) {
            if (!((rnd -= t.chance) <= 0.0f)) continue;
            return t;
        }
        throw new RuntimeException("oops?");
    }
}

