/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.trigger.global.spell;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.tann.dice.gameplay.effect.targetable.ability.Ability;
import com.tann.dice.gameplay.fightLog.Snapshot;
import com.tann.dice.gameplay.trigger.Collision;
import com.tann.dice.gameplay.trigger.global.Global;
import com.tann.dice.statics.Images;
import com.tann.dice.util.Colours;
import com.tann.dice.util.ImageActor;
import com.tann.dice.util.Pixl;
import com.tann.dice.util.Tann;
import com.tann.dice.util.lang.Words;

public class GlobalSpellsLimit
extends Global {
    final int limit;

    public GlobalSpellsLimit(int limit) {
        this.limit = limit;
    }

    @Override
    public String describeForSelfBuff() {
        if (this.limit == 0) {
            return "You cannot cast spells";
        }
        return "Maximum of " + this.limit + " " + Words.plural("spell", this.limit) + " cast per turn";
    }

    @Override
    public boolean canUseAbility(Ability ability, Snapshot snapshot) {
        return snapshot.getNumSellsCastThisTurn() < this.limit;
    }

    @Override
    public long getCollisionBits(Boolean player) {
        return Collision.SPELL;
    }

    @Override
    public Actor makePanelActorI(boolean big) {
        int gap = 3;
        if (this.limit == 0) {
            return Tann.combineActors(new ImageActor(Images.eq_triggerSpell), new ImageActor(Images.ui_cross, Colours.red));
        }
        return new Pixl().image(Images.eq_triggerSpell).gap(3).text("[red]x" + this.limit).pix();
    }

    @Override
    public String hyphenTag() {
        return this.limit + "";
    }
}

