/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.trigger.personal.affectSideModular.condition;

import com.badlogic.gdx.graphics.g2d.Batch;
import com.tann.dice.gameplay.fightLog.EntSideState;
import com.tann.dice.gameplay.fightLog.EntState;
import com.tann.dice.gameplay.trigger.personal.affectSideModular.EffectDraw;
import com.tann.dice.gameplay.trigger.personal.affectSideModular.RandomSidesView;
import com.tann.dice.gameplay.trigger.personal.affectSideModular.condition.AffectSideCondition;
import com.tann.dice.util.Colours;
import com.tann.dice.util.Draw;

public class HasValue
extends AffectSideCondition {
    public final boolean pips;

    public HasValue(boolean pips) {
        this.pips = pips;
    }

    @Override
    public boolean validFor(EntSideState sideState, EntState owner, int triggerAffectSides) {
        return sideState.getCalculatedEffect().hasValue() == this.pips;
    }

    @Override
    public String describe() {
        return this.pips ? "pipped" : "pipless";
    }

    @Override
    public EffectDraw getAddDraw() {
        final RandomSidesView result = new RandomSidesView(1);
        return new EffectDraw(){

            @Override
            public void draw(Batch batch, int x, int y) {
                if (HasValue.this.pips) {
                    batch.setColor(Colours.green);
                } else {
                    batch.setColor(Colours.red);
                }
                boolean w = true;
                boolean b = true;
                int xw = (int)((float)x + result.getWidth());
                int xo = -1;
                Draw.drawLine(batch, xw - 1 - 1 + -1, y + 1, xw - 1 + -1, (float)y + result.getHeight() - 2.0f, 1.0f);
            }
        };
    }

    @Override
    public boolean hasSideImage() {
        return true;
    }
}

