/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.screens;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.EventListener;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.tann.dice.Main;
import com.tann.dice.gameplay.phase.levelEndPhase.rewardPhase.MessagePhase;
import com.tann.dice.gameplay.save.settings.option.OptionLib;
import com.tann.dice.screens.dungeon.DungeonUtils;
import com.tann.dice.screens.dungeon.panels.Explanel.Explanel;
import com.tann.dice.screens.dungeon.panels.ExplanelReposition;
import com.tann.dice.screens.dungeon.panels.book.Book;
import com.tann.dice.screens.dungeon.panels.popup.PopupHolder;
import com.tann.dice.screens.generalPanels.InventoryPanel;
import com.tann.dice.screens.generalPanels.TextUrl;
import com.tann.dice.screens.shaderFx.FXContainer;
import com.tann.dice.statics.sound.Sounds;
import com.tann.dice.util.AlternativePop;
import com.tann.dice.util.Colours;
import com.tann.dice.util.InputBlocker;
import com.tann.dice.util.KeyListen;
import com.tann.dice.util.Pair;
import com.tann.dice.util.Pixl;
import com.tann.dice.util.PopListen;
import com.tann.dice.util.PopRequirement;
import com.tann.dice.util.PostPop;
import com.tann.dice.util.Tann;
import com.tann.dice.util.TannLog;
import com.tann.dice.util.TannStageUtils;
import com.tann.dice.util.ui.Glowverlay;
import com.tann.dice.util.ui.TextWriter;
import java.util.ArrayList;
import java.util.List;

public abstract class Screen
extends Group
implements ExplanelReposition {
    private PopupHolder popupHolder;
    final InputListener SELF_POP = new InputListener(){

        @Override
        public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
            if (event.isHandled()) {
                return true;
            }
            boolean popped = Screen.this.pop(event.getListenerActor());
            if (!popped) {
                Screen.this.popSingleLight();
            }
            Sounds.playSound(Sounds.pop);
            return true;
        }
    };
    public List<Pair<Actor, InputBlocker>> modalStack = new ArrayList<Pair<Actor, InputBlocker>>();
    List<Glowverlay> glowverlays = new ArrayList<Glowverlay>();

    public Screen() {
        this.setSize(Main.width, Main.height);
        this.resetPopupHolder();
    }

    protected void resetPopupHolder() {
        if (this.popupHolder != null) {
            this.popupHolder.remove();
        }
        this.popupHolder = new PopupHolder();
        Main.unlockManager().registerAchievementListener(this.popupHolder);
        this.addActor(this.popupHolder);
        this.popupHolder.setPosition(this.getWidth() - this.popupHolder.getWidth(), Main.height);
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        this.preDraw(batch);
        batch.end();
        batch.begin();
        super.draw(batch, parentAlpha);
        batch.flush();
        this.postDraw(batch);
    }

    public abstract void preDraw(Batch var1);

    public abstract void postDraw(Batch var1);

    public void popupText(String s) {
        this.popupHolder.addText(s);
    }

    public void addPopup(Actor a) {
        this.popupHolder.addPopup(a);
    }

    @Override
    public void act(float delta) {
        this.preTick(delta);
        super.act(delta);
        this.postTick(delta);
    }

    public abstract void preTick(float var1);

    public abstract void postTick(float var1);

    public final void mainKeyPress(int keycode) {
        if (this.genericKeyPress(keycode)) {
            return;
        }
        this.keyPress(keycode);
    }

    private boolean genericKeyPress(int keycode) {
        Actor a = this.getTopActualActor();
        if (a instanceof KeyListen && ((KeyListen)((Object)a)).keyPress(keycode)) {
            return true;
        }
        switch (keycode) {
            case 111: {
                boolean popped = this.popAllMedium();
                if (popped) {
                    Sounds.playSound(Sounds.pop);
                }
                if (!popped) {
                    Sounds.playSound(Sounds.pip);
                    DungeonUtils.showCogMenu();
                }
                return true;
            }
        }
        return Book.inBook();
    }

    protected abstract void keyPress(int var1);

    public void push(Actor a) {
        this.push(a, 0.0f);
    }

    public void push(Actor a, float alpha) {
        this.push(a, true, true, true, alpha);
    }

    public void push(Actor actor, boolean blocker, boolean blockerPops, boolean selfPops, float alpha) {
        if (actor == null) {
            actor = Pixl.makeErrorActor("ph");
        }
        InputBlocker ipb = null;
        if (blocker) {
            ipb = new InputBlocker();
            ipb.setMedium(selfPops || blockerPops);
            ipb.setAlpha(alpha);
            this.addActor(ipb);
            ipb.setActiveClicker(blockerPops);
        }
        Pair<Actor, InputBlocker> pair = new Pair<Actor, InputBlocker>(actor, ipb);
        this.modalStack.add(pair);
        this.addActor(actor);
        actor.toFront();
        if (selfPops) {
            actor.addListener(this.SELF_POP);
        }
        TannStageUtils.actorJustPushed(actor);
    }

    public void forcePop() {
        this.pop();
    }

    private boolean pop() {
        boolean allow;
        if (this.modalStack.size() == 0) {
            System.err.println("Trying to pop with nothing to pop");
            return false;
        }
        Pair<Actor, InputBlocker> toPop = this.modalStack.get(this.modalStack.size() - 1);
        if (toPop.a instanceof PopRequirement && !(allow = ((PopRequirement)toPop.a).allowPop())) {
            return false;
        }
        Pair<Actor, InputBlocker> popped = this.modalStack.remove(this.modalStack.size() - 1);
        if (!(popped.a instanceof AlternativePop) || !((AlternativePop)popped.a).alternativePop()) {
            if (OptionLib.CRAZY_UI.c()) {
                FXContainer.randomFx((Actor)popped.a).replace();
            } else {
                ((Actor)popped.a).remove();
            }
        }
        ((Actor)popped.a).removeListener(this.SELF_POP);
        if (popped.b != null) {
            ((InputBlocker)popped.b).remove();
        }
        if (popped.a instanceof PostPop) {
            ((PostPop)popped.a).postPop();
        }
        if (this.modalStack.size() > 0) {
            Pair<Actor, InputBlocker> next = this.modalStack.get(this.modalStack.size() - 1);
            if (next.b != null) {
                ((InputBlocker)next.b).toFront();
            }
            ((Actor)next.a).toFront();
            if (next.a instanceof PopListen) {
                ((PopListen)next.a).childPopped((Actor)popped.a);
            }
            TannStageUtils.actorSurfacedFromOtherPopping((Actor)next.a);
        } else {
            Actor a = this.getTopActualActor();
            if (a != null) {
                TannStageUtils.actorSurfacedFromOtherPopping(a);
            }
        }
        return true;
    }

    public boolean pop(String modal_name) {
        Actor a = this.getTopPushedActor();
        if (a == null || !modal_name.equalsIgnoreCase(a.getName())) {
            return false;
        }
        return this.pop();
    }

    public boolean pop(Class clazz) {
        if (clazz.isInstance(this.getTopPushedActor())) {
            return this.pop();
        }
        return false;
    }

    public boolean popAllLight() {
        boolean popped = false;
        while (this.popSingleLight()) {
            popped = true;
        }
        return popped;
    }

    public boolean popAllMedium() {
        boolean popped = false;
        while (this.popSingleMedium()) {
            popped = true;
        }
        return popped;
    }

    public boolean popSingleLight() {
        if (this.modalStack.size() > 0 && this.modalStack.get((int)(this.modalStack.size() - 1)).b == null && !(this.modalStack.get((int)(this.modalStack.size() - 1)).a instanceof InventoryPanel)) {
            return this.pop();
        }
        return false;
    }

    public boolean popSingleMedium() {
        if (this.popSingleLight()) {
            return true;
        }
        if (this.modalStack.size() > 0 && this.modalStack.get((int)(this.modalStack.size() - 1)).b != null && ((InputBlocker)this.modalStack.get((int)(this.modalStack.size() - 1)).b).isMedium()) {
            return this.pop();
        }
        return false;
    }

    public boolean pop(Actor a) {
        if (a == null) {
            TannLog.error("Trying to pop a null actor");
            return false;
        }
        if (this.modalStack.size() == 0) {
            TannLog.error("Trying to pop with nothing to pop");
            return false;
        }
        Pair<Actor, InputBlocker> p = this.modalStack.get(this.modalStack.size() - 1);
        if (p.a != a) {
            TannLog.error("Popping wrong panel. Expected " + a.getClass().getSimpleName() + ", found " + p.a.getClass().getSimpleName());
            return false;
        }
        return this.pop();
    }

    public Explanel getTopExplanel() {
        Actor top = this.getTopPushedActor();
        if (top instanceof Explanel) {
            return (Explanel)top;
        }
        return null;
    }

    public Actor getTopPushedActor() {
        if (this.modalStack.size() == 0) {
            return null;
        }
        return (Actor)this.modalStack.get((int)(this.modalStack.size() - 1)).a;
    }

    public Actor getTopActualActor() {
        return this.getChild(this.getChildren().size - 1);
    }

    @Override
    public boolean addListener(EventListener listener) {
        return super.addListener(listener);
    }

    public boolean stackContains(Class c) {
        for (Pair<Actor, InputBlocker> p : this.modalStack) {
            if (p.a.getClass() != c) continue;
            return true;
        }
        return false;
    }

    public abstract Screen copy();

    public void setGlowverlays(List<Glowverlay> glowverlays) {
        this.clearOldGlowverlays();
        this.glowverlays = glowverlays;
    }

    public void setGlowverlay(Glowverlay glowverlay) {
        this.clearOldGlowverlays();
        this.glowverlays.add(glowverlay);
    }

    public void clearOldGlowverlays() {
        for (Glowverlay g : this.glowverlays) {
            g.remove();
        }
        this.glowverlays.clear();
    }

    public Actor getActorUnderMouse() {
        return this.hit(Gdx.input.getX() / Main.scale, Main.height - Gdx.input.getY() / Main.scale, true);
    }

    public void center(Actor a) {
        a.setPosition((int)((this.getWidth() - a.getWidth()) / 2.0f), (int)((this.getHeight() - a.getHeight()) / 2.0f));
    }

    public boolean stackEmpty() {
        return this.getTopPushedActor() == null;
    }

    public final void showDialog(Exception e, String ctx) {
        this.showDialog(MessagePhase.getMsg(e, ctx));
    }

    public final void showDialog(String s) {
        this.showDialog(s, Colours.grey);
    }

    public void showDialog(String s, Color border) {
        TextWriter tw = new TextWriter(s, 120, border, 2);
        this.push(tw, true, true, true, 0.8f);
        Tann.center(tw);
    }

    public String getReportString() {
        return null;
    }

    public void openUrl(String url) {
        this.openUrl(url, null);
    }

    public void openUrl(String url, String description) {
        this.openUrl(url, description, null);
    }

    public void openUrl(String url, String description, Actor extra) {
        Sounds.playSound(Sounds.pip);
        Actor a = TextUrl.getUrlActor(extra, url, description);
        this.push(a, true, true, false, 0.7f);
        Tann.center(a);
    }

    public void afterSet() {
    }

    public boolean skipMonkey() {
        return false;
    }

    public void showMusicPopup(Actor a) {
        float DOWN_TIME = 0.15f;
        float UP_TIME = 0.15f;
        float DELAY = 2.0f;
        float DIST = 1.0f;
        Interpolation.PowOut terp = Interpolation.pow2Out;
        this.addActor(a);
        a.setPosition(1.0f, Main.height);
        a.addAction(Actions.sequence((Action)Actions.moveTo(this.getX(), (float)Main.height - a.getHeight() - 1.0f, 0.15f, terp), (Action)Actions.delay(2.0f), (Action)Actions.moveTo(this.getX(), Main.height, 0.15f, terp), (Action)Actions.removeActor()));
    }

    public void pushAndCenter(Actor a) {
        this.pushAndCenter(a, 0.8f);
    }

    public void pushAndCenter(Actor a, float alpha) {
        this.pushAndCenter(a, alpha, true);
    }

    public void pushAndCenter(Actor a, float alpha, boolean selfPop) {
        Sounds.playSound(Sounds.pip);
        this.push(a, true, true, selfPop, alpha);
        Tann.center(a);
    }

    @Override
    public void repositionExplanel(Explanel exp) {
        Vector2 v = Main.getCursor();
        exp.setPosition(v.x - exp.getWidth() / 2.0f, v.y - exp.getHeight() - 5.0f);
    }
}

