/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.screens.dungeon;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.tann.dice.Main;
import com.tann.dice.gameplay.content.ent.Ent;
import com.tann.dice.gameplay.content.ent.Monster;
import com.tann.dice.gameplay.content.ent.die.EntDie;
import com.tann.dice.gameplay.content.ent.die.side.EntSide;
import com.tann.dice.gameplay.effect.eff.Eff;
import com.tann.dice.gameplay.effect.eff.EffType;
import com.tann.dice.gameplay.effect.eff.TargetingType;
import com.tann.dice.gameplay.effect.eff.conditionalBonus.ConditionalBonus;
import com.tann.dice.gameplay.effect.eff.conditionalBonus.conditionalRequirement.ConditionalRequirement;
import com.tann.dice.gameplay.effect.eff.keyword.KUtils;
import com.tann.dice.gameplay.effect.eff.keyword.Keyword;
import com.tann.dice.gameplay.effect.targetable.DieTargetable;
import com.tann.dice.gameplay.effect.targetable.Targetable;
import com.tann.dice.gameplay.effect.targetable.ability.Ability;
import com.tann.dice.gameplay.fightLog.EntSideState;
import com.tann.dice.gameplay.fightLog.EntState;
import com.tann.dice.gameplay.fightLog.FightLog;
import com.tann.dice.gameplay.fightLog.Snapshot;
import com.tann.dice.gameplay.phase.Phase;
import com.tann.dice.gameplay.phase.PhaseManager;
import com.tann.dice.screens.dungeon.DungeonScreen;
import com.tann.dice.screens.dungeon.panels.Explanel.Explanel;
import com.tann.dice.screens.dungeon.panels.entPanel.EntPanel;
import com.tann.dice.statics.sound.Sounds;
import com.tann.dice.util.Colours;
import com.tann.dice.util.Pixl;
import com.tann.dice.util.Tann;
import com.tann.dice.util.lang.Words;
import com.tann.dice.util.ui.TextWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class TargetingManager {
    private FightLog fightLog;
    private Targetable selectedTargetable;
    TextWriter previousFail;
    private static final HashMap<Targetable, Boolean> usabilityMapFalse = new HashMap();
    private static final HashMap<Targetable, Boolean> usabilityMapTrue = new HashMap();

    public TargetingManager(FightLog fightLog) {
        this.fightLog = fightLog;
    }

    public Targetable getSelectedTargetable() {
        return this.selectedTargetable;
    }

    public void setSelectedTargetable(Targetable selectedTargetable) {
        Main.getCurrentScreen().popAllLight();
        this.selectedTargetable = selectedTargetable;
        this.showExplanel(selectedTargetable);
        if (this.isUsable(selectedTargetable) && selectedTargetable instanceof DieTargetable) {
            EntPanel ep = selectedTargetable.getSource().getEntPanel();
            ep.slideOutToTarget();
        }
        Sounds.playSound(Sounds.pip);
    }

    public void clicked(Ent ent, boolean dieSide) {
        EntState es = this.fightLog.getState(FightLog.Temporality.Present, ent);
        if (es != null && es.isDead()) {
            return;
        }
        if (this.getSelectedTargetable() != null && !this.getSelectedTargetable().isUsable(this.fightLog.getSnapshot(FightLog.Temporality.Present))) {
            DungeonScreen.get().popAllLight();
        }
        if (this.getSelectedTargetable() != null && dieSide) {
            this.target(ent, this.getSelectedTargetable());
        } else {
            this.clickPanel(ent, dieSide);
        }
    }

    public boolean target(Ent ent, Targetable targetable) {
        if (!PhaseManager.get().getPhase().canTarget()) {
            Sounds.playSound(Sounds.error);
            Explanel exp = DungeonScreen.get().getTopExplanel();
            if (exp != null) {
                exp.addDialog(new TextWriter("[red]Can only use abilities during targeting phase", 100, Colours.blue, 2), true);
            }
            return false;
        }
        if (targetable == null) {
            return false;
        }
        Eff effects = targetable.getDerivedEffects();
        if (effects == null) {
            return false;
        }
        if (!targetable.isUsable(this.fightLog.getSnapshot(FightLog.Temporality.Present))) {
            return false;
        }
        String invalidReason = this.getInvalidTargetReason(ent, targetable, true);
        if (invalidReason != null) {
            this.showError("[red]" + invalidReason);
            return false;
        }
        this.fightLog.addCommand(targetable, ent, false);
        Main.getCurrentScreen().popAllLight();
        this.deselectTargetable();
        DungeonScreen.get().mildSave();
        return true;
    }

    public String getInvalidTargetReason(Ent target, Targetable targetable, boolean allowBadTargets) {
        Snapshot s;
        List<EntState> actualTargets;
        Snapshot ss;
        Eff firstEffect = targetable.getDerivedEffects();
        if (firstEffect.hasKeyword(Keyword.manacost) && (ss = this.fightLog.getSnapshot(FightLog.Temporality.Present)).getTotalMana() < KUtils.getValue(firstEffect)) {
            return "Not enough mana";
        }
        if (firstEffect.isUnusableBecauseNerfed()) {
            return "Sides with value <1 cannot be used";
        }
        if (firstEffect.getType() == EffType.Blank && firstEffect.getKeywordForGameplay().size() == 0) {
            return "Side does nothing";
        }
        TargetingType targetingType = firstEffect.getTargetingType();
        EntState targetState = null;
        EntState sourceState = null;
        if (target != null) {
            targetState = this.fightLog.getState(FightLog.Temporality.Present, target);
        }
        if (targetable.getSource() != null) {
            sourceState = this.fightLog.getState(FightLog.Temporality.Present, targetable.getSource());
        }
        if (firstEffect.needsTarget()) {
            if (target == null) {
                return "No valid targets";
            }
            if (firstEffect.getType() != EffType.Or && firstEffect.isFriendly() != targetable.isPlayer() == target.isPlayer()) {
                return "Target " + Words.entName(firstEffect, (Boolean)false);
            }
        }
        if ((actualTargets = (s = this.fightLog.getSnapshot(FightLog.Temporality.Present)).getActualTargets(target, firstEffect, sourceState == null ? null : sourceState.getEnt())).size() == 0 && firstEffect.getTargetingType() != TargetingType.Untargeted) {
            if (targetState != null) {
                for (ConditionalRequirement tr : firstEffect.getRestrictions()) {
                    if (tr.isValid(s, sourceState, targetState, firstEffect)) continue;
                    return tr.getInvalidString(firstEffect);
                }
            } else {
                if (target != null && firstEffect.getRestrictions().size() > 0) {
                    return "Can only affect " + Words.entName(firstEffect, (Boolean)true) + " " + firstEffect.getRestrictions().get(0).getInvalidString(firstEffect);
                }
                return "No valid targets";
            }
        }
        List<Ent> validTargets = TargetingManager.getValidTargets(this.fightLog.getSnapshot(FightLog.Temporality.Present), targetable, true);
        if (firstEffect.needsTarget() && !validTargets.contains(target)) {
            switch (targetingType) {
                case Single: {
                    if (firstEffect.isFriendly()) {
                        if (target.isPlayer()) break;
                        return "Target " + Words.entName(firstEffect, (Boolean)false);
                    }
                    if (target.isPlayer()) {
                        return "Target " + Words.entName(true, false, false);
                    }
                    if (target.isPlayer() || targetState.isForwards() || firstEffect.hasKeyword(Keyword.ranged)) break;
                    return "Target " + Words.entName(true, false, false) + " in the front row";
                }
            }
            return "Can't target that";
        }
        if (firstEffect.getType() == EffType.Reroll && !firstEffect.hasKeyword(Keyword.future)) {
            return "Can only gain rerolls during roll phase";
        }
        if (firstEffect.getTargetingType() != TargetingType.Untargeted && validTargets.size() == 0) {
            return firstEffect.getNoTargetsString();
        }
        if (firstEffect.getType() == EffType.Resurrect && s.getStates(true, true).isEmpty()) {
            return "No defeated heroes";
        }
        return null;
    }

    private void showError(String invalidReason) {
        if (this.previousFail != null) {
            this.previousFail.remove();
        }
        Sounds.playSound(Sounds.error);
        if (Main.getCurrentScreen().getTopPushedActor() instanceof TextWriter) {
            Main.getCurrentScreen().popAllLight();
        }
        TextWriter tw = new TextWriter(invalidReason, 80, Colours.purple, 2);
        Explanel explanel = DungeonScreen.get().getTopExplanel();
        if (explanel != null) {
            explanel.addDialog(tw, true);
        } else {
            tw.setPosition((int)((float)(Main.width / 2) - tw.getWidth() / 2.0f), (int)((float)(Main.height / 2) - tw.getHeight() / 2.0f));
            Main.getCurrentScreen().push(tw, false, true, true, 0.0f);
        }
        this.previousFail = tw;
    }

    public void clickPanelDie(EntDie d) {
        if (d.ent instanceof Monster) {
            return;
        }
        if (d.getSideIndex() == -1) {
            return;
        }
        if (PhaseManager.get().getPhase().canRoll()) {
            d.toggleLock();
            return;
        }
        DieTargetable dt = d.getTargetable();
        Eff first = dt.getDerivedEffects();
        if (!this.isUsable(dt)) {
            this.showError("[red]" + this.getInvalidTargetReason(null, dt, false));
            return;
        }
        if (!first.needsTarget()) {
            this.target(null, dt);
        } else {
            this.setSelectedTargetable(dt);
        }
    }

    public Actor showExplanel(Targetable t) {
        if (!PhaseManager.get().getPhase().canTarget()) {
            return this.showExplanelInactive(t);
        }
        return this.showExplanelActive(t);
    }

    private Actor showExplanelActive(Targetable t) {
        String inv;
        Explanel exp;
        Main.getCurrentScreen().popAllLight();
        boolean usable = t.isUsable(this.fightLog.getSnapshot(FightLog.Temporality.Present));
        if (usable) {
            this.showTargetingHighlights();
        }
        if (t instanceof Ability) {
            exp = new Explanel((Ability)t, true);
            if (!usable) {
                exp.addDialog("[red]not enough " + Words.manaString(), true);
            }
        } else if (t instanceof DieTargetable) {
            DieTargetable dt = (DieTargetable)t;
            exp = new Explanel(dt.getSide(), dt.getSource());
        } else {
            throw new RuntimeException("unable to make explanel for " + t.getClass().getSimpleName());
        }
        Eff first = t.getDerivedEffects();
        boolean allowBadTargets = first.allowBadTargets();
        boolean allInvalid = first.needsTarget() && !allowBadTargets && TargetingManager.getValidTargets(this.fightLog.getSnapshot(FightLog.Temporality.Present), t, true).size() == 0 && t.isUsable(this.fightLog.getSnapshot(FightLog.Temporality.Present));
        String noTargetsString = first.getNoTargetsString();
        if (!first.needsTarget() && (inv = this.getInvalidTargetReason(null, t, true)) != null) {
            allInvalid = true;
            noTargetsString = inv;
        }
        DungeonScreen.get().push(exp, false, true, true, 0.0f);
        exp.reposition();
        if (!Main.getSettings().hasAttemptedLevel()) {
            boolean fr = first.isFriendly();
            String msg = Main.self().control.getSelectTapString() + " " + (fr ? "[yellow]" : "[purple]") + Words.entName(first, (Boolean)false);
            Group a = new Pixl(3, 3).border(Colours.green).text(msg).pix();
            a.setTouchable(Touchable.disabled);
            exp.addActor(a);
            Tann.center(a);
            a.setY(-a.getHeight() - (float)exp.getExtraBelowExtent() - 3.0f);
        }
        if (allInvalid && noTargetsString != null) {
            exp.addDialog("[red]" + noTargetsString, true);
        }
        return exp;
    }

    public Actor showExplanelInactive(Targetable t) {
        Explanel exp = DungeonScreen.get().getTopExplanel();
        if (exp != null) {
            Main.getCurrentScreen().popSingleLight();
            if (exp.isShowing(t)) {
                Sounds.playSound(Sounds.pop);
                return null;
            }
        }
        if (t instanceof DieTargetable) {
            DieTargetable dt = (DieTargetable)t;
            exp = new Explanel(dt.getSide(), dt.getSource());
        } else if (t instanceof Ability) {
            Ability s = (Ability)t;
            exp = new Explanel(s, true);
        } else {
            throw new RuntimeException("unable to make explanel for " + t.getClass().getSimpleName());
        }
        exp.reposition();
        Main.getCurrentScreen().push(exp, false, true, true, 0.0f);
        Sounds.playSound(Sounds.pip);
        return exp;
    }

    public boolean deselectTargetable() {
        if (this.selectedTargetable == null) {
            return false;
        }
        this.clearTargetingHighlights();
        DungeonScreen.get().pop(Explanel.class);
        this.selectedTargetable = null;
        return true;
    }

    private void clickPanel(Ent ent, boolean dieSide) {
        boolean canTarget;
        Phase currentPhase = PhaseManager.get().getPhase();
        if (currentPhase.canRoll() && dieSide && ent.isPlayer()) {
            if (Main.getCurrentScreen().stackEmpty()) {
                ent.getDie().toggleLock();
                DungeonScreen ds = DungeonScreen.get();
                ds.getTutorialManager().onLock(ds.getFightLog().getSnapshot(FightLog.Temporality.Present).getEntities(true, false));
                ds.onLock();
            } else {
                Main.getCurrentScreen().popAllLight();
            }
            return;
        }
        Snapshot present = this.fightLog.getSnapshot(FightLog.Temporality.Present);
        boolean bl = canTarget = present != null && !present.isEnd() && present.getState(ent) != null && present.getState(ent).canUse() && currentPhase.canTarget();
        if (Main.getCurrentScreen().getTopPushedActor() == ent.getDiePanel()) {
            if (this.getSelectedTargetable() != null) {
                Sounds.playSound(Sounds.pop);
            }
            Main.getCurrentScreen().popAllLight();
            Sounds.playSound(Sounds.pop);
            return;
        }
        if (ent.isPlayer()) {
            Main.getCurrentScreen().popAllLight();
            if (dieSide && canTarget) {
                this.clickPanelDie(ent.getDie());
                return;
            }
            ent.getDiePanel().show();
            return;
        }
        if (!dieSide || !ent.getEntPanel().holdsDie) {
            Main.getCurrentScreen().popAllLight();
            ent.getDiePanel().show();
        } else {
            Explanel e;
            Actor a = Main.getCurrentScreen().getTopPushedActor();
            if (a instanceof Explanel && (e = (Explanel)a).isShowing(ent.getDie().getCurrentSide())) {
                Sounds.playSound(Sounds.pop);
                Main.getCurrentScreen().popAllLight();
                return;
            }
            Main.getCurrentScreen().popAllLight();
            EntSide s = ent.getDie().getCurrentSide();
            Actor topActor = DungeonScreen.get().getTopPushedActor();
            if (topActor instanceof Explanel && ((Explanel)topActor).isShowing(s)) {
                Main.getCurrentScreen().popAllLight();
                Sounds.playSound(Sounds.pop);
                return;
            }
            Sounds.playSound(Sounds.pip);
            if (s != null) {
                Explanel e2 = new Explanel(s, ent);
                DungeonScreen.get().push(e2, false, true, true, 0.0f);
                e2.reposition();
                e2.addPassives(ent);
                ent.getEntPanel().setArrowIntensity(1.0f, 0.0f);
                return;
            }
        }
    }

    public void clearTargetingHighlights() {
        for (Ent de : this.fightLog.getSnapshot(FightLog.Temporality.Present).getEntities(null, null)) {
            de.getEntPanel().setPossibleTarget(false);
        }
    }

    public void showTargetingHighlights() {
        this.clearTargetingHighlights();
        Targetable t = this.getSelectedTargetable();
        if (t == null || t.getBaseEffect() == null) {
            return;
        }
        for (Ent de : TargetingManager.getRecommendedTargets(this.fightLog.getSnapshot(FightLog.Temporality.Present), t, true)) {
            EntState es = this.fightLog.getState(FightLog.Temporality.Present, de);
            if (es != null) {
                de.getEntPanel().setPossibleTarget(true, TargetingManager.getBonusTargetingKeywordsFor(t, es));
                continue;
            }
            de.getEntPanel().setPossibleTarget(true);
        }
    }

    private static List<Keyword> getBonusTargetingKeywordsFor(Targetable t, EntState potentialTarget) {
        ArrayList<Keyword> result = new ArrayList<Keyword>();
        EntState sourceState = null;
        if (t.getSource() != null) {
            sourceState = potentialTarget.getSnapshot().getState(t.getSource());
        }
        Eff e = t.getDerivedEffects(potentialTarget.getSnapshot());
        for (Keyword k : e.getKeywordForGameplay()) {
            ConditionalRequirement conReq;
            ConditionalBonus cb = k.getConditionalBonus();
            if (cb == null || (conReq = cb.requirement).preCalculate() || !conReq.isValid(potentialTarget.getSnapshot(), sourceState, potentialTarget, e)) continue;
            result.add(k);
        }
        Tann.uniquify(result);
        return result;
    }

    public void hideTargetingArrows() {
        for (Ent ent : this.fightLog.getActiveEntities()) {
            ent.getEntPanel().setArrowIntensity(0.0f, 0.0f);
        }
    }

    public Ent getRandomTargetForEnemy(DieTargetable d) {
        Eff first = d.getDerivedEffects();
        if (!first.needsTarget()) {
            return null;
        }
        if (first.hasKeyword(Keyword.eliminate)) {
            return this.getHpRestrictTargetForEnemy(false);
        }
        if (first.hasKeyword(Keyword.heavy)) {
            return this.getHpRestrictTargetForEnemy(true);
        }
        for (int i = 0; i < 4; ++i) {
            Ent potentialTarget = this.getRandomTargetForEnemyInternal(d, (i & 1) > 0, (i & 2) > 0);
            if (potentialTarget == null) continue;
            return potentialTarget;
        }
        return null;
    }

    private Ent getHpRestrictTargetForEnemy(boolean highest) {
        List<Ent> potentials = this.fightLog.getSnapshot(FightLog.Temporality.Present).getEntities(true, false);
        Collections.shuffle(potentials);
        Ent target = null;
        int bestHp = highest ? -999 : 999;
        for (Ent de : potentials) {
            EntState futureState = this.fightLog.getState(FightLog.Temporality.Future, de);
            int hp = futureState.getHp() - futureState.getTotalRegenThisTurn();
            if (hp > bestHp != highest) continue;
            bestHp = hp;
            target = de;
        }
        return target;
    }

    private Ent getRandomTargetForEnemyInternal(DieTargetable dt, boolean allowOverkill, boolean allowSuboptimal) {
        Eff e = this.fightLog.getSnapshot(FightLog.Temporality.Present).getState(dt.getSource()).getSideState(dt.getSide()).getCalculatedEffect();
        if (!e.needsTarget() || e.getType() == EffType.Heal || e.getType() == EffType.Summon) {
            return null;
        }
        List<Ent> validTargets = TargetingManager.getValidTargets(this.fightLog.getSnapshot(FightLog.Temporality.Present), dt, false);
        if (!allowOverkill) {
            for (int i = validTargets.size() - 1; i >= 0; --i) {
                Ent de = validTargets.get(i);
                if (!this.fightLog.getState(FightLog.Temporality.Future, de).isDead()) continue;
                validTargets.remove(de);
            }
        }
        if (!allowSuboptimal) {
            if (e.hasKeyword(Keyword.cleave)) {
                if (validTargets.size() < 3) {
                    return null;
                }
                validTargets.remove(0);
                validTargets.remove(validTargets.get(validTargets.size() - 1));
            }
            if (e.hasKeyword(Keyword.descend)) {
                if (validTargets.size() < 2) {
                    return null;
                }
                validTargets.remove(validTargets.get(validTargets.size() - 1));
            }
        }
        if (validTargets.size() > 0) {
            return Tann.random(validTargets);
        }
        return null;
    }

    public boolean isUsable(Targetable t) {
        return this.isUsable(t, false);
    }

    public boolean isUsable(Targetable t, boolean onlyRecommended) {
        return this.isUsable(t, onlyRecommended, false);
    }

    public boolean isUsable(Targetable t, boolean onlyRecommended, boolean cantrip) {
        Snapshot s;
        Boolean usable = null;
        HashMap<Targetable, Boolean> cache = onlyRecommended ? usabilityMapTrue : usabilityMapFalse;
        usable = cache.get(t);
        if (usable != null) {
            return usable;
        }
        Snapshot present = this.fightLog.getSnapshot(FightLog.Temporality.Present);
        Eff first = t.getDerivedEffects();
        if (!cantrip && first.hasKeyword(Keyword.unusable)) {
            return false;
        }
        if (first.getTargetingType() == TargetingType.Untargeted) {
            usable = !first.isUnusableBecauseNerfed();
            usable = usable & first.canBeUsedUntargeted(present);
        } else {
            usable = onlyRecommended ? Boolean.valueOf(TargetingManager.getRecommendedTargets(present, t, true).size() > 0) : Boolean.valueOf(TargetingManager.getValidTargets(present, t, true).size() > 0);
        }
        if (first.getType() == EffType.Reroll || first.getType() == EffType.Blank) {
            usable = false;
        }
        if (first.hasKeyword(Keyword.manacost) && (s = present).getTotalMana() < KUtils.getValue(first)) {
            usable = false;
        }
        cache.put(t, usable);
        return usable;
    }

    public void anythingChanged() {
        usabilityMapFalse.clear();
        usabilityMapTrue.clear();
    }

    public static List<Ent> getValidTargets(Snapshot present, Targetable t, boolean player) {
        ArrayList<Ent> potentialTargets = new ArrayList<Ent>();
        Eff first = t.getDerivedEffects(present);
        if (player && first.isUnusableBecauseNerfed()) {
            return new ArrayList<Ent>();
        }
        TargetingType type = first.getTargetingType();
        Ent source = null;
        EntState sourcePresent = null;
        if (t.getSource() != null) {
            source = t.getSource();
            sourcePresent = present.getState(source);
        }
        List<? extends Ent> friends = present.getAliveEntities(player);
        List<? extends Ent> enemies = present.getAliveEntities(!player);
        List<? extends Ent> probably = first.isFriendly() ? friends : enemies;
        switch (type) {
            case Single: 
            case Group: {
                potentialTargets.addAll(probably);
                break;
            }
            case ALL: {
                potentialTargets.addAll(friends);
                potentialTargets.addAll(enemies);
                break;
            }
            case Self: {
                potentialTargets.add(source);
                break;
            }
            case Top: {
                if (probably.size() <= 0) break;
                potentialTargets.add(probably.get(0));
                break;
            }
            case TopAndBot: {
                List<? extends Ent> maybe;
                List<? extends Ent> list = maybe = first.isFriendly() ? friends : enemies;
                if (maybe.size() <= 0) break;
                potentialTargets.add(maybe.get(0));
                potentialTargets.add(maybe.get(maybe.size() - 1));
                break;
            }
        }
        if (first.getType() == EffType.Or) {
            potentialTargets.addAll(friends);
            potentialTargets.addAll(enemies);
        }
        for (int i = potentialTargets.size() - 1; i >= 0; --i) {
            Ent de = (Ent)potentialTargets.get(i);
            EntState targetPresent = present.getState(de);
            if (TargetingManager.isLegalTarget(first, sourcePresent, targetPresent)) continue;
            potentialTargets.remove(de);
        }
        return potentialTargets;
    }

    private static boolean isLegalTarget(Eff eff, EntState sourcePresent, EntState targetPresent) {
        if (eff.getType() == EffType.Or) {
            return TargetingManager.isLegalTarget(eff.getOr(false), sourcePresent, targetPresent) || TargetingManager.isLegalTarget(eff.getOr(true), sourcePresent, targetPresent);
        }
        Ent target = targetPresent.getEnt();
        boolean playerSource = sourcePresent == null || sourcePresent.isPlayer();
        if (eff.isFriendly() != (target.isPlayer() == playerSource)) {
            return false;
        }
        switch (eff.getTargetingType()) {
            case Single: {
                boolean ranged;
                boolean bl = ranged = eff.hasKeyword(Keyword.ranged) || eff.getType() == EffType.Or && eff.getOr(false).hasKeyword(Keyword.ranged);
                if (ranged || targetPresent.canBeTargetedAsForwards()) break;
                return false;
            }
        }
        switch (eff.getType()) {
            case Recharge: {
                if (targetPresent.isUsed()) break;
                return false;
            }
        }
        for (int j = 0; j < eff.getRestrictions().size(); ++j) {
            if (eff.getRestrictions().get(j).isValid(targetPresent.getSnapshot(), sourcePresent, targetPresent, eff)) continue;
            return false;
        }
        return true;
    }

    public static List<Ent> getRecommendedTargets(Snapshot present, Targetable t, boolean player) {
        Eff first = t.getDerivedEffects();
        List<Ent> recommendeds = TargetingManager.getValidTargets(present, t, player);
        for (int i = recommendeds.size() - 1; i >= 0; --i) {
            Ent de = recommendeds.get(i);
            EntState targetPresent = present.getState(de);
            EntState targetFuture = present.getFightLog().getState(FightLog.Temporality.Future, de);
            if (TargetingManager.isRecommendedTarget(first, t.getSource(), targetPresent, targetFuture)) continue;
            recommendeds.remove(de);
        }
        if (first.hasKeyword(Keyword.cleave) || first.hasKeyword(Keyword.descend)) {
            int above = 1;
            int below = first.hasKeyword(Keyword.cleave) ? 1 : 0;
            ArrayList<Ent> bonusTargets = new ArrayList<Ent>();
            for (int i = 0; i < recommendeds.size(); ++i) {
                Ent de = recommendeds.get(i);
                List<? extends EntState> states = present.getAdjacents(present.getState(de), player, true, above, below);
                for (int j = 0; j < states.size(); ++j) {
                    EntState potentialTarget = states.get(j);
                    if (!TargetingManager.isLegalTarget(first, present.getState(t.getSource()), potentialTarget) || recommendeds.contains(potentialTarget.getEnt()) || bonusTargets.contains(potentialTarget.getEnt())) continue;
                    bonusTargets.add(potentialTarget.getEnt());
                }
            }
            recommendeds.addAll(bonusTargets);
        }
        return recommendeds;
    }

    private static boolean isRecommendedTarget(Eff eff, Ent source, EntState targetPresent, EntState targetFuture) {
        Snapshot snapshot;
        Eff gce;
        EffType type;
        Object ess;
        if (eff.getType() == EffType.Or) {
            return TargetingManager.isRecommendedTarget(eff.getOr(false), source, targetPresent, targetFuture) || TargetingManager.isRecommendedTarget(eff.getOr(true), source, targetPresent, targetFuture);
        }
        boolean playerSource = source == null || source.isPlayer();
        if (eff.isFriendly() != (playerSource == targetPresent.isPlayer())) {
            return false;
        }
        if (eff.hasKeyword(Keyword.cleanse) && (targetFuture.hasCleansableBuffs() || targetPresent.hasCleansableBuffs())) {
            return true;
        }
        if (eff.hasKeyword(Keyword.damage) || eff.hasKeyword(Keyword.boost) || eff.hasKeyword(Keyword.weaken) || eff.hasKeyword(Keyword.regen) || eff.hasKeyword(Keyword.manaGain) || eff.hasKeyword(Keyword.vitality)) {
            return true;
        }
        if (eff.hasKeyword(Keyword.smith) && (ess = targetPresent.getCurrentSideState()) != null && ((type = (gce = ((EntSideState)ess).getCalculatedEffect()).getType()) == EffType.Damage || type == EffType.Shield || gce.hasKeyword(Keyword.damage) || gce.hasKeyword(Keyword.shield))) {
            return true;
        }
        for (Keyword k : eff.getKeywordForGameplay()) {
            if (k.getInflict() == null) continue;
            return true;
        }
        EntState sourceState = null;
        if (targetPresent != null && (snapshot = targetPresent.getSnapshot()) != null) {
            sourceState = snapshot.getState(source);
        }
        if (eff.hasKeyword(Keyword.selfShield) && sourceState != null && sourceState.hasIncomingDamage()) {
            return true;
        }
        if (eff.hasKeyword(Keyword.selfHeal) && sourceState != null && sourceState.isDamaged()) {
            return true;
        }
        if (eff.hasKeyword(Keyword.repel) && targetPresent.getSnapshot().getAllTargeters(targetPresent.getEnt(), true).size() > 0) {
            return true;
        }
        Ent targetEnt = targetPresent.getEnt();
        EffType toCheck = eff.getType();
        if (eff.getType() == EffType.JustTarget) {
            if (eff.isFriendly()) {
                if (eff.hasKeyword(Keyword.shield)) {
                    toCheck = EffType.Shield;
                } else if (eff.hasKeyword(Keyword.heal)) {
                    toCheck = EffType.Heal;
                }
            } else if (eff.hasKeyword(Keyword.damage)) {
                toCheck = EffType.Damage;
            }
        }
        switch (toCheck) {
            case Damage: 
            case Kill: {
                return true;
            }
            case Shield: {
                if (targetPresent.immuneToShields()) {
                    return false;
                }
                return targetFuture.getBlockableDamageTaken() > targetPresent.getBlockableDamageTaken();
            }
            case Heal: {
                if (targetPresent.immuneToHealing()) {
                    return false;
                }
                return targetPresent.getHp() < targetPresent.getMaxHp() || targetPresent.allowOverheal();
            }
            case HealAndShield: {
                if (targetPresent.immuneToHealing() && targetPresent.immuneToShields()) {
                    return false;
                }
                boolean okShield = targetFuture.getBlockableDamageTaken() > targetPresent.getBlockableDamageTaken();
                boolean okHeal = targetPresent.getHp() < targetPresent.getMaxHp() || targetPresent.allowOverheal();
                return okShield || okHeal || targetPresent.allowOverheal();
            }
            case RedirectIncoming: {
                return targetEnt != source && (targetPresent.hasIncomingDamage() || targetPresent.hasIncomingBuffs());
            }
            case Buff: {
                return eff.getBuff().isRecommendedTarget(sourceState, targetPresent, targetFuture);
            }
            case Recharge: {
                return targetPresent.isUsed();
            }
            case Resurrect: {
                return targetPresent.isDead() && targetPresent.canResurrect();
            }
            case SetToHp: {
                return targetPresent.getHp() != eff.getValue();
            }
        }
        return false;
    }
}

