/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.screens.dungeon.panels.book.page.cogPage.menuPanel;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.tann.dice.Main;
import com.tann.dice.gameplay.phase.Phase;
import com.tann.dice.gameplay.phase.PhaseManager;
import com.tann.dice.gameplay.progress.chievo.AchLib;
import com.tann.dice.gameplay.progress.chievo.unlock.UnUtil;
import com.tann.dice.gameplay.save.settings.option.Option;
import com.tann.dice.gameplay.save.settings.option.OptionLib;
import com.tann.dice.screens.dungeon.DungeonUtils;
import com.tann.dice.screens.dungeon.panels.book.page.cogPage.menuPanel.MenuPanel;
import com.tann.dice.statics.Images;
import com.tann.dice.statics.sound.Sounds;
import com.tann.dice.util.Colours;
import com.tann.dice.util.Pixl;
import com.tann.dice.util.Tann;
import com.tann.dice.util.listener.TannListener;
import com.tann.dice.util.ui.TextWriter;
import com.tann.dice.util.ui.choice.ChoiceDialog;
import com.tann.dice.util.ui.standardButton.StandardButton;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class OptionsMenu
extends MenuPanel {
    private final int rowSize = 3;
    final int BOX_META_ROW = 12;
    public static final int CHECKBOX_COG_WIDTH = 100;
    private static final int SCALE_BORDER = 4;

    public static String getCheckboxExp() {
        return "[grey](" + Main.self().control.getInfoTapString().toLowerCase() + " a checkbox to learn what it does)";
    }

    public OptionsMenu(int contentWidth) {
        int ecw = (int)((float)contentWidth * 0.98f);
        Pixl p = new Pixl(3).text(OptionsMenu.getCheckboxExp(), ecw).row().actor(this.makeBoxes(ecw)).row().actor(this.makeResetButton()).row(4);
        Tann.become(this, p.pix());
    }

    private Actor makeResetButton() {
        return new StandardButton("[red]Reset All").setRunnable(new Runnable(){

            @Override
            public void run() {
                ChoiceDialog cd = new ChoiceDialog("Reset all options to unchecked?", ChoiceDialog.ChoiceNames.YesCancel, new Runnable(){

                    @Override
                    public void run() {
                        Sounds.playSound(Sounds.flap);
                        Main.getSettings().clearAllOptions();
                        Main.getCurrentScreen().popAllMedium();
                        Main.getCurrentScreen().showDialog("[red]All options reset");
                    }
                }, new Runnable(){

                    @Override
                    public void run() {
                        Main.getCurrentScreen().popSingleMedium();
                    }
                });
                Main.getCurrentScreen().push(cd, 0.8f);
                Tann.center(cd);
            }
        });
    }

    private Actor makeBoxes(int contentWidth) {
        Pixl boxes = new Pixl(0, 2);
        Pixl left = new Pixl();
        Pixl right = new Pixl();
        ArrayList<OptionLib.EscBopType> leftTypes = new ArrayList<OptionLib.EscBopType>();
        List<OptionLib.EscBopType> rightTypes = Arrays.asList(OptionLib.EscBopType.UI, OptionLib.EscBopType.Music);
        for (OptionLib.EscBopType value : OptionLib.EscBopType.values()) {
            if (!value.shownInOptions || rightTypes.contains((Object)value)) continue;
            leftTypes.add(value);
        }
        for (boolean l : Tann.BOTH) {
            List<Object> i1 = l ? leftTypes : rightTypes;
            Pixl ip = l ? left : right;
            for (int i = 0; i < i1.size(); ++i) {
                OptionLib.EscBopType t = (OptionLib.EscBopType)((Object)i1.get(i));
                Actor a = this.boxType(t);
                ip.actor(a);
                if (i >= i1.size() - 1) continue;
                ip.row(12);
            }
        }
        Group group = left.pix(8);
        Group r = right.pix(8);
        if ((float)contentWidth > 209.99998f) {
            return boxes.actor(group).gap(5).actor(r).pix(2);
        }
        for (OptionLib.EscBopType value : OptionLib.EscBopType.values()) {
            if (!value.shownInOptions) continue;
            boxes.actor(this.boxType(value)).row(12);
        }
        return boxes.pix(8);
    }

    private Actor boxType(OptionLib.EscBopType type) {
        Pixl inner = new Pixl();
        inner.text(TextWriter.getTag(type.getCol()) + (Object)((Object)type)).row(2);
        List<Option> typeBopts = type.getOptions();
        for (boolean locked : Tann.BOTH) {
            Option option;
            ArrayList<Option> innerBops = new ArrayList<Option>();
            for (int boptIndex = 0; boptIndex < typeBopts.size(); ++boptIndex) {
                option = typeBopts.get(boptIndex);
                if (!option.isValid() || option.isDebug() || UnUtil.isLocked(option) != locked) continue;
                innerBops.add(option);
            }
            for (int i = 0; i < innerBops.size(); ++i) {
                Actor a;
                option = (Option)innerBops.get(i);
                inner.row(3);
                if (UnUtil.isLocked(option)) {
                    a = new Pixl().image(Images.BOPTION_LOCKED).gap(3).text("[grey]locked").pix();
                    a.addListener(new TannListener(){

                        @Override
                        public boolean info(int button, float x, float y) {
                            AchLib.showUnlockFor(option);
                            return true;
                        }
                    });
                } else {
                    a = option.makeCogActor();
                }
                inner.actor(a);
                if (i >= innerBops.size() - 1) continue;
                inner.row(2);
            }
        }
        if (type == OptionLib.EscBopType.Music) {
            StandardButton here = new StandardButton("[grey]display/sound");
            here.setRunnable(new Runnable(){

                @Override
                public void run() {
                    Sounds.playSound(Sounds.pip);
                    DungeonUtils.showCogMenu();
                }
            });
            inner.row(2).actor(here);
        }
        return inner.pix(8);
    }

    public static Group makeScaleAdjust() {
        Pixl scaleRow = new Pixl(2);
        TextWriter tw = new TextWriter("[text]UI size");
        tw.addListener(new TannListener(){

            @Override
            public boolean info(int button, float x, float y) {
                Main.getCurrentScreen().pushAndCenter(new Pixl(0, 3).border(Colours.grey).text("UI scaling factor").pix());
                return true;
            }
        });
        scaleRow.actor(tw);
        final int maxScaleDelta = Math.max(Gdx.graphics.getWidth(), Gdx.graphics.getHeight()) / 600;
        final int minScaleDelta = Math.min(-1, -Gdx.graphics.getWidth() / 600);
        TextWriter scaleDisplay = new TextWriter(Tann.delta(Main.getSettings().getScaleAdjust()));
        for (int i = -1; i <= 1; ++i) {
            if (i == 0) {
                scaleRow.actor(scaleDisplay);
                continue;
            }
            String text = i == -1 ? "-" : "+";
            TextWriter adjust = new TextWriter(text, 999, Colours.grey, 4);
            scaleRow.actor(adjust);
            final int diff = i;
            adjust.addListener(new TannListener(){

                @Override
                public boolean action(int button, int pointer, float x, float y) {
                    Phase p = PhaseManager.get().getPhase();
                    if (p.disallowRescale()) {
                        Sounds.playSound(Sounds.error);
                        return true;
                    }
                    int curScale = Main.getSettings().getScaleAdjust();
                    int newScale = curScale + diff;
                    if (newScale > maxScaleDelta || newScale < minScaleDelta) {
                        if (curScale > maxScaleDelta || curScale < minScaleDelta) {
                            Main.getSettings().setScaleAdjust(0);
                            Main.self().setupScale();
                            Sounds.playSound(Sounds.pip);
                            return true;
                        }
                        Sounds.playSound(Sounds.error);
                        return true;
                    }
                    Sounds.playSound(Sounds.pip);
                    Main.getSettings().setScaleAdjust(newScale);
                    Main.self().setupScale();
                    return true;
                }
            });
        }
        return scaleRow.pix();
    }

    public static Group makeDiceAdjust() {
        Pixl scaleRow = new Pixl(2);
        TextWriter tw = new TextWriter("[tinyDice] size");
        tw.addListener(new TannListener(){

            @Override
            public boolean info(int button, float x, float y) {
                Main.getCurrentScreen().pushAndCenter(new Pixl(0, 3).border(Colours.grey).text("Dice size adjust").pix());
                return true;
            }
        });
        scaleRow.actor(tw);
        int maxScaleDelta = 2;
        int minScaleDelta = -10;
        TextWriter scaleDisplay = new TextWriter(Tann.delta(Main.getSettings().getDiceAdjust()));
        for (int i = -1; i <= 1; ++i) {
            if (i == 0) {
                scaleRow.actor(scaleDisplay);
                continue;
            }
            String text = i == -1 ? "-" : "+";
            TextWriter adjust = new TextWriter(text, 999, Colours.grey, 4);
            scaleRow.actor(adjust);
            final int diff = i;
            adjust.addListener(new TannListener(){

                @Override
                public boolean action(int button, int pointer, float x, float y) {
                    Phase p = PhaseManager.get().getPhase();
                    if (p.disallowRescale()) {
                        Sounds.playSound(Sounds.error);
                        return true;
                    }
                    int newScale = Main.getSettings().getDiceAdjust() + diff;
                    if (newScale > 2 || newScale < -10) {
                        Sounds.playSound(Sounds.error);
                        return true;
                    }
                    Sounds.playSound(Sounds.pip);
                    Main.getSettings().setDiceScale(newScale);
                    Main.self().setupScale();
                    return true;
                }
            });
        }
        return scaleRow.pix();
    }
}

