/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.screens.dungeon.panels.combatEffects.gaze;

import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.tann.dice.gameplay.content.ent.Ent;
import com.tann.dice.gameplay.effect.targetable.Targetable;
import com.tann.dice.gameplay.fightLog.EntState;
import com.tann.dice.gameplay.fightLog.FightLog;
import com.tann.dice.screens.dungeon.DungeonScreen;
import com.tann.dice.screens.dungeon.panels.combatEffects.CombatEffectActor;
import com.tann.dice.statics.sound.Sounds;
import com.tann.dice.util.Colours;
import com.tann.dice.util.Draw;
import com.tann.dice.util.Tann;
import java.util.List;

public class GazeActor
extends CombatEffectActor {
    Targetable targetable;
    Ent source;
    Ent target;
    float top;
    float bot;
    Vector2 sourcePos;

    public GazeActor(Targetable targetable, Ent source, Ent target) {
        this.targetable = targetable;
        this.source = source;
        this.target = target;
    }

    @Override
    protected void start(FightLog fightLog) {
        this.setColor(1.0f, 1.0f, 1.0f, 0.7f);
        Sounds.playSoundDelayed(Sounds.deboost, 1.0f, 1.0f, this.getImpactDuration() * 0.3f);
        List<EntState> targets = this.source.getFightLog().getSnapshot(FightLog.Temporality.Present).getActualTargets(this.target, this.targetable.getBaseEffect(), this.source);
        this.top = GazeActor.getTopMost(targets);
        this.bot = GazeActor.getBotMost(targets);
        DungeonScreen.get().addActor(this);
        this.sourcePos = Tann.getAbsoluteCoordinates(this.source.getEntPanel()).cpy();
        this.sourcePos.y += this.source.getEntPanel().getHeight() / 2.0f;
        this.addAction(Actions.sequence((Action)Actions.delay(this.getImpactDuration()), (Action)Actions.fadeOut(this.getExtraDuration()), (Action)Actions.removeActor()));
    }

    @Override
    protected float getImpactDuration() {
        return 0.1f;
    }

    @Override
    protected float getExtraDuration() {
        return 0.5f;
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        float mid = (this.top + this.bot) / 2.0f;
        float dist = (this.top - this.bot) / 2.0f * 0.9f;
        float realTop = mid + dist * Math.min(this.getColor().a, 0.5f) * 2.0f;
        float realBot = mid - dist * Math.min(this.getColor().a, 0.5f) * 2.0f;
        batch.setColor(Colours.withAlpha(Colours.light, this.getColor().a));
        Draw.drawTriangle(batch, this.sourcePos.x, this.sourcePos.y, 50.0f, realBot, 50.0f, realTop);
    }
}

