/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.screens.dungeon.panels.combatEffects.simpleThwack;

import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.tann.dice.gameplay.fightLog.EntState;
import com.tann.dice.gameplay.fightLog.FightLog;
import com.tann.dice.screens.dungeon.DungeonScreen;
import com.tann.dice.screens.dungeon.panels.combatEffects.CombatEffectActor;
import com.tann.dice.screens.dungeon.panels.entPanel.EntPanel;
import com.tann.dice.statics.sound.Sounds;
import com.tann.dice.util.Tann;
import java.util.List;

public class SimpleThwack
extends CombatEffectActor {
    TextureRegion image;
    float angleDiff;
    float swingTime;
    float windupTime;
    private static final float FADE_OUT_TIME = 0.2f;
    private static final float SWING_HIT_RATIO = 0.8f;
    List<EntState> targets;
    boolean player;
    String[] sound = Sounds.thwack;

    public SimpleThwack(boolean player, List<EntState> targets, TextureRegion image, float angleDiff, float swingTime, float windupTime) {
        this.player = player;
        this.image = image;
        this.angleDiff = angleDiff;
        this.swingTime = swingTime;
        this.windupTime = windupTime;
        this.targets = targets;
    }

    @Override
    protected void start(FightLog fightLog) {
        if (this.sound != null) {
            Sounds.playSoundDelayed(this.sound, 1.0f, 1.0f, this.getImpactDuration());
        }
        this.setSize(this.image.getRegionWidth(), this.image.getRegionHeight());
        DungeonScreen.get().addActor(this);
        int topMost = 0;
        int bottomMost = 9999;
        for (EntState state : this.targets) {
            EntPanel panel = state.getEnt().getEntPanel();
            topMost = (int)Math.max((float)topMost, panel.getY() + panel.getHeight());
            bottomMost = (int)Math.min((float)bottomMost, panel.getY());
        }
        Vector2 containerLoc = Tann.getAbsoluteCoordinates(DungeonScreen.get().getContainer(!this.player));
        topMost = (int)((float)topMost + containerLoc.y);
        bottomMost = (int)((float)bottomMost + containerLoc.y);
        int upwardsExtent = (int)(Math.tan(this.angleDiff) * (double)this.image.getRegionWidth() / 2.0);
        int startY = topMost - upwardsExtent;
        int endY = bottomMost + upwardsExtent;
        EntPanel panel = this.targets.get(0).getEnt().getEntPanel();
        int right = (int)(Tann.getAbsoluteCoordinates((Actor)panel).x + (this.player ? 0.0f : panel.getWidth()) - (float)this.image.getRegionWidth() * 0.5f);
        right = (int)((float)right + (float)this.image.getRegionWidth() * (this.player ? -0.8f : 0.8f));
        this.setPosition(right, startY);
        this.setRotation((float)((double)(-this.angleDiff * (float)(this.player ? -1 : 1)) + (this.player ? 0.0 : Math.PI)));
        float windupAngle = this.angleDiff * 1.5f * (float)(this.player ? -1 : 1);
        int windupDist = 5;
        this.addAction(Actions.sequence((Action)Actions.parallel((Action)Actions.rotateBy(-windupAngle, this.windupTime, Interpolation.pow2Out), (Action)Actions.moveBy(0.0f, windupDist, this.windupTime, Interpolation.pow2Out)), (Action)Actions.parallel((Action)Actions.moveTo(this.getX(), endY, this.swingTime, Interpolation.pow3In), (Action)Actions.rotateBy(this.angleDiff * (float)(this.player ? -2 : 2) + windupAngle, this.swingTime, Interpolation.pow3In)), (Action)Actions.fadeOut(0.2f), (Action)Actions.removeActor()));
    }

    public void setSound(String[] sound) {
        this.sound = sound;
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        batch.setColor(this.getColor());
        int originX = (int)((float)this.image.getRegionWidth() * 0.2f);
        int originY = (int)((float)this.image.getRegionHeight() / 2.0f);
        batch.draw(this.image, this.getX(), this.getY(), originX, originY, this.image.getRegionWidth(), this.image.getRegionHeight(), 1.0f, 1.0f, (float)Math.toDegrees(this.getRotation()));
        super.draw(batch, parentAlpha);
    }

    @Override
    protected float getImpactDuration() {
        return this.windupTime + this.swingTime * 0.8f;
    }

    @Override
    protected float getExtraDuration() {
        return this.swingTime * 0.19999999f + 0.2f;
    }
}

