/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.screens.dungeon.panels.combatEffects.triBolt;

import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.tann.dice.screens.dungeon.DungeonScreen;
import com.tann.dice.statics.ImageUtils;
import com.tann.dice.util.Colours;
import com.tann.dice.util.LineActor;

public class TriBoltActor
extends Actor {
    private static TextureRegion triBolt = ImageUtils.loadExt("combatEffects/misc/triBolt");
    float prevX;
    float prevY;

    @Override
    public void act(float delta) {
        if (this.prevX != 0.0f) {
            Vector2 rot = new Vector2(this.getX() - this.prevX, this.getY() - this.prevY).nor().rotate(90.0f);
            for (int i = 0; i < 3; ++i) {
                float bonusX = rot.x * (float)(1 - i) * 2.0f;
                float bonusY = rot.y * (float)(1 - i) * 2.0f;
                LineActor la = new LineActor(this.prevX + bonusX, this.prevY + bonusY, this.getX() + bonusX, this.getY() + bonusY);
                la.setColor(Colours.red);
                DungeonScreen.get().addActor(la);
                la.addAction(Actions.sequence((Action)Actions.fadeOut(0.2f), (Action)Actions.removeActor()));
            }
        }
        this.toFront();
        this.prevX = this.getX();
        this.prevY = this.getY();
        super.act(delta);
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        batch.setColor(Colours.z_white);
        batch.draw(triBolt, this.getX() - (float)(triBolt.getRegionWidth() / 2), this.getY() - (float)(triBolt.getRegionHeight() / 2));
    }
}

