/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.screens.dungeon.panels.entPanel;

import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.tann.dice.Main;
import com.tann.dice.gameplay.effect.targetable.ability.Ability;
import com.tann.dice.gameplay.effect.targetable.ability.tactic.Tactic;
import com.tann.dice.screens.dungeon.panels.Explanel.Explanel;
import com.tann.dice.screens.dungeon.panels.ExplanelReposition;
import com.tann.dice.statics.Images;
import com.tann.dice.statics.sound.Sounds;
import com.tann.dice.util.Colours;
import com.tann.dice.util.TannFont;
import com.tann.dice.util.listener.TannListener;

public class AbilityPanel
extends Actor {
    final Ability ability;

    public AbilityPanel(Ability ability) {
        float size = Images.itemBorder.getRegionWidth();
        this.setSize(size, size);
        this.ability = ability;
    }

    public void addStandardListener() {
        this.addListener(new TannListener(){

            @Override
            public boolean info(int button, float x, float y) {
                Explanel e;
                Actor top = Main.getCurrentScreen().getTopPushedActor();
                if (top instanceof Explanel && (e = (Explanel)top).isShowing(AbilityPanel.this.ability)) {
                    Main.getCurrentScreen().popSingleLight();
                    Sounds.playSound(Sounds.pop);
                    return true;
                }
                Main.getCurrentScreen().pop(Explanel.class);
                Explanel exp = new Explanel(AbilityPanel.this.ability, true);
                Actor a = Main.getCurrentScreen().getTopPushedActor();
                if (a != null && a instanceof ExplanelReposition) {
                    ((ExplanelReposition)((Object)a)).repositionExplanel(exp);
                } else if (Main.getCurrentScreen() instanceof ExplanelReposition) {
                    Main.getCurrentScreen().repositionExplanel(exp);
                }
                Main.getCurrentScreen().push(exp, false, true, true, 0.0f);
                Sounds.playSound(Sounds.pip);
                return true;
            }
        });
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        super.draw(batch, parentAlpha);
        batch.setColor(this.ability.getIdCol());
        batch.draw(Images.itemAbilityBorder, this.getX(), this.getY());
        if (this.ability instanceof Tactic) {
            TannFont f = TannFont.font;
            f.drawString(batch, this.ability.getTitle().charAt(0) + "", (float)((int)(this.getX() + this.getWidth() / 2.0f)), (float)((int)(this.getY() + this.getHeight() / 2.0f)), 1);
        } else {
            int imageSize = this.ability.getImage().getRegionHeight();
            batch.setColor(Colours.z_white);
            batch.draw(this.ability.getImage(), this.getX() + this.getWidth() / 2.0f - (float)(imageSize / 2), this.getY() + this.getHeight() / 2.0f - (float)(imageSize / 2));
        }
        super.draw(batch, parentAlpha);
    }
}

