/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.statics.bullet;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.PerspectiveCamera;
import com.badlogic.gdx.graphics.g3d.Material;
import com.badlogic.gdx.graphics.g3d.Model;
import com.badlogic.gdx.graphics.g3d.ModelBatch;
import com.badlogic.gdx.graphics.g3d.ModelInstance;
import com.badlogic.gdx.graphics.g3d.RenderableProvider;
import com.badlogic.gdx.graphics.g3d.Shader;
import com.badlogic.gdx.graphics.g3d.attributes.BlendingAttribute;
import com.badlogic.gdx.graphics.g3d.attributes.ColorAttribute;
import com.badlogic.gdx.graphics.g3d.utils.CameraInputController;
import com.badlogic.gdx.graphics.g3d.utils.ModelBuilder;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.math.collision.Ray;
import com.badlogic.gdx.physics.bullet.Bullet;
import com.badlogic.gdx.physics.bullet.collision.btBoxShape;
import com.badlogic.gdx.physics.bullet.collision.btSphereShape;
import com.badlogic.gdx.physics.bullet.dynamics.btRigidBody;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.utils.ObjectSet;
import com.tann.dice.Main;
import com.tann.dice.gameplay.content.ent.Ent;
import com.tann.dice.gameplay.content.ent.die.Die;
import com.tann.dice.gameplay.content.ent.die.EntDie;
import com.tann.dice.gameplay.phase.Phase;
import com.tann.dice.gameplay.phase.PhaseManager;
import com.tann.dice.gameplay.phase.gameplay.EnemyRollingPhase;
import com.tann.dice.gameplay.save.settings.option.OptionLib;
import com.tann.dice.screens.dungeon.DungeonScreen;
import com.tann.dice.screens.dungeon.panels.Explanel.RollPanel;
import com.tann.dice.screens.dungeon.panels.tutorial.TutorialManager;
import com.tann.dice.screens.rollScreen.RollScreen;
import com.tann.dice.statics.bullet.CameraCalc;
import com.tann.dice.statics.bullet.CollisionObject;
import com.tann.dice.statics.bullet.DieShader;
import com.tann.dice.statics.bullet.NoAutoDispose;
import com.tann.dice.statics.sound.Sounds;
import com.tann.dice.util.MemUtils;
import com.tann.dice.util.Tann;
import com.tann.dice.util.TannLog;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class BulletStuff {
    public static float BOX_DISTANCE_FOR_PIXEL_SIZE;
    public static final short OBJECT_FLAG = 512;
    public static final short ALL_FLAG = -1;
    public static PerspectiveCamera cam;
    static CameraInputController camController;
    public static PerspectiveCamera spinCam;
    public static ObjectSet<ModelInstance> instances;
    public static List<CollisionObject> walls;
    public static List<Die> dice;
    static ModelBatch modelBatch;
    static Model model;
    static Shader shader;
    private static Vector3 dieClickPosition;
    static float camX;
    public static float camY;
    static float camZ;
    public static float BOX_HEIGHT_FOR_PIXEL_SIZE;
    public static float BOX_WIDTH_FOR_PIXEL_SIZE;
    private static float fullscreenTrayHeight;
    private static float fullscreenTrayWidth;
    static float fov;
    private static NoAutoDispose nad;
    private static boolean needsDispose;
    static final int bonusSide = 8;
    private static final float mb = 0.2f;
    public static Vector3 camVector;
    public static float camDist;
    static Vector3 center;
    static Rectangle cachedWallBounds;
    private static long last_empty_tap;
    private static final long DOUBLE_TAP_MAX = 400L;
    public static final long clickDur = 220L;
    public static final long holdDur = 221L;
    static EntDie clicked;
    static long lastDown;
    static int storedPointer;
    static Group mousedPanel;
    private static boolean lined;
    private static boolean simulating;
    private static final int slideAmount = 13;

    public static boolean isAlive() {
        return needsDispose;
    }

    public static void init() {
        TannLog.log("Bullet init start");
        if (needsDispose) {
            BulletStuff.dispose();
        }
        needsDispose = true;
        Bullet.init();
        spinCam = new PerspectiveCamera(fov, Main.width, Main.height);
        nad = new NoAutoDispose();
        modelBatch = new ModelBatch();
        float magicNumber = 0.113f;
        BOX_DISTANCE_FOR_PIXEL_SIZE = magicNumber / (float)Main.scale * (float)Gdx.graphics.getHeight();
        BOX_HEIGHT_FOR_PIXEL_SIZE = BulletStuff.calculateBoxHeightAtDistance(BOX_DISTANCE_FOR_PIXEL_SIZE);
        BOX_WIDTH_FOR_PIXEL_SIZE = BOX_HEIGHT_FOR_PIXEL_SIZE * BulletStuff.getWidth3d() / BulletStuff.getHeight3d();
        BulletStuff.setupCamera();
        BulletStuff.setupWalls();
        shader = new DieShader();
        BulletStuff.initShader();
        TannLog.log("Bullet init end");
    }

    private static void setupCamera() {
        float actualDist = BulletStuff.getBaseCamDist() * 1.6f;
        actualDist = (float)((double)actualDist * Math.pow(0.9f, Main.getSettings().getDiceAdjust()));
        if (Main.isPortrait()) {
            camY = actualDist * 2.5f;
            camZ = actualDist * 0.23f;
        } else {
            camY = actualDist * 2.3f;
            camZ = actualDist * 0.8f;
        }
        BulletStuff.updateCamera();
    }

    private static float getBaseCamDist() {
        return CameraCalc.calcDistFromEstimatedBounds(BulletStuff.getPlayWidth(), BulletStuff.getPlayHeight());
    }

    public static Vector3 getMiddle() {
        return center.cpy();
    }

    public static void initShader() {
        shader.init();
    }

    public static boolean isWithinBox(Vector3 targetLoc, float radius) {
        Vector3 middle = BulletStuff.getMiddle();
        Vector3 diff = targetLoc.cpy().sub(middle);
        float w = BulletStuff.cachedWallBounds.width;
        float h = BulletStuff.cachedWallBounds.height;
        return diff.x - radius > -w / 2.0f && diff.x + radius < w / 2.0f && diff.z - radius > -h / 2.0f && diff.z + radius < h * 0.4f;
    }

    private static float getPlayWidth() {
        float sides = BulletStuff.getLeftSide() + BulletStuff.getRightSide();
        return 1.0f - sides;
    }

    private static float getPlayHeight() {
        return 1.0f - BulletStuff.getTopNelson() - BulletStuff.getBottomNelson();
    }

    private static float getLeftSide() {
        if (Main.isPortrait()) {
            return 0.0f;
        }
        float v = (92.0f + (float)Main.self().notch(3)) / (float)Main.width;
        return Math.max(v, 0.2f);
    }

    private static float getRightSide() {
        if (Main.isPortrait()) {
            return 0.0f;
        }
        float v = (92.0f + (float)BulletStuff.getPanelSlideAmount() + (float)Main.self().notch(1)) / (float)Main.width;
        return Math.max(v, 0.2f);
    }

    public static void setupWalls() {
        fullscreenTrayHeight = BulletStuff.calculateBoxHeightAtDistance(camDist);
        fullscreenTrayWidth = fullscreenTrayHeight * (float)Main.width / (float)Main.height;
        float bottomCutoff = BulletStuff.getBottomCutoff();
        float topBar = BulletStuff.getTopNelson() * fullscreenTrayHeight;
        BulletStuff.setupWalls(new Rectangle(BulletStuff.getLeftSide() * fullscreenTrayWidth, topBar, BulletStuff.getPlayWidth() * fullscreenTrayWidth, fullscreenTrayHeight - topBar - bottomCutoff));
    }

    private static float getBottomNelson() {
        return Main.isPortrait() ? 0.59f : 33.0f / (float)Main.height;
    }

    private static float getBottomCutoff() {
        return BulletStuff.getBottomNelson() * fullscreenTrayHeight;
    }

    private static void setupWalls(Rectangle wallArea) {
        for (CollisionObject co : walls) {
            BulletStuff.nad.dynamicsWorld.removeRigidBody(co.body);
        }
        walls = BulletStuff.makeWalls(wallArea);
        for (CollisionObject co : walls) {
            co.initialUpdate();
            BulletStuff.nad.dynamicsWorld.addRigidBody(co.body, 512, -1);
        }
    }

    private static float calculateBoxHeightAtDistance(float distance) {
        float cos = (float)Math.cos(Math.toRadians(fov / 2.0f));
        float hypot = distance / cos;
        float half = (float)Math.sqrt(hypot * hypot - distance * distance);
        return half * 2.0f;
    }

    public static void updateCamera() {
        cam = new PerspectiveCamera(fov, BulletStuff.getWidth3d(), BulletStuff.getHeight3d());
        BulletStuff.cam.position.set(camX, camY, camZ);
        Vector3 lookAt = new Vector3(0.0f, 0.0f, 0.0f);
        cam.lookAt(lookAt);
        cam.update();
        camController = new CameraInputController(cam);
        camVector = BulletStuff.cam.direction.cpy().nor();
        camDist = BulletStuff.cam.position.cpy().sub(lookAt).len();
    }

    private static List<CollisionObject> makeWalls(Rectangle playArea) {
        CollisionObject wall;
        int i;
        cachedWallBounds = playArea;
        float thickness = 0.5f;
        float height = 20.0f;
        ModelBuilder mb = new ModelBuilder();
        ArrayList<CollisionObject> results = new ArrayList<CollisionObject>();
        float trX = -fullscreenTrayWidth / 2.0f + playArea.width / 2.0f + playArea.x;
        float trY = height / 2.0f;
        float trZ = -fullscreenTrayHeight / 2.0f + playArea.height / 2.0f + playArea.y;
        center = new Vector3(trX, 0.0f, trZ);
        mb.begin();
        mb.node().id = "ground";
        mb.part("ground", 4, 9L, new Material(new BlendingAttribute(770, 771), ColorAttribute.createDiffuse(new Color(0.3f, 0.7f, 0.4f, 0.5f)))).box(0.0f, 0.0f, 0.0f);
        model = mb.end();
        float floorFriction = 100.0f;
        float wallFriction = 0.0f;
        for (i = 0; i < 2; ++i) {
            wall = new CollisionObject(model, "ground", new btBoxShape(new Vector3(playArea.width / 2.0f, thickness / 2.0f, playArea.height / 2.0f)), 0.0f, i == 0 ? floorFriction : wallFriction);
            if (i == 0) {
                wall.userData = 5;
                wall.body.userData = 5;
            }
            wall.transform.trn(trX, trY + (float)(i * 2 - 1) * (height / 2.0f + thickness / 2.0f), trZ);
            results.add(wall);
        }
        for (i = 0; i < 2; ++i) {
            wall = new CollisionObject(model, "ground", new btBoxShape(new Vector3(thickness, height / 2.0f, playArea.height / 2.0f)), 0.0f, wallFriction);
            wall.transform.trn(trX + (float)(i * 2 - 1) * (playArea.width / 2.0f + thickness / 2.0f), trY, trZ);
            results.add(wall);
        }
        for (i = 0; i < 2; ++i) {
            wall = new CollisionObject(model, "ground", new btBoxShape(new Vector3(playArea.width / 2.0f, height / 2.0f, thickness / 2.0f)), 0.0f, wallFriction);
            wall.transform.trn(trX, trY, trZ + (float)(i * 2 - 1) * (playArea.height / 2.0f + thickness / 2.0f));
            results.add(wall);
        }
        if (Main.isPortrait()) {
            float ratio = 60.0f / (float)Main.height;
            float factor = 2.2f;
            float rad = playArea.height * ratio * factor;
            results.add(BulletStuff.makeBlockerSphere(rad, trX - playArea.width / 2.0f - rad * 0.3f, 0, trZ - playArea.height / 2.0f));
        } else {
            float ratio = 35.0f / (float)Main.width;
            float factor = 2.2f;
            float rad = playArea.height * ratio * factor;
            results.add(BulletStuff.makeBlockerSphere(rad, 0.0f, 0, trZ + playArea.height / 2.0f + rad * 0.37f));
        }
        return results;
    }

    private static CollisionObject makeBlockerSphere(float rad, float trX, int trY, float trZ) {
        CollisionObject sphere = new CollisionObject(model, "ground", new btSphereShape(rad), 0.0f, 0.0f);
        sphere.transform.trn(trX, trY, trZ);
        return sphere;
    }

    public static void refreshEntities(List<Ent> entities) {
        BulletStuff.clearAllDice();
        instances.clear();
        ArrayList<EntDie> entDice = new ArrayList<EntDie>();
        for (Ent e : entities) {
            entDice.add(e.getDie());
        }
        BulletStuff.refreshDice(entDice);
    }

    public static void refreshDice(List<? extends Die> newDice) {
        dice.clear();
        dice.addAll(newDice);
    }

    public static void render() {
        camController.update();
        modelBatch.begin(cam);
        modelBatch.render(instances, shader);
        modelBatch.end();
    }

    private static void manualCameraControl() {
        float mul = Gdx.graphics.getDeltaTime() * 50.0f;
        if (Gdx.input.isKeyPressed(21)) {
            camZ -= mul;
        }
        if (Gdx.input.isKeyPressed(22)) {
            camZ += mul;
        }
        if (Gdx.input.isKeyPressed(19)) {
            camY -= mul;
        }
        if (Gdx.input.isKeyPressed(20)) {
            camY += mul;
        }
        BulletStuff.updateCamera();
    }

    public static void drawSpinnyDie3(Die die, float x, float y, float size) {
        if (!BulletStuff.isAlive()) {
            return;
        }
        float spinsPerSecond = 0.22f;
        float camDistScale = 0.27532798f;
        Vector3 v = new Vector3(-0.5f, 1.0f, -0.5f);
        v.scl(BOX_DISTANCE_FOR_PIXEL_SIZE);
        v.scl(0.27532798f);
        BulletStuff.spinCam.position.set(v);
        spinCam.lookAt(-1.0f, 2.0f, -1.0f);
        spinCam.update();
        float initialSize = 5.0f * die.getPixelSize();
        float sizeFactor = size / initialSize;
        Gdx.gl.glViewport((int)(x - (float)Main.width * sizeFactor / 2.0f), (int)(y - (float)Main.height * sizeFactor / 2.0f), (int)((float)Main.width * sizeFactor), (int)((float)Main.height * sizeFactor));
        Matrix4 copy = die.physical.transform.cpy();
        boolean prev = die.flatDraw;
        die.flatDraw = false;
        die.physical.transform.setToRotation(Vector3.X, 0.0f);
        die.physical.transform.setToRotation(1.0f, 1.0f, 1.0f, Main.secs * 360.0f * 0.22f);
        modelBatch.begin(spinCam);
        modelBatch.render((RenderableProvider)die.physical, shader);
        modelBatch.end();
        Gdx.gl.glViewport(0, 0, Main.width, Main.height);
        die.physical.transform = copy;
        die.flatDraw = prev;
    }

    public static boolean touchDown(float x, float y, int pointer, int button) {
        if (!PhaseManager.get().getPhase().canRoll()) {
            return false;
        }
        Die rawDie = BulletStuff.getDieUnderMouse(Gdx.input.getX(pointer), Gdx.input.getY(pointer));
        if (rawDie == null || !((EntDie)rawDie).ent.isPlayer()) {
            long newTap = System.currentTimeMillis();
            long doubleTap = newTap - last_empty_tap;
            if (doubleTap <= 400L) {
                last_empty_tap = 0L;
                BulletStuff.toggleDiceScatter();
            } else {
                last_empty_tap = newTap;
            }
            return false;
        }
        if (button == 1) {
            BulletStuff.attempToShowExplanel(rawDie, pointer);
            return true;
        }
        lastDown = System.currentTimeMillis();
        if (rawDie != null) {
            clicked = (EntDie)rawDie;
            storedPointer = pointer;
        }
        return true;
    }

    private static void attempToShowExplanel(Die rawDie, int pointer) {
        if (rawDie == null || rawDie.getState() != Die.DieState.Stopped) {
            return;
        }
        BulletStuff.showExplanel((EntDie)rawDie, pointer);
    }

    public static void touchUp(int screenX, int screenY, int pointer, int button) {
        Die rawDie;
        BulletStuff.highlightPanelDice(null);
        if (mousedPanel != null) {
            mousedPanel.remove();
            mousedPanel = null;
        }
        if ((rawDie = BulletStuff.getDieUnderMouse(Gdx.input.getX(pointer), Gdx.input.getY(pointer))) == null) {
            clicked = null;
            return;
        }
        long dur = System.currentTimeMillis() - lastDown;
        if (!(dur >= 220L && Main.self().control.allowLongPress() || clicked == null || clicked != rawDie)) {
            clicked.toggleLock();
            DungeonScreen.get().onLock();
        }
        clicked = null;
        lastDown = -1L;
    }

    private static void highlightPanelDice(Ent highlight) {
        if (DungeonScreen.get() != null) {
            for (Ent de : DungeonScreen.get().hero.getEntities()) {
                de.getEntPanel().setHighlightDice(de == highlight);
            }
        }
    }

    private static void setupExplanelPosition(Group group, int mouseX, int mouseY) {
        int explanelFullHeight = (int)group.getHeight();
        int distFromFinger = 8;
        int expY = Main.height - mouseY / Main.scale + distFromFinger;
        if ((float)expY + group.getHeight() > (float)Main.height) {
            expY -= distFromFinger * 2;
            expY -= explanelFullHeight;
        }
        int potentialX = (int)((float)(mouseX / Main.scale) - group.getWidth() / 2.0f);
        potentialX = (int)Math.max(0.0f, Math.min((float)Main.width - group.getWidth(), (float)potentialX));
        group.setPosition(potentialX, expY);
    }

    public static void update(float delta) {
        Phase p = PhaseManager.get().getPhase();
        if (p == null || !p.updateDice()) {
            return;
        }
        if (nad == null || nad.invalid()) {
            TannLog.error("something null in bullet");
            return;
        }
        boolean fastEnemyTurns = OptionLib.FAST_ENEMY_TURNS.c();
        int times = 1;
        if (PhaseManager.get().getPhase() instanceof EnemyRollingPhase && fastEnemyTurns) {
            times = 3;
        }
        if (Main.getCurrentScreen() instanceof RollScreen) {
            times = 100;
        }
        for (int j = 0; j < times; ++j) {
            BulletStuff.singleTick(delta);
        }
        long dur = System.currentTimeMillis() - lastDown;
        if (Main.self().control.allowLongPress() && dur >= 221L && clicked != null) {
            BulletStuff.attempToShowExplanel(clicked, storedPointer);
            clicked = null;
        }
    }

    private static void singleTick(float delta) {
        BulletStuff.nad.dynamicsWorld.stepSimulation(delta, 5, 0.016666668f);
        for (int i = 0; i < dice.size(); ++i) {
            dice.get(i).update(delta);
        }
        for (ModelInstance mi : instances) {
            if (!(mi instanceof CollisionObject)) continue;
            ((CollisionObject)mi).update();
        }
    }

    private static void showExplanel(EntDie d, int pointer) {
        Group rp;
        if (mousedPanel != null) {
            mousedPanel.remove();
        }
        BulletStuff.highlightPanelDice(d.ent);
        mousedPanel = rp = RollPanel.make(d.ent);
        Main.getCurrentScreen().addActor(mousedPanel);
        BulletStuff.setupExplanelPosition(mousedPanel, Gdx.input.getX(pointer), Gdx.input.getY(pointer));
        DungeonScreen ds = DungeonScreen.get();
        if (ds != null) {
            ds.getTutorialManager().onAction(TutorialManager.TutorialAction.DieInfo);
        }
    }

    public static boolean isMouseOnDice() {
        return BulletStuff.getDieUnderMouse(Gdx.input.getX(0), Gdx.input.getY(0)) != null;
    }

    public static Die getDieUnderMouse(int screenX, int screenY) {
        Ray ray = cam.getPickRay(screenX, screenY);
        Die result = null;
        float distance = -1.0f;
        for (Die d : dice) {
            CollisionObject instance = d.physical;
            instance.updateBounds();
            instance.transform.getTranslation(dieClickPosition);
            dieClickPosition.add(instance.center);
            float len = ray.direction.dot(BulletStuff.dieClickPosition.x - ray.origin.x, BulletStuff.dieClickPosition.y - ray.origin.y, BulletStuff.dieClickPosition.z - ray.origin.z);
            if (len < 0.0f) continue;
            float dist2 = dieClickPosition.dst2(ray.origin.x + ray.direction.x * len, ray.origin.y + ray.direction.y * len, ray.origin.z + ray.direction.z * len);
            if (distance >= 0.0f && dist2 > distance || !(dist2 <= instance.radius * instance.radius)) continue;
            result = d;
            distance = dist2;
        }
        if (result == null) {
            return null;
        }
        return result;
    }

    public static boolean allDiceLockedOrLocking() {
        for (int i = 0; i < dice.size(); ++i) {
            Die d = dice.get(i);
            if (d.getState().isLockedOrLocking()) continue;
            return false;
        }
        return true;
    }

    public static void reset() {
        BulletStuff.clearAllDice();
        instances.clear();
    }

    public static void clearAllDice() {
        for (Die d : dice) {
            d.removeFromScreen();
        }
        dice.clear();
    }

    public static void addRollSFX(int numDice, boolean firstRoll, boolean jiggle) {
        if (jiggle) {
            Sounds.playSound(Sounds.clacks, 1.0f, (float)((double)0.8f + Math.random() * (double)0.2f));
            Sounds.playSoundDelayed(Sounds.clocks, 1.0f, (float)((double)0.8f + Math.random() * (double)0.2f), 0.4f);
        }
        int maximumDelay = 5;
        float clackStart = firstRoll ? 0.1f : 0.18f;
        float clackRand = 0.1f;
        for (int i = 1; i < numDice; ++i) {
            Sounds.playSoundDelayed(Sounds.clacks, 1.0f, (float)((double)0.8f + Math.random() * (double)0.2f), (float)((double)clackStart + (double)((float)Math.min(maximumDelay, i) * clackRand) * Math.random()));
        }
        int extraClacks = (int)(Math.pow(numDice, 1.9f) * Math.random() / 7.0);
        float extraClackStart = 0.85f;
        for (int i = 0; i < extraClacks; ++i) {
            Sounds.playSoundDelayed(Sounds.clacks, 1.0f, (float)((double)0.8f + Math.random() * (double)0.2f), (float)((double)extraClackStart + (double)((float)Math.min(maximumDelay, i) * clackRand) * Math.random()));
        }
        float clockStart = 0.65f;
        float clockRand = 0.22f;
        for (int i = 0; i < numDice; ++i) {
            Sounds.playSoundDelayed(Sounds.clocks, 1.0f, (float)((double)0.8f + Math.random() * (double)0.2f), (float)((double)clockStart + (double)Math.min(maximumDelay, i) * Math.random() * (double)clockRand));
        }
    }

    private static void clearAllStatics() {
        cam = null;
        camController = null;
        modelBatch = null;
        instances = new ObjectSet();
        walls = new ArrayList<CollisionObject>();
        dice = new ArrayList<Die>();
        nad = null;
        model = null;
        shader = null;
    }

    public static void dispose() {
        needsDispose = false;
        if (!OptionLib.DISABLE_3D_DISPOSE.c()) {
            MemUtils.disp(modelBatch, model, shader, nad);
            if (dice != null) {
                for (Die d : new ArrayList<Die>(dice)) {
                    d.dispose();
                }
            }
            if (walls != null) {
                for (CollisionObject wall : walls) {
                    wall.dispose();
                }
            }
            if (instances != null) {
                for (ModelInstance mi : instances) {
                    mi.model.dispose();
                }
            }
            if (walls != null) {
                for (CollisionObject co : walls) {
                    co.dispose();
                }
            }
        }
        BulletStuff.clearAllStatics();
    }

    public static float getWidth3d() {
        return (float)Gdx.graphics.getWidth() / (float)Main.scale;
    }

    public static float getHeight3d() {
        return (float)Gdx.graphics.getHeight() / (float)Main.scale;
    }

    public static List<EntDie> getDice(Boolean hero) {
        ArrayList<EntDie> result = new ArrayList<EntDie>();
        for (Ent ent : DungeonScreen.get().getFightLog().getActiveEntities(hero)) {
            result.add(ent.getDie());
        }
        return result;
    }

    public static void toggleDiceScatter() {
        List<EntDie> availableToRoll = DungeonScreen.get().rollManager.getHeroDiceAvailableToRoll();
        List<EntDie> heroDice = BulletStuff.getDice(true);
        if (availableToRoll.size() == 0) {
            return;
        }
        boolean bl = lined = !BulletStuff.isLined();
        if (BulletStuff.isLined()) {
            EntDie.organiseDiceIntoLine(heroDice);
        } else {
            Die.scatterDice(availableToRoll);
        }
    }

    public static boolean isLined() {
        return lined && !Main.isPortrait();
    }

    public static void resetAlignment() {
        lined = false;
    }

    private static float getTopNelson() {
        return 0.15f * (Main.isPortrait() ? 0.35f : 1.0f);
    }

    /*
     * WARNING - void declaration
     */
    public static List<Integer> predictAndReset(List<EntDie> toRoll, boolean firstRoll, long rollSeed, boolean player) {
        void var12_18;
        boolean bl;
        ArrayList<Die> cpy = new ArrayList<Die>(dice);
        BulletStuff.reset();
        BulletStuff.refreshDice(cpy);
        BulletStuff.nad.dynamicsWorld.getConstraintSolver().reset();
        if (!dice.containsAll(toRoll)) {
            dice.removeAll(toRoll);
            dice.addAll(toRoll);
            String err = "dice roll err";
            TannLog.error(err);
            DungeonScreen.get().showDialog(err);
            Sounds.playSound(Sounds.bats);
        }
        simulating = true;
        ArrayList<Matrix4> pos = new ArrayList<Matrix4>();
        for (Die die : toRoll) {
            die.addToScreen();
            die.physical.update();
            pos.add(die.physical.transform.cpy());
        }
        Random r = Tann.makeStdRandom(rollSeed);
        for (EntDie entDie : toRoll) {
            entDie.roll(firstRoll, r);
        }
        boolean bl2 = false;
        int ticksLeft = 1000;
        boolean allLanded = false;
        while (!allLanded) {
            BulletStuff.singleTick(0.033333335f);
            allLanded = true;
            for (Die die : toRoll) {
                allLanded &= die.getState() != Die.DieState.Rolling;
            }
            if (--ticksLeft > 0) continue;
            TannLog.error("Failed to roll: " + toRoll);
            bl = true;
            break;
        }
        ArrayList<Integer> rolledSides = new ArrayList<Integer>();
        for (EntDie entDie : toRoll) {
            rolledSides.add(bl ? Tann.randomInt(6) : entDie.getSideIndex());
        }
        boolean bl3 = false;
        while (var12_18 < toRoll.size()) {
            Die d = toRoll.get((int)var12_18);
            d.physical.transform.set((Matrix4)pos.get((int)var12_18));
            d.physical.body.setAngularVelocity(new Vector3());
            d.physical.body.setLinearVelocity(new Vector3());
            d.physical.body.getMotionState();
            d.physical.body.setWorldTransform(d.physical.transform);
            d.physical.calculateTransforms();
            d.addToScreen();
            ++var12_18;
        }
        Tann.assertEquals("should have correct rtn amt", toRoll.size(), rolledSides.size());
        BulletStuff.nad.dynamicsWorld.getConstraintSolver().reset();
        simulating = false;
        return rolledSides;
    }

    public static boolean isSimulating() {
        return simulating;
    }

    public static boolean forcePrerandomise() {
        boolean b;
        boolean bl = b = BulletStuff.getPlayHeight() < 0.3f || BulletStuff.getPlayWidth() < 0.2f || Main.getSettings().getDiceAdjust() > 0;
        if (b) {
            TannLog.error("Bad roll bounds " + Main.resolutionString());
        }
        return b;
    }

    public static void removeBody(btRigidBody body) {
        BulletStuff.nad.dynamicsWorld.removeRigidBody(body);
        BulletStuff.nad.dynamicsWorld.removeCollisionObject(body);
    }

    public static void addDiceBody(btRigidBody body) {
        BulletStuff.nad.dynamicsWorld.addRigidBody(body, 512, -1);
    }

    public static int getPanelSlideAmount() {
        return (int)(13.0f * (Main.isPortrait() ? 0.6f : 1.0f));
    }

    static {
        instances = new ObjectSet();
        walls = new ArrayList<CollisionObject>();
        dice = new ArrayList<Die>();
        dieClickPosition = new Vector3();
        camX = 0.0f;
        camY = 20.0f;
        camZ = 8.5f;
        fov = 20.0f;
        camVector = new Vector3();
        camDist = 0.0f;
        center = new Vector3();
        last_empty_tap = 0L;
        mousedPanel = null;
        lined = false;
    }
}

