/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.test;

import com.tann.dice.gameplay.content.ent.die.side.EntSide;
import com.tann.dice.gameplay.content.ent.type.HeroCol;
import com.tann.dice.gameplay.content.ent.type.HeroType;
import com.tann.dice.gameplay.content.ent.type.lib.HeroTypeLib;
import com.tann.dice.gameplay.content.ent.type.lib.HeroTypeUtils;
import com.tann.dice.gameplay.content.item.Item;
import com.tann.dice.gameplay.content.item.ItemLib;
import com.tann.dice.gameplay.effect.eff.EffType;
import com.tann.dice.gameplay.effect.eff.keyword.Keyword;
import com.tann.dice.gameplay.trigger.personal.Personal;
import com.tann.dice.gameplay.trigger.personal.affectSideModular.AffectSides;
import com.tann.dice.gameplay.trigger.personal.affectSideModular.condition.AffectSideCondition;
import com.tann.dice.gameplay.trigger.personal.affectSideModular.condition.SpecificSidesCondition;
import com.tann.dice.gameplay.trigger.personal.affectSideModular.effect.AddKeyword;
import com.tann.dice.gameplay.trigger.personal.affectSideModular.effect.AffectSideEffect;
import com.tann.dice.test.util.Skip;
import com.tann.dice.test.util.Test;
import com.tann.dice.util.Tann;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class TestBannedCombos {
    @Test
    public static void duplicateCantrip() {
        TestBannedCombos.checkKeywordCollision(Keyword.duplicate, Keyword.cantrip);
    }

    @Test
    @Skip
    public static void growthRampage() {
        TestBannedCombos.checkKeywordCollision(Keyword.rampage, Keyword.growth);
    }

    @Test
    public static void cleaveKill() {
        TestBannedCombos.checkEffKeywordCollision(EffType.Kill, Keyword.cleave);
    }

    @Test
    public static void quadGrowth() {
        TestBannedCombos.checkKeywordCollision(Keyword.growth, Keyword.quadUse);
    }

    @Test
    @Skip
    public static void resurrectRescue() {
        TestBannedCombos.checkEffKeywordCollision(EffType.Resurrect, Keyword.rescue);
    }

    @Test
    public static void growthRerollCantrip() {
        TestBannedCombos.checkEffKeywordCollision(EffType.Reroll, Keyword.cantrip, Keyword.growth);
    }

    @Test
    public static void rechargeCleave() {
        TestBannedCombos.checkEffKeywordCollision(EffType.Recharge, Keyword.cleave);
        TestBannedCombos.checkEffKeywordCollision(EffType.Recharge, Keyword.descend);
        TestBannedCombos.checkEffKeywordCollision(EffType.Recharge, Keyword.doubleUse);
        TestBannedCombos.checkEffKeywordCollision(EffType.Recharge, Keyword.quadUse);
    }

    private static void checkKeywordCollision(Keyword a, Keyword b) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        result.addAll(TestBannedCombos.checkSingleItemCollision(a, b));
        result.addAll(TestBannedCombos.checkSingleItemCollision(b, a));
        Tann.assertTrue("Should be no collisions between " + (Object)((Object)a) + " and " + (Object)((Object)b) + ": " + result, result.size() == 0);
    }

    private static void checkEffKeywordCollision(EffType et, Keyword k) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        result.addAll(TestBannedCombos.checkSingleItemCollision(et, k));
        if (result.size() > 0) {
            System.out.println(result);
        }
        Tann.assertTrue("Should be no collisions between " + (Object)((Object)et) + " and " + (Object)((Object)k), result.size() == 0);
    }

    private static void checkEffKeywordCollision(EffType et, Keyword a, Keyword b) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        result.addAll(TestBannedCombos.checkSingleItemCollision(et, a, b));
        result.addAll(TestBannedCombos.checkSingleItemCollision(et, b, a));
        if (result.size() > 0) {
            System.out.println(result);
        }
        Tann.assertTrue("Should be no collisions between " + (Object)((Object)et) + " and " + (Object)((Object)a) + " and " + (Object)((Object)b), result.size() == 0);
    }

    private static List<Integer> checkSingleItemCollision(Keyword heroKeyword, Keyword itemKeyword) {
        ArrayList<Integer> fails = new ArrayList<Integer>();
        Set<Integer> hero = TestBannedCombos.getHeroIndices(heroKeyword);
        Set<Integer> item = TestBannedCombos.getItemIndices(itemKeyword);
        for (int i : hero) {
            if (!item.contains(i)) continue;
            fails.add(i);
        }
        return fails;
    }

    private static List<Integer> checkSingleItemCollision(EffType heroEffect, Keyword itemKeyword) {
        ArrayList<Integer> fails = new ArrayList<Integer>();
        Set<Integer> hero = TestBannedCombos.getHeroIndices(heroEffect);
        Set<Integer> item = TestBannedCombos.getItemIndices(itemKeyword);
        for (int i : hero) {
            if (!item.contains(i)) continue;
            fails.add(i);
        }
        return fails;
    }

    private static List<Integer> checkSingleItemCollision(EffType heroEffect, Keyword heroKeyword, Keyword itemKeyword) {
        ArrayList<Integer> fails = new ArrayList<Integer>();
        Set<Integer> heroA = TestBannedCombos.getHeroIndices(heroEffect, heroKeyword);
        Set<Integer> item = TestBannedCombos.getItemIndices(itemKeyword);
        for (int i : heroA) {
            if (!item.contains(i)) continue;
            fails.add(i);
        }
        return fails;
    }

    private static Set<Integer> getItemIndices(Keyword k) {
        HashSet<Integer> result = new HashSet<Integer>();
        for (Item e : ItemLib.getMasterCopy()) {
            if (e.getTier() >= 10 || e.getTier() <= 0 || e.getName().contains("otion")) continue;
            for (Personal pt : e.getPersonalTriggers()) {
                if (!(pt instanceof AffectSides)) continue;
                AffectSides tas = (AffectSides)pt;
                for (AffectSideEffect ase : tas.getEffects()) {
                    AddKeyword ak;
                    if (!(ase instanceof AddKeyword) || !(ak = (AddKeyword)ase).getKeywordList().contains((Object)k)) continue;
                    for (AffectSideCondition asc : tas.getConditions()) {
                        if (!(asc instanceof SpecificSidesCondition)) continue;
                        SpecificSidesCondition ssc = (SpecificSidesCondition)asc;
                        result.addAll(Tann.intArrayToList(ssc.specificSidesType.sideIndices));
                    }
                }
            }
        }
        return result;
    }

    private static Set<Integer> getHeroIndices(Keyword k) {
        HashSet<Integer> result = new HashSet<Integer>();
        for (HeroType ht : HeroTypeLib.getMasterCopy()) {
            if (ht.heroCol == HeroCol.green) continue;
            for (int sideIndex = 0; sideIndex < 6; ++sideIndex) {
                EntSide es = ht.sides[sideIndex];
                if (!es.getBaseEffect().hasKeyword(k)) continue;
                result.add(sideIndex);
            }
        }
        return result;
    }

    private static Set<Integer> getHeroIndices(EffType et) {
        HashSet<Integer> result = new HashSet<Integer>();
        for (HeroType ht : HeroTypeLib.getMasterCopy()) {
            for (int sideIndex = 0; sideIndex < 6; ++sideIndex) {
                EntSide es = ht.sides[sideIndex];
                if (es.getBaseEffect().getType() != et) continue;
                result.add(sideIndex);
            }
        }
        return result;
    }

    private static Set<Integer> getHeroIndices(EffType et, Keyword k) {
        HashSet<Integer> result = new HashSet<Integer>();
        List<HeroType> l = HeroTypeLib.getMasterCopy();
        List<HeroType> ignored = HeroTypeUtils.heroList("sphere", "statue", "glitch");
        l.removeAll(ignored);
        for (HeroType ht : l) {
            for (int sideIndex = 0; sideIndex < 6; ++sideIndex) {
                EntSide es = ht.sides[sideIndex];
                if (!es.getBaseEffect().hasKeyword(k) || es.getBaseEffect().getType() != et) continue;
                result.add(sideIndex);
            }
        }
        return result;
    }
}

