/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.util;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.math.Vector3;
import com.tann.dice.util.Draw;
import com.tann.dice.util.image.Img64;
import java.util.Random;

public class Colours {
    public static Color dark;
    public static Color light;
    public static Color yellow;
    public static Color orange;
    public static Color red;
    public static Color blue;
    public static Color grey;
    public static Color purple;
    public static Color green;
    public static Color pink;
    public static final Color text;
    public static final Color brown;
    public static final Color NEON_RED;
    public static final Color BLURPLE;
    public static final Color SHIFTER;
    public static Color[] palette;
    public static Color AS_BORDER;
    public static final Color z_white;
    public static final Color z_black;
    public static final Color transparent;
    private static Pixmap p;
    private static Color alphaCol;
    private static Color shiftedCol;
    private static Color colCache;
    private static Random randomCache;

    public static void init() {
        Texture t = new Texture(Gdx.files.internal("misc/palette.png"));
        p = Draw.getPixmap(t);
        dark = Colours.palette(0, 0);
        light = Colours.palette(1, 0);
        yellow = Colours.palette(2, 0);
        orange = Colours.palette(3, 0);
        red = Colours.palette(4, 0);
        blue = Colours.palette(5, 0);
        grey = Colours.palette(6, 0);
        purple = Colours.palette(7, 0);
        green = Colours.palette(8, 0);
        pink = Colours.palette(9, 0);
        palette = new Color[]{dark, light, yellow, orange, red, blue, grey, purple, green, text, pink};
    }

    public static Color palette(int x, int y) {
        Color c = new Color(p.getPixel(x, y));
        return c;
    }

    public static Color withAlpha(Color c, float alpha) {
        return alphaCol.set(c.r, c.g, c.b, alpha);
    }

    public static Color shiftedTowards(Color source, Color target, float amount) {
        if (amount > 1.0f) {
            amount = 1.0f;
        }
        if (amount < 0.0f) {
            amount = 0.0f;
        }
        float r = source.r + (target.r - source.r) * amount;
        float g = source.g + (target.g - source.g) * amount;
        float b = source.b + (target.b - source.b) * amount;
        float a = source.a + (target.a - source.a) * amount;
        return shiftedCol.set(r, g, b, a);
    }

    public static Color shiftedTowards(Color[] cols, float amount) {
        if (cols.length == 0) {
            throw new RuntimeException("null colour");
        }
        if (amount >= 1.0f || cols.length == 1) {
            return cols[cols.length - 1];
        }
        int numCols = cols.length;
        int lowerIndex = (int)(amount * (float)(numCols - 1));
        int upperIndex = lowerIndex + 1;
        float ratio = amount * (float)(numCols - 1) % 1.0f;
        return Colours.shiftedTowards(cols[lowerIndex], cols[upperIndex], ratio);
    }

    public static Color multiply(Color source, Color target) {
        return new Color(source.r * target.r, source.g * target.g, source.b * target.b, 1.0f);
    }

    public static Color make(int r, int g, int b) {
        return new Color((float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f, 1.0f);
    }

    public static Color monochrome(Color c) {
        float brightness = (c.r + c.g + c.b) / 3.0f;
        return new Color(brightness, brightness, brightness, c.a);
    }

    public static boolean equals(Color a, Color b) {
        return a.a == b.a && a.r == b.r && a.g == b.g && a.b == b.b;
    }

    public static boolean wigglyEquals(Color a, Color aa) {
        float r = Math.abs(a.r - aa.r);
        float g = Math.abs(a.g - aa.g);
        float b = Math.abs(a.b - aa.b);
        float wiggle = 0.01f;
        return r < wiggle && g < wiggle && b < wiggle;
    }

    public static void setBatchColour(Batch batch, Color c, float a) {
        batch.setColor(c.r, c.g, c.b, a);
    }

    public static Vector3 v3(Color col) {
        return new Vector3(col.r, col.g, col.b);
    }

    public static Color random() {
        return colCache.set((float)Math.random(), (float)Math.random(), (float)Math.random(), 1.0f);
    }

    public static Color randomHashed(int hash) {
        randomCache.setSeed(hash);
        for (int i = 0; i < 3; ++i) {
            randomCache.nextInt();
        }
        return colCache.set(randomCache.nextFloat(), randomCache.nextFloat(), randomCache.nextFloat(), 1.0f);
    }

    public static Color secretCol(int hash) {
        Color hashCol = Colours.randomHashed(hash);
        return Colours.shiftedTowards(hashCol, new Color(0.0f, 0.0f, 0.0f, 1.0f), 0.5f).cpy();
    }

    public static Color from64(String str) {
        if (str == null || str.length() != 3) {
            return pink;
        }
        int r = Img64.index(str.charAt(0));
        int g = Img64.index(str.charAt(1));
        int b = Img64.index(str.charAt(2));
        return new Color((float)r / 64.0f, (float)g / 64.0f, (float)b / 64.0f, 1.0f);
    }

    public static Color fromHex(String str) {
        if (str == null) {
            return pink;
        }
        if (str.length() == 3) {
            String r = "" + str.charAt(0);
            String g = "" + str.charAt(1);
            String b = "" + str.charAt(2);
            str = r + '0' + g + '0' + b + '0';
        }
        if (str.length() != 6) {
            return pink;
        }
        return Color.valueOf(str);
    }

    public static String toHex(Color col) {
        String colStr = col.toString();
        return colStr.charAt(0) + "" + colStr.charAt(2) + "" + colStr.charAt(4);
    }

    static {
        text = Colours.make(158, 168, 166);
        brown = Colours.make(137, 92, 67);
        NEON_RED = Colours.make(253, 77, 79);
        BLURPLE = Colours.make(88, 101, 242);
        SHIFTER = new Color();
        AS_BORDER = text;
        z_white = new Color(1.0f, 1.0f, 1.0f, 1.0f);
        z_black = new Color(0.0f, 0.0f, 0.0f, 1.0f);
        transparent = new Color(0.0f, 0.0f, 0.0f, 0.0f);
        alphaCol = new Color();
        shiftedCol = new Color();
        colCache = new Color();
        randomCache = new Random();
    }
}

