/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.util;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.NinePatch;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.EventListener;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.badlogic.gdx.scenes.scene2d.actions.MoveByAction;
import com.badlogic.gdx.scenes.scene2d.actions.MoveToAction;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane;
import com.badlogic.gdx.scenes.scene2d.utils.NinePatchDrawable;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.SnapshotArray;
import com.tann.dice.Main;
import com.tann.dice.gameplay.content.gen.pipe.entity.hero.PipeHero;
import com.tann.dice.gameplay.content.gen.pipe.entity.monster.PipeMonster;
import com.tann.dice.gameplay.content.gen.pipe.item.PipeItem;
import com.tann.dice.gameplay.content.gen.pipe.mod.PipeMod;
import com.tann.dice.gameplay.modifier.Modifier;
import com.tann.dice.gameplay.phase.levelEndPhase.rewardPhase.decisionPhase.choice.choosable.Choosable;
import com.tann.dice.gameplay.phase.levelEndPhase.rewardPhase.decisionPhase.choice.choosable.ChoosableUtils;
import com.tann.dice.gameplay.progress.chievo.unlock.Unlockable;
import com.tann.dice.screens.Screen;
import com.tann.dice.screens.dungeon.panels.Explanel.Explanel;
import com.tann.dice.statics.Images;
import com.tann.dice.statics.sound.Sounds;
import com.tann.dice.util.ChanceHaver;
import com.tann.dice.util.Chrono;
import com.tann.dice.util.Colours;
import com.tann.dice.util.Draw;
import com.tann.dice.util.ImageActor;
import com.tann.dice.util.Pixl;
import com.tann.dice.util.TannFont;
import com.tann.dice.util.TannLog;
import com.tann.dice.util.TannStageUtils;
import com.tann.dice.util.TimerUtil;
import com.tann.dice.util.WhiskerRandom;
import com.tann.dice.util.lang.Words;
import com.tann.dice.util.listener.TannListener;
import com.tann.dice.util.tp.TP;
import com.tann.dice.util.ui.BorderText;
import com.tann.dice.util.ui.TextWriter;
import com.tann.dice.util.ui.action.PixAction;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;

public class Tann {
    public static final boolean[] BOTH = new boolean[]{false, true};
    public static final boolean[] BOTH_R = new boolean[]{true, false};
    public static final Boolean[] ALL = new Boolean[]{false, true, null};
    private static final Vector2 tmp = new Vector2();
    public static final float TAU = (float)Math.PI * 2;
    public static final int INFINITY = 999;
    static HashSet<Object> setTmp = new HashSet();
    public static SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
    static DecimalFormat df = new DecimalFormat("#.##");
    static DecimalFormat pf = new DecimalFormat("#.##%");
    private static int rng_counter = 0;
    public static final Interpolation triangle = new Interpolation(){

        @Override
        public float apply(float a) {
            return (float)(1.0 - 2.0 * Math.abs((double)a - 0.5));
        }
    };
    static Vector2 radialTmp = new Vector2();
    public static final int MAX_ERROR_CONTENT = 5000;
    public static final int SCROLL_PANE_BAR_WIDTH = 6;

    public static Vector2 getAbsoluteCoordinates(Actor a) {
        return Tann.getAbsoluteCoordinates(a, null);
    }

    public static Vector2 getAbsoluteCoordinates(Actor a, TannPosition position) {
        tmp.set(0.0f, 0.0f);
        Tann.calculateLocalIgnoringScreens(a, tmp);
        if (position == null) {
            return tmp;
        }
        switch (position) {
            case Left: {
                tmp.add(0.0f, a.getHeight() / 2.0f);
                break;
            }
            case Right: {
                tmp.add(a.getWidth(), a.getHeight() / 2.0f);
                break;
            }
            case Top: {
                tmp.add(a.getWidth() / 2.0f, a.getHeight());
                break;
            }
            case Bot: {
                tmp.add(a.getWidth() / 2.0f, 0.0f);
                break;
            }
            case Center: {
                tmp.add(a.getWidth() / 2.0f, a.getHeight() / 2.0f);
            }
        }
        return tmp;
    }

    private static void calculateLocalIgnoringScreens(Actor a, Vector2 tmp) {
        tmp.add(a.getX(), a.getY());
        Group parent = a.getParent();
        if (parent != null && !(parent instanceof Screen)) {
            Tann.calculateLocalIgnoringScreens(parent, tmp);
        }
    }

    public static float dist(float x, float y, float x1, float y1) {
        float xDiff = x1 - x;
        float yDiff = y1 - y;
        return (float)Math.sqrt(xDiff * xDiff + yDiff * yDiff);
    }

    public static int between(float a, float b) {
        return (int)(a + (b - a) / 2.0f);
    }

    public static void delayOneFrame(Runnable r) {
        Tann.delay(1.0E-4f, r);
    }

    public static void delay(float delay, Runnable runnable) {
        TimerUtil.delay(delay, runnable);
    }

    public static boolean inArray(Object object, Object[] array) {
        return Arrays.asList(array).contains(object);
    }

    public static <T> boolean anySharedItems(List<T> a, List<T> b) {
        for (int i = 0; i < a.size(); ++i) {
            T t = a.get(i);
            if (!b.contains(t)) continue;
            return true;
        }
        return false;
    }

    public static <T> List<T> getSharedItems(List<T> a, List<T> b) {
        ArrayList<T> result = new ArrayList<T>();
        for (int i = 0; i < a.size(); ++i) {
            T t = a.get(i);
            if (!b.contains(t)) continue;
            result.add(t);
        }
        return result;
    }

    public static boolean anySharedItems(Object[] array1, Object[] array2) {
        List<Object> listOne = Arrays.asList(array1);
        for (Object o : array2) {
            if (!listOne.contains(o)) continue;
            return true;
        }
        return false;
    }

    public static boolean anySharedItems(int[] array1, int[] array2) {
        for (int i : array2) {
            if (!Tann.contains(array1, i)) continue;
            return true;
        }
        return false;
    }

    public static List<TextureAtlas.AtlasRegion> getRegionsStartingWith(String prefix) {
        return Tann.getRegionsStartingWith(Main.atlas, prefix);
    }

    public static List<TextureAtlas.AtlasRegion> getRegionsStartingWith(TextureAtlas atlas, String prefix) {
        ArrayList<TextureAtlas.AtlasRegion> results = new ArrayList<TextureAtlas.AtlasRegion>();
        if (atlas == null) {
            return results;
        }
        for (TextureAtlas.AtlasRegion ar : atlas.getRegions()) {
            if (!ar.name.startsWith(prefix)) continue;
            results.add(ar);
        }
        return results;
    }

    public static <T> List<T> iterandom(List<T> list) {
        ArrayList<T> copy = new ArrayList<T>(list);
        Collections.shuffle(copy);
        return copy;
    }

    public static void center(Actor child) {
        Group parent = child.getParent();
        child.setPosition((int)(parent.getWidth() / 2.0f - child.getWidth() / 2.0f), (int)(parent.getHeight() / 2.0f - child.getHeight() / 2.0f));
        if (child instanceof Explanel) {
            child.setY(child.getY() + (float)(((Explanel)child).getExtraBelowExtent() / 2));
        }
    }

    public static void randomPos(Actor child) {
        Group parent = child.getParent();
        child.setPosition((int)Tann.random(0.0f, parent.getWidth() - child.getWidth()), (int)Tann.random(0.0f, parent.getHeight() - child.getHeight()));
    }

    public static void swap(Object[] array, int i1, int i2) {
        Object o = array[i1];
        array[i1] = array[i2];
        array[i2] = o;
    }

    public static void printAllPositions(Actor a) {
        while (a != null) {
            System.out.println(Tann.pad(a.getClass().getSimpleName(), 30) + a.getX() + ":" + a.getY());
            a = a.getParent();
        }
    }

    public static String pad(String str, int length) {
        return Tann.pad(str, length, ' ', false);
    }

    public static String pad(String str, int length, char padChar, boolean before) {
        while (str.length() < length) {
            if (before) {
                str = padChar + str;
                continue;
            }
            str = str + padChar;
        }
        return str;
    }

    public static void insertAction(Actor a, Action action) {
        if (action instanceof MoveByAction || action instanceof MoveToAction) {
            Tann.removeMoveActions(a);
        }
        a.getActions().insert(0, action);
        action.setActor(a);
    }

    public static void removeMoveActions(Actor actor) {
        for (int i = actor.getActions().size - 1; i >= 0; --i) {
            Action a = actor.getActions().get(i);
            if (!(a instanceof MoveToAction) && !(a instanceof MoveByAction)) continue;
            actor.getActions().removeValue(a, true);
        }
    }

    public static <T> void addAll(List<T> list, T ... items) {
        list.addAll(Arrays.asList(items));
    }

    public static <T> boolean contains(T[] array, T val) {
        for (int i = 0; i < array.length; ++i) {
            T t = array[i];
            if (t != val && (t == null || !t.equals(val))) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(int[] array, int val) {
        return Tann.indexOf(array, val) != -1;
    }

    public static boolean contains(char[] array, char val) {
        for (int j = 0; j < array.length; ++j) {
            char i = array[j];
            if (i != val) continue;
            return true;
        }
        return false;
    }

    public static Group makeGroup(int width, int height) {
        Group g = new Group();
        g.setTransform(false);
        g.setSize(width, height);
        return g;
    }

    public static Group makeGroup() {
        return Tann.makeGroup(0, 0);
    }

    public static Group makeGroup(Actor a) {
        Group g = Tann.makeGroup((int)a.getWidth(), (int)a.getHeight());
        g.addActor(a);
        return g;
    }

    public static void drawPatch(Batch batch, Actor actor, NinePatch ninePatch, Color bg, Color border, int gap) {
        Tann.drawPatch(batch, (int)actor.getX(), (int)actor.getY(), (int)actor.getWidth(), (int)actor.getHeight(), ninePatch, bg, border, gap);
    }

    public static void drawPatch(Batch batch, float x, float y, float width, float height, NinePatch ninePatch, Color bg, Color border, int gap) {
        batch.setColor(bg);
        Draw.fillRectangle(batch, x + (float)gap, y + (float)gap, width - (float)(gap * 2), height - (float)(gap * 2));
        batch.setColor(border);
        ninePatch.draw(batch, x, y, width, height);
    }

    public static float length(float xDist, float yDist) {
        return (float)Math.sqrt(xDist * xDist + yDist * yDist);
    }

    public static Action fadeAndRemove(float time) {
        return Actions.sequence((Action)Actions.fadeOut(time), (Action)Actions.removeActor());
    }

    public static float getX() {
        return Gdx.input.getX() / Main.scale;
    }

    public static float getY() {
        return Main.height - Gdx.input.getY() / Main.scale;
    }

    public static void setPosition(Actor actor, Vector2 position) {
        actor.setPosition(position.x, position.y);
    }

    public static Action moveTo(Vector2 vector, float duration, Interpolation interpolation) {
        return Actions.moveTo(vector.x, vector.y, duration, interpolation);
    }

    public static Action moveBy(Vector2 vector, float duration, Interpolation interpolation) {
        return Actions.moveBy(vector.x, vector.y, duration, interpolation);
    }

    public static boolean equals(Object a, Object b) {
        return a == b || a != null && a.equals(b);
    }

    public static void assertTrue(boolean b) {
        Tann.assertTrue("", b);
    }

    public static <T> void assertEquals(String message, T expected, T actual) {
        if (!Tann.equals(expected, actual)) {
            throw new RuntimeException(message + " expected " + expected + " and got " + actual);
        }
    }

    public static void assertTrue(String message, boolean b) {
        if (!b) {
            throw new RuntimeException(message);
        }
    }

    public static void throwEx(String message) {
        Tann.assertTrue(message, false);
    }

    public static int indexOf(int[] array, int item) {
        for (int i = 0; i < array.length; ++i) {
            if (item != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static <T> int indexOf(T[] array, T item) {
        for (int i = 0; i < array.length; ++i) {
            if (item != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(String[] array, String item) {
        for (int i = 0; i < array.length; ++i) {
            if (!item.equals(array[i])) continue;
            return i;
        }
        return -1;
    }

    public static <T> int indexOfEq(T[] array, T item) {
        for (int i = 0; i < array.length; ++i) {
            if (!item.equals(array[i])) continue;
            return i;
        }
        return -1;
    }

    public static <T> void shuffle(T[] ts) {
        Random r = new Random();
        for (int i = 0; i < ts.length; ++i) {
            int rand = r.nextInt(ts.length);
            T tmp = ts[i];
            ts[i] = ts[rand];
            ts[rand] = tmp;
        }
    }

    public static void shuffle(int[] levels) {
        Random r = new Random();
        for (int i = 0; i < levels.length; ++i) {
            int rand = r.nextInt(levels.length);
            int tmp = levels[i];
            levels[i] = levels[rand];
            levels[rand] = tmp;
        }
    }

    public static Color max(Color max, Color c) {
        return new Color(Math.max(max.r, c.r), Math.max(max.g, c.g), Math.max(max.b, c.b), Math.max(max.a, c.a));
    }

    public static Color min(Color min, Color c) {
        return new Color(Math.min(min.r, c.r), Math.min(min.g, c.g), Math.min(min.b, c.b), Math.min(min.a, c.a));
    }

    public static void finishAllActions(Actor actor) {
        for (Action a : actor.getActions()) {
            a.act(100.0f);
        }
    }

    public static void setAlpha(Actor a, float alpha) {
        Color col = a.getColor();
        a.setColor(col.r, col.g, col.b, alpha);
    }

    public static Group noTransformGroup() {
        Group g = new Group();
        g.setTransform(false);
        return g;
    }

    public static <T> float countInArray(T entry, T[] array) {
        int count = 0;
        for (T t : array) {
            if (t != entry) continue;
            ++count;
        }
        return count;
    }

    public static <T> int countInList(T item, List<T> list) {
        int count = 0;
        for (int i = 0; i < list.size(); ++i) {
            T t = list.get(i);
            if (t != item) continue;
            ++count;
        }
        return count;
    }

    public static <T> void addMultiple(List<T> list, T toAdd, int amt, boolean end) {
        for (int i = 0; i < amt; ++i) {
            list.add(end ? 0 : list.size(), toAdd);
        }
    }

    public static int countDistinct(List<? extends Object> types) {
        setTmp.clear();
        setTmp.addAll(types);
        return setTmp.size();
    }

    public static <T> boolean hasOnly(List<T> list, T onlyItem) {
        return list.size() == 1 && list.contains(onlyItem);
    }

    public static String delta(int delta) {
        return (delta < 0 ? "" : "+") + delta;
    }

    public static String delta(float delta) {
        return (delta < 0.0f ? "" : "+") + delta;
    }

    public static String getTimeDescription(String submitted_time) {
        try {
            Date d = format.parse(submitted_time);
            long delta = System.currentTimeMillis() - d.getTime();
            long deltaSeconds = delta / 1000L;
            long deltaDays = deltaSeconds / 60L / 60L / 24L;
            if (deltaDays == 0L) {
                return "today";
            }
            if (deltaDays < 30L) {
                return deltaDays + " " + Words.plural("day", (int)deltaDays) + " ago";
            }
            long deltaMonths = deltaDays / 30L;
            if (deltaMonths < 24L) {
                return deltaMonths + " " + Words.plural("month", (int)deltaMonths) + " ago";
            }
            long deltaYears = deltaMonths / 12L;
            return deltaYears + " " + Words.plural("year", (int)deltaYears) + " ago";
        }
        catch (ParseException e) {
            e.printStackTrace();
            return "???";
        }
    }

    public static boolean isMissingno(Unlockable unlockable) {
        return unlockable == PipeItem.getMissingno() || unlockable == PipeHero.getMissingno() || unlockable == PipeMonster.getMissingno() || unlockable == PipeMod.getMissingno();
    }

    public static boolean isMissingnoObject(Object object) {
        if (object instanceof Unlockable) {
            return Tann.isMissingno((Unlockable)object);
        }
        return object == null;
    }

    public static void clearDupes(List list) {
        for (int i = list.size() - 1; i >= 0; --i) {
            Object o = list.get(i);
            if (list.indexOf(o) == i) continue;
            list.remove(i);
        }
    }

    public static int nextPrimeAfter(int value) {
        for (int i = value + 1; i < 999; ++i) {
            if (!Tann.isPrime(i)) continue;
            return i;
        }
        return 999;
    }

    public static boolean hasParent(Actor actor, Class<? extends Group> parentClass) {
        while (actor.hasParent()) {
            if (!parentClass.isInstance(actor = actor.getParent())) continue;
            return true;
        }
        return false;
    }

    public static boolean overlapsSibling(Actor a) {
        if (!a.hasParent()) {
            return false;
        }
        SnapshotArray<Actor> sibs = a.getParent().getChildren();
        for (Actor sib : sibs) {
            if (a == sib || !Tann.overlaps(a, sib)) continue;
            return true;
        }
        return false;
    }

    public static <T extends Actor> T findByClass(Stage stage, Class<T> clazz) {
        if (stage == null) {
            return null;
        }
        return Tann.findByClass(stage.getRoot(), clazz);
    }

    public static <T extends Actor> T findByClass(Group group, Class<T> clazz) {
        if (group == null) {
            return null;
        }
        for (Actor a : group.getChildren()) {
            T t;
            if (clazz.isInstance(a)) {
                return (T)a;
            }
            if (!(a instanceof Group) || (t = Tann.findByClass((Group)a, clazz)) == null) continue;
            return t;
        }
        return null;
    }

    private static boolean overlaps(Actor a, Actor b) {
        float ax0 = a.getX();
        float ax1 = a.getX() + a.getWidth();
        float ay0 = a.getY();
        float ay1 = a.getY() + a.getHeight();
        float bx0 = b.getX();
        float bx1 = b.getX() + b.getWidth();
        float by0 = b.getY();
        float by1 = b.getY() + b.getHeight();
        return !(ax1 < bx0 || ax0 > bx1 || ay1 < by0 || ay0 > by1);
    }

    public static String floatFormat(float input) {
        return df.format(input);
    }

    public static String percentFormat(float input) {
        return pf.format(input);
    }

    public static <T> T randomElement(List<T> list, Random r) {
        if (list.size() == 0) {
            return null;
        }
        return list.get(r.nextInt(list.size()));
    }

    public static Actor imageWithText(TextureRegion tr, String s) {
        return Tann.imageWithText(tr, s, null);
    }

    public static Actor imageWithText(TextureRegion tr, String s, Color border) {
        return Tann.actorWithText(new ImageActor(tr), s, border);
    }

    public static Actor actorWithText(Actor a, String s, Color border) {
        return Tann.combineActors(a, new BorderText(s, border == null ? Colours.dark : border));
    }

    public static Actor combineImages(TextureRegion tr, TextureRegion tr2) {
        return Tann.combineActors(new ImageActor(tr), new ImageActor(tr2));
    }

    public static Group combineActors(Actor a, Actor b) {
        Group g = Tann.makeGroup((int)Math.max(a.getWidth(), b.getWidth()), (int)Math.max(a.getHeight(), b.getHeight()));
        g.addActor(a);
        g.addActor(b);
        Tann.center(a);
        Tann.center(b);
        return g;
    }

    public static <T> List<T> arrayToList(Array<T> entriesArray) {
        return new ArrayList<T>(Arrays.asList(entriesArray.toArray()));
    }

    public static List<Integer> intArrayToList(int[] input) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (int i : input) {
            result.add(i);
        }
        return result;
    }

    public static void uniquify(List result) {
        for (int i = result.size() - 1; i >= 0; --i) {
            if (result.indexOf(result.get(i)) == i) continue;
            result.remove(i);
        }
    }

    public static int[] from(int a, int b) {
        int[] result = new int[b - a];
        for (int i = 0; i < result.length; ++i) {
            result[i] = a + i;
        }
        return result;
    }

    public static int randomInt(int bound) {
        return (int)(Math.random() * (double)bound);
    }

    public static int randomInt(int min, int maxInclusive) {
        return min + (int)(Math.random() * (double)(maxInclusive + 1 - min));
    }

    public static boolean chance(float chance) {
        return Math.random() < (double)chance;
    }

    public static void addListenerFirst(Actor a, EventListener listener) {
        a.getListeners().insert(0, listener);
    }

    public static <T> Map<T, Integer> countMap(List<T> list) {
        HashMap<T, Integer> result = new HashMap<T, Integer>();
        for (T t : list) {
            if (result.get(t) == null) {
                result.put(t, 1);
                continue;
            }
            result.put(t, (Integer)result.get(t) + 1);
        }
        return result;
    }

    public static int totalHeight(List<Actor> acs) {
        int total = 0;
        for (Actor a : acs) {
            total = (int)((float)total + a.getHeight());
        }
        return total;
    }

    public static int totalWidth(List<Actor> acs) {
        int total = 0;
        for (Actor a : acs) {
            total = (int)((float)total + a.getWidth());
        }
        return total;
    }

    public static <T> T randomExcept(T[] values, T exclude) {
        int start = (int)(Math.random() * (double)values.length);
        for (int i = 0; i < values.length; ++i) {
            int index = (start + i) % values.length;
            if (values[index] == exclude) continue;
            return values[index];
        }
        return null;
    }

    public static int[] ascending(int amt) {
        int[] result = new int[amt];
        for (int i = 0; i < amt; ++i) {
            result[i] = i;
        }
        return result;
    }

    public static void selfPop(final ScrollPane sp) {
        sp.addListener(new TannListener(){

            @Override
            public boolean action(int button, int pointer, float x, float y) {
                Main.getCurrentScreen().pop(sp);
                Sounds.playSound(Sounds.pop);
                return super.action(button, pointer, x, y);
            }
        });
    }

    public static <T> List<T> combineLists(List<T> globals, List<T> globals1) {
        ArrayList<T> ll = new ArrayList<T>();
        ll.addAll(globals);
        ll.addAll(globals1);
        return ll;
    }

    public static Random makeStdRandom() {
        return Tann.makeStdRandom(System.currentTimeMillis() + (long)rng_counter++);
    }

    public static Random makeStdRandom(long seed) {
        return new WhiskerRandom(seed);
    }

    public static List<Character> toCharList(String rep) {
        ArrayList<Character> result = new ArrayList<Character>();
        for (char c : rep.toCharArray()) {
            result.add(Character.valueOf(c));
        }
        return result;
    }

    public static List<Modifier> minList(List<Modifier> result, int sz) {
        if (result.size() <= sz) {
            return result;
        }
        return result.subList(0, sz);
    }

    public static <T> T ith(int i, T ... ts) {
        return ts[i];
    }

    public static String makeEllipses(String name) {
        return Tann.makeEllipses(name, TannFont.guessMaxTextLength(0.2f));
    }

    public static String makeEllipses(String s, int maxLn) {
        if (s.length() <= maxLn) {
            return s;
        }
        if (maxLn < 3) {
            return "??";
        }
        return s.substring(0, maxLn - 3) + "...";
    }

    public static int plusOrMinus() {
        return Tann.half() ? 1 : -1;
    }

    public static float zeroToOne(float chance) {
        return Math.max(0.0f, Math.min(1.0f, chance));
    }

    public static void removeNulls(List result) {
        for (int i = result.size() - 1; i >= 0; --i) {
            if (result.get(i) != null) continue;
            result.remove(i);
        }
    }

    public static boolean further(int test, int than) {
        return than > 0 ? test > than : test < than;
    }

    public static void become(Group g, Actor a) {
        g.clearChildren();
        g.addActor(a);
        g.setSize(a.getWidth(), a.getHeight());
    }

    public static List<String> prefixAll(List<String> src, String prefix) {
        ArrayList<String> result = new ArrayList<String>();
        for (String descriptionsLine : src) {
            result.add(prefix + descriptionsLine);
        }
        return result;
    }

    public static void assertBads(List bads) {
        Tann.assertTrue("should be no bads: " + bads, bads.isEmpty());
    }

    public static Actor layoutMinArea(List<Actor> actors, int gap) {
        return Tann.layoutMinArea(actors, gap, (int)((float)Main.width * 0.9f), (int)((float)Main.height * 0.9f));
    }

    public static Actor makeScrollpaneIfNecessary(Actor a) {
        if (a.getHeight() < (float)Main.height * 0.9f) {
            return a;
        }
        TannStageUtils.ensureSafeForScrollpane(a);
        ScrollPane sp = Tann.makeScrollpane(a);
        sp.setWidth(a.getWidth() + 6.0f);
        return sp;
    }

    public static boolean formsStraight(List<Integer> vals) {
        int oldSize = vals.size();
        Tann.uniquify(vals);
        if (oldSize != vals.size()) {
            return false;
        }
        if (vals.size() <= 1) {
            return true;
        }
        boolean greater = vals.get(1) > vals.get(0);
        int xd = greater ? 1 : -1;
        for (int i = 1; i < vals.size(); ++i) {
            if (Objects.equals(vals.get(i), vals.get(i - 1) + xd)) continue;
            return false;
        }
        return true;
    }

    public static float bound(float min, float f, float max) {
        return Math.max(min, Math.min(max, f));
    }

    public static String arrayToString(String[] groups, String sep) {
        return Tann.commaList(Arrays.asList(groups), sep, sep);
    }

    public static boolean allSame(List l) {
        if (l.isEmpty()) {
            return true;
        }
        for (int i = 1; i < l.size(); ++i) {
            if (l.get(0) == l.get(i)) continue;
            return false;
        }
        return true;
    }

    public static float splang(float a, float l, float u) {
        float dist = (a - l) / (u - l);
        return Math.min(1.0f, Math.max(0.0f, dist));
    }

    public static <T> T fallback(T maybeNull, T missingno) {
        return maybeNull == null ? missingno : maybeNull;
    }

    public static int randomRound(float f) {
        if (f < 0.0f) {
            return -Tann.randomRound(-f);
        }
        return (int)f + (Tann.chance(f % 1.0f) ? 1 : 0);
    }

    public static <T> void addIfNotNull(List<T> list, T item) {
        if (item != null) {
            list.add(item);
        }
    }

    public static int getDigit(int keycode) {
        int digit = keycode - 8;
        if (digit < 0 || digit > 9) {
            digit = keycode - 145;
        }
        if (digit < 0 || digit > 9) {
            return -1;
        }
        return digit;
    }

    public static float softLimit(float value, float softLimit, float hardLimit) {
        if (value <= softLimit) {
            return value;
        }
        float remainder = hardLimit - softLimit;
        float aboveness = (float)Math.log(1.0f + (value - softLimit));
        float remainderFactor = (float)(1.0 - 1.0 / Math.pow(2.0, aboveness));
        return softLimit + remainder * remainderFactor;
    }

    public static Vector2 randomUnitVector() {
        return new Vector2(1.0f, 0.0f).rotateDeg((float)(Math.random() * 999.0));
    }

    public static <T> T middle(List<T> ts) {
        return ts.get((ts.size() - 1) / 2);
    }

    public static String join(String separator, List<String> parts) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < parts.size(); ++i) {
            if (i > 0) {
                sb.append(separator);
            }
            sb.append(parts.get(i));
        }
        return sb.toString();
    }

    public static boolean notNullOrEmpty(List l) {
        return l != null && !l.isEmpty();
    }

    public static void thread(Runnable runnable) {
        new Thread(runnable).start();
    }

    private static Vector2 getPos(Actor a, TannPosition tannPosition, int bonusDistance) {
        switch (tannPosition) {
            case Left: {
                tmp.set(-(a.getWidth() + (float)bonusDistance), a.getY());
                break;
            }
            case Right: {
                tmp.set(Main.width + bonusDistance, a.getY());
                break;
            }
            case Top: {
                tmp.set(a.getX(), Main.height + bonusDistance);
                break;
            }
            case Bot: {
                tmp.set(a.getX(), -(a.getHeight() + (float)bonusDistance));
            }
        }
        return tmp;
    }

    private static Vector2 getPos(Actor a, TannPosition tannPosition) {
        return Tann.getPos(a, tannPosition, 0);
    }

    public static void slideAway(Actor a, TannPosition tannPosition, boolean remove) {
        Tann.slideAway(a, tannPosition, 0, remove);
    }

    public static void slideAway(Actor a, TannPosition tannPosition, int bonusDistance, boolean remove) {
        a.clearActions();
        Vector2 pos = Tann.getPos(a, tannPosition, bonusDistance);
        Action moveTo = PixAction.moveTo((int)pos.x, (int)pos.y, 0.3f, Chrono.i);
        if (remove) {
            a.addAction(Actions.sequence(moveTo, (Action)Actions.removeActor()));
        } else {
            a.addAction(moveTo);
        }
    }

    public static Action slideFromTopToCenter(Actor a) {
        int dist = (int)((float)Main.height - a.getHeight()) / 2;
        return Tann.slideIn(a, TannPosition.Top, dist, 0.4f);
    }

    public static Action slideIn(Actor a, TannPosition tannPosition, int distance) {
        return Tann.slideIn(a, tannPosition, distance, 0.4f);
    }

    public static Action slideIn(Actor a, TannPosition tannPosition, int distance, float duration) {
        a.clearActions();
        Vector2 pos = Tann.getPos(a, tannPosition);
        a.setPosition(pos.x, pos.y);
        switch (tannPosition) {
            case Left: {
                pos.x += (float)distance + a.getWidth();
                break;
            }
            case Right: {
                pos.x -= (float)distance + a.getWidth();
                break;
            }
            case Top: {
                pos.y -= (float)distance + a.getHeight();
                break;
            }
            case Bot: {
                pos.y += (float)distance + a.getHeight();
            }
        }
        Action result = PixAction.moveTo((int)pos.x, (int)pos.y, duration, Chrono.i);
        a.addAction(result);
        return result;
    }

    public static float random() {
        return (float)Math.random();
    }

    public static <T> T random(T[] values, Random r) {
        return values[r.nextInt(values.length)];
    }

    public static <T> T random(List<T> values, Random r) {
        return values.get(r.nextInt(values.size()));
    }

    public static float random(float max) {
        return Tann.random(0.0f, max);
    }

    public static float random(float min, float max) {
        return min + Tann.random() * (max - min);
    }

    public static double random(double min, double max) {
        return min + (double)Tann.random() * (max - min);
    }

    public static <T> T random(T[] array) {
        return array[(int)(Math.random() * (double)array.length)];
    }

    public static <T> T random(List<T> list) {
        return list.get((int)(Math.random() * (double)list.size()));
    }

    public static <T> T random(Map<String, T> map) {
        return map.get(Tann.random(map.keySet()));
    }

    public static <T> T random(Set<T> set) {
        int index = (int)(Tann.random() * (float)set.size());
        Iterator<T> iter = set.iterator();
        for (int i = 0; i < index; ++i) {
            iter.next();
        }
        return iter.next();
    }

    public static <E> List<E> pickNRandomElements(List<E> list, int n) {
        if (n > list.size()) {
            throw new ArrayIndexOutOfBoundsException("Trying to get " + n + " element from a list of size " + list.size());
        }
        ArrayList<E> result = new ArrayList<E>(list);
        Collections.shuffle(result);
        while (result.size() > n) {
            result.remove(0);
        }
        return result;
    }

    public static boolean half() {
        return (double)Tann.random() < 0.5;
    }

    public static boolean third() {
        return Tann.random() < 0.33333334f;
    }

    public static boolean quarter() {
        return (double)Tann.random() < 0.25;
    }

    public static <T> T pick(List<T> choices) {
        return choices.get((int)(Math.random() * (double)choices.size()));
    }

    public static <T> T pick(T ... choices) {
        return Tann.random(choices);
    }

    public static char randomLetter() {
        return (char)(97 + (int)(Math.random() * 26.0));
    }

    public static String randomString(int ln) {
        StringBuilder rs = new StringBuilder();
        for (int i = 0; i < ln; ++i) {
            rs.append(Tann.randomLetter());
        }
        return rs.toString();
    }

    public static <T> T pick(T a, T b) {
        return Math.random() > 0.5 ? a : b;
    }

    public static <T> T pick(T a, T b, T c) {
        return Math.random() > (double)0.6667f ? c : Tann.pick(a, b);
    }

    public static <T> T pick(T a, T b, T c, T d) {
        return Math.random() > 0.75 ? d : Tann.pick(a, b, c);
    }

    public static <T> T pick(T a, T b, T c, T d, T e) {
        return Math.random() > 0.8 ? e : Tann.pick(a, b, c, d);
    }

    public static boolean isPrime(int num) {
        if (num < 2 || num > 99999) {
            return false;
        }
        int max = (int)Math.sqrt(num);
        for (int i = 2; i <= max; ++i) {
            if (num % i != 0) continue;
            return false;
        }
        return true;
    }

    public static void intify(Vector2 vector2) {
        vector2.x = (int)vector2.x;
        vector2.y = (int)vector2.y;
    }

    public static Vector2 randomRadial(float length) {
        return radialTmp.set(0.0f, length).rotate(Tann.random(999.0f));
    }

    public static int countCharsInString(char[] chars, String toCheck) {
        int result = 0;
        for (int i = 0; i < chars.length; ++i) {
            result += Tann.countCharsInString(chars[i], toCheck);
        }
        return result;
    }

    public static int countStringsInString(String target, String toCheck) {
        if (!toCheck.contains(target)) {
            return 0;
        }
        int count = 0;
        for (int i = 0; i < toCheck.length() - target.length() - 1; ++i) {
            if (!toCheck.substring(i, i + target.length()).equalsIgnoreCase(target)) continue;
            ++count;
        }
        return count;
    }

    public static int countCharsInString(char target, String toCheck) {
        int count = 0;
        for (int i = 0; i < toCheck.length(); ++i) {
            if (toCheck.charAt(i) != target) continue;
            ++count;
        }
        return count;
    }

    public static int countCharsEndOfString(char target, String toCheck) {
        int count = 0;
        for (int i = 0; i < toCheck.length() && toCheck.charAt(toCheck.length() - 1 - i) == target; ++i) {
            ++count;
        }
        return count;
    }

    public static <U, T> T getOrDefault(Map<U, T> map, U key, T def) {
        T val = map.get(key);
        if (val != null) {
            return val;
        }
        return def;
    }

    public static void addBlood(Group g, int numBlood, float startX, float randStartX, float startY, float randStartY, float moveX, float randMoveX, float moveY, float randMoveY) {
        for (int i = 0; i < numBlood; ++i) {
            Actor blood = new Actor(){

                @Override
                public void draw(Batch batch, float parentAlpha) {
                    batch.setColor(this.getColor());
                    Draw.fillEllipse(batch, this.getX(), this.getY(), this.getWidth(), this.getHeight());
                    super.draw(batch, parentAlpha);
                }
            };
            blood.setPosition(startX + Tann.random(-randStartX, randStartX), startY + Tann.random(-randStartY, randStartY));
            float size = Tann.random(3.0f, 5.0f);
            blood.setSize(size, size);
            blood.setColor(Colours.red);
            float speed = Tann.random(0.3f, 0.4f);
            blood.addAction(Actions.sequence((Action)Actions.parallel((Action)Actions.moveBy(moveX + Tann.random(-randMoveX, randMoveX), moveY + Tann.random(-randMoveY, randMoveY), speed), (Action)Actions.sizeTo(0.0f, 0.0f, speed)), (Action)Actions.removeActor()));
            g.addActor(blood);
        }
    }

    public static boolean isOver(Actor actor, float x, float y) {
        if (x < -99999.0f || y < -99999.0f) {
            return true;
        }
        Actor hit = actor.hit(x, y, true);
        return hit != null && hit.isDescendantOf(actor);
    }

    public static TannPosition globalOverX(Actor a, float x, float y, float rightThreshold) {
        Vector2 aPos = Tann.getAbsoluteCoordinates(a).cpy();
        if (x > aPos.x + a.getWidth() || y > aPos.y + a.getHeight() || x < aPos.x || y < aPos.y) {
            return null;
        }
        if (x > aPos.x + a.getWidth() * rightThreshold) {
            return TannPosition.Right;
        }
        return TannPosition.Left;
    }

    public static TannPosition globalOver(Actor a, float x, float y, float topThreshold) {
        Vector2 aPos = Tann.getAbsoluteCoordinates(a).cpy();
        if (x > aPos.x + a.getWidth() || y > aPos.y + a.getHeight() || x < aPos.x || y < aPos.y) {
            return null;
        }
        if (y > aPos.y + a.getHeight() * topThreshold) {
            return TannPosition.Top;
        }
        return TannPosition.Bot;
    }

    public static String serialise(List<String> list, String separator) {
        String result = "";
        for (String i : list) {
            if (!result.isEmpty()) {
                result = result + separator;
            }
            result = result + i;
        }
        return result;
    }

    public static List<String> deserialiseStringList(String data, String separator) {
        return new ArrayList<String>(Arrays.asList(data.split(separator)));
    }

    public static <T, U> Map<T, U> makeMap(TP<T, U> ... input) {
        HashMap result = new HashMap();
        for (TP<T, U> t : input) {
            if (result.get(t.a) != null) {
                throw new RuntimeException("bad map item:" + t.a);
            }
            result.put(t.a, t.b);
        }
        return result;
    }

    public static int tettHash(long seed, int bound) {
        seed = (seed ^ (seed << 39 | seed >>> 25) ^ (seed << 14 | seed >>> 50) ^ 0xD1B54A32D192ED03L) * -5840758589994634535L;
        seed = (seed ^ (seed << 40 | seed >>> 24) ^ (seed << 15 | seed >>> 49)) * -2643881736870682267L;
        return (int)((long)bound * ((seed ^ seed >>> 28) & 0xFFFFFFFFL) >> 32);
    }

    public static <T extends Choosable> List<T> getSelectiveRandom(List<T> all, int count, T missingno, List<T> ... excludeLists) {
        List<T> result = new ArrayList<T>();
        for (int iterIndex = 0; iterIndex < excludeLists.length; ++iterIndex) {
            ArrayList<T> currentExclude = new ArrayList<T>();
            for (int i = 0; i < excludeLists.length - iterIndex; ++i) {
                currentExclude.addAll(excludeLists[i]);
            }
            result = Tann.getSelectiveRandomSingleExclude(all, count, currentExclude);
            if (result.size() != count) continue;
            return result;
        }
        if (missingno != null) {
            while (result.size() < count) {
                result.add(missingno);
            }
        }
        return result;
    }

    private static <T extends Choosable> List<T> getSelectiveRandomSingleExclude(List<T> all, int count, List<T> exclude) {
        int RESET_ATTEMPTS = 3;
        int MOD_ADD_ATTEMPTS = count * 30;
        ArrayList<T> copy = new ArrayList<T>(all);
        copy.removeAll(exclude);
        ArrayList<Choosable> result = new ArrayList<Choosable>();
        for (int attemptIndex = 0; attemptIndex < 3; ++attemptIndex) {
            result.clear();
            Collections.shuffle(copy);
            for (int i = 0; i < MOD_ADD_ATTEMPTS && i < copy.size(); ++i) {
                Choosable c = (Choosable)copy.get(i);
                boolean good = true;
                for (int ri = 0; ri < result.size(); ++ri) {
                    if (!ChoosableUtils.collides((Choosable)result.get(ri), c)) continue;
                    good = false;
                    break;
                }
                if (!good) continue;
                result.add(c);
                if (result.size() != count) continue;
                return result;
            }
        }
        return result;
    }

    public static int hash(int val, String leaderboardName) {
        int result = ((val += leaderboardName.length() * 100) + 234) * 23;
        result += result % 349 * 119;
        result += result % 791 * 13;
        result += result % 2131 * 17;
        result += result % 17 * 100000;
        return result += val;
    }

    public static String parseSeconds(long seconds) {
        return Tann.parseSeconds(seconds, true);
    }

    public static String parseSeconds(long seconds, boolean full) {
        if (seconds < 0L) {
            return "?s";
        }
        long hours = seconds / 3600L;
        long minutes = seconds / 60L % 60L;
        long actualSeconds = seconds % 60L;
        if (full) {
            String result = "";
            if (hours > 0L) {
                result = result + hours + "h ";
            }
            return result + minutes + "m " + actualSeconds + "s";
        }
        if (hours > 0L) {
            return hours + "h" + minutes + "m";
        }
        return minutes + "m" + actualSeconds + "s";
    }

    public static <T> String commaList(List<T> list, String bothSeparator) {
        return Tann.commaList(list, bothSeparator, bothSeparator);
    }

    public static <T> String commaList(List<T> list, String midSeparator, String finalSeparator) {
        String result = "";
        for (int i = 0; i < list.size(); ++i) {
            result = result + list.get(i);
            if (i < list.size() - 2) {
                result = result + midSeparator;
                continue;
            }
            if (i >= list.size() - 1) continue;
            result = result + finalSeparator;
        }
        return result;
    }

    public static <T> String commaList(List<T> list) {
        return Tann.commaList(list, ", ", " & ");
    }

    public static String repeat(String s, int amt) {
        return Tann.repeat(s, "", amt);
    }

    public static String repeat(String repeat, String sep, int amt) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < amt; ++i) {
            sb.append(repeat);
            if (i >= amt - 1) continue;
            sb.append(sep);
        }
        return sb.toString();
    }

    public static boolean allBlank(float[] a) {
        for (float f : a) {
            if (f == 0.0f) continue;
            return false;
        }
        return true;
    }

    public static float asymptote(float pips, float maxValue, float valueAtOne, float slopePower) {
        float tq = 1.5707964f;
        return (float)(Math.atan(Math.pow(pips, slopePower) * (double)valueAtOne * (double)tq / (double)maxValue) / (double)tq) * maxValue;
    }

    public static float effectTierOnlySinTote(float pips, float maxPips, float effectTierAtOne, float maxEffectTier, float curvePower) {
        float someRatio = (pips - 1.0f) / ((maxPips = Math.max(1.0f, maxPips)) - 1.0f);
        if (Float.isNaN(someRatio)) {
            someRatio = 1.0f;
        }
        if (pips < 1.0f) {
            return Math.max(0.0f, pips) * effectTierAtOne;
        }
        return (float)(Math.sin(Math.pow(Math.min(someRatio, 1.0f), curvePower) * Math.PI / 2.0) * (double)(maxEffectTier - effectTierAtOne) + (double)effectTierAtOne);
    }

    public static float niceTerp(float currentValue, float maxVal, float maxStr, float curvePower) {
        return Tann.powApply(curvePower, currentValue / maxVal) * maxStr;
    }

    public static float powApply(float power, float a) {
        return (float)Math.pow(a, power);
    }

    public static boolean isInt(String str) {
        try {
            Integer.parseInt(str);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static int compare(boolean x, boolean y) {
        return x == y ? 0 : (x ? 1 : -1);
    }

    public static ScrollPane makeScrollpane(Actor widget) {
        ScrollPane sp = new ScrollPane(widget, Tann.makeScrollpaneStyle());
        sp.setFadeScrollBars(false);
        if (widget == null) {
            return sp;
        }
        sp.setSize(Math.min(widget.getWidth(), (float)(Main.width - 50)), Math.min(widget.getHeight(), (float)(Main.height - 50)));
        sp.layout();
        sp.setOverscroll(false, false);
        if (sp.isScrollX()) {
            sp.setHeight(sp.getHeight() + 6.0f);
        }
        if (sp.isScrollY()) {
            sp.setWidth(sp.getWidth() + 6.0f);
        }
        return sp;
    }

    public static ScrollPane.ScrollPaneStyle makeScrollpaneStyle() {
        return Tann.makeScrollpaneStyle(false);
    }

    public static ScrollPane.ScrollPaneStyle makeScrollpaneStyle(boolean borderless) {
        NinePatchDrawable knob = new NinePatchDrawable(borderless ? Images.scrollpaneKnobBorderless : Images.scrollpaneKnob);
        NinePatchDrawable bar = new NinePatchDrawable(borderless ? Images.scrollpanePatchBorderless : Images.scrollpanePatch);
        knob.setMinSize(6.0f, 6.0f);
        return new ScrollPane.ScrollPaneStyle(null, bar, knob, bar, knob);
    }

    public static Color getHashColour(int hash) {
        Random r = new Random(hash);
        for (int i = 0; i < 5; ++i) {
            r.nextInt();
        }
        return new Color(r.nextFloat(), r.nextFloat(), r.nextFloat(), 1.0f);
    }

    public static Group layoutMinArea(List<Actor> actors, int gap, int maxWidth, int maxHeight) {
        return Tann.layoutMinArea(actors, gap, maxWidth, maxHeight, 1);
    }

    public static Group layoutMinArea(List<Actor> actors, int gap, int maxWidth, int maxHeight, int align) {
        return Tann.layoutMinArea(actors, gap, maxWidth, maxHeight, false, align);
    }

    private static Group layoutMinArea(List<Actor> actors, int gap, int maxWidth, int maxHeight, boolean sort, int align) {
        Group g;
        if (actors.size() == 0) {
            return new TextWriter("borken layout ??");
        }
        if (actors.size() == 1) {
            return Tann.makeGroup(actors.get(0));
        }
        if (sort) {
            Collections.sort(actors, new Comparator<Actor>(){

                @Override
                public int compare(Actor o1, Actor o2) {
                    return (int)Math.signum(o1.getHeight() - o2.getHeight());
                }
            });
        }
        int bestArea = 99999999;
        int bestWidth = maxWidth;
        for (int w = maxWidth; w > 5 && !((g = Tann.layoutGroup(gap, w, actors, align)).getHeight() > (float)maxHeight); w -= 10) {
            int area = Tann.calcArea(g, 1.5f);
            if (!(g.getWidth() > g.getHeight()) || area >= bestArea) continue;
            bestArea = area;
            bestWidth = w;
        }
        return Tann.layoutGroup(gap, bestWidth, actors, align);
    }

    private static Group layoutGroup(int gap, int w, List<Actor> actors, int align) {
        Pixl p = new Pixl();
        for (int i = 0; i < actors.size(); ++i) {
            Actor a = actors.get(i);
            if (p.currentRow.elementList.size() > 0 && p.canHandle(a, w)) {
                p.gap(gap);
            }
            p.actor(a, w, gap);
        }
        return p.pix(align);
    }

    public static int calcArea(Actor a, float factor) {
        return (int)(a.getWidth() * a.getHeight()) + (int)Math.pow(Math.max(a.getWidth(), a.getHeight()), factor);
    }

    public static <T> List<T> asList(T ... elements) {
        return new ArrayList<T>(Arrays.asList(elements));
    }

    public static <T> int getMaxInList(List<T> l) {
        HashMap<T, Integer> map = new HashMap<T, Integer>();
        for (T o : l) {
            if (map.get(o) == null) {
                map.put(o, 1);
                continue;
            }
            map.put(o, (Integer)map.get(o) + 1);
        }
        int max = 0;
        for (Map.Entry i : map.entrySet()) {
            max = Math.max(max, (Integer)i.getValue());
        }
        return max;
    }

    public static <T> T[] pack(T ... ts) {
        return ts;
    }

    public static <T> List<T> packList(T ... ts) {
        return Arrays.asList(ts);
    }

    public static <T extends ChanceHaver> T randomChanced(T[] options) {
        return (T)((ChanceHaver)Tann.randomChanced(options, (int)1).get(0));
    }

    public static <T extends ChanceHaver> List<T> randomChanced(T[] options, int amt) {
        return Tann.randomChanced(options, (int)amt, (Random)new Random());
    }

    public static <T extends ChanceHaver> List<T> randomChanced(T[] options, int amt, Random random) {
        if (options.length < amt) {
            throw new RuntimeException("not enough to find");
        }
        float totalChance = 0.0f;
        for (int i = 0; i < options.length; ++i) {
            totalChance += options[i].getChance();
        }
        if (totalChance < 0.0f) {
            TannLog.error("negative chance: " + options[0]);
            return Arrays.asList(options[0], options[1]);
        }
        ArrayList<T> result = new ArrayList<T>();
        int attempts = 1000;
        block1: for (int att = 0; att < 1000 && result.size() < amt; ++att) {
            float r = random.nextFloat() * totalChance;
            for (int i = 0; i < options.length; ++i) {
                T pot = options[i];
                if (!((r -= pot.getChance()) <= 0.0f)) continue;
                if (result.contains(pot)) continue block1;
                result.add(pot);
                continue block1;
            }
        }
        if (result.size() != amt) {
            TannLog.error("randomChanced error: " + options[0]);
        }
        return result;
    }

    public static <T> T caseInsensitiveValueOf(String name, T[] enumVal) {
        for (int i = 0; i < enumVal.length; ++i) {
            T t = enumVal[i];
            if (!(t + "").toLowerCase().equalsIgnoreCase(name)) continue;
            return t;
        }
        return null;
    }

    public static int gcd(int p, int q) {
        if (q == 0) {
            return p;
        }
        return Tann.gcd(q, p % q);
    }

    public static enum TannPosition {
        Left,
        Right,
        Top,
        Bot,
        Center;

    }
}

