/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.util;

import com.badlogic.gdx.Gdx;
import java.util.ArrayList;
import java.util.List;

public class TannLog {
    public static final List<String> logs = new ArrayList<String>();

    public static void error(String log) {
        TannLog.log(log, Severity.error);
    }

    public static void log(String log) {
        TannLog.log(log, Severity.info);
    }

    public static void log(String log, Severity severity) {
        if (logs.contains(log)) {
            return;
        }
        switch (severity) {
            case info: {
                Gdx.app.log("SliceDice", log);
                break;
            }
            case error: {
                Gdx.app.error("SliceDice", log);
            }
        }
        if (logs.size() > 9) {
            logs.remove(logs.size() - 1);
        }
        logs.add(log);
    }

    public static String newlinedLogs() {
        String result = "";
        for (String s : logs) {
            result = result + s + "\n";
        }
        return result;
    }

    public static void error(Exception e) {
        TannLog.error(e, "");
    }

    public static void error(Exception e, String ctx) {
        if (e == null) {
            return;
        }
        TannLog.error(e.getClass().getSimpleName() + ":" + e.getMessage() + " " + ctx);
    }

    public static enum Severity {
        info,
        error;

    }
}

