/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.util;

import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.utils.viewport.Viewport;
import com.tann.dice.Main;
import com.tann.dice.util.Tann;
import java.util.List;

public class TannStage
extends Stage {
    public TannStage(Viewport viewport) {
        super(viewport);
    }

    public static int maxActorWidth(List<Actor> actors) {
        int max = 0;
        for (Actor actor : actors) {
            max = (int)Math.max((float)max, actor.getWidth());
        }
        return max;
    }

    public static void alphaSetRecursive(Group g, float alpha) {
        Tann.setAlpha(g, alpha);
        for (Actor a : g.getChildren()) {
            if (a instanceof Group) {
                TannStage.alphaSetRecursive((Group)a, alpha);
                continue;
            }
            Tann.setAlpha(a, alpha);
        }
    }

    @Override
    public boolean touchDown(int screenX, int screenY, int pointer, int button) {
        return super.touchDown(screenX, screenY, pointer, button);
    }

    @Override
    public boolean touchUp(int screenX, int screenY, int pointer, int button) {
        return super.touchUp(screenX, screenY, pointer, button);
    }

    @Override
    public void calculateScissors(Rectangle localRect, Rectangle scissorRect) {
        super.calculateScissors(localRect, scissorRect);
        int scaleFactor = Main.scale;
        scissorRect.set(scissorRect.x / (float)scaleFactor, scissorRect.y / (float)scaleFactor, scissorRect.width / (float)scaleFactor, scissorRect.height / (float)scaleFactor);
    }
}

