/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.util.ui.resolver;

import com.badlogic.gdx.graphics.Color;
import com.tann.dice.gameplay.content.ent.type.HeroType;
import com.tann.dice.gameplay.content.ent.type.MonsterType;
import com.tann.dice.gameplay.content.item.Item;
import com.tann.dice.gameplay.effect.eff.keyword.Keyword;
import com.tann.dice.gameplay.modifier.Modifier;
import com.tann.dice.util.Colours;
import com.tann.dice.util.Tann;
import com.tann.dice.util.ui.resolver.HeroTypeResolver;
import com.tann.dice.util.ui.resolver.ItemResolver;
import com.tann.dice.util.ui.resolver.KeywordResolver;
import com.tann.dice.util.ui.resolver.ModifierResolver;
import com.tann.dice.util.ui.resolver.MonsterTypeResolver;
import com.tann.dice.util.ui.resolver.Resolver;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public abstract class MetaResolver
extends Resolver<Object> {
    final Resolver[] resolvers;

    public MetaResolver(Resolver ... resolvers) {
        super(new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                if (o1.getClass() != o2.getClass()) {
                    return o1.getClass().getSimpleName().compareTo(o2.getClass().getSimpleName());
                }
                return o1.toString().compareTo(o2.toString());
            }
        });
        this.resolvers = resolvers;
    }

    public MetaResolver() {
        this(new ModifierResolver(){

            @Override
            public void resolve(Modifier modifier) {
            }
        }, new KeywordResolver(){

            @Override
            public void resolve(Keyword keyword) {
            }
        }, new ItemResolver(){

            @Override
            public void resolve(Item item) {
            }
        }, new MonsterTypeResolver(){

            @Override
            public void resolve(MonsterType type) {
            }
        }, new HeroTypeResolver(){

            @Override
            public void resolve(HeroType heroType) {
            }
        });
    }

    @Override
    protected Color getCol() {
        return Colours.grey;
    }

    @Override
    protected String getTypeName() {
        return "any";
    }

    @Override
    protected Object byName(String text) {
        for (Resolver resolver : this.resolvers) {
            Object o = resolver.byName(text);
            if (Tann.isMissingnoObject(o)) continue;
            return o;
        }
        return null;
    }

    @Override
    protected List<Object> search(String text) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (Resolver resolver : this.resolvers) {
            result.addAll(resolver.search(text));
        }
        return result;
    }
}

