/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.image.j9;

import com.ibm.dtfj.corereaders.ResourceReleaser;
import com.ibm.dtfj.image.j9.IFileLocationResolver;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ZipExtractionResolver
implements IFileLocationResolver,
ResourceReleaser {
    private ZipFile _container;
    private Map _openFilesByName = new HashMap();
    private List _deletables = new Vector();

    public ZipExtractionResolver(ZipFile zipFile) {
        this._container = zipFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File findFileWithFullPath(String string) throws FileNotFoundException {
        String string2 = "";
        String string3 = new File(string).getName();
        File file = (File)this._openFilesByName.get(string);
        if (null == file) {
            ZipEntry zipEntry = this._container.getEntry(string);
            if (null == zipEntry) {
                zipEntry = this._container.getEntry(string3);
            }
            if (null == zipEntry) {
                throw new FileNotFoundException("No ZIP entry with name: \"" + string + "\"");
            }
            File file2 = null;
            InputStream inputStream = null;
            FileOutputStream fileOutputStream = null;
            int n = 0;
            byte[] byArray = new byte[4096];
            try {
                file2 = File.createTempFile(string3, ".dtfj");
                string2 = file2.getAbsolutePath();
                file2.deleteOnExit();
                this._deletables.add(file2);
            }
            catch (IOException iOException) {
                FileNotFoundException fileNotFoundException = new FileNotFoundException("Unable to open temporary file: " + iOException.getMessage());
                fileNotFoundException.setStackTrace(iOException.getStackTrace());
                throw fileNotFoundException;
            }
            try {
                inputStream = this._container.getInputStream(zipEntry);
                fileOutputStream = new FileOutputStream(file2);
            }
            catch (IOException iOException) {
                FileNotFoundException fileNotFoundException = new FileNotFoundException("Unable to locate ZIP entry: " + zipEntry.getName() + " : " + iOException.getMessage());
                fileNotFoundException.setStackTrace(iOException.getStackTrace());
                throw fileNotFoundException;
            }
            try {
                n = inputStream.read(byArray);
            }
            catch (IOException iOException) {
                FileNotFoundException fileNotFoundException = new FileNotFoundException("Unable to read ZIP entry: " + zipEntry.getName() + " : " + iOException.getMessage());
                fileNotFoundException.setStackTrace(iOException.getStackTrace());
                throw fileNotFoundException;
            }
            boolean bl = false;
            try {
                do {
                    try {
                        fileOutputStream.write(byArray, 0, n);
                    }
                    catch (IOException iOException) {
                        bl = true;
                        FileNotFoundException fileNotFoundException = new FileNotFoundException("Unable to write: " + zipEntry.getName() + " to " + string2 + " : " + iOException.getMessage());
                        fileNotFoundException.setStackTrace(iOException.getStackTrace());
                        throw fileNotFoundException;
                    }
                    try {
                        n = inputStream.read(byArray);
                    }
                    catch (IOException iOException) {
                        bl = true;
                        FileNotFoundException fileNotFoundException = new FileNotFoundException("Unable to read ZIP entry: " + zipEntry.getName() + " : " + iOException.getMessage());
                        fileNotFoundException.setStackTrace(iOException.getStackTrace());
                        throw fileNotFoundException;
                    }
                } while (n > 0);
            }
            finally {
                try {
                    fileOutputStream.close();
                    if (bl) {
                        file2.deleteOnExit();
                        file2.delete();
                    }
                }
                catch (IOException iOException) {
                    FileNotFoundException fileNotFoundException = new FileNotFoundException("Unable to close file: " + iOException.getMessage());
                    fileNotFoundException.setStackTrace(iOException.getStackTrace());
                    throw fileNotFoundException;
                }
            }
            this._openFilesByName.put(string, file2);
            file = file2;
            Logger.getLogger("com.ibm.dtfj.log").fine("Extracted " + string + " to " + file2.getAbsolutePath());
        }
        return file;
    }

    public File decompressCoreFile() throws FileNotFoundException {
        String string = this._baseCoreName();
        if (null != string) {
            return this.findFileWithFullPath(string);
        }
        throw new FileNotFoundException("Couldn't find a file resembling a core file inside the zip");
    }

    private String _baseCoreName() {
        String string = null;
        Enumeration<? extends ZipEntry> enumeration = this._container.entries();
        String string2 = this._container.getName();
        while (null == string && enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            String string3 = zipEntry.getName();
            if (string2.equals(string3 + ".zip")) {
                string = string3;
                continue;
            }
            ZipEntry zipEntry2 = this._container.getEntry(string3 + ".xml");
            if (null == zipEntry2) continue;
            string = string3;
        }
        return string;
    }

    public InputStream decompressMetaDataStream() throws IOException, FileNotFoundException {
        InputStream inputStream = null;
        String string = this._baseCoreName();
        if (null == string) {
            throw new FileNotFoundException("Couldn't find a file resembling a JExtract XML index file inside the zip");
        }
        inputStream = this._container.getInputStream(this._container.getEntry(string + ".xml"));
        return inputStream;
    }

    public void closeOpenFiles() throws IOException {
        if (this._container != null) {
            this._container.close();
        }
    }

    public Iterator getCreatedFiles() {
        return this._deletables.iterator();
    }

    @Override
    public void releaseResources() throws IOException {
        this.closeOpenFiles();
        Iterator iterator = this.getCreatedFiles();
        File file = null;
        while (iterator.hasNext() && (file = (File)iterator.next()) != null) {
            String string = "ZIP resource " + file.getAbsolutePath() + " ";
            if (file.delete()) {
                string = string + "deleted successfully.";
            } else {
                string = string + "could not be deleted. Marking for deletion at shutdown.";
                file.deleteOnExit();
            }
            Logger.getLogger("com.ibm.dtfj.log").fine(string);
        }
    }
}

