/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.phd;

import com.ibm.dtfj.image.CorruptData;
import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.ImageAddressSpace;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.image.ImageProcess;
import com.ibm.dtfj.image.ImageSection;
import com.ibm.dtfj.java.JavaHeap;
import com.ibm.dtfj.java.JavaRuntime;
import com.ibm.dtfj.phd.PHDImage;
import com.ibm.dtfj.phd.PHDImagePointer;
import com.ibm.dtfj.phd.PHDImageProcess;
import com.ibm.dtfj.phd.PHDImageSection;
import com.ibm.dtfj.runtime.ManagedRuntime;
import java.io.File;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.imageio.stream.ImageInputStream;

class PHDImageAddressSpace
implements ImageAddressSpace {
    private final List<ImageProcess> processList;
    private final ImageAddressSpace metaImageAddressSpace;

    PHDImageAddressSpace(File file, PHDImage pHDImage, ImageAddressSpace imageAddressSpace) throws IOException {
        this.metaImageAddressSpace = imageAddressSpace;
        this.processList = new ArrayList<ImageProcess>();
        ImageProcess imageProcess = imageAddressSpace != null ? imageAddressSpace.getCurrentProcess() : null;
        this.processList.add(new PHDImageProcess(file, pHDImage, (ImageAddressSpace)this, imageProcess));
    }

    PHDImageAddressSpace(ImageInputStream imageInputStream, PHDImage pHDImage, ImageAddressSpace imageAddressSpace) throws IOException {
        this.metaImageAddressSpace = imageAddressSpace;
        this.processList = new ArrayList<ImageProcess>();
        ImageProcess imageProcess = imageAddressSpace != null ? imageAddressSpace.getCurrentProcess() : null;
        this.processList.add(new PHDImageProcess(imageInputStream, pHDImage, (ImageAddressSpace)this, imageProcess));
    }

    @Override
    public ImageProcess getCurrentProcess() {
        return this.processList.get(0);
    }

    @Override
    public ByteOrder getByteOrder() {
        return ByteOrder.BIG_ENDIAN;
    }

    @Override
    public Iterator<ImageSection> getImageSections() {
        Object object;
        Object object2;
        ImageProcess imageProcess;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Iterator iterator = this.getProcesses();
        while (iterator.hasNext()) {
            imageProcess = iterator.next();
            if (imageProcess instanceof CorruptData) continue;
            object2 = imageProcess.getRuntimes();
            while (object2.hasNext()) {
                object = (ManagedRuntime)object2.next();
                if (object instanceof CorruptData || !(object instanceof JavaRuntime)) continue;
                Iterator iterator2 = ((JavaRuntime)object).getHeaps();
                while (iterator2.hasNext()) {
                    JavaHeap javaHeap = (JavaHeap)iterator2.next();
                    if (javaHeap instanceof CorruptData) continue;
                    Iterator iterator3 = javaHeap.getSections();
                    while (iterator3.hasNext()) {
                        arrayList.add(iterator3.next());
                    }
                }
            }
        }
        if (this.metaImageAddressSpace != null) {
            iterator = this.metaImageAddressSpace.getImageSections();
            while (iterator.hasNext()) {
                imageProcess = iterator.next();
                if (!(imageProcess instanceof ImageSection)) continue;
                object2 = (ImageSection)((Object)imageProcess);
                object = new PHDImageSection(object2.getName(), this.getPointer(object2.getBaseAddress().getAddress()), object2.getSize());
                arrayList.add(object);
            }
        }
        return arrayList.iterator();
    }

    @Override
    public ImagePointer getPointer(long l) {
        return new PHDImagePointer(this, l);
    }

    @Override
    public Iterator<ImageProcess> getProcesses() {
        return this.processList.iterator();
    }

    @Override
    public String getID() throws DataUnavailable, CorruptDataException {
        return "0";
    }

    @Override
    public Properties getProperties() {
        return new Properties();
    }
}

