/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.phd;

import com.ibm.dtfj.image.CorruptData;
import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.ImageAddressSpace;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.java.JavaLocation;
import com.ibm.dtfj.java.JavaMethod;
import com.ibm.dtfj.phd.PHDCorruptData;
import com.ibm.dtfj.phd.PHDJavaMethod;
import com.ibm.dtfj.phd.PHDJavaRuntime;

public class PHDJavaLocation
implements JavaLocation {
    private ImagePointer address;
    private CorruptData address_cd;
    private int compilationLevel;
    private CorruptData compilationLevel_cd;
    private String filename;
    private CorruptData filename_cd;
    private int lineNumber;
    private CorruptData lineNumber_cd;
    private JavaMethod method;
    private CorruptData method_cd;

    PHDJavaLocation(ImageAddressSpace imageAddressSpace, PHDJavaRuntime pHDJavaRuntime, JavaLocation javaLocation) {
        try {
            this.address = imageAddressSpace.getPointer(javaLocation.getAddress().getAddress());
        }
        catch (CorruptDataException corruptDataException) {
            this.address_cd = new PHDCorruptData(imageAddressSpace, corruptDataException);
        }
        try {
            this.compilationLevel = javaLocation.getCompilationLevel();
        }
        catch (CorruptDataException corruptDataException) {
            this.compilationLevel_cd = new PHDCorruptData(imageAddressSpace, corruptDataException);
        }
        try {
            this.filename = javaLocation.getFilename();
        }
        catch (CorruptDataException corruptDataException) {
            this.filename_cd = new PHDCorruptData(imageAddressSpace, corruptDataException);
        }
        catch (DataUnavailable dataUnavailable) {
            // empty catch block
        }
        try {
            this.lineNumber = javaLocation.getLineNumber();
        }
        catch (CorruptDataException corruptDataException) {
            this.lineNumber_cd = new PHDCorruptData(imageAddressSpace, corruptDataException);
        }
        catch (DataUnavailable dataUnavailable) {
            this.lineNumber = -1;
        }
        try {
            this.method = new PHDJavaMethod(imageAddressSpace, pHDJavaRuntime, javaLocation.getMethod());
        }
        catch (CorruptDataException corruptDataException) {
            this.method_cd = new PHDCorruptData(imageAddressSpace, corruptDataException);
        }
    }

    @Override
    public ImagePointer getAddress() throws CorruptDataException {
        this.checkCD(this.address_cd);
        return this.address;
    }

    @Override
    public int getCompilationLevel() throws CorruptDataException {
        this.checkCD(this.compilationLevel_cd);
        return this.compilationLevel;
    }

    @Override
    public String getFilename() throws DataUnavailable, CorruptDataException {
        this.checkCD(this.filename_cd);
        if (this.filename == null) {
            throw new DataUnavailable();
        }
        return this.filename;
    }

    @Override
    public int getLineNumber() throws DataUnavailable, CorruptDataException {
        this.checkCD(this.lineNumber_cd);
        if (this.lineNumber == -1) {
            throw new DataUnavailable();
        }
        return this.lineNumber;
    }

    @Override
    public JavaMethod getMethod() throws CorruptDataException {
        this.checkCD(this.method_cd);
        return this.method;
    }

    private void checkCD(CorruptData corruptData) throws CorruptDataException {
        if (corruptData != null) {
            throw new CorruptDataException(corruptData);
        }
    }

    @Override
    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        PHDJavaLocation pHDJavaLocation = (PHDJavaLocation)object;
        return this.equals(this.method, pHDJavaLocation.method) && this.equals(this.lineNumber, pHDJavaLocation.lineNumber);
    }

    @Override
    public int hashCode() {
        return this.hashCode(this.method) ^ this.hashCode(this.lineNumber);
    }

    private boolean equals(Object object, Object object2) {
        return object == null ? object2 == null : object.equals(object2);
    }

    private int hashCode(Object object) {
        return object == null ? 0 : object.hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            JavaMethod javaMethod = this.getMethod();
            stringBuilder.append(javaMethod.getDeclaringClass().getName().replace('/', '.'));
            stringBuilder.append('.');
            stringBuilder.append(javaMethod.getName());
        }
        catch (CorruptDataException corruptDataException) {
            stringBuilder.append("corrupt");
        }
        catch (DataUnavailable dataUnavailable) {
            stringBuilder.append("data unavailable");
        }
        stringBuilder.append('(');
        boolean bl = false;
        try {
            stringBuilder.append(this.getFilename());
            bl = true;
            int n = this.getLineNumber();
            stringBuilder.append(':');
            stringBuilder.append(n);
        }
        catch (CorruptDataException corruptDataException) {
            try {
                if (this.getCompilationLevel() > 0) {
                    if (bl) {
                        stringBuilder.append('(');
                    }
                    stringBuilder.append("Compiled Code");
                    if (bl) {
                        stringBuilder.append(')');
                    }
                }
            }
            catch (CorruptDataException corruptDataException2) {
                // empty catch block
            }
        }
        catch (DataUnavailable dataUnavailable) {
            try {
                if (this.getCompilationLevel() > 0) {
                    if (bl) {
                        stringBuilder.append('(');
                    }
                    stringBuilder.append("Compiled Code");
                    if (bl) {
                        stringBuilder.append(')');
                    }
                }
            }
            catch (CorruptDataException corruptDataException) {
                // empty catch block
            }
        }
        finally {
            stringBuilder.append(')');
        }
        return stringBuilder.toString();
    }
}

