/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.trace.format.api;

import com.ibm.jvm.trace.format.api.DataHeader;
import com.ibm.jvm.trace.format.api.TraceContext;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.Vector;

public class StartupSection {
    TraceContext context;
    String textSummary = null;
    private Vector options = new Vector();

    public StartupSection(TraceContext traceContext, ByteBuffer byteBuffer) throws IllegalArgumentException {
        this.context = traceContext;
        DataHeader dataHeader = new DataHeader(traceContext, byteBuffer, "UTSO");
        byte[] byArray = new byte[dataHeader.length - 16];
        byteBuffer.get(byArray);
        this.splitOptions(byArray);
        if (traceContext.debugStream != null) {
            traceContext.debug(this, 1, this.summary());
        }
    }

    private void splitOptions(byte[] byArray) {
        int n = 0;
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] != 0) continue;
            if (i != n) {
                String string;
                try {
                    string = new String(byArray, n, i - n, "UTF-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    string = new String(byArray, n, i - n);
                }
                this.options.add(string);
            }
            n = i + 1;
        }
    }

    public String toString() {
        return "JVM startup options";
    }

    public String summary() {
        if (this.textSummary == null) {
            StringBuilder stringBuilder = new StringBuilder(this.toString() + ":" + System.getProperty("line.separator"));
            for (int i = 0; i < this.options.size(); ++i) {
                stringBuilder.append(this.options.get(i));
                stringBuilder.append(System.getProperty("line.separator"));
            }
            this.textSummary = stringBuilder.toString();
        }
        return this.textSummary;
    }
}

