/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.Comparator;
import java.lang.invoke.ILGenMacros;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.lang.invoke.PassThroughHandle;
import java.lang.invoke.ThunkKey;
import java.lang.invoke.ThunkKeyWithInt;
import java.lang.invoke.ThunkTable;
import java.lang.invoke.ThunkTuple;

final class CatchHandle
extends PassThroughHandle {
    private final MethodHandle tryTarget;
    private final Class<? extends Throwable> exceptionClass;
    private final MethodHandle catchTarget;
    private static final ThunkTable _thunkTable = new ThunkTable();

    protected CatchHandle(MethodHandle methodHandle, Class<? extends Throwable> clazz, MethodHandle methodHandle2, MethodHandle methodHandle3) {
        super(methodHandle3, CatchHandle.infoAffectingThunks(methodHandle2.type().parameterCount()));
        this.tryTarget = methodHandle;
        this.exceptionClass = clazz;
        this.catchTarget = methodHandle2;
    }

    CatchHandle(CatchHandle catchHandle, MethodType methodType) {
        super(catchHandle, methodType);
        this.tryTarget = catchHandle.tryTarget;
        this.exceptionClass = catchHandle.exceptionClass;
        this.catchTarget = catchHandle.catchTarget;
    }

    @Override
    MethodHandle cloneWithNewType(MethodType methodType) {
        return new CatchHandle(this, methodType);
    }

    public static CatchHandle get(MethodHandle methodHandle, Class<? extends Throwable> clazz, MethodHandle methodHandle2, MethodHandle methodHandle3) {
        return new CatchHandle(methodHandle, clazz, methodHandle2, methodHandle3);
    }

    @Override
    protected final ThunkTable thunkTable() {
        return _thunkTable;
    }

    private static native int numCatchTargetArgsToPassThrough();

    private static Object infoAffectingThunks(int n) {
        return n;
    }

    @Override
    protected final ThunkTuple computeThunks(Object object) {
        int n = (Integer)object;
        return this.thunkTable().get(new ThunkKeyWithInt(ThunkKey.computeThunkableType(this.type()), n));
    }

    @MethodHandle.FrameIteratorSkip
    private final int invokeExact_thunkArchetype_X(int n) {
        if (ILGenMacros.isShareableThunk()) {
            this.undoCustomizationLogic(this.tryTarget, this.catchTarget);
        }
        if (!ILGenMacros.isCustomThunk()) {
            this.doCustomizationLogic();
        }
        try {
            return ILGenMacros.invokeExact_X(this.tryTarget, n);
        }
        catch (Throwable throwable) {
            if (this.exceptionClass.isInstance(throwable)) {
                return ILGenMacros.invokeExact_X(this.catchTarget, ILGenMacros.placeholder(throwable, ILGenMacros.firstN(CatchHandle.numCatchTargetArgsToPassThrough(), n)));
            }
            throw throwable;
        }
    }

    @Override
    final void compareWith(MethodHandle methodHandle, Comparator comparator) {
        if (methodHandle instanceof CatchHandle) {
            ((CatchHandle)methodHandle).compareWithCatch(this, comparator);
        } else {
            comparator.fail();
        }
    }

    final void compareWithCatch(CatchHandle catchHandle, Comparator comparator) {
        comparator.compareStructuralParameter(catchHandle.exceptionClass, this.exceptionClass);
        comparator.compareChildHandle(catchHandle.tryTarget, this.tryTarget);
        comparator.compareChildHandle(catchHandle.catchTarget, this.catchTarget);
    }
}

