/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.elf;

import com.ibm.j9ddr.corereaders.elf.ELFFileReader;
import com.ibm.j9ddr.corereaders.memory.Addresses;
import com.ibm.j9ddr.corereaders.memory.IDetailedMemoryRange;
import com.ibm.j9ddr.corereaders.memory.IMemorySource;
import com.ibm.j9ddr.corereaders.memory.MemoryFault;
import com.ibm.j9ddr.corereaders.memory.ProtectedMemoryRange;
import java.io.IOException;
import java.util.Properties;

public class ELFMemorySource
extends ProtectedMemoryRange
implements IMemorySource,
IDetailedMemoryRange {
    private final long fileOffset;
    private final ELFFileReader reader;
    private final String name;
    private Properties props;

    ELFMemorySource(long l, long l2, long l3, ELFFileReader eLFFileReader, String string, boolean bl) {
        super(l, l2);
        this.fileOffset = l3;
        this.reader = eLFFileReader;
        this.name = string;
        this.executable = bl;
    }

    ELFMemorySource(long l, long l2, long l3, ELFFileReader eLFFileReader, String string) {
        this(l, l2, l3, eLFFileReader, string, true);
    }

    ELFMemorySource(long l, long l2, long l3, ELFFileReader eLFFileReader) {
        this(l, l2, l3, eLFFileReader, "");
    }

    @Override
    public int getAddressSpaceId() {
        return 0;
    }

    @Override
    public int getBytes(long l, byte[] byArray, int n, int n2) throws MemoryFault {
        if (Addresses.greaterThan(l + (long)n2 - 1L, this.getTopAddress())) {
            throw new MemoryFault(l + (long)n2, "Address out of range of memory range (overflow): " + this.toString());
        }
        if (Addresses.lessThan(l, this.baseAddress)) {
            throw new MemoryFault(l, "Address out of range of memory range (underflow): " + this.toString());
        }
        long l2 = l - this.baseAddress;
        long l3 = this.fileOffset + l2;
        try {
            this.reader.seek(l3);
            this.reader.readFully(byArray, n, n2);
        }
        catch (IOException iOException) {
            throw new MemoryFault(l, "IOException accessing ELF storage in " + this.reader, iOException);
        }
        return n2;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Properties getProperties() {
        if (this.props == null) {
            this.props = new Properties();
        }
        return this.props;
    }

    @Override
    public boolean isExecutable() {
        if (this.props == null) {
            return false;
        }
        return Boolean.TRUE.toString().equals(this.props.get("executable"));
    }

    @Override
    public boolean isReadOnly() {
        if (this.props == null) {
            return false;
        }
        return Boolean.TRUE.toString().equals(this.props.get("readable")) && !Boolean.TRUE.toString().equals(this.props.get("writable"));
    }
}

