/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.tdump.zebedee.le;

import com.ibm.j9ddr.corereaders.tdump.zebedee.dumpreader.AddressSpace;
import com.ibm.j9ddr.corereaders.tdump.zebedee.dumpreader.AddressSpaceImageInputStream;
import com.ibm.j9ddr.corereaders.tdump.zebedee.le.Ceexdlcb32Template;
import com.ibm.j9ddr.corereaders.tdump.zebedee.le.Ceexdlcb64Template;
import com.ibm.j9ddr.corereaders.tdump.zebedee.le.CeexdlcbTemplate;
import com.ibm.j9ddr.corereaders.tdump.zebedee.le.Ciet2ExpFuncEntryTemplate;
import com.ibm.j9ddr.corereaders.tdump.zebedee.le.Ciet2ExpVarEntryTemplate;
import com.ibm.j9ddr.corereaders.tdump.zebedee.le.Ciet2Template;
import com.ibm.j9ddr.corereaders.tdump.zebedee.le.CietExpEntryTemplate;
import com.ibm.j9ddr.corereaders.tdump.zebedee.le.CietTemplate;
import com.ibm.j9ddr.corereaders.tdump.zebedee.le.DllFunction;
import com.ibm.j9ddr.corereaders.tdump.zebedee.le.DllVariable;
import com.ibm.j9ddr.corereaders.tdump.zebedee.le.DllcsectTemplate;
import com.ibm.j9ddr.corereaders.tdump.zebedee.le.DllexpfuncsTemplate;
import com.ibm.j9ddr.corereaders.tdump.zebedee.le.DllexpvarsTemplate;
import com.ibm.j9ddr.corereaders.tdump.zebedee.le.Edb;
import java.io.IOException;
import java.util.logging.Logger;

public class Dll {
    private long address;
    private AddressSpace space;
    private AddressSpaceImageInputStream inputStream;
    private String name;
    private long wsa;
    private Dll next;
    private DllVariable[] variables;
    private DllFunction[] functions;
    CeexdlcbTemplate ceexdlcbTemplate;
    private static Logger log = Logger.getLogger("j9ddr.core_readers");

    public Dll(long l, AddressSpace addressSpace) {
        this.address = l;
        this.space = addressSpace;
        this.inputStream = addressSpace.getImageInputStream();
        this.createTemplates(addressSpace);
    }

    public AddressSpace getSpace() {
        return this.space;
    }

    void createTemplates(AddressSpace addressSpace) {
        if (this.ceexdlcbTemplate == null) {
            this.ceexdlcbTemplate = addressSpace.is64bit() ? new Ceexdlcb64Template() : new Ceexdlcb32Template();
        }
    }

    public String getName() throws IOException {
        if (this.name == null) {
            try {
                long l = this.ceexdlcbTemplate.getDlcbnamelen(this.inputStream, this.address);
                long l2 = this.ceexdlcbTemplate.getDlcbnameptr(this.inputStream, this.address);
                this.name = this.space.readEbcdicString(l2, (int)l);
            }
            catch (IOException iOException) {
                log.fine("error reading name: " + iOException);
                this.name = "error reading name: " + iOException;
            }
        }
        return this.name;
    }

    public long getLoadAddress() {
        throw new Error("tbc");
    }

    public long getWsa() throws IOException {
        if (this.wsa == 0L) {
            this.wsa = this.ceexdlcbTemplate.getDlcbwsaptr(this.inputStream, this.address);
        }
        return this.wsa;
    }

    public Dll getNext() throws IOException {
        if (this.next == null) {
            try {
                long l = this.ceexdlcbTemplate.getDlcbnextptr(this.inputStream, this.address);
                if (l != 0L) {
                    this.next = new Dll(l, this.space);
                }
            }
            catch (IOException iOException) {
                log.fine("error reading next pointer: " + iOException);
            }
        }
        return this.next;
    }

    public DllVariable getVariable(String string) throws IOException {
        try {
            if (this.getVariables() == null) {
                return null;
            }
        }
        catch (IOException iOException) {
            log.fine("problem getting variables for dll " + this.getName() + ": " + iOException);
            return null;
        }
        for (int i = 0; i < this.variables.length; ++i) {
            if (!this.variables[i].getName().equals(string)) continue;
            return this.variables[i];
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DllVariable[] getVariables() throws IOException {
        int n;
        if (this.variables != null) {
            return this.variables;
        }
        long l = this.ceexdlcbTemplate.getDlcbiewbcie(this.inputStream, this.address);
        try {
            n = this.space.readInt(l);
        }
        catch (IOException iOException) {
            return new DllVariable[0];
        }
        if (n == -909777214) {
            long l2 = Ciet2Template.getCiet2_version(this.inputStream, l);
            if (l2 == 2L) {
                long l3 = Ciet2Template.getCiet2_var_count(this.inputStream, l);
                assert (l3 >= 0L && l3 < 1000000L) : l3;
                long l4 = Ciet2Template.getCiet2_var_addr(this.inputStream, l);
                this.variables = new DllVariable[(int)l3];
                int n2 = 0;
                while ((long)n2 < l3) {
                    try {
                        long l5 = l4 + (long)(n2 * Ciet2ExpVarEntryTemplate.length());
                        long l6 = Ciet2ExpVarEntryTemplate.getCiet2_exp_var_is_addr(this.inputStream, l5);
                        long l7 = Ciet2ExpVarEntryTemplate.getCiet2_exp_var_offset(this.inputStream, l5);
                        long l8 = Ciet2ExpVarEntryTemplate.getCiet2_exp_var_name_addr(this.inputStream, l5);
                        String string = this.space.readEbcdicString(l8);
                        long l9 = l6 == 0L ? l7 + this.getWsa() : l7;
                        this.variables[n2] = new DllVariable(string, l9);
                    }
                    catch (IOException iOException) {
                        this.variables[n2] = new DllVariable(iOException.toString(), 0L);
                    }
                    ++n2;
                }
                return this.variables;
            }
            if (l2 != 1L) throw new Error("expected ciet2_version 1 or 2 but instead found " + l2);
            long l10 = CietTemplate.getCiet_var_count(this.inputStream, l);
            long l11 = CietTemplate.getCiet_var_addr(this.inputStream, l);
            l11 = this.space.readInt(l11);
            log.finer("ciet_var_addr = " + Dll.hex(l11));
            this.variables = new DllVariable[(int)l10];
            log.finer("count = " + l10);
            int n3 = 0;
            while ((long)n3 < l10) {
                long l12 = l11 + (long)(n3 * CietExpEntryTemplate.length());
                log.finer("base = " + Dll.hex(l12));
                long l13 = CietExpEntryTemplate.getCiet_is_addr(this.inputStream, l12);
                log.finer("ciet_is_addr = " + l13);
                long l14 = CietExpEntryTemplate.getCiet_is_function(this.inputStream, l12);
                log.finer("ciet_is_function = " + Dll.hex(l14));
                long l15 = CietExpEntryTemplate.getCiet_exp_offset(this.inputStream, l12);
                log.finer("ciet_exp_offset = " + Dll.hex(l15));
                long l16 = CietExpEntryTemplate.getCiet_exp_name_addr(this.inputStream, l12);
                log.finer("ciet_exp_name_addr = " + Dll.hex(l16) + " length = " + this.space.readUnsignedShort(l16));
                String string = this.space.readEbcdicString(l16);
                log.finer("varName = " + string);
                long l17 = l13 == 0L ? l15 + this.getWsa() : l15;
                log.finer("varAddr = " + Dll.hex(l17));
                log.finer("ciet_is_addr = " + Dll.hex(l13));
                this.variables[n3] = new DllVariable(string, l17);
                ++n3;
            }
            return this.variables;
        }
        if (!this.space.readEbcdicString(l, 8).equals("@@DL370$")) throw new Error("tbc");
        long l18 = DllcsectTemplate.getDlloffexpvar(this.inputStream, l);
        long l19 = l + l18;
        long l20 = DllexpvarsTemplate.getDllexpvarscount(this.inputStream, l19);
        if (l20 < 0L || l20 > 1000000L) {
            log.config("impossible dllexpvarscount: " + l20);
            this.variables = new DllVariable[0];
            return this.variables;
        }
        this.variables = new DllVariable[(int)l20];
        int n4 = 0;
        while ((long)n4 < l20) {
            long l21 = DllexpvarsTemplate.getDllexpvarsname(this.inputStream, l19);
            long l22 = DllexpvarsTemplate.getDllexpvarsqcon(this.inputStream, l19);
            String string = this.space.readEbcdicString(l + l21);
            long l23 = this.getWsa() + l22;
            this.variables[n4] = new DllVariable(string, l23);
            l19 += (long)(DllexpvarsTemplate.getDllexpvarsarray$length() / 8);
            ++n4;
        }
        return this.variables;
    }

    public DllFunction getFunction(String string) throws IOException {
        if (this.getFunctions() == null) {
            return null;
        }
        for (int i = 0; i < this.functions.length; ++i) {
            if (!this.functions[i].name.equals(string)) continue;
            return this.functions[i];
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DllFunction[] getFunctions() throws IOException {
        if (this.functions != null) {
            return this.functions;
        }
        long l = 0L;
        int n = 0;
        log.fine("getting functions for " + this.name);
        try {
            l = this.ceexdlcbTemplate.getDlcbiewbcie(this.inputStream, this.address);
            n = this.space.readInt(l);
        }
        catch (IOException iOException) {
            log.fine("caught exception: " + iOException);
            this.functions = new DllFunction[0];
            return this.functions;
        }
        if (n == -909777214) {
            long l2 = Ciet2Template.getCiet2_version(this.inputStream, l);
            if (l2 == 2L) {
                long l3 = Ciet2Template.getCiet2_func_count(this.inputStream, l);
                assert (l3 >= 0L && l3 < 1000000L) : l3;
                long l4 = Ciet2Template.getCiet2_func_addr(this.inputStream, l);
                this.functions = new DllFunction[(int)l3];
                int n2 = 0;
                while ((long)n2 < l3) {
                    try {
                        long l5 = l4 + (long)(n2 * Ciet2ExpFuncEntryTemplate.length());
                        long l6 = Ciet2ExpFuncEntryTemplate.getCiet2_exp_func_is_addr(this.inputStream, l5);
                        long l7 = Ciet2ExpFuncEntryTemplate.getCiet2_exp_func_offset(this.inputStream, l5);
                        long l8 = Ciet2ExpFuncEntryTemplate.getCiet2_exp_func_name_addr(this.inputStream, l5);
                        String string = this.space.readEbcdicString(l8);
                        long l9 = l6 == 0L ? l7 + this.getWsa() : l7;
                        long l10 = Ciet2ExpFuncEntryTemplate.getCiet2_exp_ada_is_addr(this.inputStream, l5);
                        long l11 = Ciet2ExpFuncEntryTemplate.getCiet2_exp_func_ada_offset(this.inputStream, l5);
                        long l12 = l10 == 0L ? l11 + this.getWsa() : l11;
                        this.functions[n2] = new DllFunction(string, l9, null, l12);
                    }
                    catch (IOException iOException) {
                        this.functions[n2] = new DllFunction(iOException.toString(), 0L, null, -4995072469322842385L);
                    }
                    ++n2;
                }
                return this.functions;
            }
            if (l2 != 1L) throw new Error("expected ciet2_version 1 or 2 but instead found " + l2);
            long l13 = CietTemplate.getCiet_func_count(this.inputStream, l);
            long l14 = CietTemplate.getCiet_func_addr(this.inputStream, l);
            l14 = this.space.readInt(l14);
            this.functions = new DllFunction[(int)l13];
            log.finer("count = " + l13);
            int n3 = 0;
            while ((long)n3 < l13) {
                try {
                    long l15 = l14 + (long)(n3 * CietExpEntryTemplate.length());
                    long l16 = CietExpEntryTemplate.getCiet_is_addr(this.inputStream, l15);
                    long l17 = CietExpEntryTemplate.getCiet_is_function(this.inputStream, l15);
                    long l18 = CietExpEntryTemplate.getCiet_exp_offset(this.inputStream, l15);
                    long l19 = CietExpEntryTemplate.getCiet_exp_name_addr(this.inputStream, l15);
                    String string = this.space.readEbcdicString(l19);
                    long l20 = l16 == 0L ? l18 + this.getWsa() : l18;
                    this.functions[n3] = new DllFunction(string, l20, null, -4995072469322842385L);
                }
                catch (IOException iOException) {
                    this.functions[n3] = new DllFunction(iOException.toString(), 0L, null, -4995072469322842385L);
                }
                ++n3;
            }
            return this.functions;
        }
        if (!this.space.readEbcdicString(l, 8).equals("@@DL370$")) throw new Error("tbc");
        long l21 = DllcsectTemplate.getDlloffexpfunc(this.inputStream, l);
        long l22 = l + l21;
        long l23 = DllexpfuncsTemplate.getDllexpfuncscount(this.inputStream, l22);
        if (l23 < 0L || l23 > 1000000L) {
            log.config("impossible dllexpfuncscount: " + l23);
            this.functions = new DllFunction[0];
            return this.functions;
        }
        this.functions = new DllFunction[(int)l23];
        int n4 = 0;
        while ((long)n4 < l23) {
            long l24 = DllexpfuncsTemplate.getDllexpfuncsname(this.inputStream, l22);
            long l25 = DllexpfuncsTemplate.getDllexpfuncsaddr(this.inputStream, l22);
            String string = this.space.readEbcdicString(l + l24);
            this.functions[n4] = new DllFunction(string, l25, null, this.getWsa());
            l22 += (long)(DllexpfuncsTemplate.getDllexpfuncsarray$length() / 8);
            ++n4;
        }
        return this.functions;
    }

    public static DllFunction getFunction(AddressSpace addressSpace, String string) throws IOException {
        log.finer("try to get function " + string + " in space " + addressSpace);
        DllFunction dllFunction = (DllFunction)addressSpace.getUserMap().get(string);
        if (dllFunction != null) {
            return dllFunction;
        }
        Edb[] edbArray = Edb.getEdbs(addressSpace);
        for (int i = 0; i < edbArray.length; ++i) {
            Edb edb = edbArray[i];
            log.fine("looking at edb " + edb);
            for (Dll dll = edb.getFirstDll(); dll != null; dll = dll.getNext()) {
                log.fine("dll = " + dll.getName());
                dllFunction = dll.getFunction(string);
                if (dllFunction == null) continue;
                addressSpace.getUserMap().put(string, dllFunction);
                return dllFunction;
            }
        }
        log.fine("could not find function " + string);
        return null;
    }

    public static void addFunction(AddressSpace addressSpace, String string, DllFunction dllFunction) {
        log.fine("adding " + string);
        addressSpace.getUserMap().put(string, dllFunction);
    }

    private static String hex(long l) {
        return Long.toHexString(l);
    }

    private static String hex(int n) {
        return Integer.toHexString(n);
    }

    public String toString() {
        try {
            return this.getName();
        }
        catch (IOException iOException) {
            return "oops: " + iOException;
        }
    }
}

