/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.corereaders.memory.IProcess;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractive;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.tools.ddrinteractive.commands.SnapBaseCommand;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;

public class SnapTraceCommand
extends SnapBaseCommand {
    private String fileName = null;

    public SnapTraceCommand() {
        this.addCommand("snaptrace", "<filename>", "extract trace buffers to a file");
    }

    @Override
    public void run(String string, String[] stringArray, Context context, PrintStream printStream) throws DDRInteractiveCommandException {
        if (stringArray.length > 0) {
            this.fileName = stringArray[0];
        } else {
            this.fileName = DDRInteractive.getPath();
            if (this.fileName == null) {
                this.fileName = "snap.trc";
            } else {
                File file = new File(this.fileName);
                this.fileName = file.getParentFile().getPath() + File.separator + "Snap." + file.getName() + ".trc";
            }
        }
        printStream.println("Writing snap trace to: " + this.fileName);
        this.extractTraceData(context, printStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void writeBytesToTrace(Context context, long l, int n, PrintStream printStream) {
        if (this.fileName != null) {
            File file = new File(this.fileName);
            byte[] byArray = new byte[n];
            try {
                context.process.getBytesAt(l, byArray);
            }
            catch (CorruptDataException corruptDataException) {
                printStream.println("Problem reading " + n + " bytes from 0x" + Long.toHexString(l) + ". Trace file may contain partial or damaged data.");
            }
            FileOutputStream fileOutputStream = null;
            try {
                fileOutputStream = new FileOutputStream(file, true);
                fileOutputStream.write(byArray);
            }
            catch (FileNotFoundException fileNotFoundException) {
                printStream.println("FileNotFound " + this.fileName);
            }
            catch (IOException iOException) {
                printStream.println("IO Error writing to file " + this.fileName);
            }
            finally {
                if (fileOutputStream != null) {
                    try {
                        fileOutputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    @Override
    public String getCStringAtAddress(IProcess iProcess, long l) throws CorruptDataException {
        return this.getCStringAtAddress(iProcess, l, Long.MAX_VALUE);
    }

    @Override
    public String getCStringAtAddress(IProcess iProcess, long l, long l2) throws CorruptDataException {
        int n = 0;
        while (0 != iProcess.getByteAt(l + (long)n) && (long)n < l2) {
            ++n;
        }
        byte[] byArray = new byte[n];
        iProcess.getBytesAt(l, byArray);
        try {
            return new String(byArray, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void writeHeaderBytesToTrace(Context context, byte[] byArray, PrintStream printStream) {
        if (this.fileName != null) {
            File file = new File(this.fileName);
            FileOutputStream fileOutputStream = null;
            try {
                fileOutputStream = new FileOutputStream(file, true);
                fileOutputStream.write(byArray);
            }
            catch (FileNotFoundException fileNotFoundException) {
                printStream.println("FileNotFound " + this.fileName);
            }
            catch (IOException iOException) {
                printStream.println("IO Error writing to file " + this.fileName);
            }
            finally {
                if (fileOutputStream != null) {
                    try {
                        fileOutputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }
}

