/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.tools.ddrinteractive.plugins;

import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.tools.ddrinteractive.plugins.DDRInteractiveClassLoader;
import com.ibm.j9ddr.tools.ddrinteractive.plugins.PluginConfig;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class PluginCommand
extends Command {
    private static final String COMMAND_NAME = "!plugins";
    private static final String COMMAND_LIST = "list";
    private static final String COMMAND_RELOAD = "reload";
    private static final String COMMAND_SHOWPATH = "showpath";
    private static final String COMMAND_SETPATH = "setpath";
    private static final String COMMAND_HELP = "help";
    private static final String COMMAND_HELP_QMARK = "?";
    private final Map<String, Method> commands = new HashMap<String, Method>();
    private Command.CommandDescription cd = null;

    public PluginCommand() {
        try {
            this.commands.put(COMMAND_LIST, this.getClass().getDeclaredMethod("commandListPlugins", String[].class, Context.class, PrintStream.class));
            this.commands.put(COMMAND_RELOAD, this.getClass().getDeclaredMethod("commandReload", String[].class, Context.class, PrintStream.class));
            this.commands.put(COMMAND_SHOWPATH, this.getClass().getDeclaredMethod("commandShowPath", String[].class, Context.class, PrintStream.class));
            this.commands.put(COMMAND_SETPATH, this.getClass().getDeclaredMethod("commandSetPath", String[].class, Context.class, PrintStream.class));
            this.commands.put(COMMAND_HELP, this.getClass().getDeclaredMethod("commandHelp", String[].class, Context.class, PrintStream.class));
            this.commands.put(COMMAND_HELP_QMARK, this.getClass().getDeclaredMethod("commandHelp", String[].class, Context.class, PrintStream.class));
        }
        catch (Exception exception) {
            System.err.println("Error creating command list : " + exception.getMessage());
        }
        this.cd = this.addCommand("plugins", "<subcmd>", "DDR Plugin management commands");
        this.cd.addSubCommand(COMMAND_LIST, "", "Show the list of loaded plugins for the current context");
        this.cd.addSubCommand(COMMAND_RELOAD, "", "Reload plugins for the current context");
        this.cd.addSubCommand(COMMAND_SHOWPATH, "", "Displays the current plugin search path");
        this.cd.addSubCommand(COMMAND_SETPATH, "<search path>", "Sets the current plugin search path");
    }

    @Override
    public void run(String string, String[] stringArray, Context context, PrintStream printStream) throws DDRInteractiveCommandException {
        if (stringArray.length == 0) {
            printStream.println("\n");
            printStream.println("Error, all plugin commands require one or more parameters, see !plugins help for more information");
            return;
        }
        if (this.commands.containsKey(stringArray[0])) {
            try {
                this.commands.get(stringArray[0]).invoke((Object)this, stringArray, context, printStream);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new DDRInteractiveCommandException(invocationTargetException.getCause().getMessage());
            }
            catch (Exception exception) {
                throw new DDRInteractiveCommandException(exception.getMessage());
            }
        } else {
            printStream.println("!plugins " + string + " was not recognised, run " + COMMAND_NAME + " " + COMMAND_HELP + " to see all available options");
        }
    }

    private void commandListPlugins(String[] stringArray, Context context, PrintStream printStream) throws DDRInteractiveCommandException {
        DDRInteractiveClassLoader dDRInteractiveClassLoader;
        boolean bl = false;
        if (stringArray.length >= 2) {
            bl = stringArray[1].equalsIgnoreCase("csv");
            printStream.println("id,vmversion,enabled,path,modified,exception");
        }
        if ((dDRInteractiveClassLoader = context.getPluginClassloader()) == null) {
            printStream.println("No plugins are currently loaded");
            return;
        }
        ArrayList<PluginConfig> arrayList = dDRInteractiveClassLoader.getPlugins();
        ArrayList<PluginConfig> arrayList2 = dDRInteractiveClassLoader.getPluginFailures();
        if (arrayList.size() == 0 && arrayList2.size() == 0 && !bl) {
            printStream.println("No plugins are currently loaded");
            return;
        }
        this.printPlugins(arrayList, printStream, bl);
        this.printPlugins(arrayList2, printStream, bl);
    }

    private void printPlugins(ArrayList<PluginConfig> arrayList, PrintStream printStream, boolean bl) {
        for (PluginConfig pluginConfig : arrayList) {
            if (bl) {
                printStream.println(pluginConfig.toCSV());
                continue;
            }
            printStream.println("\t" + pluginConfig.getId());
        }
    }

    private void commandShowPath(String[] stringArray, Context context, PrintStream printStream) throws DDRInteractiveCommandException {
        String string = System.getProperty("plugins");
        string = null == string ? (null == (string = System.getenv("com.ibm.java.diagnostics.plugins")) ? "<<warning : no plugin path has been defined>>" : string + String.format(" (set from environment variable %s)", "com.ibm.java.diagnostics.plugins")) : string + String.format(" (set from system property %s)", "plugins");
        printStream.println("DDR Plugin search path : " + string);
    }

    private void commandSetPath(String[] stringArray, Context context, PrintStream printStream) throws DDRInteractiveCommandException {
        if (stringArray.length != 2) {
            printStream.println("The setpath option only takes a single parameter of the search path");
            return;
        }
        System.getProperties().setProperty("plugins", stringArray[1]);
        printStream.println("Plugin search path set to : " + stringArray[1]);
        printStream.println("Execute !plugins reload to scan this path for plugins");
    }

    private void commandReload(String[] stringArray, Context context, PrintStream printStream) throws DDRInteractiveCommandException {
        context.refreshCommandList();
        printStream.println("Plugins reloaded");
    }

    private void commandHelp(String[] stringArray, Context context, PrintStream printStream) throws DDRInteractiveCommandException {
        this.printDetailedHelp(printStream);
    }
}

