/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.tools.logging;

import java.io.File;
import java.io.FileInputStream;
import java.util.HashSet;
import java.util.Properties;
import java.util.logging.Filter;
import java.util.logging.LogRecord;

public class LogFilter
implements Filter {
    private static final String SYSTEM_PROP_LOGGING = "java.util.logging.config.file";
    private static final String KEY_CATEGORIES = "com.ibm.j9ddr.tools.logging.categories";
    private HashSet<String> idlist = null;

    public LogFilter() {
        String string = System.getProperty(SYSTEM_PROP_LOGGING);
        File file = new File(string);
        if (file.exists()) {
            Properties properties = new Properties();
            try {
                properties.load(new FileInputStream(file));
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new IllegalArgumentException("The configuration file " + file.getPath() + " specified in " + SYSTEM_PROP_LOGGING + " could not be read");
            }
            if (properties.containsKey(KEY_CATEGORIES)) {
                String[] stringArray = properties.getProperty(KEY_CATEGORIES).trim().split(",");
                if (stringArray.length == 0) {
                    return;
                }
                this.idlist = new HashSet();
                for (int i = 0; i < stringArray.length; ++i) {
                    this.idlist.add(stringArray[i].trim());
                }
            }
        }
    }

    @Override
    public boolean isLoggable(LogRecord logRecord) {
        return this.idlist == null || this.idlist.contains(logRecord.getLoggerName());
    }
}

