/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.view.dtfj.image;

import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.image.ImageStackFrame;
import com.ibm.dtfj.image.ImageThread;
import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.DataUnavailableException;
import com.ibm.j9ddr.corereaders.memory.IProcess;
import com.ibm.j9ddr.corereaders.osthread.IOSStackFrame;
import com.ibm.j9ddr.view.dtfj.J9DDRDTFJUtils;
import com.ibm.j9ddr.view.dtfj.image.J9DDRImagePointer;

public class J9DDRImageStackFrame
implements ImageStackFrame {
    private final IProcess process;
    private final IOSStackFrame frame;
    private final ImageThread parentThread;

    public J9DDRImageStackFrame(IProcess iProcess, IOSStackFrame iOSStackFrame, ImageThread imageThread) {
        this.frame = iOSStackFrame;
        this.process = iProcess;
        this.parentThread = imageThread;
    }

    public ImagePointer getBasePointer() throws com.ibm.dtfj.image.CorruptDataException {
        return new J9DDRImagePointer(this.process, this.frame.getBasePointer());
    }

    public ImagePointer getProcedureAddress() throws com.ibm.dtfj.image.CorruptDataException {
        return new J9DDRImagePointer(this.process, this.frame.getInstructionPointer());
    }

    public String getProcedureName() throws com.ibm.dtfj.image.CorruptDataException {
        try {
            return this.process.getProcedureNameForAddress(this.frame.getInstructionPointer(), true);
        }
        catch (DataUnavailableException dataUnavailableException) {
            return "<unknown location>";
        }
        catch (CorruptDataException corruptDataException) {
            throw J9DDRDTFJUtils.handleAsCorruptDataException(this.process, corruptDataException);
        }
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.frame == null ? 0 : this.frame.hashCode());
        n = 31 * n + (this.process == null ? 0 : this.process.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof J9DDRImageStackFrame)) {
            return false;
        }
        J9DDRImageStackFrame j9DDRImageStackFrame = (J9DDRImageStackFrame)object;
        if (this.frame == null ? j9DDRImageStackFrame.frame != null : !this.frame.equals(j9DDRImageStackFrame.frame)) {
            return false;
        }
        return !(this.process == null ? j9DDRImageStackFrame.process != null : !this.process.equals(j9DDRImageStackFrame.process));
    }

    public String toString() {
        try {
            return "J9DDRImageStackFrame: " + this.getProcedureName() + " from Thread " + this.parentThread.getID();
        }
        catch (com.ibm.dtfj.image.CorruptDataException corruptDataException) {
            return "J9DDRImageStackFrame <exception getting details>";
        }
    }
}

