/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.j9.gc;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.events.EventManager;
import com.ibm.j9ddr.vm29.j9.Pool;
import com.ibm.j9ddr.vm29.j9.gc.GCIterator;
import com.ibm.j9ddr.vm29.pointer.PointerPointer;
import com.ibm.j9ddr.vm29.pointer.VoidPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9JNIReferenceFramePointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9PoolPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9VMThreadPointer;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class GCVMThreadJNISlotIterator
extends GCIterator {
    protected J9JNIReferenceFramePointer jniFrame;
    protected Iterator<PointerPointer> poolIterator;

    protected GCVMThreadJNISlotIterator(J9VMThreadPointer j9VMThreadPointer) throws CorruptDataException {
        this.jniFrame = J9JNIReferenceFramePointer.cast(j9VMThreadPointer.jniLocalReferences());
        this.poolIterator = null;
    }

    public static GCVMThreadJNISlotIterator fromJ9VMThread(J9VMThreadPointer j9VMThreadPointer) throws CorruptDataException {
        return new GCVMThreadJNISlotIterator(j9VMThreadPointer);
    }

    @Override
    public boolean hasNext() {
        if (this.jniFrame.isNull()) {
            return false;
        }
        if (null == this.poolIterator) {
            try {
                J9PoolPointer j9PoolPointer = J9PoolPointer.cast(this.jniFrame.references());
                this.poolIterator = Pool.fromJ9Pool(j9PoolPointer, PointerPointer.class).iterator();
            }
            catch (CorruptDataException corruptDataException) {
                EventManager.raiseCorruptDataEvent("Error looking at current frame", corruptDataException, false);
                try {
                    this.jniFrame = this.jniFrame.previous();
                    this.poolIterator = null;
                    return this.hasNext();
                }
                catch (CorruptDataException corruptDataException2) {
                    EventManager.raiseCorruptDataEvent("Error looking at previous frame", corruptDataException2, true);
                    return false;
                }
            }
        }
        if (this.poolIterator.hasNext()) {
            return true;
        }
        try {
            this.jniFrame = this.jniFrame.previous();
            this.poolIterator = null;
            return this.hasNext();
        }
        catch (CorruptDataException corruptDataException) {
            EventManager.raiseCorruptDataEvent("Error moving to previous frame", corruptDataException, true);
            return false;
        }
    }

    @Override
    public J9ObjectPointer next() {
        if (this.hasNext()) {
            try {
                PointerPointer pointerPointer = this.poolIterator.next();
                return J9ObjectPointer.cast(pointerPointer.at(0L));
            }
            catch (CorruptDataException corruptDataException) {
                EventManager.raiseCorruptDataEvent("Error getting next item", corruptDataException, false);
                return null;
            }
        }
        throw new NoSuchElementException("There are no more items available through this iterator");
    }

    @Override
    public VoidPointer nextAddress() {
        if (this.hasNext()) {
            return VoidPointer.cast(this.poolIterator.next());
        }
        throw new NoSuchElementException("There are no more items available through this iterator");
    }
}

