/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.vm29.pointer.generated.J9ClassLoaderPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9PackagePointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9ClassHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9UTF8Helper;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.ModularityHelper;
import java.io.PrintStream;

public class DumpPackageCommand
extends Command {
    public DumpPackageCommand() {
        this.addCommand("dumppackage", "[all|exportsTo|classes] <packageAddress>|help", "List details about a package");
    }

    @Override
    public void run(String string, String[] stringArray, Context context, PrintStream printStream) throws DDRInteractiveCommandException {
        Subcommand subcommand;
        String string2 = null;
        ModularityHelper.ClassOutput classOutput = null;
        ModularityHelper.ClassIteratorFilter classIteratorFilter = null;
        block2 : switch (stringArray.length) {
            case 1: {
                switch (stringArray[0]) {
                    case "help": {
                        subcommand = Subcommand.HELP;
                        break block2;
                    }
                }
                string2 = stringArray[0];
                subcommand = Subcommand.ALL;
                break;
            }
            case 2: {
                string2 = stringArray[1];
                switch (stringArray[0]) {
                    case "all": {
                        subcommand = Subcommand.ALL;
                        break block2;
                    }
                    case "exportsTo": {
                        subcommand = Subcommand.PRINT_PACKAGE;
                        break block2;
                    }
                    case "classes": {
                        classOutput = ModularityHelper::printJ9Class;
                        classIteratorFilter = DumpPackageCommand::filterClassByPackage;
                        subcommand = Subcommand.CLASS;
                        break block2;
                    }
                }
                subcommand = Subcommand.INVALID;
                break;
            }
            default: {
                subcommand = Subcommand.INVALID;
            }
        }
        try {
            Object object = null;
            if (null != string2) {
                try {
                    object = J9PackagePointer.cast(Long.decode(string2));
                }
                catch (NumberFormatException numberFormatException) {
                    throw new DDRInteractiveCommandException("The argument \"" + string2 + "\" is not a valid number. It should be the address of a J9Package.");
                }
            }
            int n = 0;
            switch (subcommand) {
                case ALL: {
                    printStream.println("Exported to:");
                    ModularityHelper.printPackageExports((J9PackagePointer)object, printStream);
                    break;
                }
                case PRINT_PACKAGE: {
                    ModularityHelper.printPackageExports((J9PackagePointer)object, printStream);
                    break;
                }
                case CLASS: {
                    J9ClassLoaderPointer j9ClassLoaderPointer = ((J9PackagePointer)object).classLoader();
                    n = ModularityHelper.iterateClassLoaderClasses(printStream, classIteratorFilter, classOutput, string2, j9ClassLoaderPointer);
                    printStream.printf("Found %d class%s%n", n, 1 == n ? "" : "es");
                    break;
                }
                case HELP: {
                    this.printHelp(printStream);
                    break;
                }
                default: {
                    printStream.println("Argument failed to parse or was parsed to an unhandled subcommand.");
                    this.printHelp(printStream);
                    break;
                }
            }
        }
        catch (CorruptDataException corruptDataException) {
            throw new DDRInteractiveCommandException(corruptDataException);
        }
    }

    private static boolean filterClassByPackage(J9ClassPointer j9ClassPointer, String string) throws CorruptDataException {
        boolean bl = false;
        String string2 = J9ClassHelper.getJavaName(j9ClassPointer);
        int n = string2.lastIndexOf(47);
        if (n >= 0) {
            String string3 = string2.substring(0, n);
            J9PackagePointer j9PackagePointer = J9PackagePointer.cast(Long.decode(string));
            String string4 = J9UTF8Helper.stringValue(j9PackagePointer.packageName());
            bl = string3.equals(string4);
        }
        return bl;
    }

    void printHelp(PrintStream printStream) {
        printStream.println("Usage:");
        printStream.println("  !dumppackage <packageAddress>");
        printStream.println("      Lists !dumppackage all <packageAddress>");
        printStream.println("  !dumppackage all <packageAddress>");
        printStream.println("      Lists !dumppackage exportsTo <packageAddress>");
        printStream.println("  !dumppackage exportsTo <packageAddress>");
        printStream.println("      Lists all modules that the given package is exported to");
        printStream.println("  !dumppackage classes <packageAddress>");
        printStream.println("      Lists all loaded classes in the given package");
    }

    static enum Subcommand {
        CLASS,
        ALL,
        PRINT_PACKAGE,
        HELP,
        INVALID;

    }
}

