/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive.commands;

import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.vm29.structure.J9Consts;
import com.ibm.j9ddr.vm29.types.U64;
import java.io.PrintStream;

public class ExtendedMethodFlagInfoCommand
extends Command {
    public ExtendedMethodFlagInfoCommand() {
        this.addCommand("j9extendedmethodflaginfo", "<flags>", "give information about extended method flags");
    }

    @Override
    public void run(String string, String[] stringArray, Context context, PrintStream printStream) throws DDRInteractiveCommandException {
        U64 u64 = new U64(Long.decode(stringArray[0]));
        if (u64.anyBitsIn(J9Consts.J9_RAS_METHOD_UNSEEN)) {
            printStream.println("J9_RAS_METHOD_UNSEEN");
        }
        if (u64.anyBitsIn(J9Consts.J9_RAS_METHOD_SEEN)) {
            printStream.println("J9_RAS_METHOD_SEEN");
        }
        if (u64.anyBitsIn(J9Consts.J9_RAS_METHOD_TRACING)) {
            printStream.println("J9_RAS_METHOD_TRACING");
        }
        if (u64.anyBitsIn(J9Consts.J9_RAS_METHOD_TRACE_ARGS)) {
            printStream.println("J9_RAS_METHOD_TRACE_ARGS");
        }
        if (u64.anyBitsIn(J9Consts.J9_RAS_METHOD_TRIGGERING)) {
            printStream.println("J9_RAS_METHOD_TRIGGERING");
        }
    }
}

