/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.corereaders.memory.Addresses;
import com.ibm.j9ddr.corereaders.memory.IMemoryRange;
import com.ibm.j9ddr.corereaders.memory.IModule;
import com.ibm.j9ddr.corereaders.memory.IProcess;
import com.ibm.j9ddr.events.IEventListener;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.CommandUtils;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.vm29.events.EventManager;
import com.ibm.j9ddr.vm29.j9.DataType;
import com.ibm.j9ddr.vm29.j9.walkers.J9MemTagIterator;
import com.ibm.j9ddr.vm29.pointer.AbstractPointer;
import com.ibm.j9ddr.vm29.pointer.U8Pointer;
import com.ibm.j9ddr.vm29.pointer.VoidPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm29.pointer.generated.J9MemTagPointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9MemTagHelper;
import com.ibm.j9ddr.vm29.structure.J9MemTag;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.commands.WildCard;
import com.ibm.j9ddr.vm29.types.UDATA;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class J9MemTagCommands
extends Command
implements IEventListener {
    public static final long SEARCH_SLAB_SIZE = 1024L;
    private static final int SORT_TYPE_DEFAULT = 1;
    private static final int SORT_TYPE_NAME = 2;
    private static final int SORT_TYPE_ALLOCSIZE = 3;
    private static final String SORT_TYPE_STRING_NAME = "name";
    private static final String SORT_TYPE_STRING_ALLOCSIZE = "allocsize";
    private static final String SORT_TYPE_PREFIX = "sort:";
    private static final String[][] commands = new String[][]{{"!findcallsite <callsite>[,start[,end]] [sort:<name|allocsize>]", "list all allocations for the specified callsite."}, {"!printallcallsites [sort:<name|allocsize>]", "list all blocks and bytes allocated by each callsite (same as !findcallsite *)."}, {"!printfreedcallsites [sort:<name|allocsize>]", "list all freed blocks and bytes allocated by each callsite. (same as !findfreedcallsite *)"}, {"!findheader", "locate the memory allocation header for the specified address."}, {"!findallcallsites [sort:<name|allocsize>]", "list a summary of blocks and bytes allocated by each callsite."}, {"!findfreedcallsites [sort:<name|allocsize>]", "list a summary of all freed blocks and bytes allocated by each callsite."}, {"!findfreedcallsite <callsite>[,start[,end]] [sort:<name|allocsize>]", "list all freed blocks for the specified callsite."}};
    private PrintStream out;

    public J9MemTagCommands() {
        this.addCommand("findcallsite", "<callsite>[,start[,end]] [sort:<name|allocsize>]", "list all allocations for the specified callsite.");
        this.addCommand("printallcallsites", "[sort:<name|allocsize>]", "list all blocks and bytes allocated by each callsite (same as !findcallsite *).");
        this.addCommand("printfreedcallsites", "[sort:<name|allocsize>]", "list all freed blocks and bytes allocated by each callsite. (same as !findfreedcallsite *)");
        this.addCommand("findheader", "", "locate the memory allocation header for the specified address.");
        this.addCommand("findallcallsites", "[sort:<name|allocsize>]", "list a summary of blocks and bytes allocated by each callsite.");
        this.addCommand("findfreedcallsites", "[sort:<name|allocsize>]", "list a summary of all freed blocks and bytes allocated by each callsite.");
        this.addCommand("findfreedcallsite", "<callsite>[,start[,end]] [sort:<name|allocsize>]", "list all freed blocks for the specified callsite.");
    }

    @Override
    public void run(String string, String[] stringArray, Context context, PrintStream printStream) throws DDRInteractiveCommandException {
        string = string.toLowerCase();
        this.out = printStream;
        EventManager.register(this);
        try {
            if (string.endsWith("findallcallsites")) {
                this.runFindAllCallsites(string, stringArray, context);
                return;
            }
            if (string.endsWith("findfreedcallsites")) {
                this.runFindAllFreedCallsites(string, stringArray, context);
                return;
            }
            if (string.endsWith("findfreedcallsite")) {
                this.runFindFreedCallsite(string, stringArray, context);
                return;
            }
            if (string.endsWith("printallcallsites")) {
                this.runPrintAllCallsites(string, stringArray, context);
                return;
            }
            if (string.endsWith("printfreedcallsites")) {
                this.runPrintAllFreedCallsites(string, stringArray, context);
                return;
            }
            if (string.endsWith("findheader")) {
                this.runFindHeader(string, stringArray, context);
                return;
            }
            if (string.endsWith("findcallsite")) {
                this.runFindCallsite(string, stringArray, context);
                return;
            }
            throw new DDRInteractiveCommandException("Unrecognized command: " + string);
        }
        finally {
            EventManager.unregister(this);
        }
    }

    private void printUsageForFindFreedCallsite() {
        this.out.println("Usage:");
        this.out.println("  !findfreedcallsite <callsite> [sort:<name|allocsize>]");
        this.out.println("  !findfreedcallsite <callsite>,<start> [sort:<name:allocsize>]");
        this.out.println("  !findfreedcallsite <callsite>,<start>,<end> [sort:<name|allocsize>]");
    }

    private void runFindFreedCallsite(String string, String[] stringArray, Context context) throws DDRInteractiveCommandException {
        Object object;
        long l = 0L;
        long l2 = UDATA.MASK;
        int n = 1;
        if (0 == stringArray.length) {
            this.printUsageForFindFreedCallsite();
            return;
        }
        String[] stringArray2 = stringArray[0].split(",");
        String string2 = stringArray2[0];
        if (stringArray2.length == 2) {
            l = Long.decode(stringArray2[1]);
        } else if (stringArray2.length == 3) {
            l = Long.decode(stringArray2[1]);
            l2 = Long.decode(stringArray2[2]);
        } else if (stringArray2.length > 3 || stringArray.length > 2) {
            this.out.print("Too many args:");
            for (String string3 : stringArray) {
                this.out.print(" ");
                this.out.print(string3);
            }
            this.out.println();
            this.printUsageForFindFreedCallsite();
            return;
        }
        if (stringArray.length == 2 && (n = J9MemTagCommands.parseSortType(stringArray[1])) == -1) {
            this.printUsageForFindFreedCallsite();
            return;
        }
        if (Addresses.greaterThan(l, l2)) {
            this.out.println("Error: start address cannot be greater than end address");
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        long l3 = WildCard.parseWildcard(string2, stringBuffer);
        if (l3 < 0L) {
            this.out.println("Error: Invalid wildcard(s) in callsite");
            return;
        }
        String string4 = stringBuffer.toString();
        J9MemTagIterator j9MemTagIterator = J9MemTagIterator.iterateFreedHeaders(l, l2);
        if (J9BuildFlags.env_data64) {
            this.out.println("+------------------------------------------+------------------+-------------------+");
            this.out.println("|          address      |      size        |    org size      | callsite          |");
            this.out.println("+------------------------------------------+------------------+-------------------+");
        } else {
            this.out.println("+--------------------------+----------+-------------------+");
            this.out.println("|      address  |   size   | org size | callsite          |");
            this.out.println("+--------------------------+----------+-------------------+");
        }
        ArrayList<MemTagEntry> arrayList = new ArrayList<MemTagEntry>();
        int n2 = 0;
        int n3 = 0;
        while (j9MemTagIterator.hasNext()) {
            object = j9MemTagIterator.next();
            if (!J9MemTagCommands.regexMatches((J9MemTagPointer)object, l3, string4)) continue;
            ++n2;
            try {
                Object object2;
                long l4 = ((J9MemTagPointer)object).allocSize().longValue();
                if (j9MemTagIterator.isFooterCorrupted()) {
                    ++n3;
                    object2 = J9MemTagIterator.iterateAllocatedHeaders(((AbstractPointer)object).longValue() + J9MemTag.SIZEOF, ((J9MemTagPointer)object).add(l4).longValue() + J9MemTag.SIZEOF);
                    if (((J9MemTagIterator)object2).hasNext()) {
                        J9MemTagPointer j9MemTagPointer = ((J9MemTagIterator)object2).next();
                        l4 = j9MemTagPointer.longValue() - ((AbstractPointer)object).longValue();
                    }
                }
                object2 = new MemTagEntry((J9MemTagPointer)object, l4);
                if (1 == n) {
                    this.printMemTagForFindFreedCallSite((MemTagEntry)object2);
                    continue;
                }
                arrayList.add((MemTagEntry)object2);
            }
            catch (CorruptDataException corruptDataException) {
                corruptDataException.printStackTrace(this.out);
            }
        }
        if (!arrayList.isEmpty()) {
            object = 2 == n ? new NameComparator() : new AllocSizeComparator();
            Iterator iterator = arrayList.stream().sorted(object).iterator();
            while (iterator.hasNext()) {
                this.printMemTagForFindFreedCallSite((MemTagEntry)iterator.next());
            }
        }
        this.out.println("Freed call site count = " + n2);
        this.out.println("Corrupted freed call site count = " + n3);
    }

    private void printMemTagForFindFreedCallSite(MemTagEntry memTagEntry) {
        J9MemTagPointer j9MemTagPointer = memTagEntry.getHeader();
        long l = memTagEntry.getAllocSize();
        try {
            String string;
            try {
                string = J9MemTagCommands.getCString(j9MemTagPointer.callSite());
            }
            catch (CorruptDataException corruptDataException) {
                string = "<FAULT> reading callsite string: " + corruptDataException.getMessage();
            }
            long l2 = J9MemTagHelper.j9mem_get_memory_base(j9MemTagPointer).getAddress();
            if (J9BuildFlags.env_data64) {
                this.out.format(" !j9x 0x%016X 0x%016X ", l2, l);
                if (l == j9MemTagPointer.allocSize().longValue()) {
                    this.out.format("%18s ", "");
                } else {
                    this.out.format("0x%16X ", j9MemTagPointer.allocSize().longValue());
                }
                this.out.format("%s", string);
            } else {
                this.out.format(" !j9x 0x%08X 0x%08X ", l2, l);
                if (l != j9MemTagPointer.allocSize().longValue()) {
                    this.out.format("%12s ", "");
                } else {
                    this.out.format("0x%10X ", j9MemTagPointer.allocSize().longValue());
                }
                this.out.format("%s", string);
            }
            this.out.println();
        }
        catch (CorruptDataException corruptDataException) {
            corruptDataException.printStackTrace(this.out);
        }
    }

    private void printUsageForFindCallsite() {
        this.out.println("Usage:");
        this.out.println("  !findcallsite <callsite> [sort:<name|allocsize>]");
        this.out.println("  !findcallsite <callsite>,<start> [sort:<name|allocsize>]");
        this.out.println("  !findcallsite <callsite>,<start>,<end> [sort:<name|allocsize>]");
    }

    private void runFindCallsite(String string, String[] stringArray, Context context) throws DDRInteractiveCommandException {
        Object object;
        long l = 0L;
        long l2 = UDATA.MASK;
        int n = 1;
        if (stringArray.length == 0) {
            this.printUsageForFindCallsite();
            return;
        }
        String[] stringArray2 = stringArray[0].split(",");
        String string2 = stringArray2[0];
        if (stringArray.length == 2 && (n = J9MemTagCommands.parseSortType(stringArray[1])) == -1) {
            this.printUsageForFindCallsite();
            return;
        }
        if (stringArray2.length == 2) {
            l = Long.decode(stringArray2[1]);
        } else if (stringArray2.length == 3) {
            l = Long.decode(stringArray2[1]);
            l2 = Long.decode(stringArray2[2]);
        } else if (stringArray2.length > 3 || stringArray.length > 2) {
            this.out.print("Too many args:");
            for (String string3 : stringArray) {
                this.out.print(" ");
                this.out.print(string3);
            }
            this.out.println();
            this.printUsageForFindCallsite();
            return;
        }
        if (Addresses.greaterThan(l, l2)) {
            this.out.println("Error: start address cannot be greater than end address");
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        long l3 = WildCard.parseWildcard(string2, stringBuffer);
        if (l3 < 0L) {
            this.out.println("Error: Invalid wildcard(s) in callsite");
            return;
        }
        String string4 = stringBuffer.toString();
        J9MemTagIterator j9MemTagIterator = J9MemTagIterator.iterateAllocatedHeaders(l, l2);
        ArrayList<MemTagEntry> arrayList = new ArrayList<MemTagEntry>();
        int n2 = 0;
        while (j9MemTagIterator.hasNext()) {
            object = j9MemTagIterator.next();
            if (!J9MemTagCommands.regexMatches((J9MemTagPointer)object, l3, string4)) continue;
            ++n2;
            try {
                long l4 = ((J9MemTagPointer)object).allocSize().longValue();
                if (1 == n) {
                    this.printMemTagForFindCallSite(new MemTagEntry((J9MemTagPointer)object, l4));
                    continue;
                }
                arrayList.add(new MemTagEntry((J9MemTagPointer)object, l4));
            }
            catch (CorruptDataException corruptDataException) {
                corruptDataException.printStackTrace(this.out);
            }
        }
        if (!arrayList.isEmpty()) {
            object = 2 == n ? new NameComparator() : new AllocSizeComparator();
            Iterator iterator = arrayList.stream().sorted(object).iterator();
            while (iterator.hasNext()) {
                this.printMemTagForFindCallSite((MemTagEntry)iterator.next());
            }
        }
        this.out.println("Call site count = " + n2);
    }

    private void printMemTagForFindCallSite(MemTagEntry memTagEntry) {
        J9MemTagPointer j9MemTagPointer = memTagEntry.getHeader();
        try {
            String string;
            try {
                string = J9MemTagCommands.getCString(j9MemTagPointer.callSite());
            }
            catch (CorruptDataException corruptDataException) {
                string = "<FAULT> reading callsite string: " + corruptDataException.getMessage();
            }
            this.out.format(" !j9x %s,%s %s%n", J9MemTagHelper.j9mem_get_memory_base(j9MemTagPointer).getHexAddress(), j9MemTagPointer.allocSize().getHexValue(), string);
        }
        catch (CorruptDataException corruptDataException) {
            corruptDataException.printStackTrace(this.out);
        }
    }

    private void runFindHeader(String string, String[] stringArray, Context context) throws DDRInteractiveCommandException {
        Object object;
        Object object2;
        long l = 0L;
        Object object3 = null;
        if (stringArray.length != 1) {
            this.out.println("Usage:");
            this.out.println("  !findheader <address> (e.g. !findheader 0xa2b4c6d8)");
            return;
        }
        l = CommandUtils.parsePointer(stringArray[0], J9BuildFlags.env_data64);
        this.out.format("Searching memory allocation header for %s%n", U8Pointer.cast(l).getHexAddress());
        long l2 = l - 1024L;
        block8: do {
            object2 = J9MemTagIterator.iterateAllocatedHeaders(l2, l2 + 1024L + 3L);
            while (((J9MemTagIterator)object2).hasNext() && !Addresses.greaterThan(((AbstractPointer)(object = ((J9MemTagIterator)object2).next())).getAddress(), l)) {
                VoidPointer voidPointer;
                VoidPointer voidPointer2 = J9MemTagHelper.j9mem_get_memory_base((J9MemTagPointer)object);
                try {
                    voidPointer = voidPointer2.addOffset(((J9MemTagPointer)object).allocSize().longValue());
                }
                catch (CorruptDataException corruptDataException) {
                    continue;
                }
                if (!Addresses.greaterThanOrEqual(l, voidPointer2.getAddress()) || !Addresses.lessThan(l, voidPointer.getAddress())) continue;
                object3 = object;
                break block8;
            }
            if (Addresses.lessThan(l2, 1024L)) {
                l2 = 0L;
                continue;
            }
            l2 -= 1024L;
        } while (l2 != 0L);
        if (object3 == null) {
            this.out.println("No memory allocation header found");
        } else {
            try {
                object2 = J9MemTagCommands.getCString(((J9MemTagPointer)object3).callSite());
            }
            catch (CorruptDataException corruptDataException) {
                object2 = "<FAULT> reading callsite string: " + corruptDataException.getMessage();
            }
            try {
                object = J9MemTagCommands.getCString(((J9MemTagPointer)object3).category().name());
            }
            catch (CorruptDataException corruptDataException) {
                object = "<FAULT> reading category name string: " + corruptDataException.getMessage();
            }
            try {
                this.out.format("Found memory allocation header, !j9x 0x%x,0x%x%n", J9MemTagHelper.j9mem_get_memory_base((J9MemTagPointer)object3).getAddress(), ((J9MemTagPointer)object3).allocSize().longValue());
                this.out.format("J9MemTag at 0x%x {%n", ((AbstractPointer)object3).getAddress());
                this.out.format("    U_32 eyeCatcher = 0x%x;%n", ((J9MemTagPointer)object3).eyeCatcher().longValue());
                this.out.format("    U_32 sumCheck = 0x%x;%n", ((J9MemTagPointer)object3).sumCheck().longValue());
                this.out.format("    UDATA allocSize = 0x%x;%n", ((J9MemTagPointer)object3).allocSize().longValue());
                this.out.format("    char* callSite = %s;%n", object2);
                this.out.format("    struct OMRMemCategory* category = !omrmemcategory 0x%x (%s);%n", ((J9MemTagPointer)object3).category().longValue(), object);
                this.out.println("}");
            }
            catch (CorruptDataException corruptDataException) {
                this.out.println("CDE formatting J9MemTag at " + ((AbstractPointer)object3).getHexAddress());
            }
        }
    }

    private static int parseSortType(String string) throws DDRInteractiveCommandException {
        if (string.equalsIgnoreCase("sort:name")) {
            return 2;
        }
        if (string.equalsIgnoreCase("sort:allocsize")) {
            return 3;
        }
        throw new DDRInteractiveCommandException("Error: Unknown argument: " + string);
    }

    private void runPrintAllCallsites(String string, String[] stringArray, Context context) throws DDRInteractiveCommandException {
        this.out.println("Searching for all memory block callsites...");
        String[] stringArray2 = new String[stringArray.length + 1];
        stringArray2[0] = "*";
        if (stringArray.length == 1) {
            stringArray2[1] = stringArray[0];
        }
        this.runFindCallsite("!findcallsite", stringArray2, context);
    }

    private void runPrintAllFreedCallsites(String string, String[] stringArray, Context context) throws DDRInteractiveCommandException {
        this.out.println("Searching for all freed memory block callsites...");
        String[] stringArray2 = new String[stringArray.length + 1];
        stringArray2[0] = "*";
        if (stringArray.length == 1) {
            stringArray2[1] = stringArray[0];
        }
        this.runFindFreedCallsite("!findfreedcallsite", stringArray2, context);
    }

    private void runFindAllCallsites(String string, String[] stringArray, Context context) throws DDRInteractiveCommandException {
        int n = stringArray.length == 1 ? J9MemTagCommands.parseSortType(stringArray[0]) : 3;
        J9MemTagIterator j9MemTagIterator = J9MemTagIterator.iterateAllocatedHeaders();
        this.printCallsitesTable(this.buildCallsitesTable(j9MemTagIterator, false), n);
    }

    private void runFindAllFreedCallsites(String string, String[] stringArray, Context context) throws DDRInteractiveCommandException {
        this.out.println("Searching for all freed memory block callsites...");
        int n = stringArray.length == 1 ? J9MemTagCommands.parseSortType(stringArray[0]) : 3;
        J9MemTagIterator j9MemTagIterator = J9MemTagIterator.iterateFreedHeaders();
        this.printCallsitesTable(this.buildCallsitesTable(j9MemTagIterator, true), n);
    }

    private Map<U8Pointer, J9DbgExtMemStats> buildCallsitesTable(J9MemTagIterator j9MemTagIterator, boolean bl) {
        LinkedHashMap<U8Pointer, J9DbgExtMemStats> linkedHashMap = new LinkedHashMap<U8Pointer, J9DbgExtMemStats>();
        while (j9MemTagIterator.hasNext()) {
            J9MemTagPointer j9MemTagPointer = j9MemTagIterator.next();
            try {
                Object object;
                Object object2;
                long l = j9MemTagPointer.allocSize().longValue();
                if (bl && j9MemTagIterator.isFooterCorrupted() && ((J9MemTagIterator)(object2 = J9MemTagIterator.iterateAllocatedHeaders(j9MemTagPointer.longValue() + J9MemTag.SIZEOF, j9MemTagPointer.add(l).longValue() + J9MemTag.SIZEOF))).hasNext()) {
                    object = ((J9MemTagIterator)object2).next();
                    l = ((AbstractPointer)object).longValue() - j9MemTagPointer.longValue();
                }
                object2 = j9MemTagPointer.callSite();
                j9MemTagIterator.moveCurrentSearchAddress(l);
                object = (J9DbgExtMemStats)linkedHashMap.get(object2);
                if (object == null) {
                    linkedHashMap.put((U8Pointer)object2, new J9DbgExtMemStats(j9MemTagPointer.allocSize().longValue()));
                    continue;
                }
                ((J9DbgExtMemStats)object).incrementTotalBlocksAllocated();
                ((J9DbgExtMemStats)object).addTotalBytesAllocated(j9MemTagPointer.allocSize().longValue());
            }
            catch (CorruptDataException corruptDataException) {
                this.out.println("Unexpected CDE reading contents of " + Long.toHexString(j9MemTagPointer.getAddress()));
                corruptDataException.printStackTrace(this.out);
            }
        }
        return linkedHashMap;
    }

    @Override
    public void corruptData(String string, CorruptDataException corruptDataException, boolean bl) {
        if (corruptDataException instanceof J9MemTagHelper.J9MemTagCheckError) {
            J9MemTagHelper.J9MemTagCheckError j9MemTagCheckError = (J9MemTagHelper.J9MemTagCheckError)corruptDataException;
            this.out.println("J9MemTag check failed at " + Long.toHexString(j9MemTagCheckError.getAddress()) + ": " + string + " :" + corruptDataException.getMessage());
        } else {
            corruptDataException.printStackTrace(this.out);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void printCallsitesTable(Map<U8Pointer, J9DbgExtMemStats> map, int n) throws DDRInteractiveCommandException {
        Iterator<Object> iterator;
        String string;
        this.out.println("  total alloc  | largest");
        this.out.println("blocks | bytes | bytes | callsite");
        this.out.println("-------+-------+-------+-------+-------+-------+-------+-------+-------+-------");
        final HashMap<U8Pointer, String> hashMap = new HashMap<U8Pointer, String>();
        for (U8Pointer object2 : map.keySet()) {
            string = J9MemTagCommands.getCString(object2);
            hashMap.put(object2, string);
        }
        if (1 == n) {
            iterator = map.entrySet().iterator();
        } else {
            void var5_8;
            if (2 == n) {
                Comparator<Map.Entry<U8Pointer, J9DbgExtMemStats>> comparator = new Comparator<Map.Entry<U8Pointer, J9DbgExtMemStats>>(){

                    @Override
                    public int compare(Map.Entry<U8Pointer, J9DbgExtMemStats> entry, Map.Entry<U8Pointer, J9DbgExtMemStats> entry2) {
                        String string = (String)hashMap.get(entry.getKey());
                        String string2 = (String)hashMap.get(entry2.getKey());
                        return string.compareTo(string2);
                    }
                };
            } else if (3 == n) {
                Comparator<Map.Entry<U8Pointer, J9DbgExtMemStats>> comparator = new Comparator<Map.Entry<U8Pointer, J9DbgExtMemStats>>(){

                    @Override
                    public int compare(Map.Entry<U8Pointer, J9DbgExtMemStats> entry, Map.Entry<U8Pointer, J9DbgExtMemStats> entry2) {
                        long l = entry.getValue().getTotalBytesAllocated();
                        long l2 = entry2.getValue().getTotalBytesAllocated();
                        return Long.compare(l2, l);
                    }
                };
            } else {
                throw new DDRInteractiveCommandException("Unknown sort type: " + n);
            }
            iterator = map.entrySet().stream().sorted(var5_8).iterator();
        }
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            string = (String)hashMap.get(entry.getKey());
            J9DbgExtMemStats j9DbgExtMemStats = (J9DbgExtMemStats)entry.getValue();
            this.out.format("%7d %7d %7d %s%n", j9DbgExtMemStats.getTotalBlocksAllocated(), j9DbgExtMemStats.getTotalBytesAllocated(), j9DbgExtMemStats.getLargestBlockAllocated(), string);
        }
        this.out.println("-------+-------+-------+-------+-------+-------+-------+-------+-------+-------");
    }

    static String getCString(U8Pointer u8Pointer) {
        try {
            return u8Pointer.getCStringAtOffset(0L);
        }
        catch (CorruptDataException corruptDataException) {
            String string;
            block6: {
                string = "<unknown-module>";
                try {
                    long l = u8Pointer.getAddress();
                    IProcess iProcess = DataType.getProcess();
                    Collection<? extends IModule> collection = iProcess.getModules();
                    for (IModule iModule : collection) {
                        for (IMemoryRange iMemoryRange : iModule.getMemoryRanges()) {
                            if (!iMemoryRange.contains(l)) continue;
                            string = iModule.getName();
                            break block6;
                        }
                    }
                }
                catch (CorruptDataException corruptDataException2) {
                    // empty catch block
                }
            }
            return string + ":" + u8Pointer.getHexAddress();
        }
    }

    private static boolean regexMatches(J9MemTagPointer j9MemTagPointer, long l, String string) {
        U8Pointer u8Pointer;
        try {
            u8Pointer = j9MemTagPointer.callSite();
        }
        catch (CorruptDataException corruptDataException) {
            return false;
        }
        String string2 = J9MemTagCommands.getCString(u8Pointer);
        return WildCard.wildcardMatch(l, string, string2);
    }

    private static final class AllocSizeComparator
    implements Comparator<MemTagEntry> {
        private AllocSizeComparator() {
        }

        @Override
        public int compare(MemTagEntry memTagEntry, MemTagEntry memTagEntry2) {
            return Long.compare(memTagEntry2.getAllocSize(), memTagEntry.getAllocSize());
        }
    }

    private static final class NameComparator
    implements Comparator<MemTagEntry> {
        private final Map<U8Pointer, String> cache = new HashMap<U8Pointer, String>();

        NameComparator() {
        }

        private String getCallSiteName(MemTagEntry memTagEntry) {
            String string;
            try {
                U8Pointer u8Pointer = memTagEntry.getHeader().callSite();
                string = this.cache.get(u8Pointer);
                if (string == null) {
                    string = J9MemTagCommands.getCString(u8Pointer);
                    this.cache.put(u8Pointer, string);
                }
            }
            catch (CorruptDataException corruptDataException) {
                string = "<FAULT>";
            }
            return string;
        }

        @Override
        public int compare(MemTagEntry memTagEntry, MemTagEntry memTagEntry2) {
            String string = this.getCallSiteName(memTagEntry);
            String string2 = this.getCallSiteName(memTagEntry2);
            return string.compareTo(string2);
        }
    }

    private static final class MemTagEntry {
        private final J9MemTagPointer header;
        private final long allocSize;

        public MemTagEntry(J9MemTagPointer j9MemTagPointer, long l) {
            this.header = j9MemTagPointer;
            this.allocSize = l;
        }

        public J9MemTagPointer getHeader() {
            return this.header;
        }

        public long getAllocSize() {
            return this.allocSize;
        }
    }

    private static final class J9DbgExtMemStats {
        private long totalBlocksAllocated;
        private long totalBytesAllocated;
        private long largestBlockAllocated;

        public J9DbgExtMemStats(long l) {
            this.totalBytesAllocated = l;
            this.totalBlocksAllocated = 1L;
            this.largestBlockAllocated = l;
        }

        public void incrementTotalBlocksAllocated() {
            ++this.totalBlocksAllocated;
        }

        public void addTotalBytesAllocated(long l) {
            this.totalBytesAllocated += l;
            if (l > this.largestBlockAllocated) {
                this.largestBlockAllocated = l;
            }
        }

        public long getTotalBlocksAllocated() {
            return this.totalBlocksAllocated;
        }

        public long getTotalBytesAllocated() {
            return this.totalBytesAllocated;
        }

        public long getLargestBlockAllocated() {
            return this.largestBlockAllocated;
        }
    }
}

