/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive.gccheck;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.InvalidDataTypeException;
import com.ibm.j9ddr.vm29.j9.DataType;
import com.ibm.j9ddr.vm29.j9.J9ObjectFieldOffset;
import com.ibm.j9ddr.vm29.j9.J9ObjectFieldOffsetIterator;
import com.ibm.j9ddr.vm29.j9.ObjectAccessBarrier;
import com.ibm.j9ddr.vm29.j9.ObjectModel;
import com.ibm.j9ddr.vm29.j9.gc.GCClassIterator;
import com.ibm.j9ddr.vm29.j9.gc.GCClassIteratorClassSlots;
import com.ibm.j9ddr.vm29.j9.gc.GCExtensions;
import com.ibm.j9ddr.vm29.j9.gc.GCHeapLinkedFreeHeader;
import com.ibm.j9ddr.vm29.j9.gc.GCHeapRegionDescriptor;
import com.ibm.j9ddr.vm29.j9.gc.GCHeapRegionManager;
import com.ibm.j9ddr.vm29.j9.gc.GCObjectIterator;
import com.ibm.j9ddr.vm29.j9.gc.GCScavengerForwardedHeader;
import com.ibm.j9ddr.vm29.j9.gc.GCVMThreadListIterator;
import com.ibm.j9ddr.vm29.pointer.AbstractPointer;
import com.ibm.j9ddr.vm29.pointer.ObjectReferencePointer;
import com.ibm.j9ddr.vm29.pointer.PointerPointer;
import com.ibm.j9ddr.vm29.pointer.U8Pointer;
import com.ibm.j9ddr.vm29.pointer.VoidPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm29.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9IndexableObjectPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9JavaStackPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9MemorySegmentPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9VMThreadPointer;
import com.ibm.j9ddr.vm29.pointer.generated.MM_GCExtensionsPointer;
import com.ibm.j9ddr.vm29.pointer.generated.MM_HeapRegionManagerPointer;
import com.ibm.j9ddr.vm29.pointer.generated.MM_OwnableSynchronizerObjectListPointer;
import com.ibm.j9ddr.vm29.pointer.generated.MM_SublistPuddlePointer;
import com.ibm.j9ddr.vm29.pointer.generated.MM_UnfinalizedObjectListPointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9ClassHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9IndexableObjectHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9ObjectHelper;
import com.ibm.j9ddr.vm29.structure.J9Class;
import com.ibm.j9ddr.vm29.structure.J9JavaAccessFlags;
import com.ibm.j9ddr.vm29.structure.J9JavaClassFlags;
import com.ibm.j9ddr.vm29.structure.J9MemorySegment;
import com.ibm.j9ddr.vm29.structure.J9Object;
import com.ibm.j9ddr.vm29.structure.J9ROMFieldOffsetWalkState;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.gccheck.Check;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.gccheck.CheckBase;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.gccheck.CheckCycle;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.gccheck.CheckElement;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.gccheck.CheckError;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.gccheck.CheckReporter;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.gccheck.SegmentTree;
import com.ibm.j9ddr.vm29.types.IDATA;
import com.ibm.j9ddr.vm29.types.Scalar;
import com.ibm.j9ddr.vm29.types.U32;
import com.ibm.j9ddr.vm29.types.UDATA;
import java.util.Arrays;
import java.util.Iterator;

class CheckEngine {
    private J9JavaVMPointer _javaVM;
    private CheckReporter _reporter;
    private CheckCycle _cycle;
    private Check _currentCheck;
    private CheckElement _lastHeapObject1 = new CheckElement();
    private CheckElement _lastHeapObject2 = new CheckElement();
    private CheckElement _lastHeapObject3 = new CheckElement();
    private SegmentTree _classSegmentsTree;
    private static final int CLASS_CACHE_SIZE = 19;
    private J9ClassPointer[] _checkedClassCache = new J9ClassPointer[19];
    private J9ClassPointer[] _checkedClassCacheAllowUndead = new J9ClassPointer[19];
    private static final int OBJECT_CACHE_SIZE = 61;
    private J9ObjectPointer[] _checkedObjectCache = new J9ObjectPointer[61];
    private static final int UNINITIALIZED_SIZE = -1;
    private int _ownableSynchronizerObjectCountOnList = -1;
    private int _ownableSynchronizerObjectCountOnHeap = -1;
    private boolean _needVerifyOwnableSynchronizerConsistency = false;
    private GCHeapRegionManager _hrm;

    public CheckEngine(J9JavaVMPointer j9JavaVMPointer, CheckReporter checkReporter) throws CorruptDataException {
        this._javaVM = j9JavaVMPointer;
        this._reporter = checkReporter;
        MM_HeapRegionManagerPointer mM_HeapRegionManagerPointer = MM_GCExtensionsPointer.cast(this._javaVM.gcExtensions()).heapRegionManager();
        this._hrm = GCHeapRegionManager.fromHeapRegionManager(mM_HeapRegionManagerPointer);
    }

    public J9JavaVMPointer getJavaVM() {
        return this._javaVM;
    }

    public CheckReporter getReporter() {
        return this._reporter;
    }

    public void clearPreviousObjects() {
        this._lastHeapObject1.setNone();
        this._lastHeapObject2.setNone();
        this._lastHeapObject3.setNone();
    }

    public void pushPreviousObject(J9ObjectPointer j9ObjectPointer) {
        this._lastHeapObject3.copyFrom(this._lastHeapObject2);
        this._lastHeapObject2.copyFrom(this._lastHeapObject1);
        this._lastHeapObject1.setObject(j9ObjectPointer);
    }

    public void pushPreviousClass(J9ClassPointer j9ClassPointer) {
        this._lastHeapObject3.copyFrom(this._lastHeapObject2);
        this._lastHeapObject2.copyFrom(this._lastHeapObject1);
        this._lastHeapObject1.setClazz(j9ClassPointer);
    }

    public boolean isMidscavengeFlagSet() {
        return (this._cycle.getMiscFlags() & 0x10000) != 0;
    }

    public boolean isScavengerBackoutFlagSet() {
        return (this._cycle.getMiscFlags() & 0x20) != 0;
    }

    public void reportForwardedObject(J9ObjectPointer j9ObjectPointer, J9ObjectPointer j9ObjectPointer2) {
        if ((this._cycle.getMiscFlags() & 1) != 0) {
            this._reporter.reportForwardedObject(j9ObjectPointer, j9ObjectPointer2);
        }
    }

    public int checkObjectHeap(J9ObjectPointer j9ObjectPointer, GCHeapRegionDescriptor gCHeapRegionDescriptor) {
        Object object;
        int n = 0;
        boolean bl = false;
        boolean bl2 = false;
        J9ClassPointer j9ClassPointer = null;
        try {
            if (ObjectModel.isDeadObject(j9ObjectPointer)) {
                n = this.checkJ9LinkedFreeHeader(GCHeapLinkedFreeHeader.fromJ9Object(j9ObjectPointer), gCHeapRegionDescriptor, this._cycle.getCheckFlags());
                if (0 != n) {
                    CheckError checkError = new CheckError(j9ObjectPointer, this._cycle, this._currentCheck, "Object", n, this._cycle.nextErrorCount());
                    this._reporter.report(checkError);
                    if (45 != n && 46 != n && 47 != n) {
                        this._reporter.reportHeapWalkError(checkError, this._lastHeapObject1, this._lastHeapObject2, this._lastHeapObject3);
                        return 1;
                    }
                }
                return 0;
            }
        }
        catch (CorruptDataException corruptDataException) {
            CheckError checkError = new CheckError(j9ObjectPointer, this._cycle, this._currentCheck, "Object ", Integer.MAX_VALUE, this._cycle.nextErrorCount());
            this._reporter.report(checkError);
            return 1;
        }
        try {
            bl2 = ObjectModel.isIndexable(j9ObjectPointer);
            j9ClassPointer = J9ObjectHelper.clazz(j9ObjectPointer);
            n = this.checkJ9Object(j9ObjectPointer, gCHeapRegionDescriptor, this._cycle.getCheckFlags());
        }
        catch (CorruptDataException corruptDataException) {
            CheckError checkError = new CheckError(j9ObjectPointer, this._cycle, this._currentCheck, "Object ", Integer.MAX_VALUE, this._cycle.nextErrorCount());
            this._reporter.report(checkError);
            return 1;
        }
        if (0 != n) {
            String string = bl2 ? "IObject " : "Object ";
            CheckError checkError = new CheckError(j9ObjectPointer, this._cycle, this._currentCheck, string, n, this._cycle.nextErrorCount());
            this._reporter.report(checkError);
            if (48 != n) {
                this._reporter.reportHeapWalkError(checkError, this._lastHeapObject1, this._lastHeapObject2, this._lastHeapObject3);
                return 1;
            }
            return 0;
        }
        try {
            if (this.needVerifyOwnableSynchronizerConsistency() && J9Object.OBJECT_HEADER_SHAPE_MIXED == (long)ObjectModel.getClassShape(j9ClassPointer).intValue() && !J9ClassHelper.classFlags(j9ClassPointer).bitAnd(J9JavaAccessFlags.J9AccClassOwnableSynchronizer).eq(0L)) {
                if (ObjectAccessBarrier.isObjectInOwnableSynchronizerList(j9ObjectPointer).isNull()) {
                    object = new CheckError(j9ObjectPointer, this._cycle, this._currentCheck, "Object ", 42, this._cycle.nextErrorCount());
                    this._reporter.report((CheckError)object);
                } else {
                    ++this._ownableSynchronizerObjectCountOnHeap;
                }
            }
        }
        catch (CorruptDataException corruptDataException) {
            CheckError checkError = new CheckError(j9ObjectPointer, this._cycle, this._currentCheck, "Object ", Integer.MAX_VALUE, this._cycle.nextErrorCount());
            this._reporter.report(checkError);
            return 1;
        }
        if (0 == n) {
            VoidPointer voidPointer;
            J9ObjectPointer j9ObjectPointer2;
            GCObjectIterator gCObjectIterator;
            try {
                object = GCObjectIterator.fromJ9Object(j9ObjectPointer, true);
                gCObjectIterator = GCObjectIterator.fromJ9Object(j9ObjectPointer, true);
            }
            catch (CorruptDataException corruptDataException) {
                CheckError checkError = new CheckError(j9ObjectPointer, this._cycle, this._currentCheck, "Object ", Integer.MAX_VALUE, this._cycle.nextErrorCount());
                this._reporter.report(checkError);
                return 1;
            }
            while (((GCObjectIterator)object).hasNext() && 0 == (n = this.checkSlotObjectHeap(j9ObjectPointer2 = ((GCObjectIterator)object).next(), ObjectReferencePointer.cast(voidPointer = gCObjectIterator.nextAddress()), gCHeapRegionDescriptor, j9ObjectPointer))) {
            }
        }
        if (0 == n) {
            int n2 = (int)(j9ObjectPointer.getAddress() % 61L);
            this._checkedObjectCache[n2] = j9ObjectPointer;
        }
        return n;
    }

    public int checkSlotObjectHeap(J9ObjectPointer j9ObjectPointer, ObjectReferencePointer objectReferencePointer, GCHeapRegionDescriptor gCHeapRegionDescriptor, J9ObjectPointer j9ObjectPointer2) {
        if (j9ObjectPointer.isNull()) {
            return 0;
        }
        int n = this.checkObjectIndirect(j9ObjectPointer);
        if ((this._cycle.getMiscFlags() & 0x8000) != 0) {
            switch (n) {
                case 0: 
                case 1: 
                case 6: {
                    break;
                }
                case 4: {
                    break;
                }
                default: {
                    return 0;
                }
            }
        }
        boolean bl = false;
        boolean bl2 = false;
        try {
            bl = ObjectModel.isIndexable(j9ObjectPointer2);
            bl2 = GCExtensions.scavengerEnabled();
        }
        catch (CorruptDataException corruptDataException) {
            CheckError checkError = new CheckError(j9ObjectPointer, this._cycle, this._currentCheck, "Object ", Integer.MAX_VALUE, this._cycle.nextErrorCount());
            this._reporter.report(checkError);
            return 1;
        }
        if (0 != n) {
            String string = bl ? "IObject " : "Object ";
            CheckError checkError = new CheckError(j9ObjectPointer2, objectReferencePointer, this._cycle, this._currentCheck, string, n, this._cycle.nextErrorCount());
            this._reporter.report(checkError);
            return 0;
        }
        if (J9BuildFlags.gc_generational && bl2) {
            GCHeapRegionDescriptor gCHeapRegionDescriptor2 = ObjectModel.findRegionForPointer(this._javaVM, this._hrm, j9ObjectPointer, gCHeapRegionDescriptor);
            if (gCHeapRegionDescriptor2 == null) {
                return 4;
            }
            if (j9ObjectPointer.notNull()) {
                boolean bl3;
                boolean bl4;
                UDATA uDATA;
                UDATA uDATA2;
                try {
                    uDATA2 = gCHeapRegionDescriptor.getTypeFlags();
                    uDATA = gCHeapRegionDescriptor2.getTypeFlags();
                    bl4 = ObjectModel.isRemembered(j9ObjectPointer2);
                    bl3 = ObjectModel.isOld(j9ObjectPointer);
                }
                catch (CorruptDataException corruptDataException) {
                    CheckError checkError = new CheckError(j9ObjectPointer2, this._cycle, this._currentCheck, "Object ", Integer.MAX_VALUE, this._cycle.nextErrorCount());
                    this._reporter.report(checkError);
                    return 1;
                }
                if (uDATA2.allBitsIn(J9MemorySegment.MEMORY_TYPE_OLD) && uDATA.allBitsIn(J9MemorySegment.MEMORY_TYPE_NEW) && !bl4) {
                    String string = bl ? "IObject " : "Object ";
                    CheckError checkError = new CheckError(j9ObjectPointer2, objectReferencePointer, this._cycle, this._currentCheck, string, 17, this._cycle.nextErrorCount());
                    this._reporter.report(checkError);
                    return 0;
                }
                if (uDATA2.allBitsIn(J9MemorySegment.MEMORY_TYPE_OLD) && !bl3 && !bl4) {
                    String string = bl ? "IObject " : "Object ";
                    CheckError checkError = new CheckError(j9ObjectPointer2, objectReferencePointer, this._cycle, this._currentCheck, string, 20, this._cycle.nextErrorCount());
                    this._reporter.report(checkError);
                    return 0;
                }
            }
        }
        return 0;
    }

    private int checkObjectIndirect(J9ObjectPointer j9ObjectPointer) {
        int n;
        if (j9ObjectPointer.isNull()) {
            return 0;
        }
        int n2 = (int)Math.abs(j9ObjectPointer.getAddress() % 61L);
        if (this._checkedObjectCache[n2] == j9ObjectPointer) {
            return 0;
        }
        J9ObjectPointer[] j9ObjectPointerArray = new J9ObjectPointer[]{J9ObjectPointer.NULL};
        GCHeapRegionDescriptor[] gCHeapRegionDescriptorArray = new GCHeapRegionDescriptor[1];
        try {
            n = this.checkJ9ObjectPointer(j9ObjectPointer, j9ObjectPointerArray, gCHeapRegionDescriptorArray);
            if (0 == n) {
                n = this.checkJ9Object(j9ObjectPointerArray[0], gCHeapRegionDescriptorArray[0], this._cycle.getCheckFlags());
            }
        }
        catch (CorruptDataException corruptDataException) {
            n = Integer.MAX_VALUE;
        }
        if (0 == n) {
            this._checkedObjectCache[n2] = j9ObjectPointer;
        }
        return n;
    }

    private int checkJ9ObjectPointer(J9ObjectPointer j9ObjectPointer, J9ObjectPointer[] j9ObjectPointerArray, GCHeapRegionDescriptor[] gCHeapRegionDescriptorArray) throws CorruptDataException {
        GCScavengerForwardedHeader gCScavengerForwardedHeader;
        j9ObjectPointerArray[0] = j9ObjectPointer;
        if (j9ObjectPointer.isNull()) {
            return 0;
        }
        gCHeapRegionDescriptorArray[0] = ObjectModel.findRegionForPointer(this._javaVM, this._hrm, j9ObjectPointer, gCHeapRegionDescriptorArray[0]);
        if (gCHeapRegionDescriptorArray[0] == null) {
            DataType dataType;
            GCVMThreadListIterator gCVMThreadListIterator = GCVMThreadListIterator.from();
            while (gCVMThreadListIterator.hasNext()) {
                dataType = gCVMThreadListIterator.next();
                if (!this.isObjectOnStack(j9ObjectPointer, ((J9VMThreadPointer)dataType).stackObject())) continue;
                return 6;
            }
            dataType = J9ObjectHelper.rawClazz(j9ObjectPointer);
            if (((Scalar)dataType).eq(0x99669966L)) {
                return 41;
            }
            return 4;
        }
        if (!gCHeapRegionDescriptorArray[0].containsObjects()) {
            return 3;
        }
        if (j9ObjectPointer.anyBitsIn(CheckBase.J9MODRON_GCCHK_J9OBJECT_ALIGNMENT_MASK)) {
            return 1;
        }
        if (this.isMidscavengeFlagSet() && (GCExtensions.isVLHGC() || gCHeapRegionDescriptorArray[0].getTypeFlags().allBitsIn(J9MemorySegment.MEMORY_TYPE_NEW)) && (gCScavengerForwardedHeader = GCScavengerForwardedHeader.fromJ9Object(j9ObjectPointer)).isForwardedPointer()) {
            j9ObjectPointerArray[0] = gCScavengerForwardedHeader.getForwardedObject();
            this.reportForwardedObject(j9ObjectPointer, j9ObjectPointerArray[0]);
            j9ObjectPointer = j9ObjectPointerArray[0];
            gCHeapRegionDescriptorArray[0] = ObjectModel.findRegionForPointer(this._javaVM, this._hrm, j9ObjectPointer, gCHeapRegionDescriptorArray[0]);
            if (gCHeapRegionDescriptorArray[0] == null) {
                GCVMThreadListIterator gCVMThreadListIterator = GCVMThreadListIterator.from();
                while (gCVMThreadListIterator.hasNext()) {
                    J9VMThreadPointer j9VMThreadPointer = gCVMThreadListIterator.next();
                    if (!this.isObjectOnStack(j9ObjectPointer, j9VMThreadPointer.stackObject())) continue;
                    return 6;
                }
                return 4;
            }
            if (!gCHeapRegionDescriptorArray[0].containsObjects()) {
                return 3;
            }
            if (j9ObjectPointer.anyBitsIn(CheckBase.J9MODRON_GCCHK_J9OBJECT_ALIGNMENT_MASK)) {
                return 1;
            }
        }
        if (this.isScavengerBackoutFlagSet() && (gCScavengerForwardedHeader = GCScavengerForwardedHeader.fromJ9Object(j9ObjectPointer)).isReverseForwardedPointer()) {
            j9ObjectPointerArray[0] = gCScavengerForwardedHeader.getReverseForwardedPointer();
            this.reportForwardedObject(j9ObjectPointer, j9ObjectPointerArray[0]);
            j9ObjectPointer = j9ObjectPointerArray[0];
            gCHeapRegionDescriptorArray[0] = ObjectModel.findRegionForPointer(this._javaVM, this._hrm, j9ObjectPointer, gCHeapRegionDescriptorArray[0]);
            if (gCHeapRegionDescriptorArray[0] == null) {
                return 4;
            }
            if (!gCHeapRegionDescriptorArray[0].containsObjects()) {
                return 3;
            }
            if (!gCHeapRegionDescriptorArray[0].getTypeFlags().allBitsIn(J9MemorySegment.MEMORY_TYPE_NEW)) {
                return 49;
            }
            if (j9ObjectPointer.anyBitsIn(CheckBase.J9MODRON_GCCHK_J9OBJECT_ALIGNMENT_MASK)) {
                return 1;
            }
        }
        long l = -1L;
        try {
            l = ObjectModel.getClassShape(J9ObjectHelper.clazz(j9ObjectPointer)).longValue();
        }
        catch (CorruptDataException corruptDataException) {
            // empty catch block
        }
        if (l == J9Object.OBJECT_HEADER_SHAPE_DOUBLES) {
            J9IndexableObjectPointer j9IndexableObjectPointer = J9IndexableObjectPointer.cast(j9ObjectPointer);
            int n = 0;
            VoidPointer voidPointer = VoidPointer.NULL;
            try {
                n = ObjectModel.getSizeInElements(j9ObjectPointer).intValue();
            }
            catch (InvalidDataTypeException invalidDataTypeException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (0 != n) {
                voidPointer = ObjectModel.getElementAddress(j9IndexableObjectPointer, 0, 8);
                if (voidPointer.anyBitsIn(7L)) {
                    return 2;
                }
                voidPointer = ObjectModel.getElementAddress(j9IndexableObjectPointer, n - 1, 8);
                if (voidPointer.anyBitsIn(7L)) {
                    return 2;
                }
            }
        }
        return 0;
    }

    public int checkSlot(PointerPointer pointerPointer, VoidPointer voidPointer, int n) {
        try {
            J9ObjectPointer j9ObjectPointer = J9ObjectPointer.cast(pointerPointer.at(0L));
            int n2 = this.checkObjectIndirect(j9ObjectPointer);
            if (0 != n2) {
                CheckError checkError = new CheckError(voidPointer, pointerPointer, this._cycle, this._currentCheck, n2, this._cycle.nextErrorCount(), n);
                this._reporter.report(checkError);
            }
        }
        catch (CorruptDataException corruptDataException) {
            CheckError checkError = new CheckError(voidPointer, pointerPointer, this._cycle, this._currentCheck, Integer.MAX_VALUE, this._cycle.nextErrorCount(), n);
            this._reporter.report(checkError);
        }
        return 0;
    }

    public int checkSlotVMThread(PointerPointer pointerPointer, VoidPointer voidPointer, int n, int n2) {
        try {
            J9ObjectPointer j9ObjectPointer = J9ObjectPointer.cast(pointerPointer.at(0L));
            int n3 = this.checkObjectIndirect(j9ObjectPointer);
            if (3 == n2 && 6 == n3) {
                n3 = this.checkStackObject(j9ObjectPointer);
            }
            if (0 != n3) {
                CheckError checkError = new CheckError(voidPointer, pointerPointer, this._cycle, this._currentCheck, n3, this._cycle.nextErrorCount(), n);
                this._reporter.report(checkError);
            }
        }
        catch (CorruptDataException corruptDataException) {
            CheckError checkError = new CheckError(voidPointer, pointerPointer, this._cycle, this._currentCheck, Integer.MAX_VALUE, this._cycle.nextErrorCount(), n);
            this._reporter.report(checkError);
        }
        return 0;
    }

    public int checkSlotStack(PointerPointer pointerPointer, J9VMThreadPointer j9VMThreadPointer, VoidPointer voidPointer) {
        try {
            J9ObjectPointer j9ObjectPointer = J9ObjectPointer.cast(pointerPointer.at(0L));
            int n = this.checkObjectIndirect(j9ObjectPointer);
            if (6 == n) {
                n = this.checkStackObject(j9ObjectPointer);
            }
            if (0 != n) {
                CheckError checkError = new CheckError(j9VMThreadPointer, pointerPointer, voidPointer, this._cycle, this._currentCheck, n, this._cycle.nextErrorCount());
                this._reporter.report(checkError);
                return 2;
            }
        }
        catch (CorruptDataException corruptDataException) {
            CheckError checkError = new CheckError(j9VMThreadPointer, pointerPointer, voidPointer, this._cycle, this._currentCheck, Integer.MAX_VALUE, this._cycle.nextErrorCount());
            this._reporter.report(checkError);
            return 2;
        }
        return 0;
    }

    private int checkStackObject(J9ObjectPointer j9ObjectPointer) {
        if (j9ObjectPointer.isNull()) {
            return 0;
        }
        if (j9ObjectPointer.anyBitsIn(CheckBase.J9MODRON_GCCHK_ONSTACK_ALIGNMENT_MASK)) {
            return 1;
        }
        if ((this._cycle.getCheckFlags() & 1) != 0) {
            try {
                int n = this.checkJ9ClassPointer(J9ObjectHelper.clazz(j9ObjectPointer));
                if (0 != n) {
                    return n;
                }
            }
            catch (CorruptDataException corruptDataException) {
                return Integer.MAX_VALUE;
            }
        }
        if ((this._cycle.getCheckFlags() & 8) != 0) {
            try {
                if (!this.checkIndexableFlag(j9ObjectPointer)) {
                    return 13;
                }
            }
            catch (CorruptDataException corruptDataException) {
                return Integer.MAX_VALUE;
            }
        }
        return 0;
    }

    public int checkSlotRememberedSet(PointerPointer pointerPointer, MM_SublistPuddlePointer mM_SublistPuddlePointer) {
        try {
            int n;
            J9ObjectPointer j9ObjectPointer = J9ObjectPointer.cast(pointerPointer.at(0L));
            if (this.isMidscavengeFlagSet() && j9ObjectPointer.anyBitsIn(1L)) {
                j9ObjectPointer = j9ObjectPointer.untag(1L);
            }
            if (0 != (n = this.checkObjectIndirect(j9ObjectPointer))) {
                CheckError checkError = new CheckError(mM_SublistPuddlePointer, pointerPointer, this._cycle, this._currentCheck, n, this._cycle.nextErrorCount());
                this._reporter.report(checkError);
                return 0;
            }
            if (j9ObjectPointer.notNull()) {
                Object object;
                GCHeapRegionDescriptor gCHeapRegionDescriptor = ObjectModel.findRegionForPointer(this._javaVM, this._hrm, j9ObjectPointer, null);
                if (gCHeapRegionDescriptor == null) {
                    CheckError checkError = new CheckError(mM_SublistPuddlePointer, pointerPointer, this._cycle, this._currentCheck, 4, this._cycle.nextErrorCount());
                    this._reporter.report(checkError);
                    return 0;
                }
                if (gCHeapRegionDescriptor.getTypeFlags().allBitsIn(J9MemorySegment.MEMORY_TYPE_NEW)) {
                    CheckError checkError = new CheckError(mM_SublistPuddlePointer, pointerPointer, this._cycle, this._currentCheck, 18, this._cycle.nextErrorCount());
                    this._reporter.report(checkError);
                    return 0;
                }
                boolean bl = false;
                if (this.isScavengerBackoutFlagSet() && ((GCScavengerForwardedHeader)(object = GCScavengerForwardedHeader.fromJ9Object(j9ObjectPointer))).isReverseForwardedPointer()) {
                    bl = true;
                }
                if (!(bl || ObjectModel.isOld(j9ObjectPointer) && ObjectModel.isRemembered(j9ObjectPointer))) {
                    object = new CheckError(mM_SublistPuddlePointer, pointerPointer, this._cycle, this._currentCheck, 19, this._cycle.nextErrorCount());
                    this._reporter.report((CheckError)object);
                    this._reporter.reportObjectHeader((CheckError)object, j9ObjectPointer, null);
                    return 0;
                }
            }
        }
        catch (CorruptDataException corruptDataException) {
            CheckError checkError = new CheckError(mM_SublistPuddlePointer, pointerPointer, this._cycle, this._currentCheck, Integer.MAX_VALUE, this._cycle.nextErrorCount());
            this._reporter.report(checkError);
        }
        return 0;
    }

    public int checkSlotPool(PointerPointer pointerPointer, VoidPointer voidPointer) {
        try {
            J9ObjectPointer j9ObjectPointer = J9ObjectPointer.cast(pointerPointer.at(0L));
            int n = this.checkObjectIndirect(j9ObjectPointer);
            if (0 != n) {
                CheckError checkError = new CheckError(voidPointer, pointerPointer, this._cycle, this._currentCheck, n, this._cycle.nextErrorCount(), 0);
                this._reporter.report(checkError);
            }
        }
        catch (CorruptDataException corruptDataException) {
            CheckError checkError = new CheckError(voidPointer, pointerPointer, this._cycle, this._currentCheck, Integer.MAX_VALUE, this._cycle.nextErrorCount(), 0);
            this._reporter.report(checkError);
        }
        return 0;
    }

    public int checkClassHeap(J9ClassPointer j9ClassPointer, J9MemorySegmentPointer j9MemorySegmentPointer) {
        try {
            Object object;
            AbstractPointer abstractPointer;
            Object object2;
            int n = this.checkJ9Class(j9ClassPointer, j9MemorySegmentPointer, this._cycle.getCheckFlags());
            if (0 != n) {
                object2 = new CheckError(j9ClassPointer, this._cycle, this._currentCheck, "Class ", n, this._cycle.nextErrorCount());
                this._reporter.report((CheckError)object2);
            }
            object2 = GCClassIterator.fromJ9Class(j9ClassPointer);
            while (((GCClassIterator)object2).hasNext()) {
                abstractPointer = PointerPointer.cast(((GCClassIterator)object2).nextAddress());
                object = J9ObjectPointer.cast(((PointerPointer)abstractPointer).at(0L));
                n = this.checkObjectIndirect((J9ObjectPointer)object);
                if (0 != n) {
                    String string = "";
                    switch (((GCClassIterator)object2).getState()) {
                        case 1: {
                            string = "static ";
                            break;
                        }
                        case 2: {
                            string = "constant ";
                            break;
                        }
                        case 3: {
                            string = "slots ";
                        }
                    }
                    CheckError checkError = new CheckError(j9ClassPointer, (PointerPointer)abstractPointer, this._cycle, this._currentCheck, string, n, this._cycle.nextErrorCount());
                    this._reporter.report(checkError);
                    return 0;
                }
                if (!GCExtensions.isStandardGC() || !((AbstractPointer)object).notNull() || ObjectModel.isOld((J9ObjectPointer)object) || ObjectModel.isRemembered(j9ClassPointer.classObject())) continue;
                CheckError checkError = new CheckError(j9ClassPointer, (PointerPointer)abstractPointer, this._cycle, this._currentCheck, "Class ", 20, this._cycle.nextErrorCount());
                this._reporter.report(checkError);
                return 0;
            }
            if (0 != this.checkClassStatics(j9ClassPointer)) {
                return 0;
            }
            abstractPointer = j9ClassPointer.replacedClass();
            if (abstractPointer.notNull() && !J9ClassHelper.isSwappedOut((J9ClassPointer)abstractPointer)) {
                object = new CheckError(j9ClassPointer, j9ClassPointer.replacedClassEA(), this._cycle, this._currentCheck, "Class ", 40, this._cycle.nextErrorCount());
                this._reporter.report((CheckError)object);
                return 0;
            }
            object = GCClassIteratorClassSlots.fromJ9Class(j9ClassPointer);
            while (((GCClassIteratorClassSlots)object).hasNext()) {
                PointerPointer pointerPointer = PointerPointer.cast(((GCClassIteratorClassSlots)object).nextAddress());
                J9ClassPointer j9ClassPointer2 = J9ClassPointer.cast(pointerPointer.at(0L));
                String string = "";
                n = 0;
                switch (((GCClassIteratorClassSlots)object).getState()) {
                    case 1: {
                        if (j9ClassPointer2.notNull()) {
                            n = this.checkJ9ClassPointer(j9ClassPointer2);
                        }
                        string = "constant ";
                        break;
                    }
                    case 2: {
                        n = this.checkJ9ClassPointer(j9ClassPointer2);
                        string = "superclass ";
                        break;
                    }
                    case 3: {
                        n = this.checkJ9ClassPointer(j9ClassPointer2);
                        string = "interface ";
                        break;
                    }
                    case 4: {
                        if (j9ClassPointer2.notNull()) {
                            n = this.checkJ9ClassPointer(j9ClassPointer2);
                        }
                        string = "array class ";
                    }
                }
                if (0 == n) continue;
                CheckError checkError = new CheckError(j9ClassPointer, pointerPointer, this._cycle, this._currentCheck, string, n, this._cycle.nextErrorCount());
                this._reporter.report(checkError);
                return 0;
            }
        }
        catch (CorruptDataException corruptDataException) {
            CheckError checkError = new CheckError(j9ClassPointer, this._cycle, this._currentCheck, "Class ", Integer.MAX_VALUE, this._cycle.nextErrorCount());
            this._reporter.report(checkError);
        }
        return 0;
    }

    private int checkClassStatics(J9ClassPointer j9ClassPointer) {
        int n = 0;
        try {
            boolean bl = true;
            if (J9ClassHelper.isSwappedOut(j9ClassPointer)) {
                if (J9ClassHelper.isArrayClass(j9ClassPointer)) {
                    n = 39;
                    CheckError checkError = new CheckError(j9ClassPointer, this._cycle, this._currentCheck, "Class ", n, this._cycle.nextErrorCount());
                    this._reporter.report(checkError);
                    return n;
                }
                if (J9ClassHelper.areExtensionsEnabled() && j9ClassPointer.ramStatics().isNull()) {
                    bl = false;
                }
                try {
                    if (J9ClassHelper.extendedClassFlags(j9ClassPointer).allBitsIn(J9JavaClassFlags.J9ClassReusedStatics)) {
                        bl = false;
                    }
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
            }
            if (bl) {
                Object object;
                J9ROMClassPointer j9ROMClassPointer = j9ClassPointer.romClass();
                UDATA uDATA = new UDATA(0L);
                PointerPointer pointerPointer = PointerPointer.NULL;
                PointerPointer pointerPointer2 = PointerPointer.NULL;
                if (!j9ROMClassPointer.objectStaticCount().eq(0L)) {
                    pointerPointer = PointerPointer.cast(j9ClassPointer.ramStatics());
                    pointerPointer2 = pointerPointer.add(j9ROMClassPointer.objectStaticCount());
                }
                Iterator<J9ObjectFieldOffset> iterator = J9ObjectFieldOffsetIterator.J9ObjectFieldOffsetIteratorFor(j9ClassPointer, J9ClassHelper.superclass(j9ClassPointer), new U32(J9ROMFieldOffsetWalkState.J9VM_FIELD_OFFSET_WALK_INCLUDE_STATIC | J9ROMFieldOffsetWalkState.J9VM_FIELD_OFFSET_WALK_ONLY_OBJECT_SLOTS));
                while (iterator.hasNext()) {
                    object = iterator.next();
                    uDATA = uDATA.add(1L);
                    PointerPointer pointerPointer3 = pointerPointer.addOffset(((J9ObjectFieldOffset)object).getOffsetOrAddress());
                    if (pointerPointer3.gte(pointerPointer) && pointerPointer3.lt(pointerPointer2)) continue;
                    n = 32;
                    CheckError checkError = new CheckError(j9ClassPointer, pointerPointer3, this._cycle, this._currentCheck, "Class ", n, this._cycle.nextErrorCount());
                    this._reporter.report(checkError);
                }
                if (!uDATA.eq(j9ROMClassPointer.objectStaticCount())) {
                    n = 33;
                    object = new CheckError(j9ClassPointer, this._cycle, this._currentCheck, "Class ", n, this._cycle.nextErrorCount());
                    this._reporter.report((CheckError)object);
                }
            }
        }
        catch (CorruptDataException corruptDataException) {
            CheckError checkError = new CheckError(j9ClassPointer, this._cycle, this._currentCheck, "Class ", Integer.MAX_VALUE, this._cycle.nextErrorCount());
            this._reporter.report(checkError);
        }
        return n;
    }

    private int checkJ9Class(J9ClassPointer j9ClassPointer, J9MemorySegmentPointer j9MemorySegmentPointer, int n) throws CorruptDataException {
        UDATA uDATA;
        if (j9ClassPointer.isNull()) {
            return 0;
        }
        if (j9ClassPointer.anyBitsIn(CheckBase.J9MODRON_GCCHK_J9CLASS_ALIGNMENT_MASK)) {
            return 8;
        }
        int n2 = this.checkJ9ClassHeader(j9ClassPointer);
        if (0 != n2) {
            return n2;
        }
        n2 = this.checkJ9ClassIsNotUnloaded(j9ClassPointer);
        if (0 != n2) {
            return n2;
        }
        if ((n & 2) != 2 && (uDATA = UDATA.cast(j9MemorySegmentPointer.heapAlloc()).sub(UDATA.cast(j9ClassPointer))).lt(J9Class.SIZEOF)) {
            return 10;
        }
        return 0;
    }

    public int checkJ9ClassPointer(J9ClassPointer j9ClassPointer) throws CorruptDataException {
        return this.checkJ9ClassPointer(j9ClassPointer, false);
    }

    public int checkJ9ClassPointer(J9ClassPointer j9ClassPointer, boolean bl) throws CorruptDataException {
        IDATA iDATA;
        if (j9ClassPointer == null || j9ClassPointer.isNull()) {
            return 7;
        }
        int n = (int)(j9ClassPointer.longValue() % 19L);
        if (bl && j9ClassPointer.eq(this._checkedClassCacheAllowUndead[n])) {
            return 0;
        }
        if (j9ClassPointer.eq(this._checkedClassCache[n])) {
            return 0;
        }
        if (UDATA.cast(j9ClassPointer).anyBitsIn(CheckBase.J9MODRON_GCCHK_J9CLASS_ALIGNMENT_MASK)) {
            return 8;
        }
        J9MemorySegmentPointer j9MemorySegmentPointer = this.findSegmentForClass(j9ClassPointer);
        if (j9MemorySegmentPointer == null) {
            return 9;
        }
        if (!bl && (j9MemorySegmentPointer.type().longValue() & J9MemorySegment.MEMORY_TYPE_UNDEAD_CLASS) != 0L) {
            return 29;
        }
        int n2 = this.checkJ9ClassHeader(j9ClassPointer);
        if (0 != n2) {
            return n2;
        }
        n2 = this.checkJ9ClassIsNotUnloaded(j9ClassPointer);
        if (0 != n2) {
            return n2;
        }
        if ((this._cycle.getCheckFlags() & 2) != 0 && (iDATA = j9MemorySegmentPointer.heapAlloc().sub(U8Pointer.cast(j9ClassPointer))).lt(J9Class.SIZEOF)) {
            return 10;
        }
        if (bl) {
            this._checkedClassCacheAllowUndead[n] = j9ClassPointer;
        } else {
            this._checkedClassCache[n] = j9ClassPointer;
        }
        return 0;
    }

    private int checkJ9ClassHeader(J9ClassPointer j9ClassPointer) throws CorruptDataException {
        if (!j9ClassPointer.eyecatcher().eq(0x99669966L)) {
            return 26;
        }
        return 0;
    }

    private int checkJ9ClassIsNotUnloaded(J9ClassPointer j9ClassPointer) throws CorruptDataException {
        if (!j9ClassPointer.classDepthAndFlags().bitAnd(J9JavaAccessFlags.J9AccClassDying).eq(0L)) {
            return 48;
        }
        return 0;
    }

    private int checkJ9LinkedFreeHeader(GCHeapLinkedFreeHeader gCHeapLinkedFreeHeader, GCHeapRegionDescriptor gCHeapRegionDescriptor, int n) throws CorruptDataException {
        J9ObjectPointer j9ObjectPointer = gCHeapLinkedFreeHeader.getObject();
        if (ObjectModel.isSingleSlotDeadObject(j9ObjectPointer)) {
            return 0;
        }
        UDATA uDATA = gCHeapLinkedFreeHeader.getSize();
        if (uDATA.eq(0L)) {
            return 16;
        }
        if (uDATA.anyBitsIn(CheckBase.J9MODRON_GCCHK_J9OBJECT_ALIGNMENT_MASK)) {
            return 44;
        }
        UDATA uDATA2 = UDATA.cast(gCHeapRegionDescriptor.getLowAddress());
        UDATA uDATA3 = uDATA2.add(gCHeapRegionDescriptor.getSize());
        UDATA uDATA4 = uDATA3.sub(UDATA.cast(j9ObjectPointer));
        if (uDATA4.lt(uDATA)) {
            return 5;
        }
        GCHeapLinkedFreeHeader gCHeapLinkedFreeHeader2 = gCHeapLinkedFreeHeader.getNext();
        J9ObjectPointer j9ObjectPointer2 = gCHeapLinkedFreeHeader2.getObject();
        if (!j9ObjectPointer2.isNull()) {
            if (!ObjectModel.isDeadObject(j9ObjectPointer2)) {
                return 45;
            }
            if (uDATA2.gt(UDATA.cast(j9ObjectPointer2)) || uDATA3.lte(UDATA.cast(j9ObjectPointer2))) {
                return 46;
            }
            if (uDATA.add(UDATA.cast(j9ObjectPointer)).gt(UDATA.cast(j9ObjectPointer2)) && j9ObjectPointer.lt(j9ObjectPointer2)) {
                return 47;
            }
        }
        return 0;
    }

    private int checkJ9Object(J9ObjectPointer j9ObjectPointer, GCHeapRegionDescriptor gCHeapRegionDescriptor, int n) throws CorruptDataException {
        int n2;
        if (j9ObjectPointer.isNull()) {
            return 0;
        }
        if (!gCHeapRegionDescriptor.containsObjects()) {
            return 3;
        }
        if (j9ObjectPointer.anyBitsIn(CheckBase.J9MODRON_GCCHK_J9OBJECT_ALIGNMENT_MASK)) {
            return 1;
        }
        if ((n & 1) != 0 && 0 != (n2 = this.checkJ9ClassPointer(J9ObjectHelper.clazz(j9ObjectPointer), true))) {
            return n2;
        }
        if ((n & 2) != 0) {
            UDATA uDATA = UDATA.cast(gCHeapRegionDescriptor.getLowAddress()).add(gCHeapRegionDescriptor.getSize());
            long l = uDATA.sub(UDATA.cast(j9ObjectPointer)).longValue();
            if (l < J9ObjectHelper.headerSize()) {
                return 5;
            }
            if (ObjectModel.isIndexable(j9ObjectPointer) && l < J9IndexableObjectHelper.contiguousHeaderSize()) {
                return 5;
            }
            if (l < ObjectModel.getSizeInBytesWithHeader(j9ObjectPointer).longValue()) {
                return 5;
            }
            if ((n & 8) != 0) {
                if (!this.checkIndexableFlag(j9ObjectPointer)) {
                    return 13;
                }
                if (GCExtensions.isStandardGC()) {
                    UDATA uDATA2 = gCHeapRegionDescriptor.getTypeFlags();
                    if (uDATA2.allBitsIn(J9MemorySegment.MEMORY_TYPE_OLD)) {
                        if (!ObjectModel.isOld(j9ObjectPointer)) {
                            return 14;
                        }
                    } else if (uDATA2.allBitsIn(J9MemorySegment.MEMORY_TYPE_NEW) && ObjectModel.isOld(j9ObjectPointer)) {
                        return 15;
                    }
                }
            }
        }
        return 0;
    }

    private boolean checkIndexableFlag(J9ObjectPointer j9ObjectPointer) throws CorruptDataException {
        UDATA uDATA = ObjectModel.getClassShape(J9ObjectHelper.clazz(j9ObjectPointer));
        boolean bl = ObjectModel.isIndexable(j9ObjectPointer);
        if (uDATA.eq(J9Object.OBJECT_HEADER_SHAPE_POINTERS)) {
            return bl;
        }
        if (uDATA.eq(J9Object.OBJECT_HEADER_SHAPE_BYTES)) {
            return bl;
        }
        if (uDATA.eq(J9Object.OBJECT_HEADER_SHAPE_WORDS)) {
            return bl;
        }
        if (uDATA.eq(J9Object.OBJECT_HEADER_SHAPE_LONGS)) {
            return bl;
        }
        if (uDATA.eq(J9Object.OBJECT_HEADER_SHAPE_DOUBLES)) {
            return bl;
        }
        return !bl;
    }

    public void startCheckCycle(CheckCycle checkCycle) throws CorruptDataException {
        this._cycle = checkCycle;
        this._currentCheck = null;
        this.clearPreviousObjects();
        this.clearCheckedCache();
        this._needVerifyOwnableSynchronizerConsistency = 131072 == (this._cycle.getMiscFlags() & 0x20000);
        this.clearCountsForOwnableSynchronizerObjects();
        this.prepareForHeapWalk();
    }

    public void prepareForHeapWalk() throws CorruptDataException {
        this._classSegmentsTree = new SegmentTree(this._javaVM.classMemorySegments());
    }

    public void endCheckCycle() {
    }

    public void startNewCheck(Check check) {
        this._currentCheck = check;
        this.clearPreviousObjects();
    }

    private void clearCheckedCache() {
        Arrays.fill(this._checkedClassCache, null);
        Arrays.fill(this._checkedClassCacheAllowUndead, null);
        Arrays.fill(this._checkedObjectCache, null);
    }

    private boolean isPointerInSegment(AbstractPointer abstractPointer, J9MemorySegmentPointer j9MemorySegmentPointer) {
        try {
            return abstractPointer.gte(j9MemorySegmentPointer.heapBase()) && abstractPointer.lt(j9MemorySegmentPointer.heapAlloc());
        }
        catch (CorruptDataException corruptDataException) {
            return false;
        }
    }

    private boolean isObjectOnStack(J9ObjectPointer j9ObjectPointer, J9JavaStackPointer j9JavaStackPointer) {
        try {
            return j9ObjectPointer.lt(j9JavaStackPointer.end()) && j9ObjectPointer.gte(j9JavaStackPointer.add(1L));
        }
        catch (CorruptDataException corruptDataException) {
            return false;
        }
    }

    private J9MemorySegmentPointer findSegmentForClass(J9ClassPointer j9ClassPointer) {
        J9MemorySegmentPointer j9MemorySegmentPointer = this._classSegmentsTree.findSegment(j9ClassPointer);
        if (j9MemorySegmentPointer != null) {
            if (!this.isPointerInSegment(j9ClassPointer, j9MemorySegmentPointer)) {
                return null;
            }
            try {
                if (j9MemorySegmentPointer.type().anyBitsIn(J9MemorySegment.MEMORY_TYPE_RAM_CLASS | J9MemorySegment.MEMORY_TYPE_UNDEAD_CLASS)) {
                    return j9MemorySegmentPointer;
                }
            }
            catch (CorruptDataException corruptDataException) {
                return null;
            }
        }
        return null;
    }

    public int checkSlotUnfinalizedList(J9ObjectPointer j9ObjectPointer, MM_UnfinalizedObjectListPointer mM_UnfinalizedObjectListPointer) {
        int n = this.checkObjectIndirect(j9ObjectPointer);
        if (0 != n) {
            CheckError checkError = new CheckError(mM_UnfinalizedObjectListPointer, j9ObjectPointer, this._cycle, this._currentCheck, n, this._cycle.nextErrorCount());
            this._reporter.report(checkError);
        }
        return 0;
    }

    public int checkSlotOwnableSynchronizerList(J9ObjectPointer j9ObjectPointer, MM_OwnableSynchronizerObjectListPointer mM_OwnableSynchronizerObjectListPointer) {
        if (this.needVerifyOwnableSynchronizerConsistency()) {
            ++this._ownableSynchronizerObjectCountOnList;
        }
        try {
            int n = this.checkObjectIndirect(j9ObjectPointer);
            if (0 != n) {
                CheckError checkError = new CheckError(mM_OwnableSynchronizerObjectListPointer, j9ObjectPointer, this._cycle, this._currentCheck, n, this._cycle.nextErrorCount());
                this._reporter.report(checkError);
                this._reporter.reportHeapWalkError(checkError, this._lastHeapObject1, this._lastHeapObject2, this._lastHeapObject3);
                return 1;
            }
            J9ClassPointer j9ClassPointer = J9ObjectHelper.clazz(j9ObjectPointer);
            if (J9ClassHelper.classFlags(j9ClassPointer).bitAnd(J9JavaAccessFlags.J9AccClassOwnableSynchronizer).eq(0L)) {
                CheckError checkError = new CheckError(mM_OwnableSynchronizerObjectListPointer, j9ObjectPointer, this._cycle, this._currentCheck, 13, this._cycle.nextErrorCount());
                this._reporter.report(checkError);
            }
        }
        catch (CorruptDataException corruptDataException) {
            CheckError checkError = new CheckError(mM_OwnableSynchronizerObjectListPointer, j9ObjectPointer, this._cycle, this._currentCheck, Integer.MAX_VALUE, this._cycle.nextErrorCount());
            this._reporter.report(checkError);
            this._reporter.reportHeapWalkError(checkError, this._lastHeapObject1, this._lastHeapObject2, this._lastHeapObject3);
            return 1;
        }
        return 0;
    }

    public int checkSlotFinalizableList(J9ObjectPointer j9ObjectPointer) {
        int n = this.checkObjectIndirect(j9ObjectPointer);
        if (0 != n) {
            CheckError checkError = new CheckError((AbstractPointer)j9ObjectPointer, null, this._cycle, this._currentCheck, n, this._cycle.nextErrorCount(), 6);
            this._reporter.report(checkError);
        }
        return 0;
    }

    public void setMaxErrorsToReport(int n) {
        this._reporter.setMaxErrorsToReport(n);
    }

    public void clearCountsForOwnableSynchronizerObjects() {
        this._ownableSynchronizerObjectCountOnList = -1;
        this._ownableSynchronizerObjectCountOnHeap = -1;
    }

    public boolean verifyOwnableSynchronizerObjectCounts() {
        boolean bl = true;
        if (-1 != this._ownableSynchronizerObjectCountOnList && -1 != this._ownableSynchronizerObjectCountOnHeap && this._ownableSynchronizerObjectCountOnList != this._ownableSynchronizerObjectCountOnHeap) {
            this._reporter.println(String.format("<gc check: found count=%d of OwnableSynchronizerObjects on Heap doesn't match count=%d on lists>", this._ownableSynchronizerObjectCountOnHeap, this._ownableSynchronizerObjectCountOnList));
            bl = false;
        }
        return bl;
    }

    public void reportOwnableSynchronizerCircularReferenceError(J9ObjectPointer j9ObjectPointer, MM_OwnableSynchronizerObjectListPointer mM_OwnableSynchronizerObjectListPointer) {
        CheckError checkError = new CheckError(mM_OwnableSynchronizerObjectListPointer, j9ObjectPointer, this._cycle, this._currentCheck, 43, this._cycle.nextErrorCount());
        this._reporter.report(checkError);
        this._reporter.reportHeapWalkError(checkError, this._lastHeapObject1, this._lastHeapObject2, this._lastHeapObject3);
    }

    public void initializeOwnableSynchronizerCountOnList() {
        this._ownableSynchronizerObjectCountOnList = 0;
    }

    public void initializeOwnableSynchronizerCountOnHeap() {
        this._ownableSynchronizerObjectCountOnHeap = 0;
    }

    public boolean needVerifyOwnableSynchronizerConsistency() {
        return this._needVerifyOwnableSynchronizerConsistency;
    }
}

