/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.view.dtfj.java;

import com.ibm.dtfj.image.CorruptData;
import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.java.JavaMonitor;
import com.ibm.dtfj.java.JavaObject;
import com.ibm.dtfj.java.JavaThread;
import com.ibm.j9ddr.view.dtfj.J9DDRDTFJUtils;
import com.ibm.j9ddr.view.dtfj.image.J9DDRImagePointer;
import com.ibm.j9ddr.vm29.j9.ObjectMonitor;
import com.ibm.j9ddr.vm29.pointer.generated.J9VMThreadPointer;
import com.ibm.j9ddr.vm29.view.dtfj.DTFJContext;
import com.ibm.j9ddr.vm29.view.dtfj.java.DTFJJavaObject;
import com.ibm.j9ddr.vm29.view.dtfj.java.DTFJJavaThread;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;

public class DTFJJavaObjectMonitor
implements JavaMonitor {
    private final Logger log = DTFJContext.getLogger();
    private final ObjectMonitor monitor;
    private String name = null;

    public DTFJJavaObjectMonitor(ObjectMonitor objectMonitor) {
        this.monitor = objectMonitor;
        this.log.fine(String.format("Created object monitor 0x%016x", this.monitor.getObject().getAddress()));
    }

    public Iterator getEnterWaiters() {
        try {
            return this.convertToDTFJThreads(this.monitor.getBlockedThreads());
        }
        catch (Throwable throwable) {
            CorruptData corruptData = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), throwable);
            return J9DDRDTFJUtils.corruptIterator(corruptData);
        }
    }

    private Iterator<?> convertToDTFJThreads(List<J9VMThreadPointer> list) {
        ArrayList<DTFJJavaThread> arrayList = new ArrayList<DTFJJavaThread>();
        for (J9VMThreadPointer j9VMThreadPointer : list) {
            arrayList.add(new DTFJJavaThread(j9VMThreadPointer));
        }
        return arrayList.iterator();
    }

    public ImagePointer getID() {
        try {
            if (this.monitor.isInflated()) {
                return DTFJContext.getImagePointer(this.monitor.getInflatedMonitor().getAddress());
            }
            return DTFJContext.getImagePointer(this.monitor.getObject().getAddress());
        }
        catch (Throwable throwable) {
            J9DDRDTFJUtils.handleAsCorruptDataException(DTFJContext.getProcess(), throwable);
            return new J9DDRImagePointer(DTFJContext.getProcess(), 1002855686514536461L);
        }
    }

    public String getName() throws CorruptDataException {
        if (this.name == null) {
            try {
                String string = Long.toHexString(this.monitor.getObject().getAddress());
                String string2 = Long.toHexString(this.getID().getAddress());
                this.name = String.format("(un-named monitor @0x%s for object @0x%s)", string2, string);
            }
            catch (Throwable throwable) {
                throw J9DDRDTFJUtils.handleAsCorruptDataException(DTFJContext.getProcess(), throwable);
            }
        }
        return this.name;
    }

    public Iterator getNotifyWaiters() {
        try {
            return this.convertToDTFJThreads(this.monitor.getWaitingThreads());
        }
        catch (Throwable throwable) {
            CorruptData corruptData = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), throwable);
            return J9DDRDTFJUtils.corruptIterator(corruptData);
        }
    }

    public JavaObject getObject() {
        return new DTFJJavaObject(this.monitor.getObject());
    }

    public JavaThread getOwner() throws CorruptDataException {
        try {
            J9VMThreadPointer j9VMThreadPointer = this.monitor.getOwner();
            if (j9VMThreadPointer == null || j9VMThreadPointer.isNull()) {
                return null;
            }
            return new DTFJJavaThread(j9VMThreadPointer);
        }
        catch (Throwable throwable) {
            throw J9DDRDTFJUtils.handleAsCorruptDataException(DTFJContext.getProcess(), throwable);
        }
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof DTFJJavaObjectMonitor)) {
            return false;
        }
        DTFJJavaObjectMonitor dTFJJavaObjectMonitor = (DTFJJavaObjectMonitor)object;
        return this.getID().equals((Object)dTFJJavaObjectMonitor.getID());
    }

    public int hashCode() {
        return this.getID().hashCode();
    }
}

