/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.physics.bullet.collision;

import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.physics.bullet.BulletBase;
import com.badlogic.gdx.physics.bullet.collision.CollisionJNI;
import com.badlogic.gdx.physics.bullet.collision.btCollisionObject;
import com.badlogic.gdx.physics.bullet.collision.btCollisionObjectWrapper;
import com.badlogic.gdx.physics.bullet.collision.btCollisionShape;

public class CollisionObjectWrapper
extends BulletBase {
    private long swigCPtr;
    public btCollisionObjectWrapper wrapper;

    protected CollisionObjectWrapper(String className, long cPtr, boolean cMemoryOwn) {
        super(className, cPtr, cMemoryOwn);
        this.swigCPtr = cPtr;
    }

    public CollisionObjectWrapper(long cPtr, boolean cMemoryOwn) {
        this("CollisionObjectWrapper", cPtr, cMemoryOwn);
        this.construct();
    }

    @Override
    protected void reset(long cPtr, boolean cMemoryOwn) {
        if (!this.destroyed) {
            this.destroy();
        }
        this.swigCPtr = cPtr;
        super.reset(this.swigCPtr, cMemoryOwn);
    }

    public static long getCPtr(CollisionObjectWrapper obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    @Override
    protected void finalize() throws Throwable {
        if (!this.destroyed) {
            this.destroy();
        }
        super.finalize();
    }

    @Override
    protected synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                CollisionJNI.delete_CollisionObjectWrapper(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
        super.delete();
    }

    @Override
    protected void construct() {
        super.construct();
        this.wrapper = new btCollisionObjectWrapper(this.getWrapper().getCPointer(), false);
    }

    @Override
    public void dispose() {
        if (this.wrapper != null) {
            this.wrapper.dispose();
            this.wrapper = null;
        }
        super.dispose();
    }

    public CollisionObjectWrapper(btCollisionObjectWrapper parent, btCollisionShape shape, btCollisionObject collisionObject, Matrix4 worldTransform, int partId, int index) {
        this(CollisionJNI.new_CollisionObjectWrapper__SWIG_0(btCollisionObjectWrapper.getCPtr(parent), parent, btCollisionShape.getCPtr(shape), shape, btCollisionObject.getCPtr(collisionObject), collisionObject, worldTransform, partId, index), true);
    }

    public CollisionObjectWrapper(btCollisionObjectWrapper parent, btCollisionShape shape, btCollisionObject collisionObject, Matrix4 worldTransform, int partId) {
        this(CollisionJNI.new_CollisionObjectWrapper__SWIG_1(btCollisionObjectWrapper.getCPtr(parent), parent, btCollisionShape.getCPtr(shape), shape, btCollisionObject.getCPtr(collisionObject), collisionObject, worldTransform, partId), true);
    }

    public CollisionObjectWrapper(btCollisionObjectWrapper parent, btCollisionShape shape, btCollisionObject collisionObject, Matrix4 worldTransform) {
        this(CollisionJNI.new_CollisionObjectWrapper__SWIG_2(btCollisionObjectWrapper.getCPtr(parent), parent, btCollisionShape.getCPtr(shape), shape, btCollisionObject.getCPtr(collisionObject), collisionObject, worldTransform), true);
    }

    public CollisionObjectWrapper(btCollisionShape shape, btCollisionObject collisionObject, Matrix4 worldTransform, int partId, int index) {
        this(CollisionJNI.new_CollisionObjectWrapper__SWIG_3(btCollisionShape.getCPtr(shape), shape, btCollisionObject.getCPtr(collisionObject), collisionObject, worldTransform, partId, index), true);
    }

    public CollisionObjectWrapper(btCollisionShape shape, btCollisionObject collisionObject, Matrix4 worldTransform, int partId) {
        this(CollisionJNI.new_CollisionObjectWrapper__SWIG_4(btCollisionShape.getCPtr(shape), shape, btCollisionObject.getCPtr(collisionObject), collisionObject, worldTransform, partId), true);
    }

    public CollisionObjectWrapper(btCollisionShape shape, btCollisionObject collisionObject, Matrix4 worldTransform) {
        this(CollisionJNI.new_CollisionObjectWrapper__SWIG_5(btCollisionShape.getCPtr(shape), shape, btCollisionObject.getCPtr(collisionObject), collisionObject, worldTransform), true);
    }

    public CollisionObjectWrapper(btCollisionObjectWrapper parent, btCollisionObject collisionObject, int partId, int index) {
        this(CollisionJNI.new_CollisionObjectWrapper__SWIG_6(btCollisionObjectWrapper.getCPtr(parent), parent, btCollisionObject.getCPtr(collisionObject), collisionObject, partId, index), true);
    }

    public CollisionObjectWrapper(btCollisionObjectWrapper parent, btCollisionObject collisionObject, int partId) {
        this(CollisionJNI.new_CollisionObjectWrapper__SWIG_7(btCollisionObjectWrapper.getCPtr(parent), parent, btCollisionObject.getCPtr(collisionObject), collisionObject, partId), true);
    }

    public CollisionObjectWrapper(btCollisionObjectWrapper parent, btCollisionObject collisionObject) {
        this(CollisionJNI.new_CollisionObjectWrapper__SWIG_8(btCollisionObjectWrapper.getCPtr(parent), parent, btCollisionObject.getCPtr(collisionObject), collisionObject), true);
    }

    public CollisionObjectWrapper(btCollisionObject collisionObject, int partId, int index) {
        this(CollisionJNI.new_CollisionObjectWrapper__SWIG_9(btCollisionObject.getCPtr(collisionObject), collisionObject, partId, index), true);
    }

    public CollisionObjectWrapper(btCollisionObject collisionObject, int partId) {
        this(CollisionJNI.new_CollisionObjectWrapper__SWIG_10(btCollisionObject.getCPtr(collisionObject), collisionObject, partId), true);
    }

    public CollisionObjectWrapper(btCollisionObject collisionObject) {
        this(CollisionJNI.new_CollisionObjectWrapper__SWIG_11(btCollisionObject.getCPtr(collisionObject), collisionObject), true);
    }

    private btCollisionObjectWrapper getWrapper() {
        return btCollisionObjectWrapper.internalTemp(CollisionJNI.CollisionObjectWrapper_getWrapper(this.swigCPtr, this), false);
    }
}

