/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.battleTest;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.tann.dice.Main;
import com.tann.dice.gameplay.content.ent.type.MonsterType;
import com.tann.dice.gameplay.content.ent.type.lib.MonsterTypeLib;
import com.tann.dice.statics.ImageUtils;
import com.tann.dice.statics.sound.music.MusicType;
import com.tann.dice.util.Colours;
import com.tann.dice.util.Tann;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;

public enum Zone {
    Forest(0, "archer", "goblin", "boar", "rat", "wolf", "grandma", "thorn", "seed", "bee", "log", "chest"),
    Dungeon(1, "shade", "snake", "goblin", "quartz", "ogre", "slate", "slimer", "cyclops", "warchief", "dragon egg", "chest", "Illusion", "sudul", "bandit", "barrel", "militia", "fountain", "blind", "golem"),
    Catacombs(2, "shade", "zombie", "z0mbie", "bones", "wizz", "fanatic", "sniper", "imp", "grave", "quartz", "ghost", "slimer", "spiker", "sudul", "chest", "Illusion", "banshee", "militia", "Carrier", "fountain", "golem"),
    Lair(3, "chomp", "basilisk", "sniper", "demon", "ghost", "alpha", "blind", "ogre", "spiker", "slate", "troll", "caw", "snake", "cyclops", "warchief", "caw egg", "hydra", "gnoll", "dragon egg", "bandit", "thorn", "Carrier", "log", "chest"),
    Pit(4, "chomp", "demon", "sniper", "zombie", "z0mbie", "wizz", "basilisk", "spiker", "troll", "caw", "hydra", "fanatic", "dragon egg", "wisp", "banshee", "barrel", "shade", "golem"),
    Nightmare(5, "deathsigil", "decaysigil", "painsigil", "z0mbie", "x2.basilisk", "x2.basalt", "x2.lich", "x2.goblin", "x2.inevitable", "x3.hexia", "x3.alpha", "x3.warchief", "x3.log", "x3.shade", "x4.dragon egg", "x4.sniper", "x4.snake", "x5.wolf", "x5.the hand", "x6.sudul", "x6.dragon", "x7.bones", "x8.illusion", "x8.troll king", "x9.thorn", "x9.slate"),
    Snow(-1, "archer", "goblin", "boar", "rat", "wolf", "grandma", "thorn", "seed", "bee", "log"),
    Ice(-1, "archer", "goblin", "boar", "rat", "wolf", "grandma", "thorn", "seed", "bee", "log"),
    All(-1, MonsterTypeLib.stringArray(MonsterTypeLib.getAllValidMonsters()));

    public final int index;
    public final List<TextureRegion> background;
    public final TextureRegion minimap;
    public final List<MonsterType> validMonsters;

    private Color getCol() {
        return Colours.grey;
    }

    private Zone(int index, String ... types) {
        TextureRegion mtmp;
        this.index = index;
        this.validMonsters = new ArrayList<MonsterType>(MonsterTypeLib.listName(types));
        int sz = this.validMonsters.size();
        Tann.uniquify(this.validMonsters);
        if (sz != this.validMonsters.size()) {
            throw new RuntimeException("Duplicate leveltype monster?");
        }
        String n2 = "dungeon/tiling/" + this.name().toLowerCase();
        if (this.name().equalsIgnoreCase("all")) {
            n2 = "dungeon/tiling/nightmare";
        }
        this.background = new ArrayList<TextureAtlas.AtlasRegion>(Tann.getRegionsStartingWith(Main.atlas_big, n2));
        if (this.background.isEmpty()) {
            this.background.add(ImageUtils.loadExtBig("dungeon/tiling/missingno"));
        }
        this.minimap = (mtmp = ImageUtils.loadExtNull("ui/minimap/" + this.name().toLowerCase())) == null ? ImageUtils.loadExt("ui/minimap/missingno") : mtmp;
    }

    public boolean isVertical() {
        return false;
    }

    public TextureRegion getTransition(Zone next) {
        return ImageUtils.loadExtBig("dungeon/tiling/transition/" + this.name().toLowerCase() + "-" + next.name().toLowerCase());
    }

    public static Zone guessFromLevel(int level) {
        return Zone.randomWithIndex(level / 4);
    }

    public static Zone randomWithIndex(int index) {
        return Zone.randomWithIndex(index, Tann.makeStdRandom());
    }

    public static Zone randomWithIndex(int index, Random r) {
        ArrayList<Zone> zones = new ArrayList<Zone>(Arrays.asList(Zone.values()));
        Collections.shuffle(zones, r);
        for (int i = 0; i < zones.size(); ++i) {
            Zone z = (Zone)((Object)zones.get(i));
            if (z.index != index) continue;
            return z;
        }
        return null;
    }

    public String getTextButtonString() {
        return this.name();
    }

    public MusicType getMusicType() {
        switch (this) {
            case Forest: {
                return MusicType.Forest;
            }
            case Dungeon: {
                return MusicType.Dungeon;
            }
            case Catacombs: {
                return MusicType.Catacombs;
            }
            case Lair: {
                return MusicType.Lair;
            }
            case Pit: {
                return MusicType.Pit;
            }
        }
        return MusicType.Pit;
    }

    public boolean isClassic() {
        switch (this) {
            case Forest: 
            case Dungeon: 
            case Catacombs: 
            case Lair: 
            case Pit: {
                return true;
            }
        }
        return false;
    }
}

