/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.battleTest.testProvider;

import com.tann.dice.gameplay.battleTest.Difficulty;
import com.tann.dice.gameplay.battleTest.testProvider.BattleTestProvider;
import com.tann.dice.util.TannLog;

public class TierStats
implements BattleTestProvider {
    float avgSingleHeroHealth;
    float avgDamage;
    float avgMitigation;
    public final Difficulty difficulty;
    public final int playerTier;
    static final float buffer = 1.5f;
    static final float adjustedBuffer = 0.3f;

    public TierStats(int levelIndex, Difficulty difficulty) {
        this.playerTier = levelIndex;
        this.difficulty = difficulty;
        this.avgSingleHeroHealth = TierStats.getTierHp(levelIndex);
        this.avgDamage = TierStats.getStrength(levelIndex);
        this.avgMitigation = this.avgDamage * TierStats.getDefenceRatio();
    }

    public static float getLevelRatio(int currentLevelNumber) {
        return TierStats.getStrength(currentLevelNumber) / TierStats.getStrength(1);
    }

    private static float getStrength(int levelIndex) {
        switch (levelIndex) {
            case 0: {
                TannLog.error("level index 0");
                return 1.0f;
            }
            case 1: {
                return 2.7f;
            }
            case 2: {
                return 3.1f;
            }
            case 3: {
                return 3.3f;
            }
            case 4: {
                return 4.6f;
            }
            case 5: {
                return 3.7f;
            }
            case 6: {
                return 4.4f;
            }
            case 7: {
                return 5.1f;
            }
            case 8: {
                return 6.2f;
            }
            case 9: {
                return 5.8f;
            }
            case 10: {
                return 6.5f;
            }
            case 11: {
                return 7.0f;
            }
            case 12: {
                return 8.1f;
            }
            case 13: {
                return 7.3f;
            }
            case 14: {
                return 8.2f;
            }
            case 15: {
                return 9.1f;
            }
            case 16: {
                return 10.5f;
            }
            case 17: {
                return 10.2f;
            }
            case 18: {
                return 11.3f;
            }
            case 19: {
                return 12.5f;
            }
            case 20: {
                return 18.8f;
            }
        }
        return (float)((double)(TierStats.getStrength(20) * 0.9f) * Math.pow(2.0, (float)(levelIndex - 20) * 0.3f));
    }

    public static float getDefenceRatio() {
        return 0.82f;
    }

    private static float getTierHp(int levelIndex) {
        int t1 = Math.min(2, levelIndex / 10);
        int t2 = Math.min(2, levelIndex / 10 + 1);
        return TierStats.getLevelHp(t1) + (TierStats.getLevelHp(t2) - TierStats.getLevelHp(t1)) * ((float)(levelIndex % 10) / 10.0f);
    }

    private static float getLevelHp(int level) {
        switch (level) {
            case 0: {
                return 4.4f;
            }
            case 1: {
                return 7.65f;
            }
            case 2: {
                return 9.73f;
            }
        }
        throw new RuntimeException("no hp define for level " + level);
    }

    public float getAvgSingleHeroHealth() {
        return this.avgSingleHeroHealth;
    }

    @Override
    public float getTotalHealth() {
        return this.getAvgSingleHeroHealth() * 5.0f;
    }

    @Override
    public float getAvgDamage() {
        return this.avgDamage;
    }

    @Override
    public float getAvgMitigation() {
        return this.avgMitigation;
    }

    public static float getLivingHeroesMultiplier(float heroDamageTakenRatio) {
        float adjusted = Math.max(0.0f, heroDamageTakenRatio - 0.3f);
        float deads = adjusted / 0.7f;
        return 1.0f - deads;
    }

    public String toString() {
        return this.playerTier + ":" + this.difficulty;
    }
}

