/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.content.ent.type;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.tann.dice.Main;
import com.tann.dice.gameplay.content.ent.EntSize;
import com.tann.dice.gameplay.content.ent.Hero;
import com.tann.dice.gameplay.content.ent.die.side.EntSide;
import com.tann.dice.gameplay.content.ent.group.Party;
import com.tann.dice.gameplay.content.ent.type.EntType;
import com.tann.dice.gameplay.content.ent.type.HeroCol;
import com.tann.dice.gameplay.content.ent.type.lib.HeroTypeUtils;
import com.tann.dice.gameplay.content.gen.pipe.entity.hero.PipeHero;
import com.tann.dice.gameplay.context.DungeonContext;
import com.tann.dice.gameplay.effect.Trait;
import com.tann.dice.gameplay.effect.targetable.ability.Ability;
import com.tann.dice.gameplay.effect.targetable.ability.spell.Spell;
import com.tann.dice.gameplay.effect.targetable.ability.tactic.Tactic;
import com.tann.dice.gameplay.fightLog.FightLog;
import com.tann.dice.gameplay.modifier.modBal.TierUtils;
import com.tann.dice.gameplay.phase.levelEndPhase.rewardPhase.decisionPhase.choice.choosable.Choosable;
import com.tann.dice.gameplay.phase.levelEndPhase.rewardPhase.decisionPhase.choice.choosable.ChoosableType;
import com.tann.dice.gameplay.progress.chievo.unlock.UnUtil;
import com.tann.dice.gameplay.progress.stats.stat.Stat;
import com.tann.dice.gameplay.progress.stats.stat.pickRate.PickStat;
import com.tann.dice.screens.dungeon.DungeonScreen;
import com.tann.dice.screens.dungeon.panels.Explanel.DiePanel;
import com.tann.dice.statics.Images;
import com.tann.dice.util.Colours;
import com.tann.dice.util.Pixl;
import com.tann.dice.util.Tann;
import com.tann.dice.util.TannLog;
import com.tann.dice.util.lang.Words;
import com.tann.dice.util.listener.TannListener;
import com.tann.dice.util.ui.TextWriter;
import java.util.List;
import java.util.Map;

public class HeroType
extends EntType
implements Cloneable,
Choosable {
    public final HeroCol heroCol;
    public final int level;

    public HeroType(String name, int hp, TextureAtlas.AtlasRegion portrait, EntSide[] sides, List<Trait> traits, EntSize size, HeroCol heroCol, int level, Map<String, Integer> offsets) {
        super(name, hp, portrait, sides, traits, size, offsets);
        this.heroCol = heroCol;
        this.level = level;
        this.setupStats();
    }

    @Override
    public boolean skipStats() {
        return this.level == 1 || super.skipStats();
    }

    public float getHpBasedEffectTierAdjustment() {
        float targetHp = HeroTypeUtils.getHpFor(this.level);
        float hpDiff = this.getEffectiveHp() - targetHp;
        float hpDiffRatio = hpDiff / targetHp;
        float targetStrength = HeroTypeUtils.getEffectTierFor(this.level);
        return targetStrength * 0.42f * hpDiffRatio;
    }

    @Override
    public String describe() {
        return "hero";
    }

    @Override
    public float chance() {
        return this.chance;
    }

    public float getTotalEffectTier() {
        return this.getAvgEffectTier() + this.getHpBasedEffectTierAdjustment();
    }

    @Override
    public String getColourTag() {
        return "[" + this.heroCol.colName + "]";
    }

    @Override
    public Hero makeEnt() {
        if (this.hp == 0 || this.getName(false) == null || this.sides == null || this.sides.length != 6) {
            TannLog.log("Uhoh, bad ent type: " + this.getName(false) + ". It will probably throw an error soon.", TannLog.Severity.error);
        }
        return new Hero(this);
    }

    @Override
    public TextureRegion getAchievementIcon() {
        return null;
    }

    @Override
    public String getAchievementIconString() {
        return TextWriter.getTag(this.heroCol.col) + "H";
    }

    @Override
    public ChoosableType getType() {
        return ChoosableType.Hero;
    }

    @Override
    public void onChoose(DungeonContext dc, int index) {
        Hero h = this.makeEnt();
        Party p = dc.getParty();
        p.addHero(h, HeroTypeUtils.byName("Coffin"), dc);
        if (!this.isGenerated()) {
            dc.getStatsManager().pickDelta(this, true);
        }
        if (DungeonScreen.get() != null) {
            FightLog f = DungeonScreen.get().getFightLog();
            f.resetDueToFiddling();
        }
    }

    @Override
    public void onReject(DungeonContext dc) {
    }

    public boolean isGenerated() {
        for (Trait t : this.traits) {
            if (!t.personal.isGenerated()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Actor makeChoosableActor(boolean big, int index) {
        if (big) {
            return new DiePanel(this.makeEnt(), false);
        }
        Group a = new Pixl(0).image(Images.plusBig, this.getColour()).gap(3).actor(new Pixl(0, 2).border(this.getColour()).image(this.portrait)).pix();
        a.addListener(new TannListener(){

            @Override
            public boolean info(int button, float x, float y) {
                DiePanel dp = new DiePanel(HeroType.this.makeEnt(), false);
                Main.getCurrentScreen().push(dp, 0.8f);
                Tann.center(dp);
                return true;
            }
        });
        return a;
    }

    public float getBalanceRatio() {
        return this.getTotalEffectTier() / HeroTypeUtils.getEffectTierFor(this.level);
    }

    public static Color getIdCol() {
        return Colours.yellow;
    }

    @Override
    public boolean isMissingno() {
        return this == PipeHero.getMissingno();
    }

    public boolean isBannedFromLateStart() {
        for (Trait t : this.traits) {
            if (!t.personal.bannedFromLateStart()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean encountered(Map<String, Stat> allMergedStats) {
        if (this.level == 1 && !UnUtil.isLocked(this)) {
            return true;
        }
        return this.getPicks(allMergedStats, true) + this.getPicks(allMergedStats, false) > 0;
    }

    @Override
    public int getPicks(Map<String, Stat> allMergedStats, boolean reject) {
        String tag = PickStat.nameFor(this);
        Stat s = allMergedStats.get(tag);
        if (s == null) {
            return 0;
        }
        return PickStat.val(s, reject);
    }

    @Override
    public long getCollisionBits() {
        int i;
        long result = 0L;
        for (i = 0; i < this.traits.size(); ++i) {
            result |= ((Trait)this.traits.get((int)i)).personal.getCollisionBits(true);
        }
        for (i = 0; i < this.sides.length; ++i) {
            long bit = this.sides[i].getBaseEffect().getCollisionBits(true);
            result |= bit;
        }
        return result;
    }

    @Override
    public int getTier() {
        return this.level;
    }

    @Override
    public float getModTier() {
        return TierUtils.extraHeroModTier(this.getTier());
    }

    @Override
    public boolean isPositive() {
        return true;
    }

    @Override
    public String getTierString() {
        return Words.getTierString(this.getTier(), false);
    }

    public String makeBadHashString() {
        StringBuilder result = new StringBuilder();
        result.append(this.hp);
        for (EntSide es : this.sides) {
            result.append("/").append(EntSide.badHash(es.getBaseEffect()));
        }
        return result.toString();
    }

    @Override
    public Color getColour() {
        return this.heroCol.col;
    }

    public Ability getAbility() {
        for (Trait t : this.traits) {
            Ability a = t.personal.getAbility();
            if (a == null) continue;
            return a;
        }
        return null;
    }

    public Spell getSpell() {
        Ability a = this.getAbility();
        if (a instanceof Spell) {
            return (Spell)a;
        }
        return null;
    }

    public Tactic getTactic() {
        Ability a = this.getAbility();
        if (a instanceof Tactic) {
            return (Tactic)a;
        }
        return null;
    }
}

