/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.content.gen.pipe;

import com.tann.dice.gameplay.content.ent.type.HeroType;
import com.tann.dice.gameplay.content.ent.type.MonsterType;
import com.tann.dice.gameplay.content.gen.pipe.entity.hero.PipeHero;
import com.tann.dice.gameplay.content.gen.pipe.entity.monster.PipeMonster;
import com.tann.dice.gameplay.content.gen.pipe.item.PipeItem;
import com.tann.dice.gameplay.content.gen.pipe.mod.PipeCache;
import com.tann.dice.gameplay.content.gen.pipe.mod.PipeMod;
import com.tann.dice.gameplay.content.item.Item;
import com.tann.dice.gameplay.modifier.Modifier;
import com.tann.dice.screens.dungeon.panels.book.page.stuffPage.PipeType;
import com.tann.dice.util.Tann;
import com.tann.dice.util.TannLog;
import com.tann.dice.util.bsRandom.Supplier;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public abstract class Pipe<T>
implements Supplier<T> {
    public static final String ALL_THIS = "[red]TextMod[cu]";
    private static final int MAX_LN = 5000;
    public static Pattern DANGEROUS_NONMODIFIER_PIPE_CHARS = Pattern.compile("[^&,]*");
    static int recursion = -1;
    static final int MAX_PIPE_RECURSION = 5000;
    static final int slowMax = 2;

    public T get(String name) {
        if (this.nameBad(name)) {
            return null;
        }
        if (this.nameValid(name)) {
            return this.make(name);
        }
        return null;
    }

    protected boolean nameBad(String name) {
        return name.length() > 5000;
    }

    protected abstract T make(String var1);

    protected abstract boolean nameValid(String var1);

    public static void setupChecks() {
        recursion = 0;
    }

    public static void disableChecks() {
        recursion = -1;
    }

    public static <T> T checkPipes(List<Pipe<T>> pipes, String val) {
        if (recursion != -1 && ++recursion >= 5000) {
            TannLog.error("pipe recursion limit");
            return Pipe.guessMissingno(pipes);
        }
        for (int i = 0; i < pipes.size(); ++i) {
            try {
                T t = pipes.get(i).get(val);
                if (t == null) continue;
                return t;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static <T> T guessMissingno(List<Pipe<T>> pipes) {
        return pipes.get(pipes.size() - 1).get("a");
    }

    public static <T> T checkPipes(List<Pipe<T>> pipes, String val, PipeCache<T> cache) {
        if (val.contains(".") && Tann.countCharsInString('(', val) != Tann.countCharsInString(')', val)) {
            return Pipe.guessMissingno(pipes);
        }
        T t = Pipe.checkPipes(pipes, val);
        if (t != null && pipes.get(0).get(val) == null) {
            cache.cache(t);
        }
        return t;
    }

    public abstract T example();

    public List<T> examples(int amt) {
        if (this.isSlow()) {
            amt = Math.min(2, amt);
        }
        ArrayList<T> result = new ArrayList<T>();
        for (int i = 0; i < amt * 10; ++i) {
            T t = this.example();
            if (t == null) continue;
            result.add(t);
            if (result.size() == amt) break;
        }
        return result;
    }

    protected static boolean bad(String ... check) {
        for (int i = 0; i < check.length; ++i) {
            if (!Pipe.bad(check[i])) continue;
            return true;
        }
        return false;
    }

    protected static boolean bad(String check) {
        return check == null || check.isEmpty();
    }

    protected static boolean badInt(String check) {
        return !Tann.isInt(check);
    }

    public static boolean badInt(String ... check) {
        for (int i = 0; i < check.length; ++i) {
            if (!Pipe.badInt(check[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public T supply() {
        return this.example();
    }

    public boolean isTransformative() {
        return false;
    }

    public boolean canGenerate(boolean wild) {
        return false;
    }

    public final T generate(boolean wild) {
        if (!this.canGenerate(wild)) {
            return null;
        }
        return this.generateInternal(wild);
    }

    protected T generateInternal(boolean wild) {
        return null;
    }

    public float getRarity(boolean wild) {
        return 1.0f;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public static List<Pipe> makeAllPipes() {
        ArrayList<Pipe> result = new ArrayList<Pipe>();
        result.addAll(PipeMod.pipes);
        result.addAll(PipeItem.pipes);
        result.addAll(PipeMonster.pipes);
        result.addAll(PipeHero.pipes);
        return result;
    }

    public boolean isSlow() {
        return false;
    }

    public String document() {
        return "undocumented";
    }

    public boolean skipAPI() {
        return false;
    }

    public PipeType getPipeType() {
        Object o = null;
        for (int i = 0; i < 20 && (o = this.example()) == null; ++i) {
        }
        if (o instanceof Modifier) {
            return PipeType.Modifier;
        }
        if (o instanceof Item) {
            return PipeType.Item;
        }
        if (o instanceof MonsterType) {
            return PipeType.Monster;
        }
        if (o instanceof HeroType) {
            return PipeType.Hero;
        }
        return null;
    }

    public boolean isTexturey() {
        return false;
    }

    public boolean isRawTexture() {
        return this.document().contains("tx");
    }

    public String getIdTag() {
        return this.document();
    }

    public boolean showHigher() {
        return false;
    }
}

